$(document).on('input', '.quantity', function () {
    var quantity = $(this).val();
    if (Number(quantity) < 1) {
        quantity = 1;
    }
    var selector = $(this).closest('form');
    var per_monthly_price = selector.find('input[name=per_monthly_price]').val();
    var per_yearly_price = selector.find('input[name=per_yearly_price]').val();
    var totalPerMonthlyPrice = 0;
    var totalPerYearlyPrice = 0;
    if (Number(quantity) > 0) {
        totalPerMonthlyPrice = Number(per_monthly_price) * Number(quantity);
        totalPerYearlyPrice = Number(per_yearly_price) * Number(quantity);
    }
    var perMonthlyPriceDetails = currencyPrice(Number(per_monthly_price)) + '*' + Number(quantity) + '=' + currencyPrice(Number(totalPerMonthlyPrice));
    var perYearlyPriceDetails = currencyPrice(Number(per_monthly_price)) + '*' + Number(quantity) + '=' + currencyPrice(Number(totalPerYearlyPrice));
    selector.find('.per_monthly_price').text(perMonthlyPriceDetails);
    selector.find('.per_yearly_price').text(perYearlyPriceDetails);
});

$(document).on('change', '.quantity', function () {
    var quantity = $(this).val();
    if (Number(quantity) < 1) {
        $(this).val(1)
    }
});
