<?php
/**
 * AccountSettingsInformation
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * AccountSettingsInformation Class Doc Comment
 *
 * @category    Class
 * @description Contains account settings information.
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team <apihelp@docusign.com>
 * @license     The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AccountSettingsInformation implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'accountSettingsInformation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'access_code_format' => '\DocuSign\eSign\Model\AccessCodeFormat',
        'account_date_time_format' => '?string',
        'account_date_time_format_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'account_default_language' => '?string',
        'account_default_language_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'account_name' => '?string',
        'account_name_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'account_notification' => '\DocuSign\eSign\Model\AccountNotification',
        'account_ui_settings' => '\DocuSign\eSign\Model\AccountUISettings',
        'adopt_sig_config' => '?string',
        'adopt_sig_config_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'advanced_correct' => '?string',
        'advanced_correct_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'advanced_search_enable_tab_field' => '?string',
        'advanced_search_enable_tab_field_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'advanced_search_enable_template_id_field' => '?string',
        'advanced_search_enable_template_id_field_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'advanced_search_enable_template_name_field' => '?string',
        'advanced_search_enable_template_name_field_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_access_code_format' => '?string',
        'allow_access_code_format_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_account_management_granular' => '?string',
        'allow_account_management_granular_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_account_member_name_change' => '?string',
        'allow_account_member_name_change_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_ace' => '?string',
        'allow_ace_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_advanced_recipient_routing_conditional' => '?string',
        'allow_advanced_recipient_routing_conditional_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_agent_name_email_edit' => '?string',
        'allow_agent_name_email_edit_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_agreement_actions' => '?string',
        'allow_agreement_actions_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_agreement_orchestrations' => '?string',
        'allow_agreement_orchestrations_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_auto_nav_settings' => '?string',
        'allow_auto_nav_settings_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_auto_tagging' => '?string',
        'allow_auto_tagging_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_bulk_send' => '?string',
        'allow_bulk_send_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_cd_withdraw' => '?string',
        'allow_cd_withdraw_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_connect_http_listener_configs' => '?string',
        'allow_connect_identity_verification_ui' => '?string',
        'allow_connect_o_auth_ui' => '?string',
        'allow_connect_send_finish_later' => '?string',
        'allow_connect_send_finish_later_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_connect_unified_payload_ui' => '?string',
        'allow_consumer_disclosure_override' => '?string',
        'allow_consumer_disclosure_override_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_data_download' => '?string',
        'allow_data_download_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_delayed_routing' => '?string',
        'allow_delayed_routing_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_delegated_signing' => '?string',
        'allow_delegated_signing_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_doc_gen_documents' => '?string',
        'allow_doc_gen_documents_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_document_disclosures' => '?string',
        'allow_document_disclosures_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_documents_on_signed_envelopes' => '?string',
        'allow_documents_on_signed_envelopes_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_document_visibility' => '?string',
        'allow_document_visibility_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_editing_envelopes_on_behalf_of_others' => '?string',
        'allow_editing_envelopes_on_behalf_of_others_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_e_hanko_stamps' => '?string',
        'allow_e_hanko_stamps_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_e_note_e_original' => '?string',
        'allow_e_note_e_original_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_envelope_correct' => '?string',
        'allow_envelope_correct_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_envelope_custody_transfer' => '?string',
        'allow_envelope_custody_transfer_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_envelope_custom_fields' => '?string',
        'allow_envelope_custom_fields_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_envelope_publish_reporting' => '?string',
        'allow_envelope_publish_reporting_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_envelope_reporting' => '?string',
        'allow_envelope_reporting_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_expression' => '?string',
        'allow_expression_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_express_signer_certificate' => '?string',
        'allow_express_signer_certificate_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_extended_sending_resource_file' => '?string',
        'allow_extended_sending_resource_file_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_external_linked_accounts' => '?string',
        'allow_external_linked_accounts_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_external_signature_pad' => '?string',
        'allow_external_signature_pad_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_idv_for_eu_qualified_signatures' => '?string',
        'allow_idv_for_eu_qualified_signatures_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_idv_level1' => '?string',
        'allow_idv_level1_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_idv_level1_trial' => '?string',
        'allow_idv_level1_trial_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_idv_level2' => '?string',
        'allow_idv_level2_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_idv_level3' => '?string',
        'allow_idv_level3_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_idv_platform' => '?string',
        'allow_idv_platform_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_in_person' => '?string',
        'allow_in_person_electronic_notary' => '?string',
        'allow_in_person_electronic_notary_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_in_person_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_managed_stamps' => '?string',
        'allow_managed_stamps_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_managing_envelopes_on_behalf_of_others' => '?string',
        'allow_managing_envelopes_on_behalf_of_others_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_markup' => '?string',
        'allow_markup_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_member_time_zone' => '?string',
        'allow_member_time_zone_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_merge_fields' => '?string',
        'allow_merge_fields_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_multiple_brand_profiles' => '?string',
        'allow_multiple_brand_profiles_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_multiple_signer_attachments' => '?string',
        'allow_multiple_signer_attachments_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_non_us_phone_auth' => '?string',
        'allow_non_us_phone_auth_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_ocr_of_envelope_documents' => '?string',
        'allow_ocr_of_envelope_documents_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_offline_signing' => '?string',
        'allow_offline_signing_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_open_trust_signer_certificate' => '?string',
        'allow_open_trust_signer_certificate_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_organization_docusign_monitor' => '?string',
        'allow_organization_docusign_monitor_free' => '?string',
        'allow_organization_docusign_monitor_free_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_organization_docusign_monitor_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_organization_domain_user_management' => '?string',
        'allow_organization_domain_user_management_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_organizations' => '?string',
        'allow_organizations_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_organization_sso_management' => '?string',
        'allow_organization_sso_management_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_organization_to_use_in_person_electronic_notary' => '?string',
        'allow_organization_to_use_in_person_electronic_notary_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_organization_to_use_remote_notary' => '?string',
        'allow_organization_to_use_remote_notary_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_organization_to_use_third_party_electronic_notary' => '?string',
        'allow_organization_to_use_third_party_electronic_notary_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_participant_recipient_type' => '?string',
        'allow_participant_recipient_type_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_payment_processing' => '?string',
        'allow_payment_processing_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_performance_analytics' => '?string',
        'allow_performance_analytics_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_phone_authentication' => '?string',
        'allow_phone_authentication_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_phone_auth_override' => '?string',
        'allow_phone_auth_override_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_private_signing_groups' => '?string',
        'allow_private_signing_groups_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_recipient_connect' => '?string',
        'allow_recipient_connect_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_reminders' => '?string',
        'allow_reminders_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_remote_notary' => '?string',
        'allow_remote_notary_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_resource_file_branding' => '?string',
        'allow_resource_file_branding_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_safe_bio_pharma_signer_certificate' => '?string',
        'allow_safe_bio_pharma_signer_certificate_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_scheduled_sending' => '?string',
        'allow_scheduled_sending_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_security_appliance' => '?string',
        'allow_security_appliance_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_sending_envelopes_on_behalf_of_others' => '?string',
        'allow_sending_envelopes_on_behalf_of_others_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_send_to_certified_delivery' => '?string',
        'allow_send_to_certified_delivery_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_send_to_intermediary' => '?string',
        'allow_send_to_intermediary_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_server_templates' => '?string',
        'allow_server_templates_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_set_embedded_recipient_start_url' => '?string',
        'allow_set_embedded_recipient_start_url_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_shared_tabs' => '?string',
        'allow_shared_tabs_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_signature_stamps' => '?string',
        'allow_signature_stamps_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_sign_document_from_home_page' => '?string',
        'allow_sign_document_from_home_page_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_signer_reassign' => '?string',
        'allow_signer_reassign_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_signer_reassign_override' => '?string',
        'allow_signer_reassign_override_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_signing_extensions' => '?string',
        'allow_signing_extensions_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_signing_groups' => '?string',
        'allow_signing_groups_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_signing_insights' => '?string',
        'allow_signing_insights_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_signing_radio_deselect' => '?string',
        'allow_signing_radio_deselect_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_sign_now' => '?string',
        'allow_sign_now_metadata' => '?string',
        'allow_sms_delivery' => '?string',
        'allow_sms_delivery_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_social_id_login' => '?string',
        'allow_social_id_login_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_supplemental_documents' => '?string',
        'allow_supplemental_documents_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_third_party_electronic_notary' => '?string',
        'allow_third_party_electronic_notary_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_transactions_workspace' => '?string',
        'allow_transactions_workspace_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_transactions_workspace_original' => '?string',
        'allow_transactions_workspace_original_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_users_to_access_directory' => '?string',
        'allow_users_to_access_directory_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_value_insights' => '?string',
        'allow_value_insights_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_web_forms' => '?string',
        'allow_web_forms_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_whats_app_delivery' => '?string',
        'allow_whats_app_delivery_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'anchor_population_scope' => '?string',
        'anchor_population_scope_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'anchor_tag_versioned_placement_enabled' => '?string',
        'anchor_tag_versioned_placement_metadata_enabled' => '\DocuSign\eSign\Model\SettingsMetadata',
        'attach_completed_envelope' => '?string',
        'attach_completed_envelope_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'authentication_check' => '?string',
        'authentication_check_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'auto_nav_rule' => '?string',
        'auto_nav_rule_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'auto_provision_signer_account' => '?string',
        'auto_provision_signer_account_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'bcc_email_archive' => '?string',
        'bcc_email_archive_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'beta_switch_configuration' => '?string',
        'beta_switch_configuration_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'billing_address' => '\DocuSign\eSign\Model\AddressInformation',
        'billing_address_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'bulk_send' => '?string',
        'bulk_send_action_resend_limit' => '?string',
        'bulk_send_max_copies_in_batch' => '?string',
        'bulk_send_max_unprocessed_envelopes_count' => '?string',
        'bulk_send_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'can_self_brand_send' => '?string',
        'can_self_brand_send_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'can_self_brand_sign' => '?string',
        'can_self_brand_sign_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'can_use_salesforce_o_auth' => '?string',
        'can_use_salesforce_o_auth_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'capture_voice_recording' => '?string',
        'capture_voice_recording_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'cfr21_simplified_signing_enabled' => '?string',
        'cfr21_simplified_signing_enabled_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'cfr_use_wide_image' => '?string',
        'cfr_use_wide_image_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'check_for_multiple_admins_on_account' => '?string',
        'check_for_multiple_admins_on_account_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'chrome_signature_enabled' => '?string',
        'chrome_signature_enabled_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'comment_email_show_message_text' => '?string',
        'comment_email_show_message_text_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'comments_allow_envelope_override' => '?string',
        'comments_allow_envelope_override_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'conditional_fields_enabled' => '?string',
        'conditional_fields_enabled_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'consumer_disclosure_frequency' => '?string',
        'consumer_disclosure_frequency_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'convert_pdf_fields' => '?string',
        'convert_pdf_fields_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'data_population_scope' => '?string',
        'data_population_scope_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'default_to_advanced_envelopes_filter_form' => '?string',
        'default_to_advanced_envelopes_filter_form_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'disable_auto_template_matching' => '?string',
        'disable_auto_template_matching_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'disable_mobile_app' => '?string',
        'disable_mobile_app_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'disable_mobile_push_notifications' => '?string',
        'disable_mobile_push_notifications_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'disable_mobile_sending' => '?string',
        'disable_mobile_sending_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'disable_multiple_sessions' => '?string',
        'disable_multiple_sessions_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'disable_purge_notifications_for_sender_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'disable_signer_cert_view' => '?string',
        'disable_signer_cert_view_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'disable_signer_history_view' => '?string',
        'disable_signer_history_view_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'disable_style_signature' => '?string',
        'disable_style_signature_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'disable_upload_signature' => '?string',
        'disable_upload_signature_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'disable_user_sharing' => '?string',
        'disable_user_sharing_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'display_beta_switch' => '?string',
        'display_beta_switch_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'document_conversion_restrictions' => '?string',
        'document_conversion_restrictions_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'document_retention' => '?string',
        'document_retention_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'document_retention_purge_tabs' => '?string',
        'document_visibility' => '?string',
        'document_visibility_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'draft_envelope_retention' => '?string',
        'draft_envelope_retention_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'dss_enable_provisioning_pen_configuration_radmin_option' => '?string',
        'dss_sign_28411_enable_leave_page_prompt_radmin_option' => '?string',
        'dss_sign_29182_slide_up_bar_radmin_option' => '?string',
        'email_template_version' => '?string',
        'email_template_version_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_access_code_generator' => '?string',
        'enable_access_code_generator_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_account_wide_search' => '?string',
        'enable_account_wide_search_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_adm_healthcare' => '?string',
        'enable_adm_healthcare_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_advanced_envelopes_search' => '?string',
        'enable_advanced_envelopes_search_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_advanced_payments' => '?string',
        'enable_advanced_payments_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_advanced_power_forms' => '?string',
        'enable_advanced_power_forms_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_agreement_actions_for_clm' => '?string',
        'enable_agreement_actions_for_clm_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_agreement_actions_for_e_sign' => '?string',
        'enable_agreement_actions_for_e_sign_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_auto_nav' => '?string',
        'enable_auto_nav_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_bcc_dummy_link' => '?string',
        'enable_bcc_dummy_link_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_calculated_fields' => '?string',
        'enable_calculated_fields_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_click_plus' => '?string',
        'enable_click_plus_conditional_content' => '?string',
        'enable_click_plus_conditional_content_meta_data' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_click_plus_custom_fields' => '?string',
        'enable_click_plus_custom_fields_meta_data' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_click_plus_custom_style' => '?string',
        'enable_click_plus_custom_style_meta_data' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_click_plus_dynamic_content' => '?string',
        'enable_click_plus_dynamic_content_meta_data' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_click_plus_meta_data' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_clickwraps' => '?string',
        'enable_clickwraps_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_combined_pdf_download_for_sbs' => '?string',
        'enable_comments_history_download_in_signing' => '?string',
        'enable_comments_history_download_in_signing_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_contact_suggestions' => '?string',
        'enable_contact_suggestions_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_customer_satisfaction_metric_tracking' => '?string',
        'enable_customer_satisfaction_metric_tracking_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_d_sig_eu_advanced_pens' => '?string',
        'enable_d_sig_eu_advanced_pens_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_d_sig_express_pens' => '?string',
        'enable_d_sig_express_pens_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_d_sig_id_check_for_aes_pens' => '?string',
        'enable_d_sig_id_check_for_aes_pens_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_d_sig_id_check_in_person_for_qes_pens' => '?string',
        'enable_d_sig_id_check_in_person_for_qes_pens_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_d_sig_id_check_remote_for_qes_pens' => '?string',
        'enable_d_sig_id_check_remote_for_qes_pens_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_d_sig_id_verification_pens' => '?string',
        'enable_d_sig_id_verification_pens_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_d_sig_id_verification_premier_pens' => '?string',
        'enable_d_sig_id_verification_premier_pens_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_ds_pro' => '?string',
        'enable_ds_pro_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_enforce_tls_emails_setting_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_envelope_stamping_by_account_admin' => '?string',
        'enable_envelope_stamping_by_account_admin_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_envelope_stamping_by_ds_admin' => '?string',
        'enable_envelope_stamping_by_ds_admin_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_e_sign_api_hourly_limit_management' => '?string',
        'enable_e_sign_api_hourly_limit_management_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_esign_communities' => '?string',
        'enable_esign_communities_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_id_fx_accountless_sms_auth_for_part11' => '?string',
        'enable_id_fx_accountless_sms_auth_for_part11_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_id_fx_intuit_kba' => '?string',
        'enable_id_fx_intuit_kba_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_id_fx_phone_authentication' => '?string',
        'enable_id_fx_phone_authentication_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_idfx_phone_auth_signature_auth_status' => '?string',
        'enable_idfx_phone_auth_signature_auth_status_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_inbox_browse_views_powered_by_elastic_search' => '?string',
        'enable_inbox_browse_views_powered_by_elastic_search_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_inbox_relevance_sort' => '?string',
        'enable_inbox_relevance_sort_for_recent_accounts' => '?string',
        'enable_inbox_relevance_sort_for_recent_accounts_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_inbox_relevance_sort_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_in_browser_editor' => '?string',
        'enable_in_browser_editor_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_key_terms_suggestions_by_document_type' => '?string',
        'enable_key_terms_suggestions_by_document_type_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_participant_recipient_setting_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_payment_processing' => '?string',
        'enable_payment_processing_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_pdfa_conversion' => '?string',
        'enable_pdfa_conversion_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_power_form' => '?string',
        'enable_power_form_direct' => '?string',
        'enable_power_form_direct_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_power_form_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_recipient_domain_validation' => '?string',
        'enable_recipient_domain_validation_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_recipient_may_provide_phone_number' => '?string',
        'enable_recipient_may_provide_phone_number_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_report_links' => '?string',
        'enable_report_links_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_require_sign_on_paper' => '?string',
        'enable_require_sign_on_paper_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_reserved_domain' => '?string',
        'enable_reserved_domain_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_responsive_signing' => '?string',
        'enable_responsive_signing_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_scheduled_release' => '?string',
        'enable_scheduled_release_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_search' => '?string',
        'enable_search_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_search_service_azure_uri' => '?string',
        'enable_search_service_azure_uri_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_search_site_specific_api' => '?string',
        'enable_search_site_specific_api_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_search_ui' => '?string',
        'enable_search_ui_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_sending_tags_font_settings' => '?string',
        'enable_sending_tags_font_settings_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_send_to_agent' => '?string',
        'enable_send_to_agent_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_send_to_intermediary' => '?string',
        'enable_send_to_intermediary_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_send_to_manage' => '?string',
        'enable_send_to_manage_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_sequential_signing_api' => '?string',
        'enable_sequential_signing_api_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_sequential_signing_ui' => '?string',
        'enable_sequential_signing_ui_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_signer_attachments' => '?string',
        'enable_signer_attachments_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_signing_extension_comments' => '?string',
        'enable_signing_extension_comments_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_signing_extension_conversations' => '?string',
        'enable_signing_extension_conversations_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_signing_order_settings_for_account' => '?string',
        'enable_signing_order_settings_for_account_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_sign_on_paper' => '?string',
        'enable_sign_on_paper_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_sign_on_paper_override' => '?string',
        'enable_sign_on_paper_override_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_sign_with_notary' => '?string',
        'enable_sign_with_notary_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_smart_contracts' => '?string',
        'enable_smart_contracts_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_sms_authentication' => '?string',
        'enable_sms_authentication_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_sms_delivery_additional_notification' => '?string',
        'enable_sms_delivery_additional_notification_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_sms_delivery_primary' => '?string',
        'enable_social_id_login' => '?string',
        'enable_social_id_login_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_strike_through' => '?string',
        'enable_strike_through_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_transaction_point' => '?string',
        'enable_transaction_point_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_vaulting' => '?string',
        'enable_vaulting_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_web_forms_separate_user_permissions' => '?string',
        'enable_web_forms_separate_user_permissions_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_witnessing' => '?string',
        'enable_witnessing_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enforce_template_name_uniqueness' => '?string',
        'enforce_template_name_uniqueness_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enforce_tls_emails' => '?string',
        'enforce_tls_emails_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'envelope_integration_allowed' => '?string',
        'envelope_integration_allowed_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'envelope_integration_enabled' => '?string',
        'envelope_integration_enabled_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'envelope_limits_total_document_size_allowed_in_mb' => '?string',
        'envelope_limits_total_document_size_allowed_in_mb_enabled' => '?string',
        'envelope_limits_total_document_size_allowed_in_mb_enabled_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'envelope_limits_total_document_size_allowed_in_mb_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'envelope_search_mode' => '?string',
        'envelope_search_mode_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'envelope_stamping_default_value' => '?string',
        'envelope_stamping_default_value_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'exit_prompt' => '?string',
        'exit_prompt_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'express_send' => '?string',
        'express_send_allow_tabs' => '?string',
        'express_send_allow_tabs_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'express_send_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'external_document_sources' => '\DocuSign\eSign\Model\ExternalDocumentSources',
        'external_signature_pad_type' => '?string',
        'external_signature_pad_type_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'fax_out_enabled' => '?string',
        'fax_out_enabled_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'finish_reminder' => '?string',
        'finish_reminder_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'guided_forms_html_allowed' => '?string',
        'guided_forms_html_allowed_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'guided_forms_html_conversion_policy' => '?string',
        'guided_forms_html_conversion_policy_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'has_recipient_connect_claimed_domain' => '?string',
        'hide_account_address_in_co_c' => '?string',
        'hide_account_address_in_co_c_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'hide_pricing' => '?string',
        'hide_pricing_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'id_check_configurations' => '\DocuSign\eSign\Model\IdCheckConfiguration[]',
        'id_check_expire' => '?string',
        'id_check_expire_days' => '?string',
        'id_check_expire_days_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'id_check_expire_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'id_check_expire_minutes' => '?string',
        'id_check_expire_minutes_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'id_check_required' => '?string',
        'id_check_required_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'identity_verification' => '\DocuSign\eSign\Model\AccountIdentityVerificationWorkflow[]',
        'identity_verification_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'idfx_kba_authentication_override' => '?string',
        'idfx_kba_authentication_override_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'idfx_phone_authentication_override' => '?string',
        'idfx_phone_authentication_override_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'ignore_error_if_anchor_tab_not_found' => '?string',
        'ignore_error_if_anchor_tab_not_found_metadata_enabled' => '\DocuSign\eSign\Model\SettingsMetadata',
        'in_person_id_check_question' => '?string',
        'in_person_id_check_question_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'in_person_signing_enabled' => '?string',
        'in_person_signing_enabled_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'in_session_enabled' => '?string',
        'in_session_enabled_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'in_session_suppress_emails' => '?string',
        'in_session_suppress_emails_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'is_connect_document_fields_enabled' => '?string',
        'linked_external_primary_accounts' => '\DocuSign\eSign\Model\LinkedExternalPrimaryAccount[]',
        'maximum_signing_groups' => '?string',
        'maximum_signing_groups_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'maximum_users_per_signing_group' => '?string',
        'maximum_users_per_signing_group_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'max_number_of_custom_stamps' => '?string',
        'merge_mixed_mode_results' => '?string',
        'merge_mixed_mode_results_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'mobile_session_timeout' => '?string',
        'mobile_session_timeout_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'number_of_active_custom_stamps' => '?string',
        'opt_in_mobile_signing_v02' => '?string',
        'opt_in_mobile_signing_v02_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'opt_in_universal_signatures' => '?string',
        'opt_out_auto_nav_text_and_tab_color_updates' => '?string',
        'opt_out_auto_nav_text_and_tab_color_updates_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'opt_out_new_platform_seal' => '?string',
        'opt_out_new_platform_seal_platform_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'pdf_max_chunked_upload_part_size' => '?string',
        'pdf_max_chunked_upload_part_size_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'pdf_max_chunked_upload_total_size' => '?string',
        'pdf_max_chunked_upload_total_size_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'pdf_max_individual_upload_size' => '?string',
        'pdf_max_individual_upload_size_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'phone_auth_recipient_may_provide_phone_number' => '?string',
        'phone_auth_recipient_may_provide_phone_number_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'pki_sign_downloaded_pdf_docs' => '?string',
        'pki_sign_downloaded_pdf_docs_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'read_only_mode' => '?string',
        'read_only_mode_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'recipients_can_sign_offline' => '?string',
        'recipients_can_sign_offline_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'recipient_signing_auto_navigation_control' => '?string',
        'recipient_signing_auto_navigation_control_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'require21_cf_rpt11_compliance' => '?string',
        'require21_cf_rpt11_compliance_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'require_decline_reason' => '?string',
        'require_decline_reason_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'require_external_user_management' => '?string',
        'require_external_user_management_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'require_signer_certificate_type' => '?string',
        'require_signer_certificate_type_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'rsa_verid_account_name' => '?string',
        'rsa_verid_password' => '?string',
        'rsa_verid_ruleset' => '?string',
        'rsa_verid_user_id' => '?string',
        'sbs_transaction_level' => '?string',
        'self_signed_recipient_email_document' => '?string',
        'self_signed_recipient_email_document_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'self_signed_recipient_email_document_user_override' => '?string',
        'self_signed_recipient_email_document_user_override_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'sender_can_sign_in_each_location' => '?string',
        'sender_can_sign_in_each_location_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'sender_must_authenticate_signing' => '?string',
        'sender_must_authenticate_signing_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'sending_tags_font_color' => '?string',
        'sending_tags_font_color_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'sending_tags_font_name' => '?string',
        'sending_tags_font_name_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'sending_tags_font_size' => '?string',
        'sending_tags_font_size_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'send_lockout_recipient_notification' => '?string',
        'send_lockout_recipient_notification_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'send_to_certified_delivery_enabled' => '?string',
        'send_to_certified_delivery_enabled_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'session_timeout' => '?string',
        'session_timeout_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'set_recip_email_lang' => '?string',
        'set_recip_email_lang_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'set_recip_sign_lang' => '?string',
        'set_recip_sign_lang_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'shared_template_folders' => '?string',
        'shared_template_folders_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'show_complete_dialog_in_embedded_session' => '?string',
        'show_complete_dialog_in_embedded_session_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'show_conditional_routing_on_send' => '?string',
        'show_conditional_routing_on_send_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'show_initial_conditional_fields' => '?string',
        'show_initial_conditional_fields_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'show_localized_watermarks' => '?string',
        'show_localized_watermarks_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'show_masked_fields_when_downloading_document_as_sender' => '?string',
        'show_masked_fields_when_downloading_document_as_sender_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'show_tutorials' => '?string',
        'show_tutorials_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'signature_providers' => '?string[]',
        'signature_providers_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'sign_date_format' => '?string',
        'sign_date_format_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'sign_date_time_account_language_override' => '?string',
        'sign_date_time_account_language_override_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'sign_date_time_account_timezone_override' => '?string',
        'sign_date_time_account_timezone_override_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'signer_attach_certificate_to_envelope_pdf' => '?string',
        'signer_attach_certificate_to_envelope_pdf_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'signer_attach_concat' => '?string',
        'signer_attach_concat_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'signer_can_create_account' => '?string',
        'signer_can_create_account_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'signer_can_sign_on_mobile' => '?string',
        'signer_can_sign_on_mobile_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'signer_in_session_use_envelope_complete_email' => '?string',
        'signer_in_session_use_envelope_complete_email_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'signer_login_requirements' => '?string',
        'signer_login_requirements_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'signer_must_have_account' => '?string',
        'signer_must_have_account_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'signer_must_login_to_sign' => '?string',
        'signer_must_login_to_sign_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'signer_show_secure_field_initial_values' => '?string',
        'signer_show_secure_field_initial_values_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'signing_session_timeout' => '?string',
        'signing_session_timeout_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'signing_ui_version' => '?string',
        'signing_ui_version_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'sign_time_format' => '?string',
        'sign_time_format_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'sign_time_show_am_pm' => '?string',
        'sign_time_show_am_pm_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'simplified_sending_enabled' => '?string',
        'simplified_sending_enabled_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'single_sign_on_enabled' => '?string',
        'single_sign_on_enabled_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'skip_auth_completed_envelopes' => '?string',
        'skip_auth_completed_envelopes_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'social_id_recip_auth' => '?string',
        'social_id_recip_auth_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'specify_document_visibility' => '?string',
        'specify_document_visibility_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'start_in_advanced_correct' => '?string',
        'start_in_advanced_correct_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'supplemental_documents_must_accept' => '?string',
        'supplemental_documents_must_accept_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'supplemental_documents_must_read' => '?string',
        'supplemental_documents_must_read_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'supplemental_documents_must_view' => '?string',
        'supplemental_documents_must_view_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'suppress_certificate_enforcement' => '?string',
        'suppress_certificate_enforcement_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'tab_account_settings' => '\DocuSign\eSign\Model\TabAccountSettings',
        'timezone_offset_api' => '?string',
        'timezone_offset_api_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'timezone_offset_ui' => '?string',
        'timezone_offset_ui_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'universal_signature_opt_in' => '?string',
        'use_account_level_email' => '?string',
        'use_account_level_email_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'use_consumer_disclosure' => '?string',
        'use_consumer_disclosure_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'use_consumer_disclosure_within_account' => '?string',
        'use_consumer_disclosure_within_account_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'use_derived_keys' => '?string',
        'use_derived_keys_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'use_docu_sign_express_signer_certificate' => '?string',
        'use_docu_sign_express_signer_certificate_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'use_envelope_search_mixed_mode' => '?string',
        'use_envelope_search_mixed_mode_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'use_multi_app_groups_data' => '?string',
        'use_multi_app_groups_data_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'use_new_blob_for_pdf' => '?string',
        'use_new_blob_for_pdf_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'use_new_envelope_search' => '?string',
        'use_new_envelope_search_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'use_new_envelope_search_only_when_searching_after_date' => '?string',
        'use_new_envelope_search_only_when_searching_after_date_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'use_new_envelope_search_only_with_search_term' => '?string',
        'use_new_envelope_search_only_with_search_term_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'use_safe_signer_certificates' => '?string',
        'use_safe_signer_certificates_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'uses_api' => '?string',
        'uses_api_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'use_signature_provider_platform' => '?string',
        'use_signature_provider_platform_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'use_smart_contracts_v1' => '?string',
        'validations_allowed' => '?string',
        'validations_allowed_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'validations_brand' => '?string',
        'validations_brand_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'validations_cadence' => '?string',
        'validations_cadence_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'validations_enabled' => '?string',
        'validations_enabled_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'validations_report' => '?string',
        'validations_report_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'water_mark_enabled' => '?string',
        'water_mark_enabled_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'write_reminder_to_envelope_history' => '?string',
        'write_reminder_to_envelope_history_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'wurfl_min_allowable_screen_size' => '?string',
        'wurfl_min_allowable_screen_size_metadata' => '\DocuSign\eSign\Model\SettingsMetadata'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'access_code_format' => null,
        'account_date_time_format' => null,
        'account_date_time_format_metadata' => null,
        'account_default_language' => null,
        'account_default_language_metadata' => null,
        'account_name' => null,
        'account_name_metadata' => null,
        'account_notification' => null,
        'account_ui_settings' => null,
        'adopt_sig_config' => null,
        'adopt_sig_config_metadata' => null,
        'advanced_correct' => null,
        'advanced_correct_metadata' => null,
        'advanced_search_enable_tab_field' => null,
        'advanced_search_enable_tab_field_metadata' => null,
        'advanced_search_enable_template_id_field' => null,
        'advanced_search_enable_template_id_field_metadata' => null,
        'advanced_search_enable_template_name_field' => null,
        'advanced_search_enable_template_name_field_metadata' => null,
        'allow_access_code_format' => null,
        'allow_access_code_format_metadata' => null,
        'allow_account_management_granular' => null,
        'allow_account_management_granular_metadata' => null,
        'allow_account_member_name_change' => null,
        'allow_account_member_name_change_metadata' => null,
        'allow_ace' => null,
        'allow_ace_metadata' => null,
        'allow_advanced_recipient_routing_conditional' => null,
        'allow_advanced_recipient_routing_conditional_metadata' => null,
        'allow_agent_name_email_edit' => null,
        'allow_agent_name_email_edit_metadata' => null,
        'allow_agreement_actions' => null,
        'allow_agreement_actions_metadata' => null,
        'allow_agreement_orchestrations' => null,
        'allow_agreement_orchestrations_metadata' => null,
        'allow_auto_nav_settings' => null,
        'allow_auto_nav_settings_metadata' => null,
        'allow_auto_tagging' => null,
        'allow_auto_tagging_metadata' => null,
        'allow_bulk_send' => null,
        'allow_bulk_send_metadata' => null,
        'allow_cd_withdraw' => null,
        'allow_cd_withdraw_metadata' => null,
        'allow_connect_http_listener_configs' => null,
        'allow_connect_identity_verification_ui' => null,
        'allow_connect_o_auth_ui' => null,
        'allow_connect_send_finish_later' => null,
        'allow_connect_send_finish_later_metadata' => null,
        'allow_connect_unified_payload_ui' => null,
        'allow_consumer_disclosure_override' => null,
        'allow_consumer_disclosure_override_metadata' => null,
        'allow_data_download' => null,
        'allow_data_download_metadata' => null,
        'allow_delayed_routing' => null,
        'allow_delayed_routing_metadata' => null,
        'allow_delegated_signing' => null,
        'allow_delegated_signing_metadata' => null,
        'allow_doc_gen_documents' => null,
        'allow_doc_gen_documents_metadata' => null,
        'allow_document_disclosures' => null,
        'allow_document_disclosures_metadata' => null,
        'allow_documents_on_signed_envelopes' => null,
        'allow_documents_on_signed_envelopes_metadata' => null,
        'allow_document_visibility' => null,
        'allow_document_visibility_metadata' => null,
        'allow_editing_envelopes_on_behalf_of_others' => null,
        'allow_editing_envelopes_on_behalf_of_others_metadata' => null,
        'allow_e_hanko_stamps' => null,
        'allow_e_hanko_stamps_metadata' => null,
        'allow_e_note_e_original' => null,
        'allow_e_note_e_original_metadata' => null,
        'allow_envelope_correct' => null,
        'allow_envelope_correct_metadata' => null,
        'allow_envelope_custody_transfer' => null,
        'allow_envelope_custody_transfer_metadata' => null,
        'allow_envelope_custom_fields' => null,
        'allow_envelope_custom_fields_metadata' => null,
        'allow_envelope_publish_reporting' => null,
        'allow_envelope_publish_reporting_metadata' => null,
        'allow_envelope_reporting' => null,
        'allow_envelope_reporting_metadata' => null,
        'allow_expression' => null,
        'allow_expression_metadata' => null,
        'allow_express_signer_certificate' => null,
        'allow_express_signer_certificate_metadata' => null,
        'allow_extended_sending_resource_file' => null,
        'allow_extended_sending_resource_file_metadata' => null,
        'allow_external_linked_accounts' => null,
        'allow_external_linked_accounts_metadata' => null,
        'allow_external_signature_pad' => null,
        'allow_external_signature_pad_metadata' => null,
        'allow_idv_for_eu_qualified_signatures' => null,
        'allow_idv_for_eu_qualified_signatures_metadata' => null,
        'allow_idv_level1' => null,
        'allow_idv_level1_metadata' => null,
        'allow_idv_level1_trial' => null,
        'allow_idv_level1_trial_metadata' => null,
        'allow_idv_level2' => null,
        'allow_idv_level2_metadata' => null,
        'allow_idv_level3' => null,
        'allow_idv_level3_metadata' => null,
        'allow_idv_platform' => null,
        'allow_idv_platform_metadata' => null,
        'allow_in_person' => null,
        'allow_in_person_electronic_notary' => null,
        'allow_in_person_electronic_notary_metadata' => null,
        'allow_in_person_metadata' => null,
        'allow_managed_stamps' => null,
        'allow_managed_stamps_metadata' => null,
        'allow_managing_envelopes_on_behalf_of_others' => null,
        'allow_managing_envelopes_on_behalf_of_others_metadata' => null,
        'allow_markup' => null,
        'allow_markup_metadata' => null,
        'allow_member_time_zone' => null,
        'allow_member_time_zone_metadata' => null,
        'allow_merge_fields' => null,
        'allow_merge_fields_metadata' => null,
        'allow_multiple_brand_profiles' => null,
        'allow_multiple_brand_profiles_metadata' => null,
        'allow_multiple_signer_attachments' => null,
        'allow_multiple_signer_attachments_metadata' => null,
        'allow_non_us_phone_auth' => null,
        'allow_non_us_phone_auth_metadata' => null,
        'allow_ocr_of_envelope_documents' => null,
        'allow_ocr_of_envelope_documents_metadata' => null,
        'allow_offline_signing' => null,
        'allow_offline_signing_metadata' => null,
        'allow_open_trust_signer_certificate' => null,
        'allow_open_trust_signer_certificate_metadata' => null,
        'allow_organization_docusign_monitor' => null,
        'allow_organization_docusign_monitor_free' => null,
        'allow_organization_docusign_monitor_free_metadata' => null,
        'allow_organization_docusign_monitor_metadata' => null,
        'allow_organization_domain_user_management' => null,
        'allow_organization_domain_user_management_metadata' => null,
        'allow_organizations' => null,
        'allow_organizations_metadata' => null,
        'allow_organization_sso_management' => null,
        'allow_organization_sso_management_metadata' => null,
        'allow_organization_to_use_in_person_electronic_notary' => null,
        'allow_organization_to_use_in_person_electronic_notary_metadata' => null,
        'allow_organization_to_use_remote_notary' => null,
        'allow_organization_to_use_remote_notary_metadata' => null,
        'allow_organization_to_use_third_party_electronic_notary' => null,
        'allow_organization_to_use_third_party_electronic_notary_metadata' => null,
        'allow_participant_recipient_type' => null,
        'allow_participant_recipient_type_metadata' => null,
        'allow_payment_processing' => null,
        'allow_payment_processing_metadata' => null,
        'allow_performance_analytics' => null,
        'allow_performance_analytics_metadata' => null,
        'allow_phone_authentication' => null,
        'allow_phone_authentication_metadata' => null,
        'allow_phone_auth_override' => null,
        'allow_phone_auth_override_metadata' => null,
        'allow_private_signing_groups' => null,
        'allow_private_signing_groups_metadata' => null,
        'allow_recipient_connect' => null,
        'allow_recipient_connect_metadata' => null,
        'allow_reminders' => null,
        'allow_reminders_metadata' => null,
        'allow_remote_notary' => null,
        'allow_remote_notary_metadata' => null,
        'allow_resource_file_branding' => null,
        'allow_resource_file_branding_metadata' => null,
        'allow_safe_bio_pharma_signer_certificate' => null,
        'allow_safe_bio_pharma_signer_certificate_metadata' => null,
        'allow_scheduled_sending' => null,
        'allow_scheduled_sending_metadata' => null,
        'allow_security_appliance' => null,
        'allow_security_appliance_metadata' => null,
        'allow_sending_envelopes_on_behalf_of_others' => null,
        'allow_sending_envelopes_on_behalf_of_others_metadata' => null,
        'allow_send_to_certified_delivery' => null,
        'allow_send_to_certified_delivery_metadata' => null,
        'allow_send_to_intermediary' => null,
        'allow_send_to_intermediary_metadata' => null,
        'allow_server_templates' => null,
        'allow_server_templates_metadata' => null,
        'allow_set_embedded_recipient_start_url' => null,
        'allow_set_embedded_recipient_start_url_metadata' => null,
        'allow_shared_tabs' => null,
        'allow_shared_tabs_metadata' => null,
        'allow_signature_stamps' => null,
        'allow_signature_stamps_metadata' => null,
        'allow_sign_document_from_home_page' => null,
        'allow_sign_document_from_home_page_metadata' => null,
        'allow_signer_reassign' => null,
        'allow_signer_reassign_metadata' => null,
        'allow_signer_reassign_override' => null,
        'allow_signer_reassign_override_metadata' => null,
        'allow_signing_extensions' => null,
        'allow_signing_extensions_metadata' => null,
        'allow_signing_groups' => null,
        'allow_signing_groups_metadata' => null,
        'allow_signing_insights' => null,
        'allow_signing_insights_metadata' => null,
        'allow_signing_radio_deselect' => null,
        'allow_signing_radio_deselect_metadata' => null,
        'allow_sign_now' => null,
        'allow_sign_now_metadata' => null,
        'allow_sms_delivery' => null,
        'allow_sms_delivery_metadata' => null,
        'allow_social_id_login' => null,
        'allow_social_id_login_metadata' => null,
        'allow_supplemental_documents' => null,
        'allow_supplemental_documents_metadata' => null,
        'allow_third_party_electronic_notary' => null,
        'allow_third_party_electronic_notary_metadata' => null,
        'allow_transactions_workspace' => null,
        'allow_transactions_workspace_metadata' => null,
        'allow_transactions_workspace_original' => null,
        'allow_transactions_workspace_original_metadata' => null,
        'allow_users_to_access_directory' => null,
        'allow_users_to_access_directory_metadata' => null,
        'allow_value_insights' => null,
        'allow_value_insights_metadata' => null,
        'allow_web_forms' => null,
        'allow_web_forms_metadata' => null,
        'allow_whats_app_delivery' => null,
        'allow_whats_app_delivery_metadata' => null,
        'anchor_population_scope' => null,
        'anchor_population_scope_metadata' => null,
        'anchor_tag_versioned_placement_enabled' => null,
        'anchor_tag_versioned_placement_metadata_enabled' => null,
        'attach_completed_envelope' => null,
        'attach_completed_envelope_metadata' => null,
        'authentication_check' => null,
        'authentication_check_metadata' => null,
        'auto_nav_rule' => null,
        'auto_nav_rule_metadata' => null,
        'auto_provision_signer_account' => null,
        'auto_provision_signer_account_metadata' => null,
        'bcc_email_archive' => null,
        'bcc_email_archive_metadata' => null,
        'beta_switch_configuration' => null,
        'beta_switch_configuration_metadata' => null,
        'billing_address' => null,
        'billing_address_metadata' => null,
        'bulk_send' => null,
        'bulk_send_action_resend_limit' => null,
        'bulk_send_max_copies_in_batch' => null,
        'bulk_send_max_unprocessed_envelopes_count' => null,
        'bulk_send_metadata' => null,
        'can_self_brand_send' => null,
        'can_self_brand_send_metadata' => null,
        'can_self_brand_sign' => null,
        'can_self_brand_sign_metadata' => null,
        'can_use_salesforce_o_auth' => null,
        'can_use_salesforce_o_auth_metadata' => null,
        'capture_voice_recording' => null,
        'capture_voice_recording_metadata' => null,
        'cfr21_simplified_signing_enabled' => null,
        'cfr21_simplified_signing_enabled_metadata' => null,
        'cfr_use_wide_image' => null,
        'cfr_use_wide_image_metadata' => null,
        'check_for_multiple_admins_on_account' => null,
        'check_for_multiple_admins_on_account_metadata' => null,
        'chrome_signature_enabled' => null,
        'chrome_signature_enabled_metadata' => null,
        'comment_email_show_message_text' => null,
        'comment_email_show_message_text_metadata' => null,
        'comments_allow_envelope_override' => null,
        'comments_allow_envelope_override_metadata' => null,
        'conditional_fields_enabled' => null,
        'conditional_fields_enabled_metadata' => null,
        'consumer_disclosure_frequency' => null,
        'consumer_disclosure_frequency_metadata' => null,
        'convert_pdf_fields' => null,
        'convert_pdf_fields_metadata' => null,
        'data_population_scope' => null,
        'data_population_scope_metadata' => null,
        'default_to_advanced_envelopes_filter_form' => null,
        'default_to_advanced_envelopes_filter_form_metadata' => null,
        'disable_auto_template_matching' => null,
        'disable_auto_template_matching_metadata' => null,
        'disable_mobile_app' => null,
        'disable_mobile_app_metadata' => null,
        'disable_mobile_push_notifications' => null,
        'disable_mobile_push_notifications_metadata' => null,
        'disable_mobile_sending' => null,
        'disable_mobile_sending_metadata' => null,
        'disable_multiple_sessions' => null,
        'disable_multiple_sessions_metadata' => null,
        'disable_purge_notifications_for_sender_metadata' => null,
        'disable_signer_cert_view' => null,
        'disable_signer_cert_view_metadata' => null,
        'disable_signer_history_view' => null,
        'disable_signer_history_view_metadata' => null,
        'disable_style_signature' => null,
        'disable_style_signature_metadata' => null,
        'disable_upload_signature' => null,
        'disable_upload_signature_metadata' => null,
        'disable_user_sharing' => null,
        'disable_user_sharing_metadata' => null,
        'display_beta_switch' => null,
        'display_beta_switch_metadata' => null,
        'document_conversion_restrictions' => null,
        'document_conversion_restrictions_metadata' => null,
        'document_retention' => null,
        'document_retention_metadata' => null,
        'document_retention_purge_tabs' => null,
        'document_visibility' => null,
        'document_visibility_metadata' => null,
        'draft_envelope_retention' => null,
        'draft_envelope_retention_metadata' => null,
        'dss_enable_provisioning_pen_configuration_radmin_option' => null,
        'dss_sign_28411_enable_leave_page_prompt_radmin_option' => null,
        'dss_sign_29182_slide_up_bar_radmin_option' => null,
        'email_template_version' => null,
        'email_template_version_metadata' => null,
        'enable_access_code_generator' => null,
        'enable_access_code_generator_metadata' => null,
        'enable_account_wide_search' => null,
        'enable_account_wide_search_metadata' => null,
        'enable_adm_healthcare' => null,
        'enable_adm_healthcare_metadata' => null,
        'enable_advanced_envelopes_search' => null,
        'enable_advanced_envelopes_search_metadata' => null,
        'enable_advanced_payments' => null,
        'enable_advanced_payments_metadata' => null,
        'enable_advanced_power_forms' => null,
        'enable_advanced_power_forms_metadata' => null,
        'enable_agreement_actions_for_clm' => null,
        'enable_agreement_actions_for_clm_metadata' => null,
        'enable_agreement_actions_for_e_sign' => null,
        'enable_agreement_actions_for_e_sign_metadata' => null,
        'enable_auto_nav' => null,
        'enable_auto_nav_metadata' => null,
        'enable_bcc_dummy_link' => null,
        'enable_bcc_dummy_link_metadata' => null,
        'enable_calculated_fields' => null,
        'enable_calculated_fields_metadata' => null,
        'enable_click_plus' => null,
        'enable_click_plus_conditional_content' => null,
        'enable_click_plus_conditional_content_meta_data' => null,
        'enable_click_plus_custom_fields' => null,
        'enable_click_plus_custom_fields_meta_data' => null,
        'enable_click_plus_custom_style' => null,
        'enable_click_plus_custom_style_meta_data' => null,
        'enable_click_plus_dynamic_content' => null,
        'enable_click_plus_dynamic_content_meta_data' => null,
        'enable_click_plus_meta_data' => null,
        'enable_clickwraps' => null,
        'enable_clickwraps_metadata' => null,
        'enable_combined_pdf_download_for_sbs' => null,
        'enable_comments_history_download_in_signing' => null,
        'enable_comments_history_download_in_signing_metadata' => null,
        'enable_contact_suggestions' => null,
        'enable_contact_suggestions_metadata' => null,
        'enable_customer_satisfaction_metric_tracking' => null,
        'enable_customer_satisfaction_metric_tracking_metadata' => null,
        'enable_d_sig_eu_advanced_pens' => null,
        'enable_d_sig_eu_advanced_pens_metadata' => null,
        'enable_d_sig_express_pens' => null,
        'enable_d_sig_express_pens_metadata' => null,
        'enable_d_sig_id_check_for_aes_pens' => null,
        'enable_d_sig_id_check_for_aes_pens_metadata' => null,
        'enable_d_sig_id_check_in_person_for_qes_pens' => null,
        'enable_d_sig_id_check_in_person_for_qes_pens_metadata' => null,
        'enable_d_sig_id_check_remote_for_qes_pens' => null,
        'enable_d_sig_id_check_remote_for_qes_pens_metadata' => null,
        'enable_d_sig_id_verification_pens' => null,
        'enable_d_sig_id_verification_pens_metadata' => null,
        'enable_d_sig_id_verification_premier_pens' => null,
        'enable_d_sig_id_verification_premier_pens_metadata' => null,
        'enable_ds_pro' => null,
        'enable_ds_pro_metadata' => null,
        'enable_enforce_tls_emails_setting_metadata' => null,
        'enable_envelope_stamping_by_account_admin' => null,
        'enable_envelope_stamping_by_account_admin_metadata' => null,
        'enable_envelope_stamping_by_ds_admin' => null,
        'enable_envelope_stamping_by_ds_admin_metadata' => null,
        'enable_e_sign_api_hourly_limit_management' => null,
        'enable_e_sign_api_hourly_limit_management_metadata' => null,
        'enable_esign_communities' => null,
        'enable_esign_communities_metadata' => null,
        'enable_id_fx_accountless_sms_auth_for_part11' => null,
        'enable_id_fx_accountless_sms_auth_for_part11_metadata' => null,
        'enable_id_fx_intuit_kba' => null,
        'enable_id_fx_intuit_kba_metadata' => null,
        'enable_id_fx_phone_authentication' => null,
        'enable_id_fx_phone_authentication_metadata' => null,
        'enable_idfx_phone_auth_signature_auth_status' => null,
        'enable_idfx_phone_auth_signature_auth_status_metadata' => null,
        'enable_inbox_browse_views_powered_by_elastic_search' => null,
        'enable_inbox_browse_views_powered_by_elastic_search_metadata' => null,
        'enable_inbox_relevance_sort' => null,
        'enable_inbox_relevance_sort_for_recent_accounts' => null,
        'enable_inbox_relevance_sort_for_recent_accounts_metadata' => null,
        'enable_inbox_relevance_sort_metadata' => null,
        'enable_in_browser_editor' => null,
        'enable_in_browser_editor_metadata' => null,
        'enable_key_terms_suggestions_by_document_type' => null,
        'enable_key_terms_suggestions_by_document_type_metadata' => null,
        'enable_participant_recipient_setting_metadata' => null,
        'enable_payment_processing' => null,
        'enable_payment_processing_metadata' => null,
        'enable_pdfa_conversion' => null,
        'enable_pdfa_conversion_metadata' => null,
        'enable_power_form' => null,
        'enable_power_form_direct' => null,
        'enable_power_form_direct_metadata' => null,
        'enable_power_form_metadata' => null,
        'enable_recipient_domain_validation' => null,
        'enable_recipient_domain_validation_metadata' => null,
        'enable_recipient_may_provide_phone_number' => null,
        'enable_recipient_may_provide_phone_number_metadata' => null,
        'enable_report_links' => null,
        'enable_report_links_metadata' => null,
        'enable_require_sign_on_paper' => null,
        'enable_require_sign_on_paper_metadata' => null,
        'enable_reserved_domain' => null,
        'enable_reserved_domain_metadata' => null,
        'enable_responsive_signing' => null,
        'enable_responsive_signing_metadata' => null,
        'enable_scheduled_release' => null,
        'enable_scheduled_release_metadata' => null,
        'enable_search' => null,
        'enable_search_metadata' => null,
        'enable_search_service_azure_uri' => null,
        'enable_search_service_azure_uri_metadata' => null,
        'enable_search_site_specific_api' => null,
        'enable_search_site_specific_api_metadata' => null,
        'enable_search_ui' => null,
        'enable_search_ui_metadata' => null,
        'enable_sending_tags_font_settings' => null,
        'enable_sending_tags_font_settings_metadata' => null,
        'enable_send_to_agent' => null,
        'enable_send_to_agent_metadata' => null,
        'enable_send_to_intermediary' => null,
        'enable_send_to_intermediary_metadata' => null,
        'enable_send_to_manage' => null,
        'enable_send_to_manage_metadata' => null,
        'enable_sequential_signing_api' => null,
        'enable_sequential_signing_api_metadata' => null,
        'enable_sequential_signing_ui' => null,
        'enable_sequential_signing_ui_metadata' => null,
        'enable_signer_attachments' => null,
        'enable_signer_attachments_metadata' => null,
        'enable_signing_extension_comments' => null,
        'enable_signing_extension_comments_metadata' => null,
        'enable_signing_extension_conversations' => null,
        'enable_signing_extension_conversations_metadata' => null,
        'enable_signing_order_settings_for_account' => null,
        'enable_signing_order_settings_for_account_metadata' => null,
        'enable_sign_on_paper' => null,
        'enable_sign_on_paper_metadata' => null,
        'enable_sign_on_paper_override' => null,
        'enable_sign_on_paper_override_metadata' => null,
        'enable_sign_with_notary' => null,
        'enable_sign_with_notary_metadata' => null,
        'enable_smart_contracts' => null,
        'enable_smart_contracts_metadata' => null,
        'enable_sms_authentication' => null,
        'enable_sms_authentication_metadata' => null,
        'enable_sms_delivery_additional_notification' => null,
        'enable_sms_delivery_additional_notification_metadata' => null,
        'enable_sms_delivery_primary' => null,
        'enable_social_id_login' => null,
        'enable_social_id_login_metadata' => null,
        'enable_strike_through' => null,
        'enable_strike_through_metadata' => null,
        'enable_transaction_point' => null,
        'enable_transaction_point_metadata' => null,
        'enable_vaulting' => null,
        'enable_vaulting_metadata' => null,
        'enable_web_forms_separate_user_permissions' => null,
        'enable_web_forms_separate_user_permissions_metadata' => null,
        'enable_witnessing' => null,
        'enable_witnessing_metadata' => null,
        'enforce_template_name_uniqueness' => null,
        'enforce_template_name_uniqueness_metadata' => null,
        'enforce_tls_emails' => null,
        'enforce_tls_emails_metadata' => null,
        'envelope_integration_allowed' => null,
        'envelope_integration_allowed_metadata' => null,
        'envelope_integration_enabled' => null,
        'envelope_integration_enabled_metadata' => null,
        'envelope_limits_total_document_size_allowed_in_mb' => null,
        'envelope_limits_total_document_size_allowed_in_mb_enabled' => null,
        'envelope_limits_total_document_size_allowed_in_mb_enabled_metadata' => null,
        'envelope_limits_total_document_size_allowed_in_mb_metadata' => null,
        'envelope_search_mode' => null,
        'envelope_search_mode_metadata' => null,
        'envelope_stamping_default_value' => null,
        'envelope_stamping_default_value_metadata' => null,
        'exit_prompt' => null,
        'exit_prompt_metadata' => null,
        'express_send' => null,
        'express_send_allow_tabs' => null,
        'express_send_allow_tabs_metadata' => null,
        'express_send_metadata' => null,
        'external_document_sources' => null,
        'external_signature_pad_type' => null,
        'external_signature_pad_type_metadata' => null,
        'fax_out_enabled' => null,
        'fax_out_enabled_metadata' => null,
        'finish_reminder' => null,
        'finish_reminder_metadata' => null,
        'guided_forms_html_allowed' => null,
        'guided_forms_html_allowed_metadata' => null,
        'guided_forms_html_conversion_policy' => null,
        'guided_forms_html_conversion_policy_metadata' => null,
        'has_recipient_connect_claimed_domain' => null,
        'hide_account_address_in_co_c' => null,
        'hide_account_address_in_co_c_metadata' => null,
        'hide_pricing' => null,
        'hide_pricing_metadata' => null,
        'id_check_configurations' => null,
        'id_check_expire' => null,
        'id_check_expire_days' => null,
        'id_check_expire_days_metadata' => null,
        'id_check_expire_metadata' => null,
        'id_check_expire_minutes' => null,
        'id_check_expire_minutes_metadata' => null,
        'id_check_required' => null,
        'id_check_required_metadata' => null,
        'identity_verification' => null,
        'identity_verification_metadata' => null,
        'idfx_kba_authentication_override' => null,
        'idfx_kba_authentication_override_metadata' => null,
        'idfx_phone_authentication_override' => null,
        'idfx_phone_authentication_override_metadata' => null,
        'ignore_error_if_anchor_tab_not_found' => null,
        'ignore_error_if_anchor_tab_not_found_metadata_enabled' => null,
        'in_person_id_check_question' => null,
        'in_person_id_check_question_metadata' => null,
        'in_person_signing_enabled' => null,
        'in_person_signing_enabled_metadata' => null,
        'in_session_enabled' => null,
        'in_session_enabled_metadata' => null,
        'in_session_suppress_emails' => null,
        'in_session_suppress_emails_metadata' => null,
        'is_connect_document_fields_enabled' => null,
        'linked_external_primary_accounts' => null,
        'maximum_signing_groups' => null,
        'maximum_signing_groups_metadata' => null,
        'maximum_users_per_signing_group' => null,
        'maximum_users_per_signing_group_metadata' => null,
        'max_number_of_custom_stamps' => null,
        'merge_mixed_mode_results' => null,
        'merge_mixed_mode_results_metadata' => null,
        'mobile_session_timeout' => null,
        'mobile_session_timeout_metadata' => null,
        'number_of_active_custom_stamps' => null,
        'opt_in_mobile_signing_v02' => null,
        'opt_in_mobile_signing_v02_metadata' => null,
        'opt_in_universal_signatures' => null,
        'opt_out_auto_nav_text_and_tab_color_updates' => null,
        'opt_out_auto_nav_text_and_tab_color_updates_metadata' => null,
        'opt_out_new_platform_seal' => null,
        'opt_out_new_platform_seal_platform_metadata' => null,
        'pdf_max_chunked_upload_part_size' => null,
        'pdf_max_chunked_upload_part_size_metadata' => null,
        'pdf_max_chunked_upload_total_size' => null,
        'pdf_max_chunked_upload_total_size_metadata' => null,
        'pdf_max_individual_upload_size' => null,
        'pdf_max_individual_upload_size_metadata' => null,
        'phone_auth_recipient_may_provide_phone_number' => null,
        'phone_auth_recipient_may_provide_phone_number_metadata' => null,
        'pki_sign_downloaded_pdf_docs' => null,
        'pki_sign_downloaded_pdf_docs_metadata' => null,
        'read_only_mode' => null,
        'read_only_mode_metadata' => null,
        'recipients_can_sign_offline' => null,
        'recipients_can_sign_offline_metadata' => null,
        'recipient_signing_auto_navigation_control' => null,
        'recipient_signing_auto_navigation_control_metadata' => null,
        'require21_cf_rpt11_compliance' => null,
        'require21_cf_rpt11_compliance_metadata' => null,
        'require_decline_reason' => null,
        'require_decline_reason_metadata' => null,
        'require_external_user_management' => null,
        'require_external_user_management_metadata' => null,
        'require_signer_certificate_type' => null,
        'require_signer_certificate_type_metadata' => null,
        'rsa_verid_account_name' => null,
        'rsa_verid_password' => null,
        'rsa_verid_ruleset' => null,
        'rsa_verid_user_id' => null,
        'sbs_transaction_level' => null,
        'self_signed_recipient_email_document' => null,
        'self_signed_recipient_email_document_metadata' => null,
        'self_signed_recipient_email_document_user_override' => null,
        'self_signed_recipient_email_document_user_override_metadata' => null,
        'sender_can_sign_in_each_location' => null,
        'sender_can_sign_in_each_location_metadata' => null,
        'sender_must_authenticate_signing' => null,
        'sender_must_authenticate_signing_metadata' => null,
        'sending_tags_font_color' => null,
        'sending_tags_font_color_metadata' => null,
        'sending_tags_font_name' => null,
        'sending_tags_font_name_metadata' => null,
        'sending_tags_font_size' => null,
        'sending_tags_font_size_metadata' => null,
        'send_lockout_recipient_notification' => null,
        'send_lockout_recipient_notification_metadata' => null,
        'send_to_certified_delivery_enabled' => null,
        'send_to_certified_delivery_enabled_metadata' => null,
        'session_timeout' => null,
        'session_timeout_metadata' => null,
        'set_recip_email_lang' => null,
        'set_recip_email_lang_metadata' => null,
        'set_recip_sign_lang' => null,
        'set_recip_sign_lang_metadata' => null,
        'shared_template_folders' => null,
        'shared_template_folders_metadata' => null,
        'show_complete_dialog_in_embedded_session' => null,
        'show_complete_dialog_in_embedded_session_metadata' => null,
        'show_conditional_routing_on_send' => null,
        'show_conditional_routing_on_send_metadata' => null,
        'show_initial_conditional_fields' => null,
        'show_initial_conditional_fields_metadata' => null,
        'show_localized_watermarks' => null,
        'show_localized_watermarks_metadata' => null,
        'show_masked_fields_when_downloading_document_as_sender' => null,
        'show_masked_fields_when_downloading_document_as_sender_metadata' => null,
        'show_tutorials' => null,
        'show_tutorials_metadata' => null,
        'signature_providers' => null,
        'signature_providers_metadata' => null,
        'sign_date_format' => null,
        'sign_date_format_metadata' => null,
        'sign_date_time_account_language_override' => null,
        'sign_date_time_account_language_override_metadata' => null,
        'sign_date_time_account_timezone_override' => null,
        'sign_date_time_account_timezone_override_metadata' => null,
        'signer_attach_certificate_to_envelope_pdf' => null,
        'signer_attach_certificate_to_envelope_pdf_metadata' => null,
        'signer_attach_concat' => null,
        'signer_attach_concat_metadata' => null,
        'signer_can_create_account' => null,
        'signer_can_create_account_metadata' => null,
        'signer_can_sign_on_mobile' => null,
        'signer_can_sign_on_mobile_metadata' => null,
        'signer_in_session_use_envelope_complete_email' => null,
        'signer_in_session_use_envelope_complete_email_metadata' => null,
        'signer_login_requirements' => null,
        'signer_login_requirements_metadata' => null,
        'signer_must_have_account' => null,
        'signer_must_have_account_metadata' => null,
        'signer_must_login_to_sign' => null,
        'signer_must_login_to_sign_metadata' => null,
        'signer_show_secure_field_initial_values' => null,
        'signer_show_secure_field_initial_values_metadata' => null,
        'signing_session_timeout' => null,
        'signing_session_timeout_metadata' => null,
        'signing_ui_version' => null,
        'signing_ui_version_metadata' => null,
        'sign_time_format' => null,
        'sign_time_format_metadata' => null,
        'sign_time_show_am_pm' => null,
        'sign_time_show_am_pm_metadata' => null,
        'simplified_sending_enabled' => null,
        'simplified_sending_enabled_metadata' => null,
        'single_sign_on_enabled' => null,
        'single_sign_on_enabled_metadata' => null,
        'skip_auth_completed_envelopes' => null,
        'skip_auth_completed_envelopes_metadata' => null,
        'social_id_recip_auth' => null,
        'social_id_recip_auth_metadata' => null,
        'specify_document_visibility' => null,
        'specify_document_visibility_metadata' => null,
        'start_in_advanced_correct' => null,
        'start_in_advanced_correct_metadata' => null,
        'supplemental_documents_must_accept' => null,
        'supplemental_documents_must_accept_metadata' => null,
        'supplemental_documents_must_read' => null,
        'supplemental_documents_must_read_metadata' => null,
        'supplemental_documents_must_view' => null,
        'supplemental_documents_must_view_metadata' => null,
        'suppress_certificate_enforcement' => null,
        'suppress_certificate_enforcement_metadata' => null,
        'tab_account_settings' => null,
        'timezone_offset_api' => null,
        'timezone_offset_api_metadata' => null,
        'timezone_offset_ui' => null,
        'timezone_offset_ui_metadata' => null,
        'universal_signature_opt_in' => null,
        'use_account_level_email' => null,
        'use_account_level_email_metadata' => null,
        'use_consumer_disclosure' => null,
        'use_consumer_disclosure_metadata' => null,
        'use_consumer_disclosure_within_account' => null,
        'use_consumer_disclosure_within_account_metadata' => null,
        'use_derived_keys' => null,
        'use_derived_keys_metadata' => null,
        'use_docu_sign_express_signer_certificate' => null,
        'use_docu_sign_express_signer_certificate_metadata' => null,
        'use_envelope_search_mixed_mode' => null,
        'use_envelope_search_mixed_mode_metadata' => null,
        'use_multi_app_groups_data' => null,
        'use_multi_app_groups_data_metadata' => null,
        'use_new_blob_for_pdf' => null,
        'use_new_blob_for_pdf_metadata' => null,
        'use_new_envelope_search' => null,
        'use_new_envelope_search_metadata' => null,
        'use_new_envelope_search_only_when_searching_after_date' => null,
        'use_new_envelope_search_only_when_searching_after_date_metadata' => null,
        'use_new_envelope_search_only_with_search_term' => null,
        'use_new_envelope_search_only_with_search_term_metadata' => null,
        'use_safe_signer_certificates' => null,
        'use_safe_signer_certificates_metadata' => null,
        'uses_api' => null,
        'uses_api_metadata' => null,
        'use_signature_provider_platform' => null,
        'use_signature_provider_platform_metadata' => null,
        'use_smart_contracts_v1' => null,
        'validations_allowed' => null,
        'validations_allowed_metadata' => null,
        'validations_brand' => null,
        'validations_brand_metadata' => null,
        'validations_cadence' => null,
        'validations_cadence_metadata' => null,
        'validations_enabled' => null,
        'validations_enabled_metadata' => null,
        'validations_report' => null,
        'validations_report_metadata' => null,
        'water_mark_enabled' => null,
        'water_mark_enabled_metadata' => null,
        'write_reminder_to_envelope_history' => null,
        'write_reminder_to_envelope_history_metadata' => null,
        'wurfl_min_allowable_screen_size' => null,
        'wurfl_min_allowable_screen_size_metadata' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'access_code_format' => 'accessCodeFormat',
        'account_date_time_format' => 'accountDateTimeFormat',
        'account_date_time_format_metadata' => 'accountDateTimeFormatMetadata',
        'account_default_language' => 'accountDefaultLanguage',
        'account_default_language_metadata' => 'accountDefaultLanguageMetadata',
        'account_name' => 'accountName',
        'account_name_metadata' => 'accountNameMetadata',
        'account_notification' => 'accountNotification',
        'account_ui_settings' => 'accountUISettings',
        'adopt_sig_config' => 'adoptSigConfig',
        'adopt_sig_config_metadata' => 'adoptSigConfigMetadata',
        'advanced_correct' => 'advancedCorrect',
        'advanced_correct_metadata' => 'advancedCorrectMetadata',
        'advanced_search_enable_tab_field' => 'advancedSearchEnableTabField',
        'advanced_search_enable_tab_field_metadata' => 'advancedSearchEnableTabFieldMetadata',
        'advanced_search_enable_template_id_field' => 'advancedSearchEnableTemplateIdField',
        'advanced_search_enable_template_id_field_metadata' => 'advancedSearchEnableTemplateIdFieldMetadata',
        'advanced_search_enable_template_name_field' => 'advancedSearchEnableTemplateNameField',
        'advanced_search_enable_template_name_field_metadata' => 'advancedSearchEnableTemplateNameFieldMetadata',
        'allow_access_code_format' => 'allowAccessCodeFormat',
        'allow_access_code_format_metadata' => 'allowAccessCodeFormatMetadata',
        'allow_account_management_granular' => 'allowAccountManagementGranular',
        'allow_account_management_granular_metadata' => 'allowAccountManagementGranularMetadata',
        'allow_account_member_name_change' => 'allowAccountMemberNameChange',
        'allow_account_member_name_change_metadata' => 'allowAccountMemberNameChangeMetadata',
        'allow_ace' => 'allowACE',
        'allow_ace_metadata' => 'allowACEMetadata',
        'allow_advanced_recipient_routing_conditional' => 'allowAdvancedRecipientRoutingConditional',
        'allow_advanced_recipient_routing_conditional_metadata' => 'allowAdvancedRecipientRoutingConditionalMetadata',
        'allow_agent_name_email_edit' => 'allowAgentNameEmailEdit',
        'allow_agent_name_email_edit_metadata' => 'allowAgentNameEmailEditMetadata',
        'allow_agreement_actions' => 'allowAgreementActions',
        'allow_agreement_actions_metadata' => 'allowAgreementActionsMetadata',
        'allow_agreement_orchestrations' => 'allowAgreementOrchestrations',
        'allow_agreement_orchestrations_metadata' => 'allowAgreementOrchestrationsMetadata',
        'allow_auto_nav_settings' => 'allowAutoNavSettings',
        'allow_auto_nav_settings_metadata' => 'allowAutoNavSettingsMetadata',
        'allow_auto_tagging' => 'allowAutoTagging',
        'allow_auto_tagging_metadata' => 'allowAutoTaggingMetadata',
        'allow_bulk_send' => 'allowBulkSend',
        'allow_bulk_send_metadata' => 'allowBulkSendMetadata',
        'allow_cd_withdraw' => 'allowCDWithdraw',
        'allow_cd_withdraw_metadata' => 'allowCDWithdrawMetadata',
        'allow_connect_http_listener_configs' => 'allowConnectHttpListenerConfigs',
        'allow_connect_identity_verification_ui' => 'AllowConnectIdentityVerificationUI',
        'allow_connect_o_auth_ui' => 'allowConnectOAuthUI',
        'allow_connect_send_finish_later' => 'allowConnectSendFinishLater',
        'allow_connect_send_finish_later_metadata' => 'allowConnectSendFinishLaterMetadata',
        'allow_connect_unified_payload_ui' => 'allowConnectUnifiedPayloadUI',
        'allow_consumer_disclosure_override' => 'allowConsumerDisclosureOverride',
        'allow_consumer_disclosure_override_metadata' => 'allowConsumerDisclosureOverrideMetadata',
        'allow_data_download' => 'allowDataDownload',
        'allow_data_download_metadata' => 'allowDataDownloadMetadata',
        'allow_delayed_routing' => 'allowDelayedRouting',
        'allow_delayed_routing_metadata' => 'allowDelayedRoutingMetadata',
        'allow_delegated_signing' => 'allowDelegatedSigning',
        'allow_delegated_signing_metadata' => 'allowDelegatedSigningMetadata',
        'allow_doc_gen_documents' => 'allowDocGenDocuments',
        'allow_doc_gen_documents_metadata' => 'allowDocGenDocumentsMetadata',
        'allow_document_disclosures' => 'allowDocumentDisclosures',
        'allow_document_disclosures_metadata' => 'allowDocumentDisclosuresMetadata',
        'allow_documents_on_signed_envelopes' => 'allowDocumentsOnSignedEnvelopes',
        'allow_documents_on_signed_envelopes_metadata' => 'allowDocumentsOnSignedEnvelopesMetadata',
        'allow_document_visibility' => 'allowDocumentVisibility',
        'allow_document_visibility_metadata' => 'allowDocumentVisibilityMetadata',
        'allow_editing_envelopes_on_behalf_of_others' => 'allowEditingEnvelopesOnBehalfOfOthers',
        'allow_editing_envelopes_on_behalf_of_others_metadata' => 'allowEditingEnvelopesOnBehalfOfOthersMetadata',
        'allow_e_hanko_stamps' => 'allowEHankoStamps',
        'allow_e_hanko_stamps_metadata' => 'allowEHankoStampsMetadata',
        'allow_e_note_e_original' => 'allowENoteEOriginal',
        'allow_e_note_e_original_metadata' => 'allowENoteEOriginalMetadata',
        'allow_envelope_correct' => 'allowEnvelopeCorrect',
        'allow_envelope_correct_metadata' => 'allowEnvelopeCorrectMetadata',
        'allow_envelope_custody_transfer' => 'allowEnvelopeCustodyTransfer',
        'allow_envelope_custody_transfer_metadata' => 'allowEnvelopeCustodyTransferMetadata',
        'allow_envelope_custom_fields' => 'allowEnvelopeCustomFields',
        'allow_envelope_custom_fields_metadata' => 'allowEnvelopeCustomFieldsMetadata',
        'allow_envelope_publish_reporting' => 'allowEnvelopePublishReporting',
        'allow_envelope_publish_reporting_metadata' => 'allowEnvelopePublishReportingMetadata',
        'allow_envelope_reporting' => 'allowEnvelopeReporting',
        'allow_envelope_reporting_metadata' => 'allowEnvelopeReportingMetadata',
        'allow_expression' => 'allowExpression',
        'allow_expression_metadata' => 'allowExpressionMetadata',
        'allow_express_signer_certificate' => 'allowExpressSignerCertificate',
        'allow_express_signer_certificate_metadata' => 'allowExpressSignerCertificateMetadata',
        'allow_extended_sending_resource_file' => 'allowExtendedSendingResourceFile',
        'allow_extended_sending_resource_file_metadata' => 'allowExtendedSendingResourceFileMetadata',
        'allow_external_linked_accounts' => 'allowExternalLinkedAccounts',
        'allow_external_linked_accounts_metadata' => 'allowExternalLinkedAccountsMetadata',
        'allow_external_signature_pad' => 'allowExternalSignaturePad',
        'allow_external_signature_pad_metadata' => 'allowExternalSignaturePadMetadata',
        'allow_idv_for_eu_qualified_signatures' => 'allowIDVForEUQualifiedSignatures',
        'allow_idv_for_eu_qualified_signatures_metadata' => 'allowIDVForEUQualifiedSignaturesMetadata',
        'allow_idv_level1' => 'allowIDVLevel1',
        'allow_idv_level1_metadata' => 'allowIDVLevel1Metadata',
        'allow_idv_level1_trial' => 'allowIDVLevel1Trial',
        'allow_idv_level1_trial_metadata' => 'allowIDVLevel1TrialMetadata',
        'allow_idv_level2' => 'allowIDVLevel2',
        'allow_idv_level2_metadata' => 'allowIDVLevel2Metadata',
        'allow_idv_level3' => 'allowIDVLevel3',
        'allow_idv_level3_metadata' => 'allowIDVLevel3Metadata',
        'allow_idv_platform' => 'allowIDVPlatform',
        'allow_idv_platform_metadata' => 'allowIDVPlatformMetadata',
        'allow_in_person' => 'allowInPerson',
        'allow_in_person_electronic_notary' => 'allowInPersonElectronicNotary',
        'allow_in_person_electronic_notary_metadata' => 'allowInPersonElectronicNotaryMetadata',
        'allow_in_person_metadata' => 'allowInPersonMetadata',
        'allow_managed_stamps' => 'allowManagedStamps',
        'allow_managed_stamps_metadata' => 'allowManagedStampsMetadata',
        'allow_managing_envelopes_on_behalf_of_others' => 'allowManagingEnvelopesOnBehalfOfOthers',
        'allow_managing_envelopes_on_behalf_of_others_metadata' => 'allowManagingEnvelopesOnBehalfOfOthersMetadata',
        'allow_markup' => 'allowMarkup',
        'allow_markup_metadata' => 'allowMarkupMetadata',
        'allow_member_time_zone' => 'allowMemberTimeZone',
        'allow_member_time_zone_metadata' => 'allowMemberTimeZoneMetadata',
        'allow_merge_fields' => 'allowMergeFields',
        'allow_merge_fields_metadata' => 'allowMergeFieldsMetadata',
        'allow_multiple_brand_profiles' => 'allowMultipleBrandProfiles',
        'allow_multiple_brand_profiles_metadata' => 'allowMultipleBrandProfilesMetadata',
        'allow_multiple_signer_attachments' => 'allowMultipleSignerAttachments',
        'allow_multiple_signer_attachments_metadata' => 'allowMultipleSignerAttachmentsMetadata',
        'allow_non_us_phone_auth' => 'allowNonUSPhoneAuth',
        'allow_non_us_phone_auth_metadata' => 'allowNonUSPhoneAuthMetadata',
        'allow_ocr_of_envelope_documents' => 'allowOcrOfEnvelopeDocuments',
        'allow_ocr_of_envelope_documents_metadata' => 'allowOcrOfEnvelopeDocumentsMetadata',
        'allow_offline_signing' => 'allowOfflineSigning',
        'allow_offline_signing_metadata' => 'allowOfflineSigningMetadata',
        'allow_open_trust_signer_certificate' => 'allowOpenTrustSignerCertificate',
        'allow_open_trust_signer_certificate_metadata' => 'allowOpenTrustSignerCertificateMetadata',
        'allow_organization_docusign_monitor' => 'allowOrganizationDocusignMonitor',
        'allow_organization_docusign_monitor_free' => 'allowOrganizationDocusignMonitorFree',
        'allow_organization_docusign_monitor_free_metadata' => 'allowOrganizationDocusignMonitorFreeMetadata',
        'allow_organization_docusign_monitor_metadata' => 'allowOrganizationDocusignMonitorMetadata',
        'allow_organization_domain_user_management' => 'allowOrganizationDomainUserManagement',
        'allow_organization_domain_user_management_metadata' => 'allowOrganizationDomainUserManagementMetadata',
        'allow_organizations' => 'allowOrganizations',
        'allow_organizations_metadata' => 'allowOrganizationsMetadata',
        'allow_organization_sso_management' => 'allowOrganizationSsoManagement',
        'allow_organization_sso_management_metadata' => 'allowOrganizationSsoManagementMetadata',
        'allow_organization_to_use_in_person_electronic_notary' => 'allowOrganizationToUseInPersonElectronicNotary',
        'allow_organization_to_use_in_person_electronic_notary_metadata' => 'allowOrganizationToUseInPersonElectronicNotaryMetadata',
        'allow_organization_to_use_remote_notary' => 'allowOrganizationToUseRemoteNotary',
        'allow_organization_to_use_remote_notary_metadata' => 'allowOrganizationToUseRemoteNotaryMetadata',
        'allow_organization_to_use_third_party_electronic_notary' => 'allowOrganizationToUseThirdPartyElectronicNotary',
        'allow_organization_to_use_third_party_electronic_notary_metadata' => 'allowOrganizationToUseThirdPartyElectronicNotaryMetadata',
        'allow_participant_recipient_type' => 'allowParticipantRecipientType',
        'allow_participant_recipient_type_metadata' => 'allowParticipantRecipientTypeMetadata',
        'allow_payment_processing' => 'allowPaymentProcessing',
        'allow_payment_processing_metadata' => 'allowPaymentProcessingMetadata',
        'allow_performance_analytics' => 'allowPerformanceAnalytics',
        'allow_performance_analytics_metadata' => 'allowPerformanceAnalyticsMetadata',
        'allow_phone_authentication' => 'allowPhoneAuthentication',
        'allow_phone_authentication_metadata' => 'allowPhoneAuthenticationMetadata',
        'allow_phone_auth_override' => 'allowPhoneAuthOverride',
        'allow_phone_auth_override_metadata' => 'allowPhoneAuthOverrideMetadata',
        'allow_private_signing_groups' => 'allowPrivateSigningGroups',
        'allow_private_signing_groups_metadata' => 'allowPrivateSigningGroupsMetadata',
        'allow_recipient_connect' => 'allowRecipientConnect',
        'allow_recipient_connect_metadata' => 'allowRecipientConnectMetadata',
        'allow_reminders' => 'allowReminders',
        'allow_reminders_metadata' => 'allowRemindersMetadata',
        'allow_remote_notary' => 'allowRemoteNotary',
        'allow_remote_notary_metadata' => 'allowRemoteNotaryMetadata',
        'allow_resource_file_branding' => 'allowResourceFileBranding',
        'allow_resource_file_branding_metadata' => 'allowResourceFileBrandingMetadata',
        'allow_safe_bio_pharma_signer_certificate' => 'allowSafeBioPharmaSignerCertificate',
        'allow_safe_bio_pharma_signer_certificate_metadata' => 'allowSafeBioPharmaSignerCertificateMetadata',
        'allow_scheduled_sending' => 'allowScheduledSending',
        'allow_scheduled_sending_metadata' => 'allowScheduledSendingMetadata',
        'allow_security_appliance' => 'allowSecurityAppliance',
        'allow_security_appliance_metadata' => 'allowSecurityApplianceMetadata',
        'allow_sending_envelopes_on_behalf_of_others' => 'allowSendingEnvelopesOnBehalfOfOthers',
        'allow_sending_envelopes_on_behalf_of_others_metadata' => 'allowSendingEnvelopesOnBehalfOfOthersMetadata',
        'allow_send_to_certified_delivery' => 'allowSendToCertifiedDelivery',
        'allow_send_to_certified_delivery_metadata' => 'allowSendToCertifiedDeliveryMetadata',
        'allow_send_to_intermediary' => 'allowSendToIntermediary',
        'allow_send_to_intermediary_metadata' => 'allowSendToIntermediaryMetadata',
        'allow_server_templates' => 'allowServerTemplates',
        'allow_server_templates_metadata' => 'allowServerTemplatesMetadata',
        'allow_set_embedded_recipient_start_url' => 'allowSetEmbeddedRecipientStartURL',
        'allow_set_embedded_recipient_start_url_metadata' => 'allowSetEmbeddedRecipientStartURLMetadata',
        'allow_shared_tabs' => 'allowSharedTabs',
        'allow_shared_tabs_metadata' => 'allowSharedTabsMetadata',
        'allow_signature_stamps' => 'allowSignatureStamps',
        'allow_signature_stamps_metadata' => 'allowSignatureStampsMetadata',
        'allow_sign_document_from_home_page' => 'allowSignDocumentFromHomePage',
        'allow_sign_document_from_home_page_metadata' => 'allowSignDocumentFromHomePageMetadata',
        'allow_signer_reassign' => 'allowSignerReassign',
        'allow_signer_reassign_metadata' => 'allowSignerReassignMetadata',
        'allow_signer_reassign_override' => 'allowSignerReassignOverride',
        'allow_signer_reassign_override_metadata' => 'allowSignerReassignOverrideMetadata',
        'allow_signing_extensions' => 'allowSigningExtensions',
        'allow_signing_extensions_metadata' => 'allowSigningExtensionsMetadata',
        'allow_signing_groups' => 'allowSigningGroups',
        'allow_signing_groups_metadata' => 'allowSigningGroupsMetadata',
        'allow_signing_insights' => 'allowSigningInsights',
        'allow_signing_insights_metadata' => 'allowSigningInsightsMetadata',
        'allow_signing_radio_deselect' => 'allowSigningRadioDeselect',
        'allow_signing_radio_deselect_metadata' => 'allowSigningRadioDeselectMetadata',
        'allow_sign_now' => 'allowSignNow',
        'allow_sign_now_metadata' => 'allowSignNowMetadata',
        'allow_sms_delivery' => 'allowSMSDelivery',
        'allow_sms_delivery_metadata' => 'allowSMSDeliveryMetadata',
        'allow_social_id_login' => 'allowSocialIdLogin',
        'allow_social_id_login_metadata' => 'allowSocialIdLoginMetadata',
        'allow_supplemental_documents' => 'allowSupplementalDocuments',
        'allow_supplemental_documents_metadata' => 'allowSupplementalDocumentsMetadata',
        'allow_third_party_electronic_notary' => 'allowThirdPartyElectronicNotary',
        'allow_third_party_electronic_notary_metadata' => 'allowThirdPartyElectronicNotaryMetadata',
        'allow_transactions_workspace' => 'allowTransactionsWorkspace',
        'allow_transactions_workspace_metadata' => 'allowTransactionsWorkspaceMetadata',
        'allow_transactions_workspace_original' => 'allowTransactionsWorkspaceOriginal',
        'allow_transactions_workspace_original_metadata' => 'allowTransactionsWorkspaceOriginalMetadata',
        'allow_users_to_access_directory' => 'allowUsersToAccessDirectory',
        'allow_users_to_access_directory_metadata' => 'allowUsersToAccessDirectoryMetadata',
        'allow_value_insights' => 'allowValueInsights',
        'allow_value_insights_metadata' => 'allowValueInsightsMetadata',
        'allow_web_forms' => 'allowWebForms',
        'allow_web_forms_metadata' => 'allowWebFormsMetadata',
        'allow_whats_app_delivery' => 'allowWhatsAppDelivery',
        'allow_whats_app_delivery_metadata' => 'allowWhatsAppDeliveryMetadata',
        'anchor_population_scope' => 'anchorPopulationScope',
        'anchor_population_scope_metadata' => 'anchorPopulationScopeMetadata',
        'anchor_tag_versioned_placement_enabled' => 'anchorTagVersionedPlacementEnabled',
        'anchor_tag_versioned_placement_metadata_enabled' => 'anchorTagVersionedPlacementMetadataEnabled',
        'attach_completed_envelope' => 'attachCompletedEnvelope',
        'attach_completed_envelope_metadata' => 'attachCompletedEnvelopeMetadata',
        'authentication_check' => 'authenticationCheck',
        'authentication_check_metadata' => 'authenticationCheckMetadata',
        'auto_nav_rule' => 'autoNavRule',
        'auto_nav_rule_metadata' => 'autoNavRuleMetadata',
        'auto_provision_signer_account' => 'autoProvisionSignerAccount',
        'auto_provision_signer_account_metadata' => 'autoProvisionSignerAccountMetadata',
        'bcc_email_archive' => 'bccEmailArchive',
        'bcc_email_archive_metadata' => 'bccEmailArchiveMetadata',
        'beta_switch_configuration' => 'betaSwitchConfiguration',
        'beta_switch_configuration_metadata' => 'betaSwitchConfigurationMetadata',
        'billing_address' => 'billingAddress',
        'billing_address_metadata' => 'billingAddressMetadata',
        'bulk_send' => 'bulkSend',
        'bulk_send_action_resend_limit' => 'bulkSendActionResendLimit',
        'bulk_send_max_copies_in_batch' => 'bulkSendMaxCopiesInBatch',
        'bulk_send_max_unprocessed_envelopes_count' => 'bulkSendMaxUnprocessedEnvelopesCount',
        'bulk_send_metadata' => 'bulkSendMetadata',
        'can_self_brand_send' => 'canSelfBrandSend',
        'can_self_brand_send_metadata' => 'canSelfBrandSendMetadata',
        'can_self_brand_sign' => 'canSelfBrandSign',
        'can_self_brand_sign_metadata' => 'canSelfBrandSignMetadata',
        'can_use_salesforce_o_auth' => 'canUseSalesforceOAuth',
        'can_use_salesforce_o_auth_metadata' => 'canUseSalesforceOAuthMetadata',
        'capture_voice_recording' => 'captureVoiceRecording',
        'capture_voice_recording_metadata' => 'captureVoiceRecordingMetadata',
        'cfr21_simplified_signing_enabled' => 'cfr21SimplifiedSigningEnabled',
        'cfr21_simplified_signing_enabled_metadata' => 'cfr21SimplifiedSigningEnabledMetadata',
        'cfr_use_wide_image' => 'cfrUseWideImage',
        'cfr_use_wide_image_metadata' => 'cfrUseWideImageMetadata',
        'check_for_multiple_admins_on_account' => 'checkForMultipleAdminsOnAccount',
        'check_for_multiple_admins_on_account_metadata' => 'checkForMultipleAdminsOnAccountMetadata',
        'chrome_signature_enabled' => 'chromeSignatureEnabled',
        'chrome_signature_enabled_metadata' => 'chromeSignatureEnabledMetadata',
        'comment_email_show_message_text' => 'commentEmailShowMessageText',
        'comment_email_show_message_text_metadata' => 'commentEmailShowMessageTextMetadata',
        'comments_allow_envelope_override' => 'commentsAllowEnvelopeOverride',
        'comments_allow_envelope_override_metadata' => 'commentsAllowEnvelopeOverrideMetadata',
        'conditional_fields_enabled' => 'conditionalFieldsEnabled',
        'conditional_fields_enabled_metadata' => 'conditionalFieldsEnabledMetadata',
        'consumer_disclosure_frequency' => 'consumerDisclosureFrequency',
        'consumer_disclosure_frequency_metadata' => 'consumerDisclosureFrequencyMetadata',
        'convert_pdf_fields' => 'convertPdfFields',
        'convert_pdf_fields_metadata' => 'convertPdfFieldsMetadata',
        'data_population_scope' => 'dataPopulationScope',
        'data_population_scope_metadata' => 'dataPopulationScopeMetadata',
        'default_to_advanced_envelopes_filter_form' => 'defaultToAdvancedEnvelopesFilterForm',
        'default_to_advanced_envelopes_filter_form_metadata' => 'defaultToAdvancedEnvelopesFilterFormMetadata',
        'disable_auto_template_matching' => 'disableAutoTemplateMatching',
        'disable_auto_template_matching_metadata' => 'disableAutoTemplateMatchingMetadata',
        'disable_mobile_app' => 'disableMobileApp',
        'disable_mobile_app_metadata' => 'disableMobileAppMetadata',
        'disable_mobile_push_notifications' => 'disableMobilePushNotifications',
        'disable_mobile_push_notifications_metadata' => 'disableMobilePushNotificationsMetadata',
        'disable_mobile_sending' => 'disableMobileSending',
        'disable_mobile_sending_metadata' => 'disableMobileSendingMetadata',
        'disable_multiple_sessions' => 'disableMultipleSessions',
        'disable_multiple_sessions_metadata' => 'disableMultipleSessionsMetadata',
        'disable_purge_notifications_for_sender_metadata' => 'disablePurgeNotificationsForSenderMetadata',
        'disable_signer_cert_view' => 'disableSignerCertView',
        'disable_signer_cert_view_metadata' => 'disableSignerCertViewMetadata',
        'disable_signer_history_view' => 'disableSignerHistoryView',
        'disable_signer_history_view_metadata' => 'disableSignerHistoryViewMetadata',
        'disable_style_signature' => 'disableStyleSignature',
        'disable_style_signature_metadata' => 'disableStyleSignatureMetadata',
        'disable_upload_signature' => 'disableUploadSignature',
        'disable_upload_signature_metadata' => 'disableUploadSignatureMetadata',
        'disable_user_sharing' => 'disableUserSharing',
        'disable_user_sharing_metadata' => 'disableUserSharingMetadata',
        'display_beta_switch' => 'displayBetaSwitch',
        'display_beta_switch_metadata' => 'displayBetaSwitchMetadata',
        'document_conversion_restrictions' => 'documentConversionRestrictions',
        'document_conversion_restrictions_metadata' => 'documentConversionRestrictionsMetadata',
        'document_retention' => 'documentRetention',
        'document_retention_metadata' => 'documentRetentionMetadata',
        'document_retention_purge_tabs' => 'documentRetentionPurgeTabs',
        'document_visibility' => 'documentVisibility',
        'document_visibility_metadata' => 'documentVisibilityMetadata',
        'draft_envelope_retention' => 'draftEnvelopeRetention',
        'draft_envelope_retention_metadata' => 'draftEnvelopeRetentionMetadata',
        'dss_enable_provisioning_pen_configuration_radmin_option' => 'dss_EnableProvisioningPenConfiguration_RadminOption',
        'dss_sign_28411_enable_leave_page_prompt_radmin_option' => 'dss_SIGN_28411_EnableLeavePagePrompt_RadminOption',
        'dss_sign_29182_slide_up_bar_radmin_option' => 'dss_SIGN_29182_SlideUpBar_RadminOption',
        'email_template_version' => 'emailTemplateVersion',
        'email_template_version_metadata' => 'emailTemplateVersionMetadata',
        'enable_access_code_generator' => 'enableAccessCodeGenerator',
        'enable_access_code_generator_metadata' => 'enableAccessCodeGeneratorMetadata',
        'enable_account_wide_search' => 'enableAccountWideSearch',
        'enable_account_wide_search_metadata' => 'enableAccountWideSearchMetadata',
        'enable_adm_healthcare' => 'enableAdmHealthcare',
        'enable_adm_healthcare_metadata' => 'enableAdmHealthcareMetadata',
        'enable_advanced_envelopes_search' => 'enableAdvancedEnvelopesSearch',
        'enable_advanced_envelopes_search_metadata' => 'enableAdvancedEnvelopesSearchMetadata',
        'enable_advanced_payments' => 'enableAdvancedPayments',
        'enable_advanced_payments_metadata' => 'enableAdvancedPaymentsMetadata',
        'enable_advanced_power_forms' => 'enableAdvancedPowerForms',
        'enable_advanced_power_forms_metadata' => 'enableAdvancedPowerFormsMetadata',
        'enable_agreement_actions_for_clm' => 'enableAgreementActionsForCLM',
        'enable_agreement_actions_for_clm_metadata' => 'enableAgreementActionsForCLMMetadata',
        'enable_agreement_actions_for_e_sign' => 'enableAgreementActionsForESign',
        'enable_agreement_actions_for_e_sign_metadata' => 'enableAgreementActionsForESignMetadata',
        'enable_auto_nav' => 'enableAutoNav',
        'enable_auto_nav_metadata' => 'enableAutoNavMetadata',
        'enable_bcc_dummy_link' => 'enableBccDummyLink',
        'enable_bcc_dummy_link_metadata' => 'enableBccDummyLinkMetadata',
        'enable_calculated_fields' => 'enableCalculatedFields',
        'enable_calculated_fields_metadata' => 'enableCalculatedFieldsMetadata',
        'enable_click_plus' => 'enableClickPlus',
        'enable_click_plus_conditional_content' => 'enableClickPlusConditionalContent',
        'enable_click_plus_conditional_content_meta_data' => 'enableClickPlusConditionalContentMetaData',
        'enable_click_plus_custom_fields' => 'enableClickPlusCustomFields',
        'enable_click_plus_custom_fields_meta_data' => 'enableClickPlusCustomFieldsMetaData',
        'enable_click_plus_custom_style' => 'enableClickPlusCustomStyle',
        'enable_click_plus_custom_style_meta_data' => 'enableClickPlusCustomStyleMetaData',
        'enable_click_plus_dynamic_content' => 'enableClickPlusDynamicContent',
        'enable_click_plus_dynamic_content_meta_data' => 'enableClickPlusDynamicContentMetaData',
        'enable_click_plus_meta_data' => 'enableClickPlusMetaData',
        'enable_clickwraps' => 'enableClickwraps',
        'enable_clickwraps_metadata' => 'enableClickwrapsMetadata',
        'enable_combined_pdf_download_for_sbs' => 'enableCombinedPDFDownloadForSBS',
        'enable_comments_history_download_in_signing' => 'enableCommentsHistoryDownloadInSigning',
        'enable_comments_history_download_in_signing_metadata' => 'enableCommentsHistoryDownloadInSigningMetadata',
        'enable_contact_suggestions' => 'enableContactSuggestions',
        'enable_contact_suggestions_metadata' => 'enableContactSuggestionsMetadata',
        'enable_customer_satisfaction_metric_tracking' => 'enableCustomerSatisfactionMetricTracking',
        'enable_customer_satisfaction_metric_tracking_metadata' => 'enableCustomerSatisfactionMetricTrackingMetadata',
        'enable_d_sig_eu_advanced_pens' => 'enableDSigEUAdvancedPens',
        'enable_d_sig_eu_advanced_pens_metadata' => 'enableDSigEUAdvancedPensMetadata',
        'enable_d_sig_express_pens' => 'enableDSigExpressPens',
        'enable_d_sig_express_pens_metadata' => 'enableDSigExpressPensMetadata',
        'enable_d_sig_id_check_for_aes_pens' => 'enableDSigIDCheckForAESPens',
        'enable_d_sig_id_check_for_aes_pens_metadata' => 'enableDSigIDCheckForAESPensMetadata',
        'enable_d_sig_id_check_in_person_for_qes_pens' => 'enableDSigIDCheckInPersonForQESPens',
        'enable_d_sig_id_check_in_person_for_qes_pens_metadata' => 'enableDSigIDCheckInPersonForQESPensMetadata',
        'enable_d_sig_id_check_remote_for_qes_pens' => 'enableDSigIDCheckRemoteForQESPens',
        'enable_d_sig_id_check_remote_for_qes_pens_metadata' => 'enableDSigIDCheckRemoteForQESPensMetadata',
        'enable_d_sig_id_verification_pens' => 'enableDSigIDVerificationPens',
        'enable_d_sig_id_verification_pens_metadata' => 'enableDSigIDVerificationPensMetadata',
        'enable_d_sig_id_verification_premier_pens' => 'enableDSigIDVerificationPremierPens',
        'enable_d_sig_id_verification_premier_pens_metadata' => 'enableDSigIDVerificationPremierPensMetadata',
        'enable_ds_pro' => 'enableDSPro',
        'enable_ds_pro_metadata' => 'enableDSProMetadata',
        'enable_enforce_tls_emails_setting_metadata' => 'enableEnforceTlsEmailsSettingMetadata',
        'enable_envelope_stamping_by_account_admin' => 'enableEnvelopeStampingByAccountAdmin',
        'enable_envelope_stamping_by_account_admin_metadata' => 'enableEnvelopeStampingByAccountAdminMetadata',
        'enable_envelope_stamping_by_ds_admin' => 'enableEnvelopeStampingByDSAdmin',
        'enable_envelope_stamping_by_ds_admin_metadata' => 'enableEnvelopeStampingByDSAdminMetadata',
        'enable_e_sign_api_hourly_limit_management' => 'enableESignAPIHourlyLimitManagement',
        'enable_e_sign_api_hourly_limit_management_metadata' => 'enableESignAPIHourlyLimitManagementMetadata',
        'enable_esign_communities' => 'enableEsignCommunities',
        'enable_esign_communities_metadata' => 'enableEsignCommunitiesMetadata',
        'enable_id_fx_accountless_sms_auth_for_part11' => 'enableIDFxAccountlessSMSAuthForPart11',
        'enable_id_fx_accountless_sms_auth_for_part11_metadata' => 'enableIDFxAccountlessSMSAuthForPart11Metadata',
        'enable_id_fx_intuit_kba' => 'enableIDFxIntuitKBA',
        'enable_id_fx_intuit_kba_metadata' => 'enableIDFxIntuitKBAMetadata',
        'enable_id_fx_phone_authentication' => 'enableIDFxPhoneAuthentication',
        'enable_id_fx_phone_authentication_metadata' => 'enableIDFxPhoneAuthenticationMetadata',
        'enable_idfx_phone_auth_signature_auth_status' => 'enableIdfxPhoneAuthSignatureAuthStatus',
        'enable_idfx_phone_auth_signature_auth_status_metadata' => 'enableIdfxPhoneAuthSignatureAuthStatusMetadata',
        'enable_inbox_browse_views_powered_by_elastic_search' => 'enableInboxBrowseViewsPoweredByElasticSearch',
        'enable_inbox_browse_views_powered_by_elastic_search_metadata' => 'enableInboxBrowseViewsPoweredByElasticSearchMetadata',
        'enable_inbox_relevance_sort' => 'enableInboxRelevanceSort',
        'enable_inbox_relevance_sort_for_recent_accounts' => 'enableInboxRelevanceSortForRecentAccounts',
        'enable_inbox_relevance_sort_for_recent_accounts_metadata' => 'enableInboxRelevanceSortForRecentAccountsMetadata',
        'enable_inbox_relevance_sort_metadata' => 'enableInboxRelevanceSortMetadata',
        'enable_in_browser_editor' => 'enableInBrowserEditor',
        'enable_in_browser_editor_metadata' => 'enableInBrowserEditorMetadata',
        'enable_key_terms_suggestions_by_document_type' => 'enableKeyTermsSuggestionsByDocumentType',
        'enable_key_terms_suggestions_by_document_type_metadata' => 'enableKeyTermsSuggestionsByDocumentTypeMetadata',
        'enable_participant_recipient_setting_metadata' => 'enableParticipantRecipientSettingMetadata',
        'enable_payment_processing' => 'enablePaymentProcessing',
        'enable_payment_processing_metadata' => 'enablePaymentProcessingMetadata',
        'enable_pdfa_conversion' => 'enablePDFAConversion',
        'enable_pdfa_conversion_metadata' => 'enablePDFAConversionMetadata',
        'enable_power_form' => 'enablePowerForm',
        'enable_power_form_direct' => 'enablePowerFormDirect',
        'enable_power_form_direct_metadata' => 'enablePowerFormDirectMetadata',
        'enable_power_form_metadata' => 'enablePowerFormMetadata',
        'enable_recipient_domain_validation' => 'enableRecipientDomainValidation',
        'enable_recipient_domain_validation_metadata' => 'enableRecipientDomainValidationMetadata',
        'enable_recipient_may_provide_phone_number' => 'enableRecipientMayProvidePhoneNumber',
        'enable_recipient_may_provide_phone_number_metadata' => 'enableRecipientMayProvidePhoneNumberMetadata',
        'enable_report_links' => 'enableReportLinks',
        'enable_report_links_metadata' => 'enableReportLinksMetadata',
        'enable_require_sign_on_paper' => 'enableRequireSignOnPaper',
        'enable_require_sign_on_paper_metadata' => 'enableRequireSignOnPaperMetadata',
        'enable_reserved_domain' => 'enableReservedDomain',
        'enable_reserved_domain_metadata' => 'enableReservedDomainMetadata',
        'enable_responsive_signing' => 'enableResponsiveSigning',
        'enable_responsive_signing_metadata' => 'enableResponsiveSigningMetadata',
        'enable_scheduled_release' => 'enableScheduledRelease',
        'enable_scheduled_release_metadata' => 'enableScheduledReleaseMetadata',
        'enable_search' => 'enableSearch',
        'enable_search_metadata' => 'enableSearchMetadata',
        'enable_search_service_azure_uri' => 'enableSearchServiceAzureUri',
        'enable_search_service_azure_uri_metadata' => 'enableSearchServiceAzureUriMetadata',
        'enable_search_site_specific_api' => 'enableSearchSiteSpecificApi',
        'enable_search_site_specific_api_metadata' => 'enableSearchSiteSpecificApiMetadata',
        'enable_search_ui' => 'enableSearchUI',
        'enable_search_ui_metadata' => 'enableSearchUIMetadata',
        'enable_sending_tags_font_settings' => 'enableSendingTagsFontSettings',
        'enable_sending_tags_font_settings_metadata' => 'enableSendingTagsFontSettingsMetadata',
        'enable_send_to_agent' => 'enableSendToAgent',
        'enable_send_to_agent_metadata' => 'enableSendToAgentMetadata',
        'enable_send_to_intermediary' => 'enableSendToIntermediary',
        'enable_send_to_intermediary_metadata' => 'enableSendToIntermediaryMetadata',
        'enable_send_to_manage' => 'enableSendToManage',
        'enable_send_to_manage_metadata' => 'enableSendToManageMetadata',
        'enable_sequential_signing_api' => 'enableSequentialSigningAPI',
        'enable_sequential_signing_api_metadata' => 'enableSequentialSigningAPIMetadata',
        'enable_sequential_signing_ui' => 'enableSequentialSigningUI',
        'enable_sequential_signing_ui_metadata' => 'enableSequentialSigningUIMetadata',
        'enable_signer_attachments' => 'enableSignerAttachments',
        'enable_signer_attachments_metadata' => 'enableSignerAttachmentsMetadata',
        'enable_signing_extension_comments' => 'enableSigningExtensionComments',
        'enable_signing_extension_comments_metadata' => 'enableSigningExtensionCommentsMetadata',
        'enable_signing_extension_conversations' => 'enableSigningExtensionConversations',
        'enable_signing_extension_conversations_metadata' => 'enableSigningExtensionConversationsMetadata',
        'enable_signing_order_settings_for_account' => 'enableSigningOrderSettingsForAccount',
        'enable_signing_order_settings_for_account_metadata' => 'enableSigningOrderSettingsForAccountMetadata',
        'enable_sign_on_paper' => 'enableSignOnPaper',
        'enable_sign_on_paper_metadata' => 'enableSignOnPaperMetadata',
        'enable_sign_on_paper_override' => 'enableSignOnPaperOverride',
        'enable_sign_on_paper_override_metadata' => 'enableSignOnPaperOverrideMetadata',
        'enable_sign_with_notary' => 'enableSignWithNotary',
        'enable_sign_with_notary_metadata' => 'enableSignWithNotaryMetadata',
        'enable_smart_contracts' => 'enableSmartContracts',
        'enable_smart_contracts_metadata' => 'enableSmartContractsMetadata',
        'enable_sms_authentication' => 'enableSMSAuthentication',
        'enable_sms_authentication_metadata' => 'enableSMSAuthenticationMetadata',
        'enable_sms_delivery_additional_notification' => 'enableSMSDeliveryAdditionalNotification',
        'enable_sms_delivery_additional_notification_metadata' => 'enableSMSDeliveryAdditionalNotificationMetadata',
        'enable_sms_delivery_primary' => 'enableSMSDeliveryPrimary',
        'enable_social_id_login' => 'enableSocialIdLogin',
        'enable_social_id_login_metadata' => 'enableSocialIdLoginMetadata',
        'enable_strike_through' => 'enableStrikeThrough',
        'enable_strike_through_metadata' => 'enableStrikeThroughMetadata',
        'enable_transaction_point' => 'enableTransactionPoint',
        'enable_transaction_point_metadata' => 'enableTransactionPointMetadata',
        'enable_vaulting' => 'enableVaulting',
        'enable_vaulting_metadata' => 'enableVaultingMetadata',
        'enable_web_forms_separate_user_permissions' => 'enableWebFormsSeparateUserPermissions',
        'enable_web_forms_separate_user_permissions_metadata' => 'enableWebFormsSeparateUserPermissionsMetadata',
        'enable_witnessing' => 'enableWitnessing',
        'enable_witnessing_metadata' => 'enableWitnessingMetadata',
        'enforce_template_name_uniqueness' => 'enforceTemplateNameUniqueness',
        'enforce_template_name_uniqueness_metadata' => 'enforceTemplateNameUniquenessMetadata',
        'enforce_tls_emails' => 'enforceTlsEmails',
        'enforce_tls_emails_metadata' => 'enforceTlsEmailsMetadata',
        'envelope_integration_allowed' => 'envelopeIntegrationAllowed',
        'envelope_integration_allowed_metadata' => 'envelopeIntegrationAllowedMetadata',
        'envelope_integration_enabled' => 'envelopeIntegrationEnabled',
        'envelope_integration_enabled_metadata' => 'envelopeIntegrationEnabledMetadata',
        'envelope_limits_total_document_size_allowed_in_mb' => 'EnvelopeLimitsTotalDocumentSizeAllowedInMB',
        'envelope_limits_total_document_size_allowed_in_mb_enabled' => 'EnvelopeLimitsTotalDocumentSizeAllowedInMBEnabled',
        'envelope_limits_total_document_size_allowed_in_mb_enabled_metadata' => 'EnvelopeLimitsTotalDocumentSizeAllowedInMBEnabledMetadata',
        'envelope_limits_total_document_size_allowed_in_mb_metadata' => 'EnvelopeLimitsTotalDocumentSizeAllowedInMBMetadata',
        'envelope_search_mode' => 'envelopeSearchMode',
        'envelope_search_mode_metadata' => 'envelopeSearchModeMetadata',
        'envelope_stamping_default_value' => 'envelopeStampingDefaultValue',
        'envelope_stamping_default_value_metadata' => 'envelopeStampingDefaultValueMetadata',
        'exit_prompt' => 'exitPrompt',
        'exit_prompt_metadata' => 'exitPromptMetadata',
        'express_send' => 'expressSend',
        'express_send_allow_tabs' => 'expressSendAllowTabs',
        'express_send_allow_tabs_metadata' => 'expressSendAllowTabsMetadata',
        'express_send_metadata' => 'expressSendMetadata',
        'external_document_sources' => 'externalDocumentSources',
        'external_signature_pad_type' => 'externalSignaturePadType',
        'external_signature_pad_type_metadata' => 'externalSignaturePadTypeMetadata',
        'fax_out_enabled' => 'faxOutEnabled',
        'fax_out_enabled_metadata' => 'faxOutEnabledMetadata',
        'finish_reminder' => 'finishReminder',
        'finish_reminder_metadata' => 'finishReminderMetadata',
        'guided_forms_html_allowed' => 'guidedFormsHtmlAllowed',
        'guided_forms_html_allowed_metadata' => 'guidedFormsHtmlAllowedMetadata',
        'guided_forms_html_conversion_policy' => 'guidedFormsHtmlConversionPolicy',
        'guided_forms_html_conversion_policy_metadata' => 'guidedFormsHtmlConversionPolicyMetadata',
        'has_recipient_connect_claimed_domain' => 'hasRecipientConnectClaimedDomain',
        'hide_account_address_in_co_c' => 'hideAccountAddressInCoC',
        'hide_account_address_in_co_c_metadata' => 'hideAccountAddressInCoCMetadata',
        'hide_pricing' => 'hidePricing',
        'hide_pricing_metadata' => 'hidePricingMetadata',
        'id_check_configurations' => 'idCheckConfigurations',
        'id_check_expire' => 'idCheckExpire',
        'id_check_expire_days' => 'idCheckExpireDays',
        'id_check_expire_days_metadata' => 'idCheckExpireDaysMetadata',
        'id_check_expire_metadata' => 'idCheckExpireMetadata',
        'id_check_expire_minutes' => 'idCheckExpireMinutes',
        'id_check_expire_minutes_metadata' => 'idCheckExpireMinutesMetadata',
        'id_check_required' => 'idCheckRequired',
        'id_check_required_metadata' => 'idCheckRequiredMetadata',
        'identity_verification' => 'identityVerification',
        'identity_verification_metadata' => 'identityVerificationMetadata',
        'idfx_kba_authentication_override' => 'idfxKBAAuthenticationOverride',
        'idfx_kba_authentication_override_metadata' => 'idfxKBAAuthenticationOverrideMetadata',
        'idfx_phone_authentication_override' => 'idfxPhoneAuthenticationOverride',
        'idfx_phone_authentication_override_metadata' => 'idfxPhoneAuthenticationOverrideMetadata',
        'ignore_error_if_anchor_tab_not_found' => 'ignoreErrorIfAnchorTabNotFound',
        'ignore_error_if_anchor_tab_not_found_metadata_enabled' => 'ignoreErrorIfAnchorTabNotFoundMetadataEnabled',
        'in_person_id_check_question' => 'inPersonIDCheckQuestion',
        'in_person_id_check_question_metadata' => 'inPersonIDCheckQuestionMetadata',
        'in_person_signing_enabled' => 'inPersonSigningEnabled',
        'in_person_signing_enabled_metadata' => 'inPersonSigningEnabledMetadata',
        'in_session_enabled' => 'inSessionEnabled',
        'in_session_enabled_metadata' => 'inSessionEnabledMetadata',
        'in_session_suppress_emails' => 'inSessionSuppressEmails',
        'in_session_suppress_emails_metadata' => 'inSessionSuppressEmailsMetadata',
        'is_connect_document_fields_enabled' => 'isConnectDocumentFieldsEnabled',
        'linked_external_primary_accounts' => 'linkedExternalPrimaryAccounts',
        'maximum_signing_groups' => 'maximumSigningGroups',
        'maximum_signing_groups_metadata' => 'maximumSigningGroupsMetadata',
        'maximum_users_per_signing_group' => 'maximumUsersPerSigningGroup',
        'maximum_users_per_signing_group_metadata' => 'maximumUsersPerSigningGroupMetadata',
        'max_number_of_custom_stamps' => 'maxNumberOfCustomStamps',
        'merge_mixed_mode_results' => 'mergeMixedModeResults',
        'merge_mixed_mode_results_metadata' => 'mergeMixedModeResultsMetadata',
        'mobile_session_timeout' => 'mobileSessionTimeout',
        'mobile_session_timeout_metadata' => 'mobileSessionTimeoutMetadata',
        'number_of_active_custom_stamps' => 'numberOfActiveCustomStamps',
        'opt_in_mobile_signing_v02' => 'optInMobileSigningV02',
        'opt_in_mobile_signing_v02_metadata' => 'optInMobileSigningV02Metadata',
        'opt_in_universal_signatures' => 'optInUniversalSignatures',
        'opt_out_auto_nav_text_and_tab_color_updates' => 'optOutAutoNavTextAndTabColorUpdates',
        'opt_out_auto_nav_text_and_tab_color_updates_metadata' => 'optOutAutoNavTextAndTabColorUpdatesMetadata',
        'opt_out_new_platform_seal' => 'optOutNewPlatformSeal',
        'opt_out_new_platform_seal_platform_metadata' => 'optOutNewPlatformSealPlatformMetadata',
        'pdf_max_chunked_upload_part_size' => 'pdfMaxChunkedUploadPartSize',
        'pdf_max_chunked_upload_part_size_metadata' => 'pdfMaxChunkedUploadPartSizeMetadata',
        'pdf_max_chunked_upload_total_size' => 'pdfMaxChunkedUploadTotalSize',
        'pdf_max_chunked_upload_total_size_metadata' => 'pdfMaxChunkedUploadTotalSizeMetadata',
        'pdf_max_individual_upload_size' => 'pdfMaxIndividualUploadSize',
        'pdf_max_individual_upload_size_metadata' => 'pdfMaxIndividualUploadSizeMetadata',
        'phone_auth_recipient_may_provide_phone_number' => 'phoneAuthRecipientMayProvidePhoneNumber',
        'phone_auth_recipient_may_provide_phone_number_metadata' => 'phoneAuthRecipientMayProvidePhoneNumberMetadata',
        'pki_sign_downloaded_pdf_docs' => 'pkiSignDownloadedPDFDocs',
        'pki_sign_downloaded_pdf_docs_metadata' => 'pkiSignDownloadedPDFDocsMetadata',
        'read_only_mode' => 'readOnlyMode',
        'read_only_mode_metadata' => 'readOnlyModeMetadata',
        'recipients_can_sign_offline' => 'recipientsCanSignOffline',
        'recipients_can_sign_offline_metadata' => 'recipientsCanSignOfflineMetadata',
        'recipient_signing_auto_navigation_control' => 'recipientSigningAutoNavigationControl',
        'recipient_signing_auto_navigation_control_metadata' => 'recipientSigningAutoNavigationControlMetadata',
        'require21_cf_rpt11_compliance' => 'require21CFRpt11Compliance',
        'require21_cf_rpt11_compliance_metadata' => 'require21CFRpt11ComplianceMetadata',
        'require_decline_reason' => 'requireDeclineReason',
        'require_decline_reason_metadata' => 'requireDeclineReasonMetadata',
        'require_external_user_management' => 'requireExternalUserManagement',
        'require_external_user_management_metadata' => 'requireExternalUserManagementMetadata',
        'require_signer_certificate_type' => 'requireSignerCertificateType',
        'require_signer_certificate_type_metadata' => 'requireSignerCertificateTypeMetadata',
        'rsa_verid_account_name' => 'rsaVeridAccountName',
        'rsa_verid_password' => 'rsaVeridPassword',
        'rsa_verid_ruleset' => 'rsaVeridRuleset',
        'rsa_verid_user_id' => 'rsaVeridUserId',
        'sbs_transaction_level' => 'sbsTransactionLevel',
        'self_signed_recipient_email_document' => 'selfSignedRecipientEmailDocument',
        'self_signed_recipient_email_document_metadata' => 'selfSignedRecipientEmailDocumentMetadata',
        'self_signed_recipient_email_document_user_override' => 'selfSignedRecipientEmailDocumentUserOverride',
        'self_signed_recipient_email_document_user_override_metadata' => 'selfSignedRecipientEmailDocumentUserOverrideMetadata',
        'sender_can_sign_in_each_location' => 'senderCanSignInEachLocation',
        'sender_can_sign_in_each_location_metadata' => 'senderCanSignInEachLocationMetadata',
        'sender_must_authenticate_signing' => 'senderMustAuthenticateSigning',
        'sender_must_authenticate_signing_metadata' => 'senderMustAuthenticateSigningMetadata',
        'sending_tags_font_color' => 'sendingTagsFontColor',
        'sending_tags_font_color_metadata' => 'sendingTagsFontColorMetadata',
        'sending_tags_font_name' => 'sendingTagsFontName',
        'sending_tags_font_name_metadata' => 'sendingTagsFontNameMetadata',
        'sending_tags_font_size' => 'sendingTagsFontSize',
        'sending_tags_font_size_metadata' => 'sendingTagsFontSizeMetadata',
        'send_lockout_recipient_notification' => 'sendLockoutRecipientNotification',
        'send_lockout_recipient_notification_metadata' => 'sendLockoutRecipientNotificationMetadata',
        'send_to_certified_delivery_enabled' => 'sendToCertifiedDeliveryEnabled',
        'send_to_certified_delivery_enabled_metadata' => 'sendToCertifiedDeliveryEnabledMetadata',
        'session_timeout' => 'sessionTimeout',
        'session_timeout_metadata' => 'sessionTimeoutMetadata',
        'set_recip_email_lang' => 'setRecipEmailLang',
        'set_recip_email_lang_metadata' => 'setRecipEmailLangMetadata',
        'set_recip_sign_lang' => 'setRecipSignLang',
        'set_recip_sign_lang_metadata' => 'setRecipSignLangMetadata',
        'shared_template_folders' => 'sharedTemplateFolders',
        'shared_template_folders_metadata' => 'sharedTemplateFoldersMetadata',
        'show_complete_dialog_in_embedded_session' => 'showCompleteDialogInEmbeddedSession',
        'show_complete_dialog_in_embedded_session_metadata' => 'showCompleteDialogInEmbeddedSessionMetadata',
        'show_conditional_routing_on_send' => 'showConditionalRoutingOnSend',
        'show_conditional_routing_on_send_metadata' => 'showConditionalRoutingOnSendMetadata',
        'show_initial_conditional_fields' => 'showInitialConditionalFields',
        'show_initial_conditional_fields_metadata' => 'showInitialConditionalFieldsMetadata',
        'show_localized_watermarks' => 'showLocalizedWatermarks',
        'show_localized_watermarks_metadata' => 'showLocalizedWatermarksMetadata',
        'show_masked_fields_when_downloading_document_as_sender' => 'showMaskedFieldsWhenDownloadingDocumentAsSender',
        'show_masked_fields_when_downloading_document_as_sender_metadata' => 'showMaskedFieldsWhenDownloadingDocumentAsSenderMetadata',
        'show_tutorials' => 'showTutorials',
        'show_tutorials_metadata' => 'showTutorialsMetadata',
        'signature_providers' => 'signatureProviders',
        'signature_providers_metadata' => 'signatureProvidersMetadata',
        'sign_date_format' => 'signDateFormat',
        'sign_date_format_metadata' => 'signDateFormatMetadata',
        'sign_date_time_account_language_override' => 'signDateTimeAccountLanguageOverride',
        'sign_date_time_account_language_override_metadata' => 'signDateTimeAccountLanguageOverrideMetadata',
        'sign_date_time_account_timezone_override' => 'signDateTimeAccountTimezoneOverride',
        'sign_date_time_account_timezone_override_metadata' => 'signDateTimeAccountTimezoneOverrideMetadata',
        'signer_attach_certificate_to_envelope_pdf' => 'signerAttachCertificateToEnvelopePDF',
        'signer_attach_certificate_to_envelope_pdf_metadata' => 'signerAttachCertificateToEnvelopePDFMetadata',
        'signer_attach_concat' => 'signerAttachConcat',
        'signer_attach_concat_metadata' => 'signerAttachConcatMetadata',
        'signer_can_create_account' => 'signerCanCreateAccount',
        'signer_can_create_account_metadata' => 'signerCanCreateAccountMetadata',
        'signer_can_sign_on_mobile' => 'signerCanSignOnMobile',
        'signer_can_sign_on_mobile_metadata' => 'signerCanSignOnMobileMetadata',
        'signer_in_session_use_envelope_complete_email' => 'signerInSessionUseEnvelopeCompleteEmail',
        'signer_in_session_use_envelope_complete_email_metadata' => 'signerInSessionUseEnvelopeCompleteEmailMetadata',
        'signer_login_requirements' => 'signerLoginRequirements',
        'signer_login_requirements_metadata' => 'signerLoginRequirementsMetadata',
        'signer_must_have_account' => 'signerMustHaveAccount',
        'signer_must_have_account_metadata' => 'signerMustHaveAccountMetadata',
        'signer_must_login_to_sign' => 'signerMustLoginToSign',
        'signer_must_login_to_sign_metadata' => 'signerMustLoginToSignMetadata',
        'signer_show_secure_field_initial_values' => 'signerShowSecureFieldInitialValues',
        'signer_show_secure_field_initial_values_metadata' => 'signerShowSecureFieldInitialValuesMetadata',
        'signing_session_timeout' => 'signingSessionTimeout',
        'signing_session_timeout_metadata' => 'signingSessionTimeoutMetadata',
        'signing_ui_version' => 'signingUiVersion',
        'signing_ui_version_metadata' => 'signingUiVersionMetadata',
        'sign_time_format' => 'signTimeFormat',
        'sign_time_format_metadata' => 'signTimeFormatMetadata',
        'sign_time_show_am_pm' => 'signTimeShowAmPm',
        'sign_time_show_am_pm_metadata' => 'signTimeShowAmPmMetadata',
        'simplified_sending_enabled' => 'simplifiedSendingEnabled',
        'simplified_sending_enabled_metadata' => 'simplifiedSendingEnabledMetadata',
        'single_sign_on_enabled' => 'singleSignOnEnabled',
        'single_sign_on_enabled_metadata' => 'singleSignOnEnabledMetadata',
        'skip_auth_completed_envelopes' => 'skipAuthCompletedEnvelopes',
        'skip_auth_completed_envelopes_metadata' => 'skipAuthCompletedEnvelopesMetadata',
        'social_id_recip_auth' => 'socialIdRecipAuth',
        'social_id_recip_auth_metadata' => 'socialIdRecipAuthMetadata',
        'specify_document_visibility' => 'specifyDocumentVisibility',
        'specify_document_visibility_metadata' => 'specifyDocumentVisibilityMetadata',
        'start_in_advanced_correct' => 'startInAdvancedCorrect',
        'start_in_advanced_correct_metadata' => 'startInAdvancedCorrectMetadata',
        'supplemental_documents_must_accept' => 'supplementalDocumentsMustAccept',
        'supplemental_documents_must_accept_metadata' => 'supplementalDocumentsMustAcceptMetadata',
        'supplemental_documents_must_read' => 'supplementalDocumentsMustRead',
        'supplemental_documents_must_read_metadata' => 'supplementalDocumentsMustReadMetadata',
        'supplemental_documents_must_view' => 'supplementalDocumentsMustView',
        'supplemental_documents_must_view_metadata' => 'supplementalDocumentsMustViewMetadata',
        'suppress_certificate_enforcement' => 'suppressCertificateEnforcement',
        'suppress_certificate_enforcement_metadata' => 'suppressCertificateEnforcementMetadata',
        'tab_account_settings' => 'tabAccountSettings',
        'timezone_offset_api' => 'timezoneOffsetAPI',
        'timezone_offset_api_metadata' => 'timezoneOffsetAPIMetadata',
        'timezone_offset_ui' => 'timezoneOffsetUI',
        'timezone_offset_ui_metadata' => 'timezoneOffsetUIMetadata',
        'universal_signature_opt_in' => 'universalSignatureOptIn',
        'use_account_level_email' => 'useAccountLevelEmail',
        'use_account_level_email_metadata' => 'useAccountLevelEmailMetadata',
        'use_consumer_disclosure' => 'useConsumerDisclosure',
        'use_consumer_disclosure_metadata' => 'useConsumerDisclosureMetadata',
        'use_consumer_disclosure_within_account' => 'useConsumerDisclosureWithinAccount',
        'use_consumer_disclosure_within_account_metadata' => 'useConsumerDisclosureWithinAccountMetadata',
        'use_derived_keys' => 'useDerivedKeys',
        'use_derived_keys_metadata' => 'useDerivedKeysMetadata',
        'use_docu_sign_express_signer_certificate' => 'useDocuSignExpressSignerCertificate',
        'use_docu_sign_express_signer_certificate_metadata' => 'useDocuSignExpressSignerCertificateMetadata',
        'use_envelope_search_mixed_mode' => 'useEnvelopeSearchMixedMode',
        'use_envelope_search_mixed_mode_metadata' => 'useEnvelopeSearchMixedModeMetadata',
        'use_multi_app_groups_data' => 'useMultiAppGroupsData',
        'use_multi_app_groups_data_metadata' => 'useMultiAppGroupsDataMetadata',
        'use_new_blob_for_pdf' => 'useNewBlobForPdf',
        'use_new_blob_for_pdf_metadata' => 'useNewBlobForPdfMetadata',
        'use_new_envelope_search' => 'useNewEnvelopeSearch',
        'use_new_envelope_search_metadata' => 'useNewEnvelopeSearchMetadata',
        'use_new_envelope_search_only_when_searching_after_date' => 'useNewEnvelopeSearchOnlyWhenSearchingAfterDate',
        'use_new_envelope_search_only_when_searching_after_date_metadata' => 'useNewEnvelopeSearchOnlyWhenSearchingAfterDateMetadata',
        'use_new_envelope_search_only_with_search_term' => 'useNewEnvelopeSearchOnlyWithSearchTerm',
        'use_new_envelope_search_only_with_search_term_metadata' => 'useNewEnvelopeSearchOnlyWithSearchTermMetadata',
        'use_safe_signer_certificates' => 'useSAFESignerCertificates',
        'use_safe_signer_certificates_metadata' => 'useSAFESignerCertificatesMetadata',
        'uses_api' => 'usesAPI',
        'uses_api_metadata' => 'usesAPIMetadata',
        'use_signature_provider_platform' => 'useSignatureProviderPlatform',
        'use_signature_provider_platform_metadata' => 'useSignatureProviderPlatformMetadata',
        'use_smart_contracts_v1' => 'useSmartContractsV1',
        'validations_allowed' => 'validationsAllowed',
        'validations_allowed_metadata' => 'validationsAllowedMetadata',
        'validations_brand' => 'validationsBrand',
        'validations_brand_metadata' => 'validationsBrandMetadata',
        'validations_cadence' => 'validationsCadence',
        'validations_cadence_metadata' => 'validationsCadenceMetadata',
        'validations_enabled' => 'validationsEnabled',
        'validations_enabled_metadata' => 'validationsEnabledMetadata',
        'validations_report' => 'validationsReport',
        'validations_report_metadata' => 'validationsReportMetadata',
        'water_mark_enabled' => 'waterMarkEnabled',
        'water_mark_enabled_metadata' => 'waterMarkEnabledMetadata',
        'write_reminder_to_envelope_history' => 'writeReminderToEnvelopeHistory',
        'write_reminder_to_envelope_history_metadata' => 'writeReminderToEnvelopeHistoryMetadata',
        'wurfl_min_allowable_screen_size' => 'wurflMinAllowableScreenSize',
        'wurfl_min_allowable_screen_size_metadata' => 'wurflMinAllowableScreenSizeMetadata'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'access_code_format' => 'setAccessCodeFormat',
        'account_date_time_format' => 'setAccountDateTimeFormat',
        'account_date_time_format_metadata' => 'setAccountDateTimeFormatMetadata',
        'account_default_language' => 'setAccountDefaultLanguage',
        'account_default_language_metadata' => 'setAccountDefaultLanguageMetadata',
        'account_name' => 'setAccountName',
        'account_name_metadata' => 'setAccountNameMetadata',
        'account_notification' => 'setAccountNotification',
        'account_ui_settings' => 'setAccountUiSettings',
        'adopt_sig_config' => 'setAdoptSigConfig',
        'adopt_sig_config_metadata' => 'setAdoptSigConfigMetadata',
        'advanced_correct' => 'setAdvancedCorrect',
        'advanced_correct_metadata' => 'setAdvancedCorrectMetadata',
        'advanced_search_enable_tab_field' => 'setAdvancedSearchEnableTabField',
        'advanced_search_enable_tab_field_metadata' => 'setAdvancedSearchEnableTabFieldMetadata',
        'advanced_search_enable_template_id_field' => 'setAdvancedSearchEnableTemplateIdField',
        'advanced_search_enable_template_id_field_metadata' => 'setAdvancedSearchEnableTemplateIdFieldMetadata',
        'advanced_search_enable_template_name_field' => 'setAdvancedSearchEnableTemplateNameField',
        'advanced_search_enable_template_name_field_metadata' => 'setAdvancedSearchEnableTemplateNameFieldMetadata',
        'allow_access_code_format' => 'setAllowAccessCodeFormat',
        'allow_access_code_format_metadata' => 'setAllowAccessCodeFormatMetadata',
        'allow_account_management_granular' => 'setAllowAccountManagementGranular',
        'allow_account_management_granular_metadata' => 'setAllowAccountManagementGranularMetadata',
        'allow_account_member_name_change' => 'setAllowAccountMemberNameChange',
        'allow_account_member_name_change_metadata' => 'setAllowAccountMemberNameChangeMetadata',
        'allow_ace' => 'setAllowAce',
        'allow_ace_metadata' => 'setAllowAceMetadata',
        'allow_advanced_recipient_routing_conditional' => 'setAllowAdvancedRecipientRoutingConditional',
        'allow_advanced_recipient_routing_conditional_metadata' => 'setAllowAdvancedRecipientRoutingConditionalMetadata',
        'allow_agent_name_email_edit' => 'setAllowAgentNameEmailEdit',
        'allow_agent_name_email_edit_metadata' => 'setAllowAgentNameEmailEditMetadata',
        'allow_agreement_actions' => 'setAllowAgreementActions',
        'allow_agreement_actions_metadata' => 'setAllowAgreementActionsMetadata',
        'allow_agreement_orchestrations' => 'setAllowAgreementOrchestrations',
        'allow_agreement_orchestrations_metadata' => 'setAllowAgreementOrchestrationsMetadata',
        'allow_auto_nav_settings' => 'setAllowAutoNavSettings',
        'allow_auto_nav_settings_metadata' => 'setAllowAutoNavSettingsMetadata',
        'allow_auto_tagging' => 'setAllowAutoTagging',
        'allow_auto_tagging_metadata' => 'setAllowAutoTaggingMetadata',
        'allow_bulk_send' => 'setAllowBulkSend',
        'allow_bulk_send_metadata' => 'setAllowBulkSendMetadata',
        'allow_cd_withdraw' => 'setAllowCdWithdraw',
        'allow_cd_withdraw_metadata' => 'setAllowCdWithdrawMetadata',
        'allow_connect_http_listener_configs' => 'setAllowConnectHttpListenerConfigs',
        'allow_connect_identity_verification_ui' => 'setAllowConnectIdentityVerificationUi',
        'allow_connect_o_auth_ui' => 'setAllowConnectOAuthUi',
        'allow_connect_send_finish_later' => 'setAllowConnectSendFinishLater',
        'allow_connect_send_finish_later_metadata' => 'setAllowConnectSendFinishLaterMetadata',
        'allow_connect_unified_payload_ui' => 'setAllowConnectUnifiedPayloadUi',
        'allow_consumer_disclosure_override' => 'setAllowConsumerDisclosureOverride',
        'allow_consumer_disclosure_override_metadata' => 'setAllowConsumerDisclosureOverrideMetadata',
        'allow_data_download' => 'setAllowDataDownload',
        'allow_data_download_metadata' => 'setAllowDataDownloadMetadata',
        'allow_delayed_routing' => 'setAllowDelayedRouting',
        'allow_delayed_routing_metadata' => 'setAllowDelayedRoutingMetadata',
        'allow_delegated_signing' => 'setAllowDelegatedSigning',
        'allow_delegated_signing_metadata' => 'setAllowDelegatedSigningMetadata',
        'allow_doc_gen_documents' => 'setAllowDocGenDocuments',
        'allow_doc_gen_documents_metadata' => 'setAllowDocGenDocumentsMetadata',
        'allow_document_disclosures' => 'setAllowDocumentDisclosures',
        'allow_document_disclosures_metadata' => 'setAllowDocumentDisclosuresMetadata',
        'allow_documents_on_signed_envelopes' => 'setAllowDocumentsOnSignedEnvelopes',
        'allow_documents_on_signed_envelopes_metadata' => 'setAllowDocumentsOnSignedEnvelopesMetadata',
        'allow_document_visibility' => 'setAllowDocumentVisibility',
        'allow_document_visibility_metadata' => 'setAllowDocumentVisibilityMetadata',
        'allow_editing_envelopes_on_behalf_of_others' => 'setAllowEditingEnvelopesOnBehalfOfOthers',
        'allow_editing_envelopes_on_behalf_of_others_metadata' => 'setAllowEditingEnvelopesOnBehalfOfOthersMetadata',
        'allow_e_hanko_stamps' => 'setAllowEHankoStamps',
        'allow_e_hanko_stamps_metadata' => 'setAllowEHankoStampsMetadata',
        'allow_e_note_e_original' => 'setAllowENoteEOriginal',
        'allow_e_note_e_original_metadata' => 'setAllowENoteEOriginalMetadata',
        'allow_envelope_correct' => 'setAllowEnvelopeCorrect',
        'allow_envelope_correct_metadata' => 'setAllowEnvelopeCorrectMetadata',
        'allow_envelope_custody_transfer' => 'setAllowEnvelopeCustodyTransfer',
        'allow_envelope_custody_transfer_metadata' => 'setAllowEnvelopeCustodyTransferMetadata',
        'allow_envelope_custom_fields' => 'setAllowEnvelopeCustomFields',
        'allow_envelope_custom_fields_metadata' => 'setAllowEnvelopeCustomFieldsMetadata',
        'allow_envelope_publish_reporting' => 'setAllowEnvelopePublishReporting',
        'allow_envelope_publish_reporting_metadata' => 'setAllowEnvelopePublishReportingMetadata',
        'allow_envelope_reporting' => 'setAllowEnvelopeReporting',
        'allow_envelope_reporting_metadata' => 'setAllowEnvelopeReportingMetadata',
        'allow_expression' => 'setAllowExpression',
        'allow_expression_metadata' => 'setAllowExpressionMetadata',
        'allow_express_signer_certificate' => 'setAllowExpressSignerCertificate',
        'allow_express_signer_certificate_metadata' => 'setAllowExpressSignerCertificateMetadata',
        'allow_extended_sending_resource_file' => 'setAllowExtendedSendingResourceFile',
        'allow_extended_sending_resource_file_metadata' => 'setAllowExtendedSendingResourceFileMetadata',
        'allow_external_linked_accounts' => 'setAllowExternalLinkedAccounts',
        'allow_external_linked_accounts_metadata' => 'setAllowExternalLinkedAccountsMetadata',
        'allow_external_signature_pad' => 'setAllowExternalSignaturePad',
        'allow_external_signature_pad_metadata' => 'setAllowExternalSignaturePadMetadata',
        'allow_idv_for_eu_qualified_signatures' => 'setAllowIdvForEuQualifiedSignatures',
        'allow_idv_for_eu_qualified_signatures_metadata' => 'setAllowIdvForEuQualifiedSignaturesMetadata',
        'allow_idv_level1' => 'setAllowIdvLevel1',
        'allow_idv_level1_metadata' => 'setAllowIdvLevel1Metadata',
        'allow_idv_level1_trial' => 'setAllowIdvLevel1Trial',
        'allow_idv_level1_trial_metadata' => 'setAllowIdvLevel1TrialMetadata',
        'allow_idv_level2' => 'setAllowIdvLevel2',
        'allow_idv_level2_metadata' => 'setAllowIdvLevel2Metadata',
        'allow_idv_level3' => 'setAllowIdvLevel3',
        'allow_idv_level3_metadata' => 'setAllowIdvLevel3Metadata',
        'allow_idv_platform' => 'setAllowIdvPlatform',
        'allow_idv_platform_metadata' => 'setAllowIdvPlatformMetadata',
        'allow_in_person' => 'setAllowInPerson',
        'allow_in_person_electronic_notary' => 'setAllowInPersonElectronicNotary',
        'allow_in_person_electronic_notary_metadata' => 'setAllowInPersonElectronicNotaryMetadata',
        'allow_in_person_metadata' => 'setAllowInPersonMetadata',
        'allow_managed_stamps' => 'setAllowManagedStamps',
        'allow_managed_stamps_metadata' => 'setAllowManagedStampsMetadata',
        'allow_managing_envelopes_on_behalf_of_others' => 'setAllowManagingEnvelopesOnBehalfOfOthers',
        'allow_managing_envelopes_on_behalf_of_others_metadata' => 'setAllowManagingEnvelopesOnBehalfOfOthersMetadata',
        'allow_markup' => 'setAllowMarkup',
        'allow_markup_metadata' => 'setAllowMarkupMetadata',
        'allow_member_time_zone' => 'setAllowMemberTimeZone',
        'allow_member_time_zone_metadata' => 'setAllowMemberTimeZoneMetadata',
        'allow_merge_fields' => 'setAllowMergeFields',
        'allow_merge_fields_metadata' => 'setAllowMergeFieldsMetadata',
        'allow_multiple_brand_profiles' => 'setAllowMultipleBrandProfiles',
        'allow_multiple_brand_profiles_metadata' => 'setAllowMultipleBrandProfilesMetadata',
        'allow_multiple_signer_attachments' => 'setAllowMultipleSignerAttachments',
        'allow_multiple_signer_attachments_metadata' => 'setAllowMultipleSignerAttachmentsMetadata',
        'allow_non_us_phone_auth' => 'setAllowNonUsPhoneAuth',
        'allow_non_us_phone_auth_metadata' => 'setAllowNonUsPhoneAuthMetadata',
        'allow_ocr_of_envelope_documents' => 'setAllowOcrOfEnvelopeDocuments',
        'allow_ocr_of_envelope_documents_metadata' => 'setAllowOcrOfEnvelopeDocumentsMetadata',
        'allow_offline_signing' => 'setAllowOfflineSigning',
        'allow_offline_signing_metadata' => 'setAllowOfflineSigningMetadata',
        'allow_open_trust_signer_certificate' => 'setAllowOpenTrustSignerCertificate',
        'allow_open_trust_signer_certificate_metadata' => 'setAllowOpenTrustSignerCertificateMetadata',
        'allow_organization_docusign_monitor' => 'setAllowOrganizationDocusignMonitor',
        'allow_organization_docusign_monitor_free' => 'setAllowOrganizationDocusignMonitorFree',
        'allow_organization_docusign_monitor_free_metadata' => 'setAllowOrganizationDocusignMonitorFreeMetadata',
        'allow_organization_docusign_monitor_metadata' => 'setAllowOrganizationDocusignMonitorMetadata',
        'allow_organization_domain_user_management' => 'setAllowOrganizationDomainUserManagement',
        'allow_organization_domain_user_management_metadata' => 'setAllowOrganizationDomainUserManagementMetadata',
        'allow_organizations' => 'setAllowOrganizations',
        'allow_organizations_metadata' => 'setAllowOrganizationsMetadata',
        'allow_organization_sso_management' => 'setAllowOrganizationSsoManagement',
        'allow_organization_sso_management_metadata' => 'setAllowOrganizationSsoManagementMetadata',
        'allow_organization_to_use_in_person_electronic_notary' => 'setAllowOrganizationToUseInPersonElectronicNotary',
        'allow_organization_to_use_in_person_electronic_notary_metadata' => 'setAllowOrganizationToUseInPersonElectronicNotaryMetadata',
        'allow_organization_to_use_remote_notary' => 'setAllowOrganizationToUseRemoteNotary',
        'allow_organization_to_use_remote_notary_metadata' => 'setAllowOrganizationToUseRemoteNotaryMetadata',
        'allow_organization_to_use_third_party_electronic_notary' => 'setAllowOrganizationToUseThirdPartyElectronicNotary',
        'allow_organization_to_use_third_party_electronic_notary_metadata' => 'setAllowOrganizationToUseThirdPartyElectronicNotaryMetadata',
        'allow_participant_recipient_type' => 'setAllowParticipantRecipientType',
        'allow_participant_recipient_type_metadata' => 'setAllowParticipantRecipientTypeMetadata',
        'allow_payment_processing' => 'setAllowPaymentProcessing',
        'allow_payment_processing_metadata' => 'setAllowPaymentProcessingMetadata',
        'allow_performance_analytics' => 'setAllowPerformanceAnalytics',
        'allow_performance_analytics_metadata' => 'setAllowPerformanceAnalyticsMetadata',
        'allow_phone_authentication' => 'setAllowPhoneAuthentication',
        'allow_phone_authentication_metadata' => 'setAllowPhoneAuthenticationMetadata',
        'allow_phone_auth_override' => 'setAllowPhoneAuthOverride',
        'allow_phone_auth_override_metadata' => 'setAllowPhoneAuthOverrideMetadata',
        'allow_private_signing_groups' => 'setAllowPrivateSigningGroups',
        'allow_private_signing_groups_metadata' => 'setAllowPrivateSigningGroupsMetadata',
        'allow_recipient_connect' => 'setAllowRecipientConnect',
        'allow_recipient_connect_metadata' => 'setAllowRecipientConnectMetadata',
        'allow_reminders' => 'setAllowReminders',
        'allow_reminders_metadata' => 'setAllowRemindersMetadata',
        'allow_remote_notary' => 'setAllowRemoteNotary',
        'allow_remote_notary_metadata' => 'setAllowRemoteNotaryMetadata',
        'allow_resource_file_branding' => 'setAllowResourceFileBranding',
        'allow_resource_file_branding_metadata' => 'setAllowResourceFileBrandingMetadata',
        'allow_safe_bio_pharma_signer_certificate' => 'setAllowSafeBioPharmaSignerCertificate',
        'allow_safe_bio_pharma_signer_certificate_metadata' => 'setAllowSafeBioPharmaSignerCertificateMetadata',
        'allow_scheduled_sending' => 'setAllowScheduledSending',
        'allow_scheduled_sending_metadata' => 'setAllowScheduledSendingMetadata',
        'allow_security_appliance' => 'setAllowSecurityAppliance',
        'allow_security_appliance_metadata' => 'setAllowSecurityApplianceMetadata',
        'allow_sending_envelopes_on_behalf_of_others' => 'setAllowSendingEnvelopesOnBehalfOfOthers',
        'allow_sending_envelopes_on_behalf_of_others_metadata' => 'setAllowSendingEnvelopesOnBehalfOfOthersMetadata',
        'allow_send_to_certified_delivery' => 'setAllowSendToCertifiedDelivery',
        'allow_send_to_certified_delivery_metadata' => 'setAllowSendToCertifiedDeliveryMetadata',
        'allow_send_to_intermediary' => 'setAllowSendToIntermediary',
        'allow_send_to_intermediary_metadata' => 'setAllowSendToIntermediaryMetadata',
        'allow_server_templates' => 'setAllowServerTemplates',
        'allow_server_templates_metadata' => 'setAllowServerTemplatesMetadata',
        'allow_set_embedded_recipient_start_url' => 'setAllowSetEmbeddedRecipientStartUrl',
        'allow_set_embedded_recipient_start_url_metadata' => 'setAllowSetEmbeddedRecipientStartUrlMetadata',
        'allow_shared_tabs' => 'setAllowSharedTabs',
        'allow_shared_tabs_metadata' => 'setAllowSharedTabsMetadata',
        'allow_signature_stamps' => 'setAllowSignatureStamps',
        'allow_signature_stamps_metadata' => 'setAllowSignatureStampsMetadata',
        'allow_sign_document_from_home_page' => 'setAllowSignDocumentFromHomePage',
        'allow_sign_document_from_home_page_metadata' => 'setAllowSignDocumentFromHomePageMetadata',
        'allow_signer_reassign' => 'setAllowSignerReassign',
        'allow_signer_reassign_metadata' => 'setAllowSignerReassignMetadata',
        'allow_signer_reassign_override' => 'setAllowSignerReassignOverride',
        'allow_signer_reassign_override_metadata' => 'setAllowSignerReassignOverrideMetadata',
        'allow_signing_extensions' => 'setAllowSigningExtensions',
        'allow_signing_extensions_metadata' => 'setAllowSigningExtensionsMetadata',
        'allow_signing_groups' => 'setAllowSigningGroups',
        'allow_signing_groups_metadata' => 'setAllowSigningGroupsMetadata',
        'allow_signing_insights' => 'setAllowSigningInsights',
        'allow_signing_insights_metadata' => 'setAllowSigningInsightsMetadata',
        'allow_signing_radio_deselect' => 'setAllowSigningRadioDeselect',
        'allow_signing_radio_deselect_metadata' => 'setAllowSigningRadioDeselectMetadata',
        'allow_sign_now' => 'setAllowSignNow',
        'allow_sign_now_metadata' => 'setAllowSignNowMetadata',
        'allow_sms_delivery' => 'setAllowSmsDelivery',
        'allow_sms_delivery_metadata' => 'setAllowSmsDeliveryMetadata',
        'allow_social_id_login' => 'setAllowSocialIdLogin',
        'allow_social_id_login_metadata' => 'setAllowSocialIdLoginMetadata',
        'allow_supplemental_documents' => 'setAllowSupplementalDocuments',
        'allow_supplemental_documents_metadata' => 'setAllowSupplementalDocumentsMetadata',
        'allow_third_party_electronic_notary' => 'setAllowThirdPartyElectronicNotary',
        'allow_third_party_electronic_notary_metadata' => 'setAllowThirdPartyElectronicNotaryMetadata',
        'allow_transactions_workspace' => 'setAllowTransactionsWorkspace',
        'allow_transactions_workspace_metadata' => 'setAllowTransactionsWorkspaceMetadata',
        'allow_transactions_workspace_original' => 'setAllowTransactionsWorkspaceOriginal',
        'allow_transactions_workspace_original_metadata' => 'setAllowTransactionsWorkspaceOriginalMetadata',
        'allow_users_to_access_directory' => 'setAllowUsersToAccessDirectory',
        'allow_users_to_access_directory_metadata' => 'setAllowUsersToAccessDirectoryMetadata',
        'allow_value_insights' => 'setAllowValueInsights',
        'allow_value_insights_metadata' => 'setAllowValueInsightsMetadata',
        'allow_web_forms' => 'setAllowWebForms',
        'allow_web_forms_metadata' => 'setAllowWebFormsMetadata',
        'allow_whats_app_delivery' => 'setAllowWhatsAppDelivery',
        'allow_whats_app_delivery_metadata' => 'setAllowWhatsAppDeliveryMetadata',
        'anchor_population_scope' => 'setAnchorPopulationScope',
        'anchor_population_scope_metadata' => 'setAnchorPopulationScopeMetadata',
        'anchor_tag_versioned_placement_enabled' => 'setAnchorTagVersionedPlacementEnabled',
        'anchor_tag_versioned_placement_metadata_enabled' => 'setAnchorTagVersionedPlacementMetadataEnabled',
        'attach_completed_envelope' => 'setAttachCompletedEnvelope',
        'attach_completed_envelope_metadata' => 'setAttachCompletedEnvelopeMetadata',
        'authentication_check' => 'setAuthenticationCheck',
        'authentication_check_metadata' => 'setAuthenticationCheckMetadata',
        'auto_nav_rule' => 'setAutoNavRule',
        'auto_nav_rule_metadata' => 'setAutoNavRuleMetadata',
        'auto_provision_signer_account' => 'setAutoProvisionSignerAccount',
        'auto_provision_signer_account_metadata' => 'setAutoProvisionSignerAccountMetadata',
        'bcc_email_archive' => 'setBccEmailArchive',
        'bcc_email_archive_metadata' => 'setBccEmailArchiveMetadata',
        'beta_switch_configuration' => 'setBetaSwitchConfiguration',
        'beta_switch_configuration_metadata' => 'setBetaSwitchConfigurationMetadata',
        'billing_address' => 'setBillingAddress',
        'billing_address_metadata' => 'setBillingAddressMetadata',
        'bulk_send' => 'setBulkSend',
        'bulk_send_action_resend_limit' => 'setBulkSendActionResendLimit',
        'bulk_send_max_copies_in_batch' => 'setBulkSendMaxCopiesInBatch',
        'bulk_send_max_unprocessed_envelopes_count' => 'setBulkSendMaxUnprocessedEnvelopesCount',
        'bulk_send_metadata' => 'setBulkSendMetadata',
        'can_self_brand_send' => 'setCanSelfBrandSend',
        'can_self_brand_send_metadata' => 'setCanSelfBrandSendMetadata',
        'can_self_brand_sign' => 'setCanSelfBrandSign',
        'can_self_brand_sign_metadata' => 'setCanSelfBrandSignMetadata',
        'can_use_salesforce_o_auth' => 'setCanUseSalesforceOAuth',
        'can_use_salesforce_o_auth_metadata' => 'setCanUseSalesforceOAuthMetadata',
        'capture_voice_recording' => 'setCaptureVoiceRecording',
        'capture_voice_recording_metadata' => 'setCaptureVoiceRecordingMetadata',
        'cfr21_simplified_signing_enabled' => 'setCfr21SimplifiedSigningEnabled',
        'cfr21_simplified_signing_enabled_metadata' => 'setCfr21SimplifiedSigningEnabledMetadata',
        'cfr_use_wide_image' => 'setCfrUseWideImage',
        'cfr_use_wide_image_metadata' => 'setCfrUseWideImageMetadata',
        'check_for_multiple_admins_on_account' => 'setCheckForMultipleAdminsOnAccount',
        'check_for_multiple_admins_on_account_metadata' => 'setCheckForMultipleAdminsOnAccountMetadata',
        'chrome_signature_enabled' => 'setChromeSignatureEnabled',
        'chrome_signature_enabled_metadata' => 'setChromeSignatureEnabledMetadata',
        'comment_email_show_message_text' => 'setCommentEmailShowMessageText',
        'comment_email_show_message_text_metadata' => 'setCommentEmailShowMessageTextMetadata',
        'comments_allow_envelope_override' => 'setCommentsAllowEnvelopeOverride',
        'comments_allow_envelope_override_metadata' => 'setCommentsAllowEnvelopeOverrideMetadata',
        'conditional_fields_enabled' => 'setConditionalFieldsEnabled',
        'conditional_fields_enabled_metadata' => 'setConditionalFieldsEnabledMetadata',
        'consumer_disclosure_frequency' => 'setConsumerDisclosureFrequency',
        'consumer_disclosure_frequency_metadata' => 'setConsumerDisclosureFrequencyMetadata',
        'convert_pdf_fields' => 'setConvertPdfFields',
        'convert_pdf_fields_metadata' => 'setConvertPdfFieldsMetadata',
        'data_population_scope' => 'setDataPopulationScope',
        'data_population_scope_metadata' => 'setDataPopulationScopeMetadata',
        'default_to_advanced_envelopes_filter_form' => 'setDefaultToAdvancedEnvelopesFilterForm',
        'default_to_advanced_envelopes_filter_form_metadata' => 'setDefaultToAdvancedEnvelopesFilterFormMetadata',
        'disable_auto_template_matching' => 'setDisableAutoTemplateMatching',
        'disable_auto_template_matching_metadata' => 'setDisableAutoTemplateMatchingMetadata',
        'disable_mobile_app' => 'setDisableMobileApp',
        'disable_mobile_app_metadata' => 'setDisableMobileAppMetadata',
        'disable_mobile_push_notifications' => 'setDisableMobilePushNotifications',
        'disable_mobile_push_notifications_metadata' => 'setDisableMobilePushNotificationsMetadata',
        'disable_mobile_sending' => 'setDisableMobileSending',
        'disable_mobile_sending_metadata' => 'setDisableMobileSendingMetadata',
        'disable_multiple_sessions' => 'setDisableMultipleSessions',
        'disable_multiple_sessions_metadata' => 'setDisableMultipleSessionsMetadata',
        'disable_purge_notifications_for_sender_metadata' => 'setDisablePurgeNotificationsForSenderMetadata',
        'disable_signer_cert_view' => 'setDisableSignerCertView',
        'disable_signer_cert_view_metadata' => 'setDisableSignerCertViewMetadata',
        'disable_signer_history_view' => 'setDisableSignerHistoryView',
        'disable_signer_history_view_metadata' => 'setDisableSignerHistoryViewMetadata',
        'disable_style_signature' => 'setDisableStyleSignature',
        'disable_style_signature_metadata' => 'setDisableStyleSignatureMetadata',
        'disable_upload_signature' => 'setDisableUploadSignature',
        'disable_upload_signature_metadata' => 'setDisableUploadSignatureMetadata',
        'disable_user_sharing' => 'setDisableUserSharing',
        'disable_user_sharing_metadata' => 'setDisableUserSharingMetadata',
        'display_beta_switch' => 'setDisplayBetaSwitch',
        'display_beta_switch_metadata' => 'setDisplayBetaSwitchMetadata',
        'document_conversion_restrictions' => 'setDocumentConversionRestrictions',
        'document_conversion_restrictions_metadata' => 'setDocumentConversionRestrictionsMetadata',
        'document_retention' => 'setDocumentRetention',
        'document_retention_metadata' => 'setDocumentRetentionMetadata',
        'document_retention_purge_tabs' => 'setDocumentRetentionPurgeTabs',
        'document_visibility' => 'setDocumentVisibility',
        'document_visibility_metadata' => 'setDocumentVisibilityMetadata',
        'draft_envelope_retention' => 'setDraftEnvelopeRetention',
        'draft_envelope_retention_metadata' => 'setDraftEnvelopeRetentionMetadata',
        'dss_enable_provisioning_pen_configuration_radmin_option' => 'setDssEnableProvisioningPenConfigurationRadminOption',
        'dss_sign_28411_enable_leave_page_prompt_radmin_option' => 'setDssSign28411EnableLeavePagePromptRadminOption',
        'dss_sign_29182_slide_up_bar_radmin_option' => 'setDssSign29182SlideUpBarRadminOption',
        'email_template_version' => 'setEmailTemplateVersion',
        'email_template_version_metadata' => 'setEmailTemplateVersionMetadata',
        'enable_access_code_generator' => 'setEnableAccessCodeGenerator',
        'enable_access_code_generator_metadata' => 'setEnableAccessCodeGeneratorMetadata',
        'enable_account_wide_search' => 'setEnableAccountWideSearch',
        'enable_account_wide_search_metadata' => 'setEnableAccountWideSearchMetadata',
        'enable_adm_healthcare' => 'setEnableAdmHealthcare',
        'enable_adm_healthcare_metadata' => 'setEnableAdmHealthcareMetadata',
        'enable_advanced_envelopes_search' => 'setEnableAdvancedEnvelopesSearch',
        'enable_advanced_envelopes_search_metadata' => 'setEnableAdvancedEnvelopesSearchMetadata',
        'enable_advanced_payments' => 'setEnableAdvancedPayments',
        'enable_advanced_payments_metadata' => 'setEnableAdvancedPaymentsMetadata',
        'enable_advanced_power_forms' => 'setEnableAdvancedPowerForms',
        'enable_advanced_power_forms_metadata' => 'setEnableAdvancedPowerFormsMetadata',
        'enable_agreement_actions_for_clm' => 'setEnableAgreementActionsForClm',
        'enable_agreement_actions_for_clm_metadata' => 'setEnableAgreementActionsForClmMetadata',
        'enable_agreement_actions_for_e_sign' => 'setEnableAgreementActionsForESign',
        'enable_agreement_actions_for_e_sign_metadata' => 'setEnableAgreementActionsForESignMetadata',
        'enable_auto_nav' => 'setEnableAutoNav',
        'enable_auto_nav_metadata' => 'setEnableAutoNavMetadata',
        'enable_bcc_dummy_link' => 'setEnableBccDummyLink',
        'enable_bcc_dummy_link_metadata' => 'setEnableBccDummyLinkMetadata',
        'enable_calculated_fields' => 'setEnableCalculatedFields',
        'enable_calculated_fields_metadata' => 'setEnableCalculatedFieldsMetadata',
        'enable_click_plus' => 'setEnableClickPlus',
        'enable_click_plus_conditional_content' => 'setEnableClickPlusConditionalContent',
        'enable_click_plus_conditional_content_meta_data' => 'setEnableClickPlusConditionalContentMetaData',
        'enable_click_plus_custom_fields' => 'setEnableClickPlusCustomFields',
        'enable_click_plus_custom_fields_meta_data' => 'setEnableClickPlusCustomFieldsMetaData',
        'enable_click_plus_custom_style' => 'setEnableClickPlusCustomStyle',
        'enable_click_plus_custom_style_meta_data' => 'setEnableClickPlusCustomStyleMetaData',
        'enable_click_plus_dynamic_content' => 'setEnableClickPlusDynamicContent',
        'enable_click_plus_dynamic_content_meta_data' => 'setEnableClickPlusDynamicContentMetaData',
        'enable_click_plus_meta_data' => 'setEnableClickPlusMetaData',
        'enable_clickwraps' => 'setEnableClickwraps',
        'enable_clickwraps_metadata' => 'setEnableClickwrapsMetadata',
        'enable_combined_pdf_download_for_sbs' => 'setEnableCombinedPdfDownloadForSbs',
        'enable_comments_history_download_in_signing' => 'setEnableCommentsHistoryDownloadInSigning',
        'enable_comments_history_download_in_signing_metadata' => 'setEnableCommentsHistoryDownloadInSigningMetadata',
        'enable_contact_suggestions' => 'setEnableContactSuggestions',
        'enable_contact_suggestions_metadata' => 'setEnableContactSuggestionsMetadata',
        'enable_customer_satisfaction_metric_tracking' => 'setEnableCustomerSatisfactionMetricTracking',
        'enable_customer_satisfaction_metric_tracking_metadata' => 'setEnableCustomerSatisfactionMetricTrackingMetadata',
        'enable_d_sig_eu_advanced_pens' => 'setEnableDSigEuAdvancedPens',
        'enable_d_sig_eu_advanced_pens_metadata' => 'setEnableDSigEuAdvancedPensMetadata',
        'enable_d_sig_express_pens' => 'setEnableDSigExpressPens',
        'enable_d_sig_express_pens_metadata' => 'setEnableDSigExpressPensMetadata',
        'enable_d_sig_id_check_for_aes_pens' => 'setEnableDSigIdCheckForAesPens',
        'enable_d_sig_id_check_for_aes_pens_metadata' => 'setEnableDSigIdCheckForAesPensMetadata',
        'enable_d_sig_id_check_in_person_for_qes_pens' => 'setEnableDSigIdCheckInPersonForQesPens',
        'enable_d_sig_id_check_in_person_for_qes_pens_metadata' => 'setEnableDSigIdCheckInPersonForQesPensMetadata',
        'enable_d_sig_id_check_remote_for_qes_pens' => 'setEnableDSigIdCheckRemoteForQesPens',
        'enable_d_sig_id_check_remote_for_qes_pens_metadata' => 'setEnableDSigIdCheckRemoteForQesPensMetadata',
        'enable_d_sig_id_verification_pens' => 'setEnableDSigIdVerificationPens',
        'enable_d_sig_id_verification_pens_metadata' => 'setEnableDSigIdVerificationPensMetadata',
        'enable_d_sig_id_verification_premier_pens' => 'setEnableDSigIdVerificationPremierPens',
        'enable_d_sig_id_verification_premier_pens_metadata' => 'setEnableDSigIdVerificationPremierPensMetadata',
        'enable_ds_pro' => 'setEnableDsPro',
        'enable_ds_pro_metadata' => 'setEnableDsProMetadata',
        'enable_enforce_tls_emails_setting_metadata' => 'setEnableEnforceTlsEmailsSettingMetadata',
        'enable_envelope_stamping_by_account_admin' => 'setEnableEnvelopeStampingByAccountAdmin',
        'enable_envelope_stamping_by_account_admin_metadata' => 'setEnableEnvelopeStampingByAccountAdminMetadata',
        'enable_envelope_stamping_by_ds_admin' => 'setEnableEnvelopeStampingByDsAdmin',
        'enable_envelope_stamping_by_ds_admin_metadata' => 'setEnableEnvelopeStampingByDsAdminMetadata',
        'enable_e_sign_api_hourly_limit_management' => 'setEnableESignApiHourlyLimitManagement',
        'enable_e_sign_api_hourly_limit_management_metadata' => 'setEnableESignApiHourlyLimitManagementMetadata',
        'enable_esign_communities' => 'setEnableEsignCommunities',
        'enable_esign_communities_metadata' => 'setEnableEsignCommunitiesMetadata',
        'enable_id_fx_accountless_sms_auth_for_part11' => 'setEnableIdFxAccountlessSmsAuthForPart11',
        'enable_id_fx_accountless_sms_auth_for_part11_metadata' => 'setEnableIdFxAccountlessSmsAuthForPart11Metadata',
        'enable_id_fx_intuit_kba' => 'setEnableIdFxIntuitKba',
        'enable_id_fx_intuit_kba_metadata' => 'setEnableIdFxIntuitKbaMetadata',
        'enable_id_fx_phone_authentication' => 'setEnableIdFxPhoneAuthentication',
        'enable_id_fx_phone_authentication_metadata' => 'setEnableIdFxPhoneAuthenticationMetadata',
        'enable_idfx_phone_auth_signature_auth_status' => 'setEnableIdfxPhoneAuthSignatureAuthStatus',
        'enable_idfx_phone_auth_signature_auth_status_metadata' => 'setEnableIdfxPhoneAuthSignatureAuthStatusMetadata',
        'enable_inbox_browse_views_powered_by_elastic_search' => 'setEnableInboxBrowseViewsPoweredByElasticSearch',
        'enable_inbox_browse_views_powered_by_elastic_search_metadata' => 'setEnableInboxBrowseViewsPoweredByElasticSearchMetadata',
        'enable_inbox_relevance_sort' => 'setEnableInboxRelevanceSort',
        'enable_inbox_relevance_sort_for_recent_accounts' => 'setEnableInboxRelevanceSortForRecentAccounts',
        'enable_inbox_relevance_sort_for_recent_accounts_metadata' => 'setEnableInboxRelevanceSortForRecentAccountsMetadata',
        'enable_inbox_relevance_sort_metadata' => 'setEnableInboxRelevanceSortMetadata',
        'enable_in_browser_editor' => 'setEnableInBrowserEditor',
        'enable_in_browser_editor_metadata' => 'setEnableInBrowserEditorMetadata',
        'enable_key_terms_suggestions_by_document_type' => 'setEnableKeyTermsSuggestionsByDocumentType',
        'enable_key_terms_suggestions_by_document_type_metadata' => 'setEnableKeyTermsSuggestionsByDocumentTypeMetadata',
        'enable_participant_recipient_setting_metadata' => 'setEnableParticipantRecipientSettingMetadata',
        'enable_payment_processing' => 'setEnablePaymentProcessing',
        'enable_payment_processing_metadata' => 'setEnablePaymentProcessingMetadata',
        'enable_pdfa_conversion' => 'setEnablePdfaConversion',
        'enable_pdfa_conversion_metadata' => 'setEnablePdfaConversionMetadata',
        'enable_power_form' => 'setEnablePowerForm',
        'enable_power_form_direct' => 'setEnablePowerFormDirect',
        'enable_power_form_direct_metadata' => 'setEnablePowerFormDirectMetadata',
        'enable_power_form_metadata' => 'setEnablePowerFormMetadata',
        'enable_recipient_domain_validation' => 'setEnableRecipientDomainValidation',
        'enable_recipient_domain_validation_metadata' => 'setEnableRecipientDomainValidationMetadata',
        'enable_recipient_may_provide_phone_number' => 'setEnableRecipientMayProvidePhoneNumber',
        'enable_recipient_may_provide_phone_number_metadata' => 'setEnableRecipientMayProvidePhoneNumberMetadata',
        'enable_report_links' => 'setEnableReportLinks',
        'enable_report_links_metadata' => 'setEnableReportLinksMetadata',
        'enable_require_sign_on_paper' => 'setEnableRequireSignOnPaper',
        'enable_require_sign_on_paper_metadata' => 'setEnableRequireSignOnPaperMetadata',
        'enable_reserved_domain' => 'setEnableReservedDomain',
        'enable_reserved_domain_metadata' => 'setEnableReservedDomainMetadata',
        'enable_responsive_signing' => 'setEnableResponsiveSigning',
        'enable_responsive_signing_metadata' => 'setEnableResponsiveSigningMetadata',
        'enable_scheduled_release' => 'setEnableScheduledRelease',
        'enable_scheduled_release_metadata' => 'setEnableScheduledReleaseMetadata',
        'enable_search' => 'setEnableSearch',
        'enable_search_metadata' => 'setEnableSearchMetadata',
        'enable_search_service_azure_uri' => 'setEnableSearchServiceAzureUri',
        'enable_search_service_azure_uri_metadata' => 'setEnableSearchServiceAzureUriMetadata',
        'enable_search_site_specific_api' => 'setEnableSearchSiteSpecificApi',
        'enable_search_site_specific_api_metadata' => 'setEnableSearchSiteSpecificApiMetadata',
        'enable_search_ui' => 'setEnableSearchUi',
        'enable_search_ui_metadata' => 'setEnableSearchUiMetadata',
        'enable_sending_tags_font_settings' => 'setEnableSendingTagsFontSettings',
        'enable_sending_tags_font_settings_metadata' => 'setEnableSendingTagsFontSettingsMetadata',
        'enable_send_to_agent' => 'setEnableSendToAgent',
        'enable_send_to_agent_metadata' => 'setEnableSendToAgentMetadata',
        'enable_send_to_intermediary' => 'setEnableSendToIntermediary',
        'enable_send_to_intermediary_metadata' => 'setEnableSendToIntermediaryMetadata',
        'enable_send_to_manage' => 'setEnableSendToManage',
        'enable_send_to_manage_metadata' => 'setEnableSendToManageMetadata',
        'enable_sequential_signing_api' => 'setEnableSequentialSigningApi',
        'enable_sequential_signing_api_metadata' => 'setEnableSequentialSigningApiMetadata',
        'enable_sequential_signing_ui' => 'setEnableSequentialSigningUi',
        'enable_sequential_signing_ui_metadata' => 'setEnableSequentialSigningUiMetadata',
        'enable_signer_attachments' => 'setEnableSignerAttachments',
        'enable_signer_attachments_metadata' => 'setEnableSignerAttachmentsMetadata',
        'enable_signing_extension_comments' => 'setEnableSigningExtensionComments',
        'enable_signing_extension_comments_metadata' => 'setEnableSigningExtensionCommentsMetadata',
        'enable_signing_extension_conversations' => 'setEnableSigningExtensionConversations',
        'enable_signing_extension_conversations_metadata' => 'setEnableSigningExtensionConversationsMetadata',
        'enable_signing_order_settings_for_account' => 'setEnableSigningOrderSettingsForAccount',
        'enable_signing_order_settings_for_account_metadata' => 'setEnableSigningOrderSettingsForAccountMetadata',
        'enable_sign_on_paper' => 'setEnableSignOnPaper',
        'enable_sign_on_paper_metadata' => 'setEnableSignOnPaperMetadata',
        'enable_sign_on_paper_override' => 'setEnableSignOnPaperOverride',
        'enable_sign_on_paper_override_metadata' => 'setEnableSignOnPaperOverrideMetadata',
        'enable_sign_with_notary' => 'setEnableSignWithNotary',
        'enable_sign_with_notary_metadata' => 'setEnableSignWithNotaryMetadata',
        'enable_smart_contracts' => 'setEnableSmartContracts',
        'enable_smart_contracts_metadata' => 'setEnableSmartContractsMetadata',
        'enable_sms_authentication' => 'setEnableSmsAuthentication',
        'enable_sms_authentication_metadata' => 'setEnableSmsAuthenticationMetadata',
        'enable_sms_delivery_additional_notification' => 'setEnableSmsDeliveryAdditionalNotification',
        'enable_sms_delivery_additional_notification_metadata' => 'setEnableSmsDeliveryAdditionalNotificationMetadata',
        'enable_sms_delivery_primary' => 'setEnableSmsDeliveryPrimary',
        'enable_social_id_login' => 'setEnableSocialIdLogin',
        'enable_social_id_login_metadata' => 'setEnableSocialIdLoginMetadata',
        'enable_strike_through' => 'setEnableStrikeThrough',
        'enable_strike_through_metadata' => 'setEnableStrikeThroughMetadata',
        'enable_transaction_point' => 'setEnableTransactionPoint',
        'enable_transaction_point_metadata' => 'setEnableTransactionPointMetadata',
        'enable_vaulting' => 'setEnableVaulting',
        'enable_vaulting_metadata' => 'setEnableVaultingMetadata',
        'enable_web_forms_separate_user_permissions' => 'setEnableWebFormsSeparateUserPermissions',
        'enable_web_forms_separate_user_permissions_metadata' => 'setEnableWebFormsSeparateUserPermissionsMetadata',
        'enable_witnessing' => 'setEnableWitnessing',
        'enable_witnessing_metadata' => 'setEnableWitnessingMetadata',
        'enforce_template_name_uniqueness' => 'setEnforceTemplateNameUniqueness',
        'enforce_template_name_uniqueness_metadata' => 'setEnforceTemplateNameUniquenessMetadata',
        'enforce_tls_emails' => 'setEnforceTlsEmails',
        'enforce_tls_emails_metadata' => 'setEnforceTlsEmailsMetadata',
        'envelope_integration_allowed' => 'setEnvelopeIntegrationAllowed',
        'envelope_integration_allowed_metadata' => 'setEnvelopeIntegrationAllowedMetadata',
        'envelope_integration_enabled' => 'setEnvelopeIntegrationEnabled',
        'envelope_integration_enabled_metadata' => 'setEnvelopeIntegrationEnabledMetadata',
        'envelope_limits_total_document_size_allowed_in_mb' => 'setEnvelopeLimitsTotalDocumentSizeAllowedInMb',
        'envelope_limits_total_document_size_allowed_in_mb_enabled' => 'setEnvelopeLimitsTotalDocumentSizeAllowedInMbEnabled',
        'envelope_limits_total_document_size_allowed_in_mb_enabled_metadata' => 'setEnvelopeLimitsTotalDocumentSizeAllowedInMbEnabledMetadata',
        'envelope_limits_total_document_size_allowed_in_mb_metadata' => 'setEnvelopeLimitsTotalDocumentSizeAllowedInMbMetadata',
        'envelope_search_mode' => 'setEnvelopeSearchMode',
        'envelope_search_mode_metadata' => 'setEnvelopeSearchModeMetadata',
        'envelope_stamping_default_value' => 'setEnvelopeStampingDefaultValue',
        'envelope_stamping_default_value_metadata' => 'setEnvelopeStampingDefaultValueMetadata',
        'exit_prompt' => 'setExitPrompt',
        'exit_prompt_metadata' => 'setExitPromptMetadata',
        'express_send' => 'setExpressSend',
        'express_send_allow_tabs' => 'setExpressSendAllowTabs',
        'express_send_allow_tabs_metadata' => 'setExpressSendAllowTabsMetadata',
        'express_send_metadata' => 'setExpressSendMetadata',
        'external_document_sources' => 'setExternalDocumentSources',
        'external_signature_pad_type' => 'setExternalSignaturePadType',
        'external_signature_pad_type_metadata' => 'setExternalSignaturePadTypeMetadata',
        'fax_out_enabled' => 'setFaxOutEnabled',
        'fax_out_enabled_metadata' => 'setFaxOutEnabledMetadata',
        'finish_reminder' => 'setFinishReminder',
        'finish_reminder_metadata' => 'setFinishReminderMetadata',
        'guided_forms_html_allowed' => 'setGuidedFormsHtmlAllowed',
        'guided_forms_html_allowed_metadata' => 'setGuidedFormsHtmlAllowedMetadata',
        'guided_forms_html_conversion_policy' => 'setGuidedFormsHtmlConversionPolicy',
        'guided_forms_html_conversion_policy_metadata' => 'setGuidedFormsHtmlConversionPolicyMetadata',
        'has_recipient_connect_claimed_domain' => 'setHasRecipientConnectClaimedDomain',
        'hide_account_address_in_co_c' => 'setHideAccountAddressInCoC',
        'hide_account_address_in_co_c_metadata' => 'setHideAccountAddressInCoCMetadata',
        'hide_pricing' => 'setHidePricing',
        'hide_pricing_metadata' => 'setHidePricingMetadata',
        'id_check_configurations' => 'setIdCheckConfigurations',
        'id_check_expire' => 'setIdCheckExpire',
        'id_check_expire_days' => 'setIdCheckExpireDays',
        'id_check_expire_days_metadata' => 'setIdCheckExpireDaysMetadata',
        'id_check_expire_metadata' => 'setIdCheckExpireMetadata',
        'id_check_expire_minutes' => 'setIdCheckExpireMinutes',
        'id_check_expire_minutes_metadata' => 'setIdCheckExpireMinutesMetadata',
        'id_check_required' => 'setIdCheckRequired',
        'id_check_required_metadata' => 'setIdCheckRequiredMetadata',
        'identity_verification' => 'setIdentityVerification',
        'identity_verification_metadata' => 'setIdentityVerificationMetadata',
        'idfx_kba_authentication_override' => 'setIdfxKbaAuthenticationOverride',
        'idfx_kba_authentication_override_metadata' => 'setIdfxKbaAuthenticationOverrideMetadata',
        'idfx_phone_authentication_override' => 'setIdfxPhoneAuthenticationOverride',
        'idfx_phone_authentication_override_metadata' => 'setIdfxPhoneAuthenticationOverrideMetadata',
        'ignore_error_if_anchor_tab_not_found' => 'setIgnoreErrorIfAnchorTabNotFound',
        'ignore_error_if_anchor_tab_not_found_metadata_enabled' => 'setIgnoreErrorIfAnchorTabNotFoundMetadataEnabled',
        'in_person_id_check_question' => 'setInPersonIdCheckQuestion',
        'in_person_id_check_question_metadata' => 'setInPersonIdCheckQuestionMetadata',
        'in_person_signing_enabled' => 'setInPersonSigningEnabled',
        'in_person_signing_enabled_metadata' => 'setInPersonSigningEnabledMetadata',
        'in_session_enabled' => 'setInSessionEnabled',
        'in_session_enabled_metadata' => 'setInSessionEnabledMetadata',
        'in_session_suppress_emails' => 'setInSessionSuppressEmails',
        'in_session_suppress_emails_metadata' => 'setInSessionSuppressEmailsMetadata',
        'is_connect_document_fields_enabled' => 'setIsConnectDocumentFieldsEnabled',
        'linked_external_primary_accounts' => 'setLinkedExternalPrimaryAccounts',
        'maximum_signing_groups' => 'setMaximumSigningGroups',
        'maximum_signing_groups_metadata' => 'setMaximumSigningGroupsMetadata',
        'maximum_users_per_signing_group' => 'setMaximumUsersPerSigningGroup',
        'maximum_users_per_signing_group_metadata' => 'setMaximumUsersPerSigningGroupMetadata',
        'max_number_of_custom_stamps' => 'setMaxNumberOfCustomStamps',
        'merge_mixed_mode_results' => 'setMergeMixedModeResults',
        'merge_mixed_mode_results_metadata' => 'setMergeMixedModeResultsMetadata',
        'mobile_session_timeout' => 'setMobileSessionTimeout',
        'mobile_session_timeout_metadata' => 'setMobileSessionTimeoutMetadata',
        'number_of_active_custom_stamps' => 'setNumberOfActiveCustomStamps',
        'opt_in_mobile_signing_v02' => 'setOptInMobileSigningV02',
        'opt_in_mobile_signing_v02_metadata' => 'setOptInMobileSigningV02Metadata',
        'opt_in_universal_signatures' => 'setOptInUniversalSignatures',
        'opt_out_auto_nav_text_and_tab_color_updates' => 'setOptOutAutoNavTextAndTabColorUpdates',
        'opt_out_auto_nav_text_and_tab_color_updates_metadata' => 'setOptOutAutoNavTextAndTabColorUpdatesMetadata',
        'opt_out_new_platform_seal' => 'setOptOutNewPlatformSeal',
        'opt_out_new_platform_seal_platform_metadata' => 'setOptOutNewPlatformSealPlatformMetadata',
        'pdf_max_chunked_upload_part_size' => 'setPdfMaxChunkedUploadPartSize',
        'pdf_max_chunked_upload_part_size_metadata' => 'setPdfMaxChunkedUploadPartSizeMetadata',
        'pdf_max_chunked_upload_total_size' => 'setPdfMaxChunkedUploadTotalSize',
        'pdf_max_chunked_upload_total_size_metadata' => 'setPdfMaxChunkedUploadTotalSizeMetadata',
        'pdf_max_individual_upload_size' => 'setPdfMaxIndividualUploadSize',
        'pdf_max_individual_upload_size_metadata' => 'setPdfMaxIndividualUploadSizeMetadata',
        'phone_auth_recipient_may_provide_phone_number' => 'setPhoneAuthRecipientMayProvidePhoneNumber',
        'phone_auth_recipient_may_provide_phone_number_metadata' => 'setPhoneAuthRecipientMayProvidePhoneNumberMetadata',
        'pki_sign_downloaded_pdf_docs' => 'setPkiSignDownloadedPdfDocs',
        'pki_sign_downloaded_pdf_docs_metadata' => 'setPkiSignDownloadedPdfDocsMetadata',
        'read_only_mode' => 'setReadOnlyMode',
        'read_only_mode_metadata' => 'setReadOnlyModeMetadata',
        'recipients_can_sign_offline' => 'setRecipientsCanSignOffline',
        'recipients_can_sign_offline_metadata' => 'setRecipientsCanSignOfflineMetadata',
        'recipient_signing_auto_navigation_control' => 'setRecipientSigningAutoNavigationControl',
        'recipient_signing_auto_navigation_control_metadata' => 'setRecipientSigningAutoNavigationControlMetadata',
        'require21_cf_rpt11_compliance' => 'setRequire21CfRpt11Compliance',
        'require21_cf_rpt11_compliance_metadata' => 'setRequire21CfRpt11ComplianceMetadata',
        'require_decline_reason' => 'setRequireDeclineReason',
        'require_decline_reason_metadata' => 'setRequireDeclineReasonMetadata',
        'require_external_user_management' => 'setRequireExternalUserManagement',
        'require_external_user_management_metadata' => 'setRequireExternalUserManagementMetadata',
        'require_signer_certificate_type' => 'setRequireSignerCertificateType',
        'require_signer_certificate_type_metadata' => 'setRequireSignerCertificateTypeMetadata',
        'rsa_verid_account_name' => 'setRsaVeridAccountName',
        'rsa_verid_password' => 'setRsaVeridPassword',
        'rsa_verid_ruleset' => 'setRsaVeridRuleset',
        'rsa_verid_user_id' => 'setRsaVeridUserId',
        'sbs_transaction_level' => 'setSbsTransactionLevel',
        'self_signed_recipient_email_document' => 'setSelfSignedRecipientEmailDocument',
        'self_signed_recipient_email_document_metadata' => 'setSelfSignedRecipientEmailDocumentMetadata',
        'self_signed_recipient_email_document_user_override' => 'setSelfSignedRecipientEmailDocumentUserOverride',
        'self_signed_recipient_email_document_user_override_metadata' => 'setSelfSignedRecipientEmailDocumentUserOverrideMetadata',
        'sender_can_sign_in_each_location' => 'setSenderCanSignInEachLocation',
        'sender_can_sign_in_each_location_metadata' => 'setSenderCanSignInEachLocationMetadata',
        'sender_must_authenticate_signing' => 'setSenderMustAuthenticateSigning',
        'sender_must_authenticate_signing_metadata' => 'setSenderMustAuthenticateSigningMetadata',
        'sending_tags_font_color' => 'setSendingTagsFontColor',
        'sending_tags_font_color_metadata' => 'setSendingTagsFontColorMetadata',
        'sending_tags_font_name' => 'setSendingTagsFontName',
        'sending_tags_font_name_metadata' => 'setSendingTagsFontNameMetadata',
        'sending_tags_font_size' => 'setSendingTagsFontSize',
        'sending_tags_font_size_metadata' => 'setSendingTagsFontSizeMetadata',
        'send_lockout_recipient_notification' => 'setSendLockoutRecipientNotification',
        'send_lockout_recipient_notification_metadata' => 'setSendLockoutRecipientNotificationMetadata',
        'send_to_certified_delivery_enabled' => 'setSendToCertifiedDeliveryEnabled',
        'send_to_certified_delivery_enabled_metadata' => 'setSendToCertifiedDeliveryEnabledMetadata',
        'session_timeout' => 'setSessionTimeout',
        'session_timeout_metadata' => 'setSessionTimeoutMetadata',
        'set_recip_email_lang' => 'setSetRecipEmailLang',
        'set_recip_email_lang_metadata' => 'setSetRecipEmailLangMetadata',
        'set_recip_sign_lang' => 'setSetRecipSignLang',
        'set_recip_sign_lang_metadata' => 'setSetRecipSignLangMetadata',
        'shared_template_folders' => 'setSharedTemplateFolders',
        'shared_template_folders_metadata' => 'setSharedTemplateFoldersMetadata',
        'show_complete_dialog_in_embedded_session' => 'setShowCompleteDialogInEmbeddedSession',
        'show_complete_dialog_in_embedded_session_metadata' => 'setShowCompleteDialogInEmbeddedSessionMetadata',
        'show_conditional_routing_on_send' => 'setShowConditionalRoutingOnSend',
        'show_conditional_routing_on_send_metadata' => 'setShowConditionalRoutingOnSendMetadata',
        'show_initial_conditional_fields' => 'setShowInitialConditionalFields',
        'show_initial_conditional_fields_metadata' => 'setShowInitialConditionalFieldsMetadata',
        'show_localized_watermarks' => 'setShowLocalizedWatermarks',
        'show_localized_watermarks_metadata' => 'setShowLocalizedWatermarksMetadata',
        'show_masked_fields_when_downloading_document_as_sender' => 'setShowMaskedFieldsWhenDownloadingDocumentAsSender',
        'show_masked_fields_when_downloading_document_as_sender_metadata' => 'setShowMaskedFieldsWhenDownloadingDocumentAsSenderMetadata',
        'show_tutorials' => 'setShowTutorials',
        'show_tutorials_metadata' => 'setShowTutorialsMetadata',
        'signature_providers' => 'setSignatureProviders',
        'signature_providers_metadata' => 'setSignatureProvidersMetadata',
        'sign_date_format' => 'setSignDateFormat',
        'sign_date_format_metadata' => 'setSignDateFormatMetadata',
        'sign_date_time_account_language_override' => 'setSignDateTimeAccountLanguageOverride',
        'sign_date_time_account_language_override_metadata' => 'setSignDateTimeAccountLanguageOverrideMetadata',
        'sign_date_time_account_timezone_override' => 'setSignDateTimeAccountTimezoneOverride',
        'sign_date_time_account_timezone_override_metadata' => 'setSignDateTimeAccountTimezoneOverrideMetadata',
        'signer_attach_certificate_to_envelope_pdf' => 'setSignerAttachCertificateToEnvelopePdf',
        'signer_attach_certificate_to_envelope_pdf_metadata' => 'setSignerAttachCertificateToEnvelopePdfMetadata',
        'signer_attach_concat' => 'setSignerAttachConcat',
        'signer_attach_concat_metadata' => 'setSignerAttachConcatMetadata',
        'signer_can_create_account' => 'setSignerCanCreateAccount',
        'signer_can_create_account_metadata' => 'setSignerCanCreateAccountMetadata',
        'signer_can_sign_on_mobile' => 'setSignerCanSignOnMobile',
        'signer_can_sign_on_mobile_metadata' => 'setSignerCanSignOnMobileMetadata',
        'signer_in_session_use_envelope_complete_email' => 'setSignerInSessionUseEnvelopeCompleteEmail',
        'signer_in_session_use_envelope_complete_email_metadata' => 'setSignerInSessionUseEnvelopeCompleteEmailMetadata',
        'signer_login_requirements' => 'setSignerLoginRequirements',
        'signer_login_requirements_metadata' => 'setSignerLoginRequirementsMetadata',
        'signer_must_have_account' => 'setSignerMustHaveAccount',
        'signer_must_have_account_metadata' => 'setSignerMustHaveAccountMetadata',
        'signer_must_login_to_sign' => 'setSignerMustLoginToSign',
        'signer_must_login_to_sign_metadata' => 'setSignerMustLoginToSignMetadata',
        'signer_show_secure_field_initial_values' => 'setSignerShowSecureFieldInitialValues',
        'signer_show_secure_field_initial_values_metadata' => 'setSignerShowSecureFieldInitialValuesMetadata',
        'signing_session_timeout' => 'setSigningSessionTimeout',
        'signing_session_timeout_metadata' => 'setSigningSessionTimeoutMetadata',
        'signing_ui_version' => 'setSigningUiVersion',
        'signing_ui_version_metadata' => 'setSigningUiVersionMetadata',
        'sign_time_format' => 'setSignTimeFormat',
        'sign_time_format_metadata' => 'setSignTimeFormatMetadata',
        'sign_time_show_am_pm' => 'setSignTimeShowAmPm',
        'sign_time_show_am_pm_metadata' => 'setSignTimeShowAmPmMetadata',
        'simplified_sending_enabled' => 'setSimplifiedSendingEnabled',
        'simplified_sending_enabled_metadata' => 'setSimplifiedSendingEnabledMetadata',
        'single_sign_on_enabled' => 'setSingleSignOnEnabled',
        'single_sign_on_enabled_metadata' => 'setSingleSignOnEnabledMetadata',
        'skip_auth_completed_envelopes' => 'setSkipAuthCompletedEnvelopes',
        'skip_auth_completed_envelopes_metadata' => 'setSkipAuthCompletedEnvelopesMetadata',
        'social_id_recip_auth' => 'setSocialIdRecipAuth',
        'social_id_recip_auth_metadata' => 'setSocialIdRecipAuthMetadata',
        'specify_document_visibility' => 'setSpecifyDocumentVisibility',
        'specify_document_visibility_metadata' => 'setSpecifyDocumentVisibilityMetadata',
        'start_in_advanced_correct' => 'setStartInAdvancedCorrect',
        'start_in_advanced_correct_metadata' => 'setStartInAdvancedCorrectMetadata',
        'supplemental_documents_must_accept' => 'setSupplementalDocumentsMustAccept',
        'supplemental_documents_must_accept_metadata' => 'setSupplementalDocumentsMustAcceptMetadata',
        'supplemental_documents_must_read' => 'setSupplementalDocumentsMustRead',
        'supplemental_documents_must_read_metadata' => 'setSupplementalDocumentsMustReadMetadata',
        'supplemental_documents_must_view' => 'setSupplementalDocumentsMustView',
        'supplemental_documents_must_view_metadata' => 'setSupplementalDocumentsMustViewMetadata',
        'suppress_certificate_enforcement' => 'setSuppressCertificateEnforcement',
        'suppress_certificate_enforcement_metadata' => 'setSuppressCertificateEnforcementMetadata',
        'tab_account_settings' => 'setTabAccountSettings',
        'timezone_offset_api' => 'setTimezoneOffsetApi',
        'timezone_offset_api_metadata' => 'setTimezoneOffsetApiMetadata',
        'timezone_offset_ui' => 'setTimezoneOffsetUi',
        'timezone_offset_ui_metadata' => 'setTimezoneOffsetUiMetadata',
        'universal_signature_opt_in' => 'setUniversalSignatureOptIn',
        'use_account_level_email' => 'setUseAccountLevelEmail',
        'use_account_level_email_metadata' => 'setUseAccountLevelEmailMetadata',
        'use_consumer_disclosure' => 'setUseConsumerDisclosure',
        'use_consumer_disclosure_metadata' => 'setUseConsumerDisclosureMetadata',
        'use_consumer_disclosure_within_account' => 'setUseConsumerDisclosureWithinAccount',
        'use_consumer_disclosure_within_account_metadata' => 'setUseConsumerDisclosureWithinAccountMetadata',
        'use_derived_keys' => 'setUseDerivedKeys',
        'use_derived_keys_metadata' => 'setUseDerivedKeysMetadata',
        'use_docu_sign_express_signer_certificate' => 'setUseDocuSignExpressSignerCertificate',
        'use_docu_sign_express_signer_certificate_metadata' => 'setUseDocuSignExpressSignerCertificateMetadata',
        'use_envelope_search_mixed_mode' => 'setUseEnvelopeSearchMixedMode',
        'use_envelope_search_mixed_mode_metadata' => 'setUseEnvelopeSearchMixedModeMetadata',
        'use_multi_app_groups_data' => 'setUseMultiAppGroupsData',
        'use_multi_app_groups_data_metadata' => 'setUseMultiAppGroupsDataMetadata',
        'use_new_blob_for_pdf' => 'setUseNewBlobForPdf',
        'use_new_blob_for_pdf_metadata' => 'setUseNewBlobForPdfMetadata',
        'use_new_envelope_search' => 'setUseNewEnvelopeSearch',
        'use_new_envelope_search_metadata' => 'setUseNewEnvelopeSearchMetadata',
        'use_new_envelope_search_only_when_searching_after_date' => 'setUseNewEnvelopeSearchOnlyWhenSearchingAfterDate',
        'use_new_envelope_search_only_when_searching_after_date_metadata' => 'setUseNewEnvelopeSearchOnlyWhenSearchingAfterDateMetadata',
        'use_new_envelope_search_only_with_search_term' => 'setUseNewEnvelopeSearchOnlyWithSearchTerm',
        'use_new_envelope_search_only_with_search_term_metadata' => 'setUseNewEnvelopeSearchOnlyWithSearchTermMetadata',
        'use_safe_signer_certificates' => 'setUseSafeSignerCertificates',
        'use_safe_signer_certificates_metadata' => 'setUseSafeSignerCertificatesMetadata',
        'uses_api' => 'setUsesApi',
        'uses_api_metadata' => 'setUsesApiMetadata',
        'use_signature_provider_platform' => 'setUseSignatureProviderPlatform',
        'use_signature_provider_platform_metadata' => 'setUseSignatureProviderPlatformMetadata',
        'use_smart_contracts_v1' => 'setUseSmartContractsV1',
        'validations_allowed' => 'setValidationsAllowed',
        'validations_allowed_metadata' => 'setValidationsAllowedMetadata',
        'validations_brand' => 'setValidationsBrand',
        'validations_brand_metadata' => 'setValidationsBrandMetadata',
        'validations_cadence' => 'setValidationsCadence',
        'validations_cadence_metadata' => 'setValidationsCadenceMetadata',
        'validations_enabled' => 'setValidationsEnabled',
        'validations_enabled_metadata' => 'setValidationsEnabledMetadata',
        'validations_report' => 'setValidationsReport',
        'validations_report_metadata' => 'setValidationsReportMetadata',
        'water_mark_enabled' => 'setWaterMarkEnabled',
        'water_mark_enabled_metadata' => 'setWaterMarkEnabledMetadata',
        'write_reminder_to_envelope_history' => 'setWriteReminderToEnvelopeHistory',
        'write_reminder_to_envelope_history_metadata' => 'setWriteReminderToEnvelopeHistoryMetadata',
        'wurfl_min_allowable_screen_size' => 'setWurflMinAllowableScreenSize',
        'wurfl_min_allowable_screen_size_metadata' => 'setWurflMinAllowableScreenSizeMetadata'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'access_code_format' => 'getAccessCodeFormat',
        'account_date_time_format' => 'getAccountDateTimeFormat',
        'account_date_time_format_metadata' => 'getAccountDateTimeFormatMetadata',
        'account_default_language' => 'getAccountDefaultLanguage',
        'account_default_language_metadata' => 'getAccountDefaultLanguageMetadata',
        'account_name' => 'getAccountName',
        'account_name_metadata' => 'getAccountNameMetadata',
        'account_notification' => 'getAccountNotification',
        'account_ui_settings' => 'getAccountUiSettings',
        'adopt_sig_config' => 'getAdoptSigConfig',
        'adopt_sig_config_metadata' => 'getAdoptSigConfigMetadata',
        'advanced_correct' => 'getAdvancedCorrect',
        'advanced_correct_metadata' => 'getAdvancedCorrectMetadata',
        'advanced_search_enable_tab_field' => 'getAdvancedSearchEnableTabField',
        'advanced_search_enable_tab_field_metadata' => 'getAdvancedSearchEnableTabFieldMetadata',
        'advanced_search_enable_template_id_field' => 'getAdvancedSearchEnableTemplateIdField',
        'advanced_search_enable_template_id_field_metadata' => 'getAdvancedSearchEnableTemplateIdFieldMetadata',
        'advanced_search_enable_template_name_field' => 'getAdvancedSearchEnableTemplateNameField',
        'advanced_search_enable_template_name_field_metadata' => 'getAdvancedSearchEnableTemplateNameFieldMetadata',
        'allow_access_code_format' => 'getAllowAccessCodeFormat',
        'allow_access_code_format_metadata' => 'getAllowAccessCodeFormatMetadata',
        'allow_account_management_granular' => 'getAllowAccountManagementGranular',
        'allow_account_management_granular_metadata' => 'getAllowAccountManagementGranularMetadata',
        'allow_account_member_name_change' => 'getAllowAccountMemberNameChange',
        'allow_account_member_name_change_metadata' => 'getAllowAccountMemberNameChangeMetadata',
        'allow_ace' => 'getAllowAce',
        'allow_ace_metadata' => 'getAllowAceMetadata',
        'allow_advanced_recipient_routing_conditional' => 'getAllowAdvancedRecipientRoutingConditional',
        'allow_advanced_recipient_routing_conditional_metadata' => 'getAllowAdvancedRecipientRoutingConditionalMetadata',
        'allow_agent_name_email_edit' => 'getAllowAgentNameEmailEdit',
        'allow_agent_name_email_edit_metadata' => 'getAllowAgentNameEmailEditMetadata',
        'allow_agreement_actions' => 'getAllowAgreementActions',
        'allow_agreement_actions_metadata' => 'getAllowAgreementActionsMetadata',
        'allow_agreement_orchestrations' => 'getAllowAgreementOrchestrations',
        'allow_agreement_orchestrations_metadata' => 'getAllowAgreementOrchestrationsMetadata',
        'allow_auto_nav_settings' => 'getAllowAutoNavSettings',
        'allow_auto_nav_settings_metadata' => 'getAllowAutoNavSettingsMetadata',
        'allow_auto_tagging' => 'getAllowAutoTagging',
        'allow_auto_tagging_metadata' => 'getAllowAutoTaggingMetadata',
        'allow_bulk_send' => 'getAllowBulkSend',
        'allow_bulk_send_metadata' => 'getAllowBulkSendMetadata',
        'allow_cd_withdraw' => 'getAllowCdWithdraw',
        'allow_cd_withdraw_metadata' => 'getAllowCdWithdrawMetadata',
        'allow_connect_http_listener_configs' => 'getAllowConnectHttpListenerConfigs',
        'allow_connect_identity_verification_ui' => 'getAllowConnectIdentityVerificationUi',
        'allow_connect_o_auth_ui' => 'getAllowConnectOAuthUi',
        'allow_connect_send_finish_later' => 'getAllowConnectSendFinishLater',
        'allow_connect_send_finish_later_metadata' => 'getAllowConnectSendFinishLaterMetadata',
        'allow_connect_unified_payload_ui' => 'getAllowConnectUnifiedPayloadUi',
        'allow_consumer_disclosure_override' => 'getAllowConsumerDisclosureOverride',
        'allow_consumer_disclosure_override_metadata' => 'getAllowConsumerDisclosureOverrideMetadata',
        'allow_data_download' => 'getAllowDataDownload',
        'allow_data_download_metadata' => 'getAllowDataDownloadMetadata',
        'allow_delayed_routing' => 'getAllowDelayedRouting',
        'allow_delayed_routing_metadata' => 'getAllowDelayedRoutingMetadata',
        'allow_delegated_signing' => 'getAllowDelegatedSigning',
        'allow_delegated_signing_metadata' => 'getAllowDelegatedSigningMetadata',
        'allow_doc_gen_documents' => 'getAllowDocGenDocuments',
        'allow_doc_gen_documents_metadata' => 'getAllowDocGenDocumentsMetadata',
        'allow_document_disclosures' => 'getAllowDocumentDisclosures',
        'allow_document_disclosures_metadata' => 'getAllowDocumentDisclosuresMetadata',
        'allow_documents_on_signed_envelopes' => 'getAllowDocumentsOnSignedEnvelopes',
        'allow_documents_on_signed_envelopes_metadata' => 'getAllowDocumentsOnSignedEnvelopesMetadata',
        'allow_document_visibility' => 'getAllowDocumentVisibility',
        'allow_document_visibility_metadata' => 'getAllowDocumentVisibilityMetadata',
        'allow_editing_envelopes_on_behalf_of_others' => 'getAllowEditingEnvelopesOnBehalfOfOthers',
        'allow_editing_envelopes_on_behalf_of_others_metadata' => 'getAllowEditingEnvelopesOnBehalfOfOthersMetadata',
        'allow_e_hanko_stamps' => 'getAllowEHankoStamps',
        'allow_e_hanko_stamps_metadata' => 'getAllowEHankoStampsMetadata',
        'allow_e_note_e_original' => 'getAllowENoteEOriginal',
        'allow_e_note_e_original_metadata' => 'getAllowENoteEOriginalMetadata',
        'allow_envelope_correct' => 'getAllowEnvelopeCorrect',
        'allow_envelope_correct_metadata' => 'getAllowEnvelopeCorrectMetadata',
        'allow_envelope_custody_transfer' => 'getAllowEnvelopeCustodyTransfer',
        'allow_envelope_custody_transfer_metadata' => 'getAllowEnvelopeCustodyTransferMetadata',
        'allow_envelope_custom_fields' => 'getAllowEnvelopeCustomFields',
        'allow_envelope_custom_fields_metadata' => 'getAllowEnvelopeCustomFieldsMetadata',
        'allow_envelope_publish_reporting' => 'getAllowEnvelopePublishReporting',
        'allow_envelope_publish_reporting_metadata' => 'getAllowEnvelopePublishReportingMetadata',
        'allow_envelope_reporting' => 'getAllowEnvelopeReporting',
        'allow_envelope_reporting_metadata' => 'getAllowEnvelopeReportingMetadata',
        'allow_expression' => 'getAllowExpression',
        'allow_expression_metadata' => 'getAllowExpressionMetadata',
        'allow_express_signer_certificate' => 'getAllowExpressSignerCertificate',
        'allow_express_signer_certificate_metadata' => 'getAllowExpressSignerCertificateMetadata',
        'allow_extended_sending_resource_file' => 'getAllowExtendedSendingResourceFile',
        'allow_extended_sending_resource_file_metadata' => 'getAllowExtendedSendingResourceFileMetadata',
        'allow_external_linked_accounts' => 'getAllowExternalLinkedAccounts',
        'allow_external_linked_accounts_metadata' => 'getAllowExternalLinkedAccountsMetadata',
        'allow_external_signature_pad' => 'getAllowExternalSignaturePad',
        'allow_external_signature_pad_metadata' => 'getAllowExternalSignaturePadMetadata',
        'allow_idv_for_eu_qualified_signatures' => 'getAllowIdvForEuQualifiedSignatures',
        'allow_idv_for_eu_qualified_signatures_metadata' => 'getAllowIdvForEuQualifiedSignaturesMetadata',
        'allow_idv_level1' => 'getAllowIdvLevel1',
        'allow_idv_level1_metadata' => 'getAllowIdvLevel1Metadata',
        'allow_idv_level1_trial' => 'getAllowIdvLevel1Trial',
        'allow_idv_level1_trial_metadata' => 'getAllowIdvLevel1TrialMetadata',
        'allow_idv_level2' => 'getAllowIdvLevel2',
        'allow_idv_level2_metadata' => 'getAllowIdvLevel2Metadata',
        'allow_idv_level3' => 'getAllowIdvLevel3',
        'allow_idv_level3_metadata' => 'getAllowIdvLevel3Metadata',
        'allow_idv_platform' => 'getAllowIdvPlatform',
        'allow_idv_platform_metadata' => 'getAllowIdvPlatformMetadata',
        'allow_in_person' => 'getAllowInPerson',
        'allow_in_person_electronic_notary' => 'getAllowInPersonElectronicNotary',
        'allow_in_person_electronic_notary_metadata' => 'getAllowInPersonElectronicNotaryMetadata',
        'allow_in_person_metadata' => 'getAllowInPersonMetadata',
        'allow_managed_stamps' => 'getAllowManagedStamps',
        'allow_managed_stamps_metadata' => 'getAllowManagedStampsMetadata',
        'allow_managing_envelopes_on_behalf_of_others' => 'getAllowManagingEnvelopesOnBehalfOfOthers',
        'allow_managing_envelopes_on_behalf_of_others_metadata' => 'getAllowManagingEnvelopesOnBehalfOfOthersMetadata',
        'allow_markup' => 'getAllowMarkup',
        'allow_markup_metadata' => 'getAllowMarkupMetadata',
        'allow_member_time_zone' => 'getAllowMemberTimeZone',
        'allow_member_time_zone_metadata' => 'getAllowMemberTimeZoneMetadata',
        'allow_merge_fields' => 'getAllowMergeFields',
        'allow_merge_fields_metadata' => 'getAllowMergeFieldsMetadata',
        'allow_multiple_brand_profiles' => 'getAllowMultipleBrandProfiles',
        'allow_multiple_brand_profiles_metadata' => 'getAllowMultipleBrandProfilesMetadata',
        'allow_multiple_signer_attachments' => 'getAllowMultipleSignerAttachments',
        'allow_multiple_signer_attachments_metadata' => 'getAllowMultipleSignerAttachmentsMetadata',
        'allow_non_us_phone_auth' => 'getAllowNonUsPhoneAuth',
        'allow_non_us_phone_auth_metadata' => 'getAllowNonUsPhoneAuthMetadata',
        'allow_ocr_of_envelope_documents' => 'getAllowOcrOfEnvelopeDocuments',
        'allow_ocr_of_envelope_documents_metadata' => 'getAllowOcrOfEnvelopeDocumentsMetadata',
        'allow_offline_signing' => 'getAllowOfflineSigning',
        'allow_offline_signing_metadata' => 'getAllowOfflineSigningMetadata',
        'allow_open_trust_signer_certificate' => 'getAllowOpenTrustSignerCertificate',
        'allow_open_trust_signer_certificate_metadata' => 'getAllowOpenTrustSignerCertificateMetadata',
        'allow_organization_docusign_monitor' => 'getAllowOrganizationDocusignMonitor',
        'allow_organization_docusign_monitor_free' => 'getAllowOrganizationDocusignMonitorFree',
        'allow_organization_docusign_monitor_free_metadata' => 'getAllowOrganizationDocusignMonitorFreeMetadata',
        'allow_organization_docusign_monitor_metadata' => 'getAllowOrganizationDocusignMonitorMetadata',
        'allow_organization_domain_user_management' => 'getAllowOrganizationDomainUserManagement',
        'allow_organization_domain_user_management_metadata' => 'getAllowOrganizationDomainUserManagementMetadata',
        'allow_organizations' => 'getAllowOrganizations',
        'allow_organizations_metadata' => 'getAllowOrganizationsMetadata',
        'allow_organization_sso_management' => 'getAllowOrganizationSsoManagement',
        'allow_organization_sso_management_metadata' => 'getAllowOrganizationSsoManagementMetadata',
        'allow_organization_to_use_in_person_electronic_notary' => 'getAllowOrganizationToUseInPersonElectronicNotary',
        'allow_organization_to_use_in_person_electronic_notary_metadata' => 'getAllowOrganizationToUseInPersonElectronicNotaryMetadata',
        'allow_organization_to_use_remote_notary' => 'getAllowOrganizationToUseRemoteNotary',
        'allow_organization_to_use_remote_notary_metadata' => 'getAllowOrganizationToUseRemoteNotaryMetadata',
        'allow_organization_to_use_third_party_electronic_notary' => 'getAllowOrganizationToUseThirdPartyElectronicNotary',
        'allow_organization_to_use_third_party_electronic_notary_metadata' => 'getAllowOrganizationToUseThirdPartyElectronicNotaryMetadata',
        'allow_participant_recipient_type' => 'getAllowParticipantRecipientType',
        'allow_participant_recipient_type_metadata' => 'getAllowParticipantRecipientTypeMetadata',
        'allow_payment_processing' => 'getAllowPaymentProcessing',
        'allow_payment_processing_metadata' => 'getAllowPaymentProcessingMetadata',
        'allow_performance_analytics' => 'getAllowPerformanceAnalytics',
        'allow_performance_analytics_metadata' => 'getAllowPerformanceAnalyticsMetadata',
        'allow_phone_authentication' => 'getAllowPhoneAuthentication',
        'allow_phone_authentication_metadata' => 'getAllowPhoneAuthenticationMetadata',
        'allow_phone_auth_override' => 'getAllowPhoneAuthOverride',
        'allow_phone_auth_override_metadata' => 'getAllowPhoneAuthOverrideMetadata',
        'allow_private_signing_groups' => 'getAllowPrivateSigningGroups',
        'allow_private_signing_groups_metadata' => 'getAllowPrivateSigningGroupsMetadata',
        'allow_recipient_connect' => 'getAllowRecipientConnect',
        'allow_recipient_connect_metadata' => 'getAllowRecipientConnectMetadata',
        'allow_reminders' => 'getAllowReminders',
        'allow_reminders_metadata' => 'getAllowRemindersMetadata',
        'allow_remote_notary' => 'getAllowRemoteNotary',
        'allow_remote_notary_metadata' => 'getAllowRemoteNotaryMetadata',
        'allow_resource_file_branding' => 'getAllowResourceFileBranding',
        'allow_resource_file_branding_metadata' => 'getAllowResourceFileBrandingMetadata',
        'allow_safe_bio_pharma_signer_certificate' => 'getAllowSafeBioPharmaSignerCertificate',
        'allow_safe_bio_pharma_signer_certificate_metadata' => 'getAllowSafeBioPharmaSignerCertificateMetadata',
        'allow_scheduled_sending' => 'getAllowScheduledSending',
        'allow_scheduled_sending_metadata' => 'getAllowScheduledSendingMetadata',
        'allow_security_appliance' => 'getAllowSecurityAppliance',
        'allow_security_appliance_metadata' => 'getAllowSecurityApplianceMetadata',
        'allow_sending_envelopes_on_behalf_of_others' => 'getAllowSendingEnvelopesOnBehalfOfOthers',
        'allow_sending_envelopes_on_behalf_of_others_metadata' => 'getAllowSendingEnvelopesOnBehalfOfOthersMetadata',
        'allow_send_to_certified_delivery' => 'getAllowSendToCertifiedDelivery',
        'allow_send_to_certified_delivery_metadata' => 'getAllowSendToCertifiedDeliveryMetadata',
        'allow_send_to_intermediary' => 'getAllowSendToIntermediary',
        'allow_send_to_intermediary_metadata' => 'getAllowSendToIntermediaryMetadata',
        'allow_server_templates' => 'getAllowServerTemplates',
        'allow_server_templates_metadata' => 'getAllowServerTemplatesMetadata',
        'allow_set_embedded_recipient_start_url' => 'getAllowSetEmbeddedRecipientStartUrl',
        'allow_set_embedded_recipient_start_url_metadata' => 'getAllowSetEmbeddedRecipientStartUrlMetadata',
        'allow_shared_tabs' => 'getAllowSharedTabs',
        'allow_shared_tabs_metadata' => 'getAllowSharedTabsMetadata',
        'allow_signature_stamps' => 'getAllowSignatureStamps',
        'allow_signature_stamps_metadata' => 'getAllowSignatureStampsMetadata',
        'allow_sign_document_from_home_page' => 'getAllowSignDocumentFromHomePage',
        'allow_sign_document_from_home_page_metadata' => 'getAllowSignDocumentFromHomePageMetadata',
        'allow_signer_reassign' => 'getAllowSignerReassign',
        'allow_signer_reassign_metadata' => 'getAllowSignerReassignMetadata',
        'allow_signer_reassign_override' => 'getAllowSignerReassignOverride',
        'allow_signer_reassign_override_metadata' => 'getAllowSignerReassignOverrideMetadata',
        'allow_signing_extensions' => 'getAllowSigningExtensions',
        'allow_signing_extensions_metadata' => 'getAllowSigningExtensionsMetadata',
        'allow_signing_groups' => 'getAllowSigningGroups',
        'allow_signing_groups_metadata' => 'getAllowSigningGroupsMetadata',
        'allow_signing_insights' => 'getAllowSigningInsights',
        'allow_signing_insights_metadata' => 'getAllowSigningInsightsMetadata',
        'allow_signing_radio_deselect' => 'getAllowSigningRadioDeselect',
        'allow_signing_radio_deselect_metadata' => 'getAllowSigningRadioDeselectMetadata',
        'allow_sign_now' => 'getAllowSignNow',
        'allow_sign_now_metadata' => 'getAllowSignNowMetadata',
        'allow_sms_delivery' => 'getAllowSmsDelivery',
        'allow_sms_delivery_metadata' => 'getAllowSmsDeliveryMetadata',
        'allow_social_id_login' => 'getAllowSocialIdLogin',
        'allow_social_id_login_metadata' => 'getAllowSocialIdLoginMetadata',
        'allow_supplemental_documents' => 'getAllowSupplementalDocuments',
        'allow_supplemental_documents_metadata' => 'getAllowSupplementalDocumentsMetadata',
        'allow_third_party_electronic_notary' => 'getAllowThirdPartyElectronicNotary',
        'allow_third_party_electronic_notary_metadata' => 'getAllowThirdPartyElectronicNotaryMetadata',
        'allow_transactions_workspace' => 'getAllowTransactionsWorkspace',
        'allow_transactions_workspace_metadata' => 'getAllowTransactionsWorkspaceMetadata',
        'allow_transactions_workspace_original' => 'getAllowTransactionsWorkspaceOriginal',
        'allow_transactions_workspace_original_metadata' => 'getAllowTransactionsWorkspaceOriginalMetadata',
        'allow_users_to_access_directory' => 'getAllowUsersToAccessDirectory',
        'allow_users_to_access_directory_metadata' => 'getAllowUsersToAccessDirectoryMetadata',
        'allow_value_insights' => 'getAllowValueInsights',
        'allow_value_insights_metadata' => 'getAllowValueInsightsMetadata',
        'allow_web_forms' => 'getAllowWebForms',
        'allow_web_forms_metadata' => 'getAllowWebFormsMetadata',
        'allow_whats_app_delivery' => 'getAllowWhatsAppDelivery',
        'allow_whats_app_delivery_metadata' => 'getAllowWhatsAppDeliveryMetadata',
        'anchor_population_scope' => 'getAnchorPopulationScope',
        'anchor_population_scope_metadata' => 'getAnchorPopulationScopeMetadata',
        'anchor_tag_versioned_placement_enabled' => 'getAnchorTagVersionedPlacementEnabled',
        'anchor_tag_versioned_placement_metadata_enabled' => 'getAnchorTagVersionedPlacementMetadataEnabled',
        'attach_completed_envelope' => 'getAttachCompletedEnvelope',
        'attach_completed_envelope_metadata' => 'getAttachCompletedEnvelopeMetadata',
        'authentication_check' => 'getAuthenticationCheck',
        'authentication_check_metadata' => 'getAuthenticationCheckMetadata',
        'auto_nav_rule' => 'getAutoNavRule',
        'auto_nav_rule_metadata' => 'getAutoNavRuleMetadata',
        'auto_provision_signer_account' => 'getAutoProvisionSignerAccount',
        'auto_provision_signer_account_metadata' => 'getAutoProvisionSignerAccountMetadata',
        'bcc_email_archive' => 'getBccEmailArchive',
        'bcc_email_archive_metadata' => 'getBccEmailArchiveMetadata',
        'beta_switch_configuration' => 'getBetaSwitchConfiguration',
        'beta_switch_configuration_metadata' => 'getBetaSwitchConfigurationMetadata',
        'billing_address' => 'getBillingAddress',
        'billing_address_metadata' => 'getBillingAddressMetadata',
        'bulk_send' => 'getBulkSend',
        'bulk_send_action_resend_limit' => 'getBulkSendActionResendLimit',
        'bulk_send_max_copies_in_batch' => 'getBulkSendMaxCopiesInBatch',
        'bulk_send_max_unprocessed_envelopes_count' => 'getBulkSendMaxUnprocessedEnvelopesCount',
        'bulk_send_metadata' => 'getBulkSendMetadata',
        'can_self_brand_send' => 'getCanSelfBrandSend',
        'can_self_brand_send_metadata' => 'getCanSelfBrandSendMetadata',
        'can_self_brand_sign' => 'getCanSelfBrandSign',
        'can_self_brand_sign_metadata' => 'getCanSelfBrandSignMetadata',
        'can_use_salesforce_o_auth' => 'getCanUseSalesforceOAuth',
        'can_use_salesforce_o_auth_metadata' => 'getCanUseSalesforceOAuthMetadata',
        'capture_voice_recording' => 'getCaptureVoiceRecording',
        'capture_voice_recording_metadata' => 'getCaptureVoiceRecordingMetadata',
        'cfr21_simplified_signing_enabled' => 'getCfr21SimplifiedSigningEnabled',
        'cfr21_simplified_signing_enabled_metadata' => 'getCfr21SimplifiedSigningEnabledMetadata',
        'cfr_use_wide_image' => 'getCfrUseWideImage',
        'cfr_use_wide_image_metadata' => 'getCfrUseWideImageMetadata',
        'check_for_multiple_admins_on_account' => 'getCheckForMultipleAdminsOnAccount',
        'check_for_multiple_admins_on_account_metadata' => 'getCheckForMultipleAdminsOnAccountMetadata',
        'chrome_signature_enabled' => 'getChromeSignatureEnabled',
        'chrome_signature_enabled_metadata' => 'getChromeSignatureEnabledMetadata',
        'comment_email_show_message_text' => 'getCommentEmailShowMessageText',
        'comment_email_show_message_text_metadata' => 'getCommentEmailShowMessageTextMetadata',
        'comments_allow_envelope_override' => 'getCommentsAllowEnvelopeOverride',
        'comments_allow_envelope_override_metadata' => 'getCommentsAllowEnvelopeOverrideMetadata',
        'conditional_fields_enabled' => 'getConditionalFieldsEnabled',
        'conditional_fields_enabled_metadata' => 'getConditionalFieldsEnabledMetadata',
        'consumer_disclosure_frequency' => 'getConsumerDisclosureFrequency',
        'consumer_disclosure_frequency_metadata' => 'getConsumerDisclosureFrequencyMetadata',
        'convert_pdf_fields' => 'getConvertPdfFields',
        'convert_pdf_fields_metadata' => 'getConvertPdfFieldsMetadata',
        'data_population_scope' => 'getDataPopulationScope',
        'data_population_scope_metadata' => 'getDataPopulationScopeMetadata',
        'default_to_advanced_envelopes_filter_form' => 'getDefaultToAdvancedEnvelopesFilterForm',
        'default_to_advanced_envelopes_filter_form_metadata' => 'getDefaultToAdvancedEnvelopesFilterFormMetadata',
        'disable_auto_template_matching' => 'getDisableAutoTemplateMatching',
        'disable_auto_template_matching_metadata' => 'getDisableAutoTemplateMatchingMetadata',
        'disable_mobile_app' => 'getDisableMobileApp',
        'disable_mobile_app_metadata' => 'getDisableMobileAppMetadata',
        'disable_mobile_push_notifications' => 'getDisableMobilePushNotifications',
        'disable_mobile_push_notifications_metadata' => 'getDisableMobilePushNotificationsMetadata',
        'disable_mobile_sending' => 'getDisableMobileSending',
        'disable_mobile_sending_metadata' => 'getDisableMobileSendingMetadata',
        'disable_multiple_sessions' => 'getDisableMultipleSessions',
        'disable_multiple_sessions_metadata' => 'getDisableMultipleSessionsMetadata',
        'disable_purge_notifications_for_sender_metadata' => 'getDisablePurgeNotificationsForSenderMetadata',
        'disable_signer_cert_view' => 'getDisableSignerCertView',
        'disable_signer_cert_view_metadata' => 'getDisableSignerCertViewMetadata',
        'disable_signer_history_view' => 'getDisableSignerHistoryView',
        'disable_signer_history_view_metadata' => 'getDisableSignerHistoryViewMetadata',
        'disable_style_signature' => 'getDisableStyleSignature',
        'disable_style_signature_metadata' => 'getDisableStyleSignatureMetadata',
        'disable_upload_signature' => 'getDisableUploadSignature',
        'disable_upload_signature_metadata' => 'getDisableUploadSignatureMetadata',
        'disable_user_sharing' => 'getDisableUserSharing',
        'disable_user_sharing_metadata' => 'getDisableUserSharingMetadata',
        'display_beta_switch' => 'getDisplayBetaSwitch',
        'display_beta_switch_metadata' => 'getDisplayBetaSwitchMetadata',
        'document_conversion_restrictions' => 'getDocumentConversionRestrictions',
        'document_conversion_restrictions_metadata' => 'getDocumentConversionRestrictionsMetadata',
        'document_retention' => 'getDocumentRetention',
        'document_retention_metadata' => 'getDocumentRetentionMetadata',
        'document_retention_purge_tabs' => 'getDocumentRetentionPurgeTabs',
        'document_visibility' => 'getDocumentVisibility',
        'document_visibility_metadata' => 'getDocumentVisibilityMetadata',
        'draft_envelope_retention' => 'getDraftEnvelopeRetention',
        'draft_envelope_retention_metadata' => 'getDraftEnvelopeRetentionMetadata',
        'dss_enable_provisioning_pen_configuration_radmin_option' => 'getDssEnableProvisioningPenConfigurationRadminOption',
        'dss_sign_28411_enable_leave_page_prompt_radmin_option' => 'getDssSign28411EnableLeavePagePromptRadminOption',
        'dss_sign_29182_slide_up_bar_radmin_option' => 'getDssSign29182SlideUpBarRadminOption',
        'email_template_version' => 'getEmailTemplateVersion',
        'email_template_version_metadata' => 'getEmailTemplateVersionMetadata',
        'enable_access_code_generator' => 'getEnableAccessCodeGenerator',
        'enable_access_code_generator_metadata' => 'getEnableAccessCodeGeneratorMetadata',
        'enable_account_wide_search' => 'getEnableAccountWideSearch',
        'enable_account_wide_search_metadata' => 'getEnableAccountWideSearchMetadata',
        'enable_adm_healthcare' => 'getEnableAdmHealthcare',
        'enable_adm_healthcare_metadata' => 'getEnableAdmHealthcareMetadata',
        'enable_advanced_envelopes_search' => 'getEnableAdvancedEnvelopesSearch',
        'enable_advanced_envelopes_search_metadata' => 'getEnableAdvancedEnvelopesSearchMetadata',
        'enable_advanced_payments' => 'getEnableAdvancedPayments',
        'enable_advanced_payments_metadata' => 'getEnableAdvancedPaymentsMetadata',
        'enable_advanced_power_forms' => 'getEnableAdvancedPowerForms',
        'enable_advanced_power_forms_metadata' => 'getEnableAdvancedPowerFormsMetadata',
        'enable_agreement_actions_for_clm' => 'getEnableAgreementActionsForClm',
        'enable_agreement_actions_for_clm_metadata' => 'getEnableAgreementActionsForClmMetadata',
        'enable_agreement_actions_for_e_sign' => 'getEnableAgreementActionsForESign',
        'enable_agreement_actions_for_e_sign_metadata' => 'getEnableAgreementActionsForESignMetadata',
        'enable_auto_nav' => 'getEnableAutoNav',
        'enable_auto_nav_metadata' => 'getEnableAutoNavMetadata',
        'enable_bcc_dummy_link' => 'getEnableBccDummyLink',
        'enable_bcc_dummy_link_metadata' => 'getEnableBccDummyLinkMetadata',
        'enable_calculated_fields' => 'getEnableCalculatedFields',
        'enable_calculated_fields_metadata' => 'getEnableCalculatedFieldsMetadata',
        'enable_click_plus' => 'getEnableClickPlus',
        'enable_click_plus_conditional_content' => 'getEnableClickPlusConditionalContent',
        'enable_click_plus_conditional_content_meta_data' => 'getEnableClickPlusConditionalContentMetaData',
        'enable_click_plus_custom_fields' => 'getEnableClickPlusCustomFields',
        'enable_click_plus_custom_fields_meta_data' => 'getEnableClickPlusCustomFieldsMetaData',
        'enable_click_plus_custom_style' => 'getEnableClickPlusCustomStyle',
        'enable_click_plus_custom_style_meta_data' => 'getEnableClickPlusCustomStyleMetaData',
        'enable_click_plus_dynamic_content' => 'getEnableClickPlusDynamicContent',
        'enable_click_plus_dynamic_content_meta_data' => 'getEnableClickPlusDynamicContentMetaData',
        'enable_click_plus_meta_data' => 'getEnableClickPlusMetaData',
        'enable_clickwraps' => 'getEnableClickwraps',
        'enable_clickwraps_metadata' => 'getEnableClickwrapsMetadata',
        'enable_combined_pdf_download_for_sbs' => 'getEnableCombinedPdfDownloadForSbs',
        'enable_comments_history_download_in_signing' => 'getEnableCommentsHistoryDownloadInSigning',
        'enable_comments_history_download_in_signing_metadata' => 'getEnableCommentsHistoryDownloadInSigningMetadata',
        'enable_contact_suggestions' => 'getEnableContactSuggestions',
        'enable_contact_suggestions_metadata' => 'getEnableContactSuggestionsMetadata',
        'enable_customer_satisfaction_metric_tracking' => 'getEnableCustomerSatisfactionMetricTracking',
        'enable_customer_satisfaction_metric_tracking_metadata' => 'getEnableCustomerSatisfactionMetricTrackingMetadata',
        'enable_d_sig_eu_advanced_pens' => 'getEnableDSigEuAdvancedPens',
        'enable_d_sig_eu_advanced_pens_metadata' => 'getEnableDSigEuAdvancedPensMetadata',
        'enable_d_sig_express_pens' => 'getEnableDSigExpressPens',
        'enable_d_sig_express_pens_metadata' => 'getEnableDSigExpressPensMetadata',
        'enable_d_sig_id_check_for_aes_pens' => 'getEnableDSigIdCheckForAesPens',
        'enable_d_sig_id_check_for_aes_pens_metadata' => 'getEnableDSigIdCheckForAesPensMetadata',
        'enable_d_sig_id_check_in_person_for_qes_pens' => 'getEnableDSigIdCheckInPersonForQesPens',
        'enable_d_sig_id_check_in_person_for_qes_pens_metadata' => 'getEnableDSigIdCheckInPersonForQesPensMetadata',
        'enable_d_sig_id_check_remote_for_qes_pens' => 'getEnableDSigIdCheckRemoteForQesPens',
        'enable_d_sig_id_check_remote_for_qes_pens_metadata' => 'getEnableDSigIdCheckRemoteForQesPensMetadata',
        'enable_d_sig_id_verification_pens' => 'getEnableDSigIdVerificationPens',
        'enable_d_sig_id_verification_pens_metadata' => 'getEnableDSigIdVerificationPensMetadata',
        'enable_d_sig_id_verification_premier_pens' => 'getEnableDSigIdVerificationPremierPens',
        'enable_d_sig_id_verification_premier_pens_metadata' => 'getEnableDSigIdVerificationPremierPensMetadata',
        'enable_ds_pro' => 'getEnableDsPro',
        'enable_ds_pro_metadata' => 'getEnableDsProMetadata',
        'enable_enforce_tls_emails_setting_metadata' => 'getEnableEnforceTlsEmailsSettingMetadata',
        'enable_envelope_stamping_by_account_admin' => 'getEnableEnvelopeStampingByAccountAdmin',
        'enable_envelope_stamping_by_account_admin_metadata' => 'getEnableEnvelopeStampingByAccountAdminMetadata',
        'enable_envelope_stamping_by_ds_admin' => 'getEnableEnvelopeStampingByDsAdmin',
        'enable_envelope_stamping_by_ds_admin_metadata' => 'getEnableEnvelopeStampingByDsAdminMetadata',
        'enable_e_sign_api_hourly_limit_management' => 'getEnableESignApiHourlyLimitManagement',
        'enable_e_sign_api_hourly_limit_management_metadata' => 'getEnableESignApiHourlyLimitManagementMetadata',
        'enable_esign_communities' => 'getEnableEsignCommunities',
        'enable_esign_communities_metadata' => 'getEnableEsignCommunitiesMetadata',
        'enable_id_fx_accountless_sms_auth_for_part11' => 'getEnableIdFxAccountlessSmsAuthForPart11',
        'enable_id_fx_accountless_sms_auth_for_part11_metadata' => 'getEnableIdFxAccountlessSmsAuthForPart11Metadata',
        'enable_id_fx_intuit_kba' => 'getEnableIdFxIntuitKba',
        'enable_id_fx_intuit_kba_metadata' => 'getEnableIdFxIntuitKbaMetadata',
        'enable_id_fx_phone_authentication' => 'getEnableIdFxPhoneAuthentication',
        'enable_id_fx_phone_authentication_metadata' => 'getEnableIdFxPhoneAuthenticationMetadata',
        'enable_idfx_phone_auth_signature_auth_status' => 'getEnableIdfxPhoneAuthSignatureAuthStatus',
        'enable_idfx_phone_auth_signature_auth_status_metadata' => 'getEnableIdfxPhoneAuthSignatureAuthStatusMetadata',
        'enable_inbox_browse_views_powered_by_elastic_search' => 'getEnableInboxBrowseViewsPoweredByElasticSearch',
        'enable_inbox_browse_views_powered_by_elastic_search_metadata' => 'getEnableInboxBrowseViewsPoweredByElasticSearchMetadata',
        'enable_inbox_relevance_sort' => 'getEnableInboxRelevanceSort',
        'enable_inbox_relevance_sort_for_recent_accounts' => 'getEnableInboxRelevanceSortForRecentAccounts',
        'enable_inbox_relevance_sort_for_recent_accounts_metadata' => 'getEnableInboxRelevanceSortForRecentAccountsMetadata',
        'enable_inbox_relevance_sort_metadata' => 'getEnableInboxRelevanceSortMetadata',
        'enable_in_browser_editor' => 'getEnableInBrowserEditor',
        'enable_in_browser_editor_metadata' => 'getEnableInBrowserEditorMetadata',
        'enable_key_terms_suggestions_by_document_type' => 'getEnableKeyTermsSuggestionsByDocumentType',
        'enable_key_terms_suggestions_by_document_type_metadata' => 'getEnableKeyTermsSuggestionsByDocumentTypeMetadata',
        'enable_participant_recipient_setting_metadata' => 'getEnableParticipantRecipientSettingMetadata',
        'enable_payment_processing' => 'getEnablePaymentProcessing',
        'enable_payment_processing_metadata' => 'getEnablePaymentProcessingMetadata',
        'enable_pdfa_conversion' => 'getEnablePdfaConversion',
        'enable_pdfa_conversion_metadata' => 'getEnablePdfaConversionMetadata',
        'enable_power_form' => 'getEnablePowerForm',
        'enable_power_form_direct' => 'getEnablePowerFormDirect',
        'enable_power_form_direct_metadata' => 'getEnablePowerFormDirectMetadata',
        'enable_power_form_metadata' => 'getEnablePowerFormMetadata',
        'enable_recipient_domain_validation' => 'getEnableRecipientDomainValidation',
        'enable_recipient_domain_validation_metadata' => 'getEnableRecipientDomainValidationMetadata',
        'enable_recipient_may_provide_phone_number' => 'getEnableRecipientMayProvidePhoneNumber',
        'enable_recipient_may_provide_phone_number_metadata' => 'getEnableRecipientMayProvidePhoneNumberMetadata',
        'enable_report_links' => 'getEnableReportLinks',
        'enable_report_links_metadata' => 'getEnableReportLinksMetadata',
        'enable_require_sign_on_paper' => 'getEnableRequireSignOnPaper',
        'enable_require_sign_on_paper_metadata' => 'getEnableRequireSignOnPaperMetadata',
        'enable_reserved_domain' => 'getEnableReservedDomain',
        'enable_reserved_domain_metadata' => 'getEnableReservedDomainMetadata',
        'enable_responsive_signing' => 'getEnableResponsiveSigning',
        'enable_responsive_signing_metadata' => 'getEnableResponsiveSigningMetadata',
        'enable_scheduled_release' => 'getEnableScheduledRelease',
        'enable_scheduled_release_metadata' => 'getEnableScheduledReleaseMetadata',
        'enable_search' => 'getEnableSearch',
        'enable_search_metadata' => 'getEnableSearchMetadata',
        'enable_search_service_azure_uri' => 'getEnableSearchServiceAzureUri',
        'enable_search_service_azure_uri_metadata' => 'getEnableSearchServiceAzureUriMetadata',
        'enable_search_site_specific_api' => 'getEnableSearchSiteSpecificApi',
        'enable_search_site_specific_api_metadata' => 'getEnableSearchSiteSpecificApiMetadata',
        'enable_search_ui' => 'getEnableSearchUi',
        'enable_search_ui_metadata' => 'getEnableSearchUiMetadata',
        'enable_sending_tags_font_settings' => 'getEnableSendingTagsFontSettings',
        'enable_sending_tags_font_settings_metadata' => 'getEnableSendingTagsFontSettingsMetadata',
        'enable_send_to_agent' => 'getEnableSendToAgent',
        'enable_send_to_agent_metadata' => 'getEnableSendToAgentMetadata',
        'enable_send_to_intermediary' => 'getEnableSendToIntermediary',
        'enable_send_to_intermediary_metadata' => 'getEnableSendToIntermediaryMetadata',
        'enable_send_to_manage' => 'getEnableSendToManage',
        'enable_send_to_manage_metadata' => 'getEnableSendToManageMetadata',
        'enable_sequential_signing_api' => 'getEnableSequentialSigningApi',
        'enable_sequential_signing_api_metadata' => 'getEnableSequentialSigningApiMetadata',
        'enable_sequential_signing_ui' => 'getEnableSequentialSigningUi',
        'enable_sequential_signing_ui_metadata' => 'getEnableSequentialSigningUiMetadata',
        'enable_signer_attachments' => 'getEnableSignerAttachments',
        'enable_signer_attachments_metadata' => 'getEnableSignerAttachmentsMetadata',
        'enable_signing_extension_comments' => 'getEnableSigningExtensionComments',
        'enable_signing_extension_comments_metadata' => 'getEnableSigningExtensionCommentsMetadata',
        'enable_signing_extension_conversations' => 'getEnableSigningExtensionConversations',
        'enable_signing_extension_conversations_metadata' => 'getEnableSigningExtensionConversationsMetadata',
        'enable_signing_order_settings_for_account' => 'getEnableSigningOrderSettingsForAccount',
        'enable_signing_order_settings_for_account_metadata' => 'getEnableSigningOrderSettingsForAccountMetadata',
        'enable_sign_on_paper' => 'getEnableSignOnPaper',
        'enable_sign_on_paper_metadata' => 'getEnableSignOnPaperMetadata',
        'enable_sign_on_paper_override' => 'getEnableSignOnPaperOverride',
        'enable_sign_on_paper_override_metadata' => 'getEnableSignOnPaperOverrideMetadata',
        'enable_sign_with_notary' => 'getEnableSignWithNotary',
        'enable_sign_with_notary_metadata' => 'getEnableSignWithNotaryMetadata',
        'enable_smart_contracts' => 'getEnableSmartContracts',
        'enable_smart_contracts_metadata' => 'getEnableSmartContractsMetadata',
        'enable_sms_authentication' => 'getEnableSmsAuthentication',
        'enable_sms_authentication_metadata' => 'getEnableSmsAuthenticationMetadata',
        'enable_sms_delivery_additional_notification' => 'getEnableSmsDeliveryAdditionalNotification',
        'enable_sms_delivery_additional_notification_metadata' => 'getEnableSmsDeliveryAdditionalNotificationMetadata',
        'enable_sms_delivery_primary' => 'getEnableSmsDeliveryPrimary',
        'enable_social_id_login' => 'getEnableSocialIdLogin',
        'enable_social_id_login_metadata' => 'getEnableSocialIdLoginMetadata',
        'enable_strike_through' => 'getEnableStrikeThrough',
        'enable_strike_through_metadata' => 'getEnableStrikeThroughMetadata',
        'enable_transaction_point' => 'getEnableTransactionPoint',
        'enable_transaction_point_metadata' => 'getEnableTransactionPointMetadata',
        'enable_vaulting' => 'getEnableVaulting',
        'enable_vaulting_metadata' => 'getEnableVaultingMetadata',
        'enable_web_forms_separate_user_permissions' => 'getEnableWebFormsSeparateUserPermissions',
        'enable_web_forms_separate_user_permissions_metadata' => 'getEnableWebFormsSeparateUserPermissionsMetadata',
        'enable_witnessing' => 'getEnableWitnessing',
        'enable_witnessing_metadata' => 'getEnableWitnessingMetadata',
        'enforce_template_name_uniqueness' => 'getEnforceTemplateNameUniqueness',
        'enforce_template_name_uniqueness_metadata' => 'getEnforceTemplateNameUniquenessMetadata',
        'enforce_tls_emails' => 'getEnforceTlsEmails',
        'enforce_tls_emails_metadata' => 'getEnforceTlsEmailsMetadata',
        'envelope_integration_allowed' => 'getEnvelopeIntegrationAllowed',
        'envelope_integration_allowed_metadata' => 'getEnvelopeIntegrationAllowedMetadata',
        'envelope_integration_enabled' => 'getEnvelopeIntegrationEnabled',
        'envelope_integration_enabled_metadata' => 'getEnvelopeIntegrationEnabledMetadata',
        'envelope_limits_total_document_size_allowed_in_mb' => 'getEnvelopeLimitsTotalDocumentSizeAllowedInMb',
        'envelope_limits_total_document_size_allowed_in_mb_enabled' => 'getEnvelopeLimitsTotalDocumentSizeAllowedInMbEnabled',
        'envelope_limits_total_document_size_allowed_in_mb_enabled_metadata' => 'getEnvelopeLimitsTotalDocumentSizeAllowedInMbEnabledMetadata',
        'envelope_limits_total_document_size_allowed_in_mb_metadata' => 'getEnvelopeLimitsTotalDocumentSizeAllowedInMbMetadata',
        'envelope_search_mode' => 'getEnvelopeSearchMode',
        'envelope_search_mode_metadata' => 'getEnvelopeSearchModeMetadata',
        'envelope_stamping_default_value' => 'getEnvelopeStampingDefaultValue',
        'envelope_stamping_default_value_metadata' => 'getEnvelopeStampingDefaultValueMetadata',
        'exit_prompt' => 'getExitPrompt',
        'exit_prompt_metadata' => 'getExitPromptMetadata',
        'express_send' => 'getExpressSend',
        'express_send_allow_tabs' => 'getExpressSendAllowTabs',
        'express_send_allow_tabs_metadata' => 'getExpressSendAllowTabsMetadata',
        'express_send_metadata' => 'getExpressSendMetadata',
        'external_document_sources' => 'getExternalDocumentSources',
        'external_signature_pad_type' => 'getExternalSignaturePadType',
        'external_signature_pad_type_metadata' => 'getExternalSignaturePadTypeMetadata',
        'fax_out_enabled' => 'getFaxOutEnabled',
        'fax_out_enabled_metadata' => 'getFaxOutEnabledMetadata',
        'finish_reminder' => 'getFinishReminder',
        'finish_reminder_metadata' => 'getFinishReminderMetadata',
        'guided_forms_html_allowed' => 'getGuidedFormsHtmlAllowed',
        'guided_forms_html_allowed_metadata' => 'getGuidedFormsHtmlAllowedMetadata',
        'guided_forms_html_conversion_policy' => 'getGuidedFormsHtmlConversionPolicy',
        'guided_forms_html_conversion_policy_metadata' => 'getGuidedFormsHtmlConversionPolicyMetadata',
        'has_recipient_connect_claimed_domain' => 'getHasRecipientConnectClaimedDomain',
        'hide_account_address_in_co_c' => 'getHideAccountAddressInCoC',
        'hide_account_address_in_co_c_metadata' => 'getHideAccountAddressInCoCMetadata',
        'hide_pricing' => 'getHidePricing',
        'hide_pricing_metadata' => 'getHidePricingMetadata',
        'id_check_configurations' => 'getIdCheckConfigurations',
        'id_check_expire' => 'getIdCheckExpire',
        'id_check_expire_days' => 'getIdCheckExpireDays',
        'id_check_expire_days_metadata' => 'getIdCheckExpireDaysMetadata',
        'id_check_expire_metadata' => 'getIdCheckExpireMetadata',
        'id_check_expire_minutes' => 'getIdCheckExpireMinutes',
        'id_check_expire_minutes_metadata' => 'getIdCheckExpireMinutesMetadata',
        'id_check_required' => 'getIdCheckRequired',
        'id_check_required_metadata' => 'getIdCheckRequiredMetadata',
        'identity_verification' => 'getIdentityVerification',
        'identity_verification_metadata' => 'getIdentityVerificationMetadata',
        'idfx_kba_authentication_override' => 'getIdfxKbaAuthenticationOverride',
        'idfx_kba_authentication_override_metadata' => 'getIdfxKbaAuthenticationOverrideMetadata',
        'idfx_phone_authentication_override' => 'getIdfxPhoneAuthenticationOverride',
        'idfx_phone_authentication_override_metadata' => 'getIdfxPhoneAuthenticationOverrideMetadata',
        'ignore_error_if_anchor_tab_not_found' => 'getIgnoreErrorIfAnchorTabNotFound',
        'ignore_error_if_anchor_tab_not_found_metadata_enabled' => 'getIgnoreErrorIfAnchorTabNotFoundMetadataEnabled',
        'in_person_id_check_question' => 'getInPersonIdCheckQuestion',
        'in_person_id_check_question_metadata' => 'getInPersonIdCheckQuestionMetadata',
        'in_person_signing_enabled' => 'getInPersonSigningEnabled',
        'in_person_signing_enabled_metadata' => 'getInPersonSigningEnabledMetadata',
        'in_session_enabled' => 'getInSessionEnabled',
        'in_session_enabled_metadata' => 'getInSessionEnabledMetadata',
        'in_session_suppress_emails' => 'getInSessionSuppressEmails',
        'in_session_suppress_emails_metadata' => 'getInSessionSuppressEmailsMetadata',
        'is_connect_document_fields_enabled' => 'getIsConnectDocumentFieldsEnabled',
        'linked_external_primary_accounts' => 'getLinkedExternalPrimaryAccounts',
        'maximum_signing_groups' => 'getMaximumSigningGroups',
        'maximum_signing_groups_metadata' => 'getMaximumSigningGroupsMetadata',
        'maximum_users_per_signing_group' => 'getMaximumUsersPerSigningGroup',
        'maximum_users_per_signing_group_metadata' => 'getMaximumUsersPerSigningGroupMetadata',
        'max_number_of_custom_stamps' => 'getMaxNumberOfCustomStamps',
        'merge_mixed_mode_results' => 'getMergeMixedModeResults',
        'merge_mixed_mode_results_metadata' => 'getMergeMixedModeResultsMetadata',
        'mobile_session_timeout' => 'getMobileSessionTimeout',
        'mobile_session_timeout_metadata' => 'getMobileSessionTimeoutMetadata',
        'number_of_active_custom_stamps' => 'getNumberOfActiveCustomStamps',
        'opt_in_mobile_signing_v02' => 'getOptInMobileSigningV02',
        'opt_in_mobile_signing_v02_metadata' => 'getOptInMobileSigningV02Metadata',
        'opt_in_universal_signatures' => 'getOptInUniversalSignatures',
        'opt_out_auto_nav_text_and_tab_color_updates' => 'getOptOutAutoNavTextAndTabColorUpdates',
        'opt_out_auto_nav_text_and_tab_color_updates_metadata' => 'getOptOutAutoNavTextAndTabColorUpdatesMetadata',
        'opt_out_new_platform_seal' => 'getOptOutNewPlatformSeal',
        'opt_out_new_platform_seal_platform_metadata' => 'getOptOutNewPlatformSealPlatformMetadata',
        'pdf_max_chunked_upload_part_size' => 'getPdfMaxChunkedUploadPartSize',
        'pdf_max_chunked_upload_part_size_metadata' => 'getPdfMaxChunkedUploadPartSizeMetadata',
        'pdf_max_chunked_upload_total_size' => 'getPdfMaxChunkedUploadTotalSize',
        'pdf_max_chunked_upload_total_size_metadata' => 'getPdfMaxChunkedUploadTotalSizeMetadata',
        'pdf_max_individual_upload_size' => 'getPdfMaxIndividualUploadSize',
        'pdf_max_individual_upload_size_metadata' => 'getPdfMaxIndividualUploadSizeMetadata',
        'phone_auth_recipient_may_provide_phone_number' => 'getPhoneAuthRecipientMayProvidePhoneNumber',
        'phone_auth_recipient_may_provide_phone_number_metadata' => 'getPhoneAuthRecipientMayProvidePhoneNumberMetadata',
        'pki_sign_downloaded_pdf_docs' => 'getPkiSignDownloadedPdfDocs',
        'pki_sign_downloaded_pdf_docs_metadata' => 'getPkiSignDownloadedPdfDocsMetadata',
        'read_only_mode' => 'getReadOnlyMode',
        'read_only_mode_metadata' => 'getReadOnlyModeMetadata',
        'recipients_can_sign_offline' => 'getRecipientsCanSignOffline',
        'recipients_can_sign_offline_metadata' => 'getRecipientsCanSignOfflineMetadata',
        'recipient_signing_auto_navigation_control' => 'getRecipientSigningAutoNavigationControl',
        'recipient_signing_auto_navigation_control_metadata' => 'getRecipientSigningAutoNavigationControlMetadata',
        'require21_cf_rpt11_compliance' => 'getRequire21CfRpt11Compliance',
        'require21_cf_rpt11_compliance_metadata' => 'getRequire21CfRpt11ComplianceMetadata',
        'require_decline_reason' => 'getRequireDeclineReason',
        'require_decline_reason_metadata' => 'getRequireDeclineReasonMetadata',
        'require_external_user_management' => 'getRequireExternalUserManagement',
        'require_external_user_management_metadata' => 'getRequireExternalUserManagementMetadata',
        'require_signer_certificate_type' => 'getRequireSignerCertificateType',
        'require_signer_certificate_type_metadata' => 'getRequireSignerCertificateTypeMetadata',
        'rsa_verid_account_name' => 'getRsaVeridAccountName',
        'rsa_verid_password' => 'getRsaVeridPassword',
        'rsa_verid_ruleset' => 'getRsaVeridRuleset',
        'rsa_verid_user_id' => 'getRsaVeridUserId',
        'sbs_transaction_level' => 'getSbsTransactionLevel',
        'self_signed_recipient_email_document' => 'getSelfSignedRecipientEmailDocument',
        'self_signed_recipient_email_document_metadata' => 'getSelfSignedRecipientEmailDocumentMetadata',
        'self_signed_recipient_email_document_user_override' => 'getSelfSignedRecipientEmailDocumentUserOverride',
        'self_signed_recipient_email_document_user_override_metadata' => 'getSelfSignedRecipientEmailDocumentUserOverrideMetadata',
        'sender_can_sign_in_each_location' => 'getSenderCanSignInEachLocation',
        'sender_can_sign_in_each_location_metadata' => 'getSenderCanSignInEachLocationMetadata',
        'sender_must_authenticate_signing' => 'getSenderMustAuthenticateSigning',
        'sender_must_authenticate_signing_metadata' => 'getSenderMustAuthenticateSigningMetadata',
        'sending_tags_font_color' => 'getSendingTagsFontColor',
        'sending_tags_font_color_metadata' => 'getSendingTagsFontColorMetadata',
        'sending_tags_font_name' => 'getSendingTagsFontName',
        'sending_tags_font_name_metadata' => 'getSendingTagsFontNameMetadata',
        'sending_tags_font_size' => 'getSendingTagsFontSize',
        'sending_tags_font_size_metadata' => 'getSendingTagsFontSizeMetadata',
        'send_lockout_recipient_notification' => 'getSendLockoutRecipientNotification',
        'send_lockout_recipient_notification_metadata' => 'getSendLockoutRecipientNotificationMetadata',
        'send_to_certified_delivery_enabled' => 'getSendToCertifiedDeliveryEnabled',
        'send_to_certified_delivery_enabled_metadata' => 'getSendToCertifiedDeliveryEnabledMetadata',
        'session_timeout' => 'getSessionTimeout',
        'session_timeout_metadata' => 'getSessionTimeoutMetadata',
        'set_recip_email_lang' => 'getSetRecipEmailLang',
        'set_recip_email_lang_metadata' => 'getSetRecipEmailLangMetadata',
        'set_recip_sign_lang' => 'getSetRecipSignLang',
        'set_recip_sign_lang_metadata' => 'getSetRecipSignLangMetadata',
        'shared_template_folders' => 'getSharedTemplateFolders',
        'shared_template_folders_metadata' => 'getSharedTemplateFoldersMetadata',
        'show_complete_dialog_in_embedded_session' => 'getShowCompleteDialogInEmbeddedSession',
        'show_complete_dialog_in_embedded_session_metadata' => 'getShowCompleteDialogInEmbeddedSessionMetadata',
        'show_conditional_routing_on_send' => 'getShowConditionalRoutingOnSend',
        'show_conditional_routing_on_send_metadata' => 'getShowConditionalRoutingOnSendMetadata',
        'show_initial_conditional_fields' => 'getShowInitialConditionalFields',
        'show_initial_conditional_fields_metadata' => 'getShowInitialConditionalFieldsMetadata',
        'show_localized_watermarks' => 'getShowLocalizedWatermarks',
        'show_localized_watermarks_metadata' => 'getShowLocalizedWatermarksMetadata',
        'show_masked_fields_when_downloading_document_as_sender' => 'getShowMaskedFieldsWhenDownloadingDocumentAsSender',
        'show_masked_fields_when_downloading_document_as_sender_metadata' => 'getShowMaskedFieldsWhenDownloadingDocumentAsSenderMetadata',
        'show_tutorials' => 'getShowTutorials',
        'show_tutorials_metadata' => 'getShowTutorialsMetadata',
        'signature_providers' => 'getSignatureProviders',
        'signature_providers_metadata' => 'getSignatureProvidersMetadata',
        'sign_date_format' => 'getSignDateFormat',
        'sign_date_format_metadata' => 'getSignDateFormatMetadata',
        'sign_date_time_account_language_override' => 'getSignDateTimeAccountLanguageOverride',
        'sign_date_time_account_language_override_metadata' => 'getSignDateTimeAccountLanguageOverrideMetadata',
        'sign_date_time_account_timezone_override' => 'getSignDateTimeAccountTimezoneOverride',
        'sign_date_time_account_timezone_override_metadata' => 'getSignDateTimeAccountTimezoneOverrideMetadata',
        'signer_attach_certificate_to_envelope_pdf' => 'getSignerAttachCertificateToEnvelopePdf',
        'signer_attach_certificate_to_envelope_pdf_metadata' => 'getSignerAttachCertificateToEnvelopePdfMetadata',
        'signer_attach_concat' => 'getSignerAttachConcat',
        'signer_attach_concat_metadata' => 'getSignerAttachConcatMetadata',
        'signer_can_create_account' => 'getSignerCanCreateAccount',
        'signer_can_create_account_metadata' => 'getSignerCanCreateAccountMetadata',
        'signer_can_sign_on_mobile' => 'getSignerCanSignOnMobile',
        'signer_can_sign_on_mobile_metadata' => 'getSignerCanSignOnMobileMetadata',
        'signer_in_session_use_envelope_complete_email' => 'getSignerInSessionUseEnvelopeCompleteEmail',
        'signer_in_session_use_envelope_complete_email_metadata' => 'getSignerInSessionUseEnvelopeCompleteEmailMetadata',
        'signer_login_requirements' => 'getSignerLoginRequirements',
        'signer_login_requirements_metadata' => 'getSignerLoginRequirementsMetadata',
        'signer_must_have_account' => 'getSignerMustHaveAccount',
        'signer_must_have_account_metadata' => 'getSignerMustHaveAccountMetadata',
        'signer_must_login_to_sign' => 'getSignerMustLoginToSign',
        'signer_must_login_to_sign_metadata' => 'getSignerMustLoginToSignMetadata',
        'signer_show_secure_field_initial_values' => 'getSignerShowSecureFieldInitialValues',
        'signer_show_secure_field_initial_values_metadata' => 'getSignerShowSecureFieldInitialValuesMetadata',
        'signing_session_timeout' => 'getSigningSessionTimeout',
        'signing_session_timeout_metadata' => 'getSigningSessionTimeoutMetadata',
        'signing_ui_version' => 'getSigningUiVersion',
        'signing_ui_version_metadata' => 'getSigningUiVersionMetadata',
        'sign_time_format' => 'getSignTimeFormat',
        'sign_time_format_metadata' => 'getSignTimeFormatMetadata',
        'sign_time_show_am_pm' => 'getSignTimeShowAmPm',
        'sign_time_show_am_pm_metadata' => 'getSignTimeShowAmPmMetadata',
        'simplified_sending_enabled' => 'getSimplifiedSendingEnabled',
        'simplified_sending_enabled_metadata' => 'getSimplifiedSendingEnabledMetadata',
        'single_sign_on_enabled' => 'getSingleSignOnEnabled',
        'single_sign_on_enabled_metadata' => 'getSingleSignOnEnabledMetadata',
        'skip_auth_completed_envelopes' => 'getSkipAuthCompletedEnvelopes',
        'skip_auth_completed_envelopes_metadata' => 'getSkipAuthCompletedEnvelopesMetadata',
        'social_id_recip_auth' => 'getSocialIdRecipAuth',
        'social_id_recip_auth_metadata' => 'getSocialIdRecipAuthMetadata',
        'specify_document_visibility' => 'getSpecifyDocumentVisibility',
        'specify_document_visibility_metadata' => 'getSpecifyDocumentVisibilityMetadata',
        'start_in_advanced_correct' => 'getStartInAdvancedCorrect',
        'start_in_advanced_correct_metadata' => 'getStartInAdvancedCorrectMetadata',
        'supplemental_documents_must_accept' => 'getSupplementalDocumentsMustAccept',
        'supplemental_documents_must_accept_metadata' => 'getSupplementalDocumentsMustAcceptMetadata',
        'supplemental_documents_must_read' => 'getSupplementalDocumentsMustRead',
        'supplemental_documents_must_read_metadata' => 'getSupplementalDocumentsMustReadMetadata',
        'supplemental_documents_must_view' => 'getSupplementalDocumentsMustView',
        'supplemental_documents_must_view_metadata' => 'getSupplementalDocumentsMustViewMetadata',
        'suppress_certificate_enforcement' => 'getSuppressCertificateEnforcement',
        'suppress_certificate_enforcement_metadata' => 'getSuppressCertificateEnforcementMetadata',
        'tab_account_settings' => 'getTabAccountSettings',
        'timezone_offset_api' => 'getTimezoneOffsetApi',
        'timezone_offset_api_metadata' => 'getTimezoneOffsetApiMetadata',
        'timezone_offset_ui' => 'getTimezoneOffsetUi',
        'timezone_offset_ui_metadata' => 'getTimezoneOffsetUiMetadata',
        'universal_signature_opt_in' => 'getUniversalSignatureOptIn',
        'use_account_level_email' => 'getUseAccountLevelEmail',
        'use_account_level_email_metadata' => 'getUseAccountLevelEmailMetadata',
        'use_consumer_disclosure' => 'getUseConsumerDisclosure',
        'use_consumer_disclosure_metadata' => 'getUseConsumerDisclosureMetadata',
        'use_consumer_disclosure_within_account' => 'getUseConsumerDisclosureWithinAccount',
        'use_consumer_disclosure_within_account_metadata' => 'getUseConsumerDisclosureWithinAccountMetadata',
        'use_derived_keys' => 'getUseDerivedKeys',
        'use_derived_keys_metadata' => 'getUseDerivedKeysMetadata',
        'use_docu_sign_express_signer_certificate' => 'getUseDocuSignExpressSignerCertificate',
        'use_docu_sign_express_signer_certificate_metadata' => 'getUseDocuSignExpressSignerCertificateMetadata',
        'use_envelope_search_mixed_mode' => 'getUseEnvelopeSearchMixedMode',
        'use_envelope_search_mixed_mode_metadata' => 'getUseEnvelopeSearchMixedModeMetadata',
        'use_multi_app_groups_data' => 'getUseMultiAppGroupsData',
        'use_multi_app_groups_data_metadata' => 'getUseMultiAppGroupsDataMetadata',
        'use_new_blob_for_pdf' => 'getUseNewBlobForPdf',
        'use_new_blob_for_pdf_metadata' => 'getUseNewBlobForPdfMetadata',
        'use_new_envelope_search' => 'getUseNewEnvelopeSearch',
        'use_new_envelope_search_metadata' => 'getUseNewEnvelopeSearchMetadata',
        'use_new_envelope_search_only_when_searching_after_date' => 'getUseNewEnvelopeSearchOnlyWhenSearchingAfterDate',
        'use_new_envelope_search_only_when_searching_after_date_metadata' => 'getUseNewEnvelopeSearchOnlyWhenSearchingAfterDateMetadata',
        'use_new_envelope_search_only_with_search_term' => 'getUseNewEnvelopeSearchOnlyWithSearchTerm',
        'use_new_envelope_search_only_with_search_term_metadata' => 'getUseNewEnvelopeSearchOnlyWithSearchTermMetadata',
        'use_safe_signer_certificates' => 'getUseSafeSignerCertificates',
        'use_safe_signer_certificates_metadata' => 'getUseSafeSignerCertificatesMetadata',
        'uses_api' => 'getUsesApi',
        'uses_api_metadata' => 'getUsesApiMetadata',
        'use_signature_provider_platform' => 'getUseSignatureProviderPlatform',
        'use_signature_provider_platform_metadata' => 'getUseSignatureProviderPlatformMetadata',
        'use_smart_contracts_v1' => 'getUseSmartContractsV1',
        'validations_allowed' => 'getValidationsAllowed',
        'validations_allowed_metadata' => 'getValidationsAllowedMetadata',
        'validations_brand' => 'getValidationsBrand',
        'validations_brand_metadata' => 'getValidationsBrandMetadata',
        'validations_cadence' => 'getValidationsCadence',
        'validations_cadence_metadata' => 'getValidationsCadenceMetadata',
        'validations_enabled' => 'getValidationsEnabled',
        'validations_enabled_metadata' => 'getValidationsEnabledMetadata',
        'validations_report' => 'getValidationsReport',
        'validations_report_metadata' => 'getValidationsReportMetadata',
        'water_mark_enabled' => 'getWaterMarkEnabled',
        'water_mark_enabled_metadata' => 'getWaterMarkEnabledMetadata',
        'write_reminder_to_envelope_history' => 'getWriteReminderToEnvelopeHistory',
        'write_reminder_to_envelope_history_metadata' => 'getWriteReminderToEnvelopeHistoryMetadata',
        'wurfl_min_allowable_screen_size' => 'getWurflMinAllowableScreenSize',
        'wurfl_min_allowable_screen_size_metadata' => 'getWurflMinAllowableScreenSizeMetadata'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['access_code_format'] = isset($data['access_code_format']) ? $data['access_code_format'] : null;
        $this->container['account_date_time_format'] = isset($data['account_date_time_format']) ? $data['account_date_time_format'] : null;
        $this->container['account_date_time_format_metadata'] = isset($data['account_date_time_format_metadata']) ? $data['account_date_time_format_metadata'] : null;
        $this->container['account_default_language'] = isset($data['account_default_language']) ? $data['account_default_language'] : null;
        $this->container['account_default_language_metadata'] = isset($data['account_default_language_metadata']) ? $data['account_default_language_metadata'] : null;
        $this->container['account_name'] = isset($data['account_name']) ? $data['account_name'] : null;
        $this->container['account_name_metadata'] = isset($data['account_name_metadata']) ? $data['account_name_metadata'] : null;
        $this->container['account_notification'] = isset($data['account_notification']) ? $data['account_notification'] : null;
        $this->container['account_ui_settings'] = isset($data['account_ui_settings']) ? $data['account_ui_settings'] : null;
        $this->container['adopt_sig_config'] = isset($data['adopt_sig_config']) ? $data['adopt_sig_config'] : null;
        $this->container['adopt_sig_config_metadata'] = isset($data['adopt_sig_config_metadata']) ? $data['adopt_sig_config_metadata'] : null;
        $this->container['advanced_correct'] = isset($data['advanced_correct']) ? $data['advanced_correct'] : null;
        $this->container['advanced_correct_metadata'] = isset($data['advanced_correct_metadata']) ? $data['advanced_correct_metadata'] : null;
        $this->container['advanced_search_enable_tab_field'] = isset($data['advanced_search_enable_tab_field']) ? $data['advanced_search_enable_tab_field'] : null;
        $this->container['advanced_search_enable_tab_field_metadata'] = isset($data['advanced_search_enable_tab_field_metadata']) ? $data['advanced_search_enable_tab_field_metadata'] : null;
        $this->container['advanced_search_enable_template_id_field'] = isset($data['advanced_search_enable_template_id_field']) ? $data['advanced_search_enable_template_id_field'] : null;
        $this->container['advanced_search_enable_template_id_field_metadata'] = isset($data['advanced_search_enable_template_id_field_metadata']) ? $data['advanced_search_enable_template_id_field_metadata'] : null;
        $this->container['advanced_search_enable_template_name_field'] = isset($data['advanced_search_enable_template_name_field']) ? $data['advanced_search_enable_template_name_field'] : null;
        $this->container['advanced_search_enable_template_name_field_metadata'] = isset($data['advanced_search_enable_template_name_field_metadata']) ? $data['advanced_search_enable_template_name_field_metadata'] : null;
        $this->container['allow_access_code_format'] = isset($data['allow_access_code_format']) ? $data['allow_access_code_format'] : null;
        $this->container['allow_access_code_format_metadata'] = isset($data['allow_access_code_format_metadata']) ? $data['allow_access_code_format_metadata'] : null;
        $this->container['allow_account_management_granular'] = isset($data['allow_account_management_granular']) ? $data['allow_account_management_granular'] : null;
        $this->container['allow_account_management_granular_metadata'] = isset($data['allow_account_management_granular_metadata']) ? $data['allow_account_management_granular_metadata'] : null;
        $this->container['allow_account_member_name_change'] = isset($data['allow_account_member_name_change']) ? $data['allow_account_member_name_change'] : null;
        $this->container['allow_account_member_name_change_metadata'] = isset($data['allow_account_member_name_change_metadata']) ? $data['allow_account_member_name_change_metadata'] : null;
        $this->container['allow_ace'] = isset($data['allow_ace']) ? $data['allow_ace'] : null;
        $this->container['allow_ace_metadata'] = isset($data['allow_ace_metadata']) ? $data['allow_ace_metadata'] : null;
        $this->container['allow_advanced_recipient_routing_conditional'] = isset($data['allow_advanced_recipient_routing_conditional']) ? $data['allow_advanced_recipient_routing_conditional'] : null;
        $this->container['allow_advanced_recipient_routing_conditional_metadata'] = isset($data['allow_advanced_recipient_routing_conditional_metadata']) ? $data['allow_advanced_recipient_routing_conditional_metadata'] : null;
        $this->container['allow_agent_name_email_edit'] = isset($data['allow_agent_name_email_edit']) ? $data['allow_agent_name_email_edit'] : null;
        $this->container['allow_agent_name_email_edit_metadata'] = isset($data['allow_agent_name_email_edit_metadata']) ? $data['allow_agent_name_email_edit_metadata'] : null;
        $this->container['allow_agreement_actions'] = isset($data['allow_agreement_actions']) ? $data['allow_agreement_actions'] : null;
        $this->container['allow_agreement_actions_metadata'] = isset($data['allow_agreement_actions_metadata']) ? $data['allow_agreement_actions_metadata'] : null;
        $this->container['allow_agreement_orchestrations'] = isset($data['allow_agreement_orchestrations']) ? $data['allow_agreement_orchestrations'] : null;
        $this->container['allow_agreement_orchestrations_metadata'] = isset($data['allow_agreement_orchestrations_metadata']) ? $data['allow_agreement_orchestrations_metadata'] : null;
        $this->container['allow_auto_nav_settings'] = isset($data['allow_auto_nav_settings']) ? $data['allow_auto_nav_settings'] : null;
        $this->container['allow_auto_nav_settings_metadata'] = isset($data['allow_auto_nav_settings_metadata']) ? $data['allow_auto_nav_settings_metadata'] : null;
        $this->container['allow_auto_tagging'] = isset($data['allow_auto_tagging']) ? $data['allow_auto_tagging'] : null;
        $this->container['allow_auto_tagging_metadata'] = isset($data['allow_auto_tagging_metadata']) ? $data['allow_auto_tagging_metadata'] : null;
        $this->container['allow_bulk_send'] = isset($data['allow_bulk_send']) ? $data['allow_bulk_send'] : null;
        $this->container['allow_bulk_send_metadata'] = isset($data['allow_bulk_send_metadata']) ? $data['allow_bulk_send_metadata'] : null;
        $this->container['allow_cd_withdraw'] = isset($data['allow_cd_withdraw']) ? $data['allow_cd_withdraw'] : null;
        $this->container['allow_cd_withdraw_metadata'] = isset($data['allow_cd_withdraw_metadata']) ? $data['allow_cd_withdraw_metadata'] : null;
        $this->container['allow_connect_http_listener_configs'] = isset($data['allow_connect_http_listener_configs']) ? $data['allow_connect_http_listener_configs'] : null;
        $this->container['allow_connect_identity_verification_ui'] = isset($data['allow_connect_identity_verification_ui']) ? $data['allow_connect_identity_verification_ui'] : null;
        $this->container['allow_connect_o_auth_ui'] = isset($data['allow_connect_o_auth_ui']) ? $data['allow_connect_o_auth_ui'] : null;
        $this->container['allow_connect_send_finish_later'] = isset($data['allow_connect_send_finish_later']) ? $data['allow_connect_send_finish_later'] : null;
        $this->container['allow_connect_send_finish_later_metadata'] = isset($data['allow_connect_send_finish_later_metadata']) ? $data['allow_connect_send_finish_later_metadata'] : null;
        $this->container['allow_connect_unified_payload_ui'] = isset($data['allow_connect_unified_payload_ui']) ? $data['allow_connect_unified_payload_ui'] : null;
        $this->container['allow_consumer_disclosure_override'] = isset($data['allow_consumer_disclosure_override']) ? $data['allow_consumer_disclosure_override'] : null;
        $this->container['allow_consumer_disclosure_override_metadata'] = isset($data['allow_consumer_disclosure_override_metadata']) ? $data['allow_consumer_disclosure_override_metadata'] : null;
        $this->container['allow_data_download'] = isset($data['allow_data_download']) ? $data['allow_data_download'] : null;
        $this->container['allow_data_download_metadata'] = isset($data['allow_data_download_metadata']) ? $data['allow_data_download_metadata'] : null;
        $this->container['allow_delayed_routing'] = isset($data['allow_delayed_routing']) ? $data['allow_delayed_routing'] : null;
        $this->container['allow_delayed_routing_metadata'] = isset($data['allow_delayed_routing_metadata']) ? $data['allow_delayed_routing_metadata'] : null;
        $this->container['allow_delegated_signing'] = isset($data['allow_delegated_signing']) ? $data['allow_delegated_signing'] : null;
        $this->container['allow_delegated_signing_metadata'] = isset($data['allow_delegated_signing_metadata']) ? $data['allow_delegated_signing_metadata'] : null;
        $this->container['allow_doc_gen_documents'] = isset($data['allow_doc_gen_documents']) ? $data['allow_doc_gen_documents'] : null;
        $this->container['allow_doc_gen_documents_metadata'] = isset($data['allow_doc_gen_documents_metadata']) ? $data['allow_doc_gen_documents_metadata'] : null;
        $this->container['allow_document_disclosures'] = isset($data['allow_document_disclosures']) ? $data['allow_document_disclosures'] : null;
        $this->container['allow_document_disclosures_metadata'] = isset($data['allow_document_disclosures_metadata']) ? $data['allow_document_disclosures_metadata'] : null;
        $this->container['allow_documents_on_signed_envelopes'] = isset($data['allow_documents_on_signed_envelopes']) ? $data['allow_documents_on_signed_envelopes'] : null;
        $this->container['allow_documents_on_signed_envelopes_metadata'] = isset($data['allow_documents_on_signed_envelopes_metadata']) ? $data['allow_documents_on_signed_envelopes_metadata'] : null;
        $this->container['allow_document_visibility'] = isset($data['allow_document_visibility']) ? $data['allow_document_visibility'] : null;
        $this->container['allow_document_visibility_metadata'] = isset($data['allow_document_visibility_metadata']) ? $data['allow_document_visibility_metadata'] : null;
        $this->container['allow_editing_envelopes_on_behalf_of_others'] = isset($data['allow_editing_envelopes_on_behalf_of_others']) ? $data['allow_editing_envelopes_on_behalf_of_others'] : null;
        $this->container['allow_editing_envelopes_on_behalf_of_others_metadata'] = isset($data['allow_editing_envelopes_on_behalf_of_others_metadata']) ? $data['allow_editing_envelopes_on_behalf_of_others_metadata'] : null;
        $this->container['allow_e_hanko_stamps'] = isset($data['allow_e_hanko_stamps']) ? $data['allow_e_hanko_stamps'] : null;
        $this->container['allow_e_hanko_stamps_metadata'] = isset($data['allow_e_hanko_stamps_metadata']) ? $data['allow_e_hanko_stamps_metadata'] : null;
        $this->container['allow_e_note_e_original'] = isset($data['allow_e_note_e_original']) ? $data['allow_e_note_e_original'] : null;
        $this->container['allow_e_note_e_original_metadata'] = isset($data['allow_e_note_e_original_metadata']) ? $data['allow_e_note_e_original_metadata'] : null;
        $this->container['allow_envelope_correct'] = isset($data['allow_envelope_correct']) ? $data['allow_envelope_correct'] : null;
        $this->container['allow_envelope_correct_metadata'] = isset($data['allow_envelope_correct_metadata']) ? $data['allow_envelope_correct_metadata'] : null;
        $this->container['allow_envelope_custody_transfer'] = isset($data['allow_envelope_custody_transfer']) ? $data['allow_envelope_custody_transfer'] : null;
        $this->container['allow_envelope_custody_transfer_metadata'] = isset($data['allow_envelope_custody_transfer_metadata']) ? $data['allow_envelope_custody_transfer_metadata'] : null;
        $this->container['allow_envelope_custom_fields'] = isset($data['allow_envelope_custom_fields']) ? $data['allow_envelope_custom_fields'] : null;
        $this->container['allow_envelope_custom_fields_metadata'] = isset($data['allow_envelope_custom_fields_metadata']) ? $data['allow_envelope_custom_fields_metadata'] : null;
        $this->container['allow_envelope_publish_reporting'] = isset($data['allow_envelope_publish_reporting']) ? $data['allow_envelope_publish_reporting'] : null;
        $this->container['allow_envelope_publish_reporting_metadata'] = isset($data['allow_envelope_publish_reporting_metadata']) ? $data['allow_envelope_publish_reporting_metadata'] : null;
        $this->container['allow_envelope_reporting'] = isset($data['allow_envelope_reporting']) ? $data['allow_envelope_reporting'] : null;
        $this->container['allow_envelope_reporting_metadata'] = isset($data['allow_envelope_reporting_metadata']) ? $data['allow_envelope_reporting_metadata'] : null;
        $this->container['allow_expression'] = isset($data['allow_expression']) ? $data['allow_expression'] : null;
        $this->container['allow_expression_metadata'] = isset($data['allow_expression_metadata']) ? $data['allow_expression_metadata'] : null;
        $this->container['allow_express_signer_certificate'] = isset($data['allow_express_signer_certificate']) ? $data['allow_express_signer_certificate'] : null;
        $this->container['allow_express_signer_certificate_metadata'] = isset($data['allow_express_signer_certificate_metadata']) ? $data['allow_express_signer_certificate_metadata'] : null;
        $this->container['allow_extended_sending_resource_file'] = isset($data['allow_extended_sending_resource_file']) ? $data['allow_extended_sending_resource_file'] : null;
        $this->container['allow_extended_sending_resource_file_metadata'] = isset($data['allow_extended_sending_resource_file_metadata']) ? $data['allow_extended_sending_resource_file_metadata'] : null;
        $this->container['allow_external_linked_accounts'] = isset($data['allow_external_linked_accounts']) ? $data['allow_external_linked_accounts'] : null;
        $this->container['allow_external_linked_accounts_metadata'] = isset($data['allow_external_linked_accounts_metadata']) ? $data['allow_external_linked_accounts_metadata'] : null;
        $this->container['allow_external_signature_pad'] = isset($data['allow_external_signature_pad']) ? $data['allow_external_signature_pad'] : null;
        $this->container['allow_external_signature_pad_metadata'] = isset($data['allow_external_signature_pad_metadata']) ? $data['allow_external_signature_pad_metadata'] : null;
        $this->container['allow_idv_for_eu_qualified_signatures'] = isset($data['allow_idv_for_eu_qualified_signatures']) ? $data['allow_idv_for_eu_qualified_signatures'] : null;
        $this->container['allow_idv_for_eu_qualified_signatures_metadata'] = isset($data['allow_idv_for_eu_qualified_signatures_metadata']) ? $data['allow_idv_for_eu_qualified_signatures_metadata'] : null;
        $this->container['allow_idv_level1'] = isset($data['allow_idv_level1']) ? $data['allow_idv_level1'] : null;
        $this->container['allow_idv_level1_metadata'] = isset($data['allow_idv_level1_metadata']) ? $data['allow_idv_level1_metadata'] : null;
        $this->container['allow_idv_level1_trial'] = isset($data['allow_idv_level1_trial']) ? $data['allow_idv_level1_trial'] : null;
        $this->container['allow_idv_level1_trial_metadata'] = isset($data['allow_idv_level1_trial_metadata']) ? $data['allow_idv_level1_trial_metadata'] : null;
        $this->container['allow_idv_level2'] = isset($data['allow_idv_level2']) ? $data['allow_idv_level2'] : null;
        $this->container['allow_idv_level2_metadata'] = isset($data['allow_idv_level2_metadata']) ? $data['allow_idv_level2_metadata'] : null;
        $this->container['allow_idv_level3'] = isset($data['allow_idv_level3']) ? $data['allow_idv_level3'] : null;
        $this->container['allow_idv_level3_metadata'] = isset($data['allow_idv_level3_metadata']) ? $data['allow_idv_level3_metadata'] : null;
        $this->container['allow_idv_platform'] = isset($data['allow_idv_platform']) ? $data['allow_idv_platform'] : null;
        $this->container['allow_idv_platform_metadata'] = isset($data['allow_idv_platform_metadata']) ? $data['allow_idv_platform_metadata'] : null;
        $this->container['allow_in_person'] = isset($data['allow_in_person']) ? $data['allow_in_person'] : null;
        $this->container['allow_in_person_electronic_notary'] = isset($data['allow_in_person_electronic_notary']) ? $data['allow_in_person_electronic_notary'] : null;
        $this->container['allow_in_person_electronic_notary_metadata'] = isset($data['allow_in_person_electronic_notary_metadata']) ? $data['allow_in_person_electronic_notary_metadata'] : null;
        $this->container['allow_in_person_metadata'] = isset($data['allow_in_person_metadata']) ? $data['allow_in_person_metadata'] : null;
        $this->container['allow_managed_stamps'] = isset($data['allow_managed_stamps']) ? $data['allow_managed_stamps'] : null;
        $this->container['allow_managed_stamps_metadata'] = isset($data['allow_managed_stamps_metadata']) ? $data['allow_managed_stamps_metadata'] : null;
        $this->container['allow_managing_envelopes_on_behalf_of_others'] = isset($data['allow_managing_envelopes_on_behalf_of_others']) ? $data['allow_managing_envelopes_on_behalf_of_others'] : null;
        $this->container['allow_managing_envelopes_on_behalf_of_others_metadata'] = isset($data['allow_managing_envelopes_on_behalf_of_others_metadata']) ? $data['allow_managing_envelopes_on_behalf_of_others_metadata'] : null;
        $this->container['allow_markup'] = isset($data['allow_markup']) ? $data['allow_markup'] : null;
        $this->container['allow_markup_metadata'] = isset($data['allow_markup_metadata']) ? $data['allow_markup_metadata'] : null;
        $this->container['allow_member_time_zone'] = isset($data['allow_member_time_zone']) ? $data['allow_member_time_zone'] : null;
        $this->container['allow_member_time_zone_metadata'] = isset($data['allow_member_time_zone_metadata']) ? $data['allow_member_time_zone_metadata'] : null;
        $this->container['allow_merge_fields'] = isset($data['allow_merge_fields']) ? $data['allow_merge_fields'] : null;
        $this->container['allow_merge_fields_metadata'] = isset($data['allow_merge_fields_metadata']) ? $data['allow_merge_fields_metadata'] : null;
        $this->container['allow_multiple_brand_profiles'] = isset($data['allow_multiple_brand_profiles']) ? $data['allow_multiple_brand_profiles'] : null;
        $this->container['allow_multiple_brand_profiles_metadata'] = isset($data['allow_multiple_brand_profiles_metadata']) ? $data['allow_multiple_brand_profiles_metadata'] : null;
        $this->container['allow_multiple_signer_attachments'] = isset($data['allow_multiple_signer_attachments']) ? $data['allow_multiple_signer_attachments'] : null;
        $this->container['allow_multiple_signer_attachments_metadata'] = isset($data['allow_multiple_signer_attachments_metadata']) ? $data['allow_multiple_signer_attachments_metadata'] : null;
        $this->container['allow_non_us_phone_auth'] = isset($data['allow_non_us_phone_auth']) ? $data['allow_non_us_phone_auth'] : null;
        $this->container['allow_non_us_phone_auth_metadata'] = isset($data['allow_non_us_phone_auth_metadata']) ? $data['allow_non_us_phone_auth_metadata'] : null;
        $this->container['allow_ocr_of_envelope_documents'] = isset($data['allow_ocr_of_envelope_documents']) ? $data['allow_ocr_of_envelope_documents'] : null;
        $this->container['allow_ocr_of_envelope_documents_metadata'] = isset($data['allow_ocr_of_envelope_documents_metadata']) ? $data['allow_ocr_of_envelope_documents_metadata'] : null;
        $this->container['allow_offline_signing'] = isset($data['allow_offline_signing']) ? $data['allow_offline_signing'] : null;
        $this->container['allow_offline_signing_metadata'] = isset($data['allow_offline_signing_metadata']) ? $data['allow_offline_signing_metadata'] : null;
        $this->container['allow_open_trust_signer_certificate'] = isset($data['allow_open_trust_signer_certificate']) ? $data['allow_open_trust_signer_certificate'] : null;
        $this->container['allow_open_trust_signer_certificate_metadata'] = isset($data['allow_open_trust_signer_certificate_metadata']) ? $data['allow_open_trust_signer_certificate_metadata'] : null;
        $this->container['allow_organization_docusign_monitor'] = isset($data['allow_organization_docusign_monitor']) ? $data['allow_organization_docusign_monitor'] : null;
        $this->container['allow_organization_docusign_monitor_free'] = isset($data['allow_organization_docusign_monitor_free']) ? $data['allow_organization_docusign_monitor_free'] : null;
        $this->container['allow_organization_docusign_monitor_free_metadata'] = isset($data['allow_organization_docusign_monitor_free_metadata']) ? $data['allow_organization_docusign_monitor_free_metadata'] : null;
        $this->container['allow_organization_docusign_monitor_metadata'] = isset($data['allow_organization_docusign_monitor_metadata']) ? $data['allow_organization_docusign_monitor_metadata'] : null;
        $this->container['allow_organization_domain_user_management'] = isset($data['allow_organization_domain_user_management']) ? $data['allow_organization_domain_user_management'] : null;
        $this->container['allow_organization_domain_user_management_metadata'] = isset($data['allow_organization_domain_user_management_metadata']) ? $data['allow_organization_domain_user_management_metadata'] : null;
        $this->container['allow_organizations'] = isset($data['allow_organizations']) ? $data['allow_organizations'] : null;
        $this->container['allow_organizations_metadata'] = isset($data['allow_organizations_metadata']) ? $data['allow_organizations_metadata'] : null;
        $this->container['allow_organization_sso_management'] = isset($data['allow_organization_sso_management']) ? $data['allow_organization_sso_management'] : null;
        $this->container['allow_organization_sso_management_metadata'] = isset($data['allow_organization_sso_management_metadata']) ? $data['allow_organization_sso_management_metadata'] : null;
        $this->container['allow_organization_to_use_in_person_electronic_notary'] = isset($data['allow_organization_to_use_in_person_electronic_notary']) ? $data['allow_organization_to_use_in_person_electronic_notary'] : null;
        $this->container['allow_organization_to_use_in_person_electronic_notary_metadata'] = isset($data['allow_organization_to_use_in_person_electronic_notary_metadata']) ? $data['allow_organization_to_use_in_person_electronic_notary_metadata'] : null;
        $this->container['allow_organization_to_use_remote_notary'] = isset($data['allow_organization_to_use_remote_notary']) ? $data['allow_organization_to_use_remote_notary'] : null;
        $this->container['allow_organization_to_use_remote_notary_metadata'] = isset($data['allow_organization_to_use_remote_notary_metadata']) ? $data['allow_organization_to_use_remote_notary_metadata'] : null;
        $this->container['allow_organization_to_use_third_party_electronic_notary'] = isset($data['allow_organization_to_use_third_party_electronic_notary']) ? $data['allow_organization_to_use_third_party_electronic_notary'] : null;
        $this->container['allow_organization_to_use_third_party_electronic_notary_metadata'] = isset($data['allow_organization_to_use_third_party_electronic_notary_metadata']) ? $data['allow_organization_to_use_third_party_electronic_notary_metadata'] : null;
        $this->container['allow_participant_recipient_type'] = isset($data['allow_participant_recipient_type']) ? $data['allow_participant_recipient_type'] : null;
        $this->container['allow_participant_recipient_type_metadata'] = isset($data['allow_participant_recipient_type_metadata']) ? $data['allow_participant_recipient_type_metadata'] : null;
        $this->container['allow_payment_processing'] = isset($data['allow_payment_processing']) ? $data['allow_payment_processing'] : null;
        $this->container['allow_payment_processing_metadata'] = isset($data['allow_payment_processing_metadata']) ? $data['allow_payment_processing_metadata'] : null;
        $this->container['allow_performance_analytics'] = isset($data['allow_performance_analytics']) ? $data['allow_performance_analytics'] : null;
        $this->container['allow_performance_analytics_metadata'] = isset($data['allow_performance_analytics_metadata']) ? $data['allow_performance_analytics_metadata'] : null;
        $this->container['allow_phone_authentication'] = isset($data['allow_phone_authentication']) ? $data['allow_phone_authentication'] : null;
        $this->container['allow_phone_authentication_metadata'] = isset($data['allow_phone_authentication_metadata']) ? $data['allow_phone_authentication_metadata'] : null;
        $this->container['allow_phone_auth_override'] = isset($data['allow_phone_auth_override']) ? $data['allow_phone_auth_override'] : null;
        $this->container['allow_phone_auth_override_metadata'] = isset($data['allow_phone_auth_override_metadata']) ? $data['allow_phone_auth_override_metadata'] : null;
        $this->container['allow_private_signing_groups'] = isset($data['allow_private_signing_groups']) ? $data['allow_private_signing_groups'] : null;
        $this->container['allow_private_signing_groups_metadata'] = isset($data['allow_private_signing_groups_metadata']) ? $data['allow_private_signing_groups_metadata'] : null;
        $this->container['allow_recipient_connect'] = isset($data['allow_recipient_connect']) ? $data['allow_recipient_connect'] : null;
        $this->container['allow_recipient_connect_metadata'] = isset($data['allow_recipient_connect_metadata']) ? $data['allow_recipient_connect_metadata'] : null;
        $this->container['allow_reminders'] = isset($data['allow_reminders']) ? $data['allow_reminders'] : null;
        $this->container['allow_reminders_metadata'] = isset($data['allow_reminders_metadata']) ? $data['allow_reminders_metadata'] : null;
        $this->container['allow_remote_notary'] = isset($data['allow_remote_notary']) ? $data['allow_remote_notary'] : null;
        $this->container['allow_remote_notary_metadata'] = isset($data['allow_remote_notary_metadata']) ? $data['allow_remote_notary_metadata'] : null;
        $this->container['allow_resource_file_branding'] = isset($data['allow_resource_file_branding']) ? $data['allow_resource_file_branding'] : null;
        $this->container['allow_resource_file_branding_metadata'] = isset($data['allow_resource_file_branding_metadata']) ? $data['allow_resource_file_branding_metadata'] : null;
        $this->container['allow_safe_bio_pharma_signer_certificate'] = isset($data['allow_safe_bio_pharma_signer_certificate']) ? $data['allow_safe_bio_pharma_signer_certificate'] : null;
        $this->container['allow_safe_bio_pharma_signer_certificate_metadata'] = isset($data['allow_safe_bio_pharma_signer_certificate_metadata']) ? $data['allow_safe_bio_pharma_signer_certificate_metadata'] : null;
        $this->container['allow_scheduled_sending'] = isset($data['allow_scheduled_sending']) ? $data['allow_scheduled_sending'] : null;
        $this->container['allow_scheduled_sending_metadata'] = isset($data['allow_scheduled_sending_metadata']) ? $data['allow_scheduled_sending_metadata'] : null;
        $this->container['allow_security_appliance'] = isset($data['allow_security_appliance']) ? $data['allow_security_appliance'] : null;
        $this->container['allow_security_appliance_metadata'] = isset($data['allow_security_appliance_metadata']) ? $data['allow_security_appliance_metadata'] : null;
        $this->container['allow_sending_envelopes_on_behalf_of_others'] = isset($data['allow_sending_envelopes_on_behalf_of_others']) ? $data['allow_sending_envelopes_on_behalf_of_others'] : null;
        $this->container['allow_sending_envelopes_on_behalf_of_others_metadata'] = isset($data['allow_sending_envelopes_on_behalf_of_others_metadata']) ? $data['allow_sending_envelopes_on_behalf_of_others_metadata'] : null;
        $this->container['allow_send_to_certified_delivery'] = isset($data['allow_send_to_certified_delivery']) ? $data['allow_send_to_certified_delivery'] : null;
        $this->container['allow_send_to_certified_delivery_metadata'] = isset($data['allow_send_to_certified_delivery_metadata']) ? $data['allow_send_to_certified_delivery_metadata'] : null;
        $this->container['allow_send_to_intermediary'] = isset($data['allow_send_to_intermediary']) ? $data['allow_send_to_intermediary'] : null;
        $this->container['allow_send_to_intermediary_metadata'] = isset($data['allow_send_to_intermediary_metadata']) ? $data['allow_send_to_intermediary_metadata'] : null;
        $this->container['allow_server_templates'] = isset($data['allow_server_templates']) ? $data['allow_server_templates'] : null;
        $this->container['allow_server_templates_metadata'] = isset($data['allow_server_templates_metadata']) ? $data['allow_server_templates_metadata'] : null;
        $this->container['allow_set_embedded_recipient_start_url'] = isset($data['allow_set_embedded_recipient_start_url']) ? $data['allow_set_embedded_recipient_start_url'] : null;
        $this->container['allow_set_embedded_recipient_start_url_metadata'] = isset($data['allow_set_embedded_recipient_start_url_metadata']) ? $data['allow_set_embedded_recipient_start_url_metadata'] : null;
        $this->container['allow_shared_tabs'] = isset($data['allow_shared_tabs']) ? $data['allow_shared_tabs'] : null;
        $this->container['allow_shared_tabs_metadata'] = isset($data['allow_shared_tabs_metadata']) ? $data['allow_shared_tabs_metadata'] : null;
        $this->container['allow_signature_stamps'] = isset($data['allow_signature_stamps']) ? $data['allow_signature_stamps'] : null;
        $this->container['allow_signature_stamps_metadata'] = isset($data['allow_signature_stamps_metadata']) ? $data['allow_signature_stamps_metadata'] : null;
        $this->container['allow_sign_document_from_home_page'] = isset($data['allow_sign_document_from_home_page']) ? $data['allow_sign_document_from_home_page'] : null;
        $this->container['allow_sign_document_from_home_page_metadata'] = isset($data['allow_sign_document_from_home_page_metadata']) ? $data['allow_sign_document_from_home_page_metadata'] : null;
        $this->container['allow_signer_reassign'] = isset($data['allow_signer_reassign']) ? $data['allow_signer_reassign'] : null;
        $this->container['allow_signer_reassign_metadata'] = isset($data['allow_signer_reassign_metadata']) ? $data['allow_signer_reassign_metadata'] : null;
        $this->container['allow_signer_reassign_override'] = isset($data['allow_signer_reassign_override']) ? $data['allow_signer_reassign_override'] : null;
        $this->container['allow_signer_reassign_override_metadata'] = isset($data['allow_signer_reassign_override_metadata']) ? $data['allow_signer_reassign_override_metadata'] : null;
        $this->container['allow_signing_extensions'] = isset($data['allow_signing_extensions']) ? $data['allow_signing_extensions'] : null;
        $this->container['allow_signing_extensions_metadata'] = isset($data['allow_signing_extensions_metadata']) ? $data['allow_signing_extensions_metadata'] : null;
        $this->container['allow_signing_groups'] = isset($data['allow_signing_groups']) ? $data['allow_signing_groups'] : null;
        $this->container['allow_signing_groups_metadata'] = isset($data['allow_signing_groups_metadata']) ? $data['allow_signing_groups_metadata'] : null;
        $this->container['allow_signing_insights'] = isset($data['allow_signing_insights']) ? $data['allow_signing_insights'] : null;
        $this->container['allow_signing_insights_metadata'] = isset($data['allow_signing_insights_metadata']) ? $data['allow_signing_insights_metadata'] : null;
        $this->container['allow_signing_radio_deselect'] = isset($data['allow_signing_radio_deselect']) ? $data['allow_signing_radio_deselect'] : null;
        $this->container['allow_signing_radio_deselect_metadata'] = isset($data['allow_signing_radio_deselect_metadata']) ? $data['allow_signing_radio_deselect_metadata'] : null;
        $this->container['allow_sign_now'] = isset($data['allow_sign_now']) ? $data['allow_sign_now'] : null;
        $this->container['allow_sign_now_metadata'] = isset($data['allow_sign_now_metadata']) ? $data['allow_sign_now_metadata'] : null;
        $this->container['allow_sms_delivery'] = isset($data['allow_sms_delivery']) ? $data['allow_sms_delivery'] : null;
        $this->container['allow_sms_delivery_metadata'] = isset($data['allow_sms_delivery_metadata']) ? $data['allow_sms_delivery_metadata'] : null;
        $this->container['allow_social_id_login'] = isset($data['allow_social_id_login']) ? $data['allow_social_id_login'] : null;
        $this->container['allow_social_id_login_metadata'] = isset($data['allow_social_id_login_metadata']) ? $data['allow_social_id_login_metadata'] : null;
        $this->container['allow_supplemental_documents'] = isset($data['allow_supplemental_documents']) ? $data['allow_supplemental_documents'] : null;
        $this->container['allow_supplemental_documents_metadata'] = isset($data['allow_supplemental_documents_metadata']) ? $data['allow_supplemental_documents_metadata'] : null;
        $this->container['allow_third_party_electronic_notary'] = isset($data['allow_third_party_electronic_notary']) ? $data['allow_third_party_electronic_notary'] : null;
        $this->container['allow_third_party_electronic_notary_metadata'] = isset($data['allow_third_party_electronic_notary_metadata']) ? $data['allow_third_party_electronic_notary_metadata'] : null;
        $this->container['allow_transactions_workspace'] = isset($data['allow_transactions_workspace']) ? $data['allow_transactions_workspace'] : null;
        $this->container['allow_transactions_workspace_metadata'] = isset($data['allow_transactions_workspace_metadata']) ? $data['allow_transactions_workspace_metadata'] : null;
        $this->container['allow_transactions_workspace_original'] = isset($data['allow_transactions_workspace_original']) ? $data['allow_transactions_workspace_original'] : null;
        $this->container['allow_transactions_workspace_original_metadata'] = isset($data['allow_transactions_workspace_original_metadata']) ? $data['allow_transactions_workspace_original_metadata'] : null;
        $this->container['allow_users_to_access_directory'] = isset($data['allow_users_to_access_directory']) ? $data['allow_users_to_access_directory'] : null;
        $this->container['allow_users_to_access_directory_metadata'] = isset($data['allow_users_to_access_directory_metadata']) ? $data['allow_users_to_access_directory_metadata'] : null;
        $this->container['allow_value_insights'] = isset($data['allow_value_insights']) ? $data['allow_value_insights'] : null;
        $this->container['allow_value_insights_metadata'] = isset($data['allow_value_insights_metadata']) ? $data['allow_value_insights_metadata'] : null;
        $this->container['allow_web_forms'] = isset($data['allow_web_forms']) ? $data['allow_web_forms'] : null;
        $this->container['allow_web_forms_metadata'] = isset($data['allow_web_forms_metadata']) ? $data['allow_web_forms_metadata'] : null;
        $this->container['allow_whats_app_delivery'] = isset($data['allow_whats_app_delivery']) ? $data['allow_whats_app_delivery'] : null;
        $this->container['allow_whats_app_delivery_metadata'] = isset($data['allow_whats_app_delivery_metadata']) ? $data['allow_whats_app_delivery_metadata'] : null;
        $this->container['anchor_population_scope'] = isset($data['anchor_population_scope']) ? $data['anchor_population_scope'] : null;
        $this->container['anchor_population_scope_metadata'] = isset($data['anchor_population_scope_metadata']) ? $data['anchor_population_scope_metadata'] : null;
        $this->container['anchor_tag_versioned_placement_enabled'] = isset($data['anchor_tag_versioned_placement_enabled']) ? $data['anchor_tag_versioned_placement_enabled'] : null;
        $this->container['anchor_tag_versioned_placement_metadata_enabled'] = isset($data['anchor_tag_versioned_placement_metadata_enabled']) ? $data['anchor_tag_versioned_placement_metadata_enabled'] : null;
        $this->container['attach_completed_envelope'] = isset($data['attach_completed_envelope']) ? $data['attach_completed_envelope'] : null;
        $this->container['attach_completed_envelope_metadata'] = isset($data['attach_completed_envelope_metadata']) ? $data['attach_completed_envelope_metadata'] : null;
        $this->container['authentication_check'] = isset($data['authentication_check']) ? $data['authentication_check'] : null;
        $this->container['authentication_check_metadata'] = isset($data['authentication_check_metadata']) ? $data['authentication_check_metadata'] : null;
        $this->container['auto_nav_rule'] = isset($data['auto_nav_rule']) ? $data['auto_nav_rule'] : null;
        $this->container['auto_nav_rule_metadata'] = isset($data['auto_nav_rule_metadata']) ? $data['auto_nav_rule_metadata'] : null;
        $this->container['auto_provision_signer_account'] = isset($data['auto_provision_signer_account']) ? $data['auto_provision_signer_account'] : null;
        $this->container['auto_provision_signer_account_metadata'] = isset($data['auto_provision_signer_account_metadata']) ? $data['auto_provision_signer_account_metadata'] : null;
        $this->container['bcc_email_archive'] = isset($data['bcc_email_archive']) ? $data['bcc_email_archive'] : null;
        $this->container['bcc_email_archive_metadata'] = isset($data['bcc_email_archive_metadata']) ? $data['bcc_email_archive_metadata'] : null;
        $this->container['beta_switch_configuration'] = isset($data['beta_switch_configuration']) ? $data['beta_switch_configuration'] : null;
        $this->container['beta_switch_configuration_metadata'] = isset($data['beta_switch_configuration_metadata']) ? $data['beta_switch_configuration_metadata'] : null;
        $this->container['billing_address'] = isset($data['billing_address']) ? $data['billing_address'] : null;
        $this->container['billing_address_metadata'] = isset($data['billing_address_metadata']) ? $data['billing_address_metadata'] : null;
        $this->container['bulk_send'] = isset($data['bulk_send']) ? $data['bulk_send'] : null;
        $this->container['bulk_send_action_resend_limit'] = isset($data['bulk_send_action_resend_limit']) ? $data['bulk_send_action_resend_limit'] : null;
        $this->container['bulk_send_max_copies_in_batch'] = isset($data['bulk_send_max_copies_in_batch']) ? $data['bulk_send_max_copies_in_batch'] : null;
        $this->container['bulk_send_max_unprocessed_envelopes_count'] = isset($data['bulk_send_max_unprocessed_envelopes_count']) ? $data['bulk_send_max_unprocessed_envelopes_count'] : null;
        $this->container['bulk_send_metadata'] = isset($data['bulk_send_metadata']) ? $data['bulk_send_metadata'] : null;
        $this->container['can_self_brand_send'] = isset($data['can_self_brand_send']) ? $data['can_self_brand_send'] : null;
        $this->container['can_self_brand_send_metadata'] = isset($data['can_self_brand_send_metadata']) ? $data['can_self_brand_send_metadata'] : null;
        $this->container['can_self_brand_sign'] = isset($data['can_self_brand_sign']) ? $data['can_self_brand_sign'] : null;
        $this->container['can_self_brand_sign_metadata'] = isset($data['can_self_brand_sign_metadata']) ? $data['can_self_brand_sign_metadata'] : null;
        $this->container['can_use_salesforce_o_auth'] = isset($data['can_use_salesforce_o_auth']) ? $data['can_use_salesforce_o_auth'] : null;
        $this->container['can_use_salesforce_o_auth_metadata'] = isset($data['can_use_salesforce_o_auth_metadata']) ? $data['can_use_salesforce_o_auth_metadata'] : null;
        $this->container['capture_voice_recording'] = isset($data['capture_voice_recording']) ? $data['capture_voice_recording'] : null;
        $this->container['capture_voice_recording_metadata'] = isset($data['capture_voice_recording_metadata']) ? $data['capture_voice_recording_metadata'] : null;
        $this->container['cfr21_simplified_signing_enabled'] = isset($data['cfr21_simplified_signing_enabled']) ? $data['cfr21_simplified_signing_enabled'] : null;
        $this->container['cfr21_simplified_signing_enabled_metadata'] = isset($data['cfr21_simplified_signing_enabled_metadata']) ? $data['cfr21_simplified_signing_enabled_metadata'] : null;
        $this->container['cfr_use_wide_image'] = isset($data['cfr_use_wide_image']) ? $data['cfr_use_wide_image'] : null;
        $this->container['cfr_use_wide_image_metadata'] = isset($data['cfr_use_wide_image_metadata']) ? $data['cfr_use_wide_image_metadata'] : null;
        $this->container['check_for_multiple_admins_on_account'] = isset($data['check_for_multiple_admins_on_account']) ? $data['check_for_multiple_admins_on_account'] : null;
        $this->container['check_for_multiple_admins_on_account_metadata'] = isset($data['check_for_multiple_admins_on_account_metadata']) ? $data['check_for_multiple_admins_on_account_metadata'] : null;
        $this->container['chrome_signature_enabled'] = isset($data['chrome_signature_enabled']) ? $data['chrome_signature_enabled'] : null;
        $this->container['chrome_signature_enabled_metadata'] = isset($data['chrome_signature_enabled_metadata']) ? $data['chrome_signature_enabled_metadata'] : null;
        $this->container['comment_email_show_message_text'] = isset($data['comment_email_show_message_text']) ? $data['comment_email_show_message_text'] : null;
        $this->container['comment_email_show_message_text_metadata'] = isset($data['comment_email_show_message_text_metadata']) ? $data['comment_email_show_message_text_metadata'] : null;
        $this->container['comments_allow_envelope_override'] = isset($data['comments_allow_envelope_override']) ? $data['comments_allow_envelope_override'] : null;
        $this->container['comments_allow_envelope_override_metadata'] = isset($data['comments_allow_envelope_override_metadata']) ? $data['comments_allow_envelope_override_metadata'] : null;
        $this->container['conditional_fields_enabled'] = isset($data['conditional_fields_enabled']) ? $data['conditional_fields_enabled'] : null;
        $this->container['conditional_fields_enabled_metadata'] = isset($data['conditional_fields_enabled_metadata']) ? $data['conditional_fields_enabled_metadata'] : null;
        $this->container['consumer_disclosure_frequency'] = isset($data['consumer_disclosure_frequency']) ? $data['consumer_disclosure_frequency'] : null;
        $this->container['consumer_disclosure_frequency_metadata'] = isset($data['consumer_disclosure_frequency_metadata']) ? $data['consumer_disclosure_frequency_metadata'] : null;
        $this->container['convert_pdf_fields'] = isset($data['convert_pdf_fields']) ? $data['convert_pdf_fields'] : null;
        $this->container['convert_pdf_fields_metadata'] = isset($data['convert_pdf_fields_metadata']) ? $data['convert_pdf_fields_metadata'] : null;
        $this->container['data_population_scope'] = isset($data['data_population_scope']) ? $data['data_population_scope'] : null;
        $this->container['data_population_scope_metadata'] = isset($data['data_population_scope_metadata']) ? $data['data_population_scope_metadata'] : null;
        $this->container['default_to_advanced_envelopes_filter_form'] = isset($data['default_to_advanced_envelopes_filter_form']) ? $data['default_to_advanced_envelopes_filter_form'] : null;
        $this->container['default_to_advanced_envelopes_filter_form_metadata'] = isset($data['default_to_advanced_envelopes_filter_form_metadata']) ? $data['default_to_advanced_envelopes_filter_form_metadata'] : null;
        $this->container['disable_auto_template_matching'] = isset($data['disable_auto_template_matching']) ? $data['disable_auto_template_matching'] : null;
        $this->container['disable_auto_template_matching_metadata'] = isset($data['disable_auto_template_matching_metadata']) ? $data['disable_auto_template_matching_metadata'] : null;
        $this->container['disable_mobile_app'] = isset($data['disable_mobile_app']) ? $data['disable_mobile_app'] : null;
        $this->container['disable_mobile_app_metadata'] = isset($data['disable_mobile_app_metadata']) ? $data['disable_mobile_app_metadata'] : null;
        $this->container['disable_mobile_push_notifications'] = isset($data['disable_mobile_push_notifications']) ? $data['disable_mobile_push_notifications'] : null;
        $this->container['disable_mobile_push_notifications_metadata'] = isset($data['disable_mobile_push_notifications_metadata']) ? $data['disable_mobile_push_notifications_metadata'] : null;
        $this->container['disable_mobile_sending'] = isset($data['disable_mobile_sending']) ? $data['disable_mobile_sending'] : null;
        $this->container['disable_mobile_sending_metadata'] = isset($data['disable_mobile_sending_metadata']) ? $data['disable_mobile_sending_metadata'] : null;
        $this->container['disable_multiple_sessions'] = isset($data['disable_multiple_sessions']) ? $data['disable_multiple_sessions'] : null;
        $this->container['disable_multiple_sessions_metadata'] = isset($data['disable_multiple_sessions_metadata']) ? $data['disable_multiple_sessions_metadata'] : null;
        $this->container['disable_purge_notifications_for_sender_metadata'] = isset($data['disable_purge_notifications_for_sender_metadata']) ? $data['disable_purge_notifications_for_sender_metadata'] : null;
        $this->container['disable_signer_cert_view'] = isset($data['disable_signer_cert_view']) ? $data['disable_signer_cert_view'] : null;
        $this->container['disable_signer_cert_view_metadata'] = isset($data['disable_signer_cert_view_metadata']) ? $data['disable_signer_cert_view_metadata'] : null;
        $this->container['disable_signer_history_view'] = isset($data['disable_signer_history_view']) ? $data['disable_signer_history_view'] : null;
        $this->container['disable_signer_history_view_metadata'] = isset($data['disable_signer_history_view_metadata']) ? $data['disable_signer_history_view_metadata'] : null;
        $this->container['disable_style_signature'] = isset($data['disable_style_signature']) ? $data['disable_style_signature'] : null;
        $this->container['disable_style_signature_metadata'] = isset($data['disable_style_signature_metadata']) ? $data['disable_style_signature_metadata'] : null;
        $this->container['disable_upload_signature'] = isset($data['disable_upload_signature']) ? $data['disable_upload_signature'] : null;
        $this->container['disable_upload_signature_metadata'] = isset($data['disable_upload_signature_metadata']) ? $data['disable_upload_signature_metadata'] : null;
        $this->container['disable_user_sharing'] = isset($data['disable_user_sharing']) ? $data['disable_user_sharing'] : null;
        $this->container['disable_user_sharing_metadata'] = isset($data['disable_user_sharing_metadata']) ? $data['disable_user_sharing_metadata'] : null;
        $this->container['display_beta_switch'] = isset($data['display_beta_switch']) ? $data['display_beta_switch'] : null;
        $this->container['display_beta_switch_metadata'] = isset($data['display_beta_switch_metadata']) ? $data['display_beta_switch_metadata'] : null;
        $this->container['document_conversion_restrictions'] = isset($data['document_conversion_restrictions']) ? $data['document_conversion_restrictions'] : null;
        $this->container['document_conversion_restrictions_metadata'] = isset($data['document_conversion_restrictions_metadata']) ? $data['document_conversion_restrictions_metadata'] : null;
        $this->container['document_retention'] = isset($data['document_retention']) ? $data['document_retention'] : null;
        $this->container['document_retention_metadata'] = isset($data['document_retention_metadata']) ? $data['document_retention_metadata'] : null;
        $this->container['document_retention_purge_tabs'] = isset($data['document_retention_purge_tabs']) ? $data['document_retention_purge_tabs'] : null;
        $this->container['document_visibility'] = isset($data['document_visibility']) ? $data['document_visibility'] : null;
        $this->container['document_visibility_metadata'] = isset($data['document_visibility_metadata']) ? $data['document_visibility_metadata'] : null;
        $this->container['draft_envelope_retention'] = isset($data['draft_envelope_retention']) ? $data['draft_envelope_retention'] : null;
        $this->container['draft_envelope_retention_metadata'] = isset($data['draft_envelope_retention_metadata']) ? $data['draft_envelope_retention_metadata'] : null;
        $this->container['dss_enable_provisioning_pen_configuration_radmin_option'] = isset($data['dss_enable_provisioning_pen_configuration_radmin_option']) ? $data['dss_enable_provisioning_pen_configuration_radmin_option'] : null;
        $this->container['dss_sign_28411_enable_leave_page_prompt_radmin_option'] = isset($data['dss_sign_28411_enable_leave_page_prompt_radmin_option']) ? $data['dss_sign_28411_enable_leave_page_prompt_radmin_option'] : null;
        $this->container['dss_sign_29182_slide_up_bar_radmin_option'] = isset($data['dss_sign_29182_slide_up_bar_radmin_option']) ? $data['dss_sign_29182_slide_up_bar_radmin_option'] : null;
        $this->container['email_template_version'] = isset($data['email_template_version']) ? $data['email_template_version'] : null;
        $this->container['email_template_version_metadata'] = isset($data['email_template_version_metadata']) ? $data['email_template_version_metadata'] : null;
        $this->container['enable_access_code_generator'] = isset($data['enable_access_code_generator']) ? $data['enable_access_code_generator'] : null;
        $this->container['enable_access_code_generator_metadata'] = isset($data['enable_access_code_generator_metadata']) ? $data['enable_access_code_generator_metadata'] : null;
        $this->container['enable_account_wide_search'] = isset($data['enable_account_wide_search']) ? $data['enable_account_wide_search'] : null;
        $this->container['enable_account_wide_search_metadata'] = isset($data['enable_account_wide_search_metadata']) ? $data['enable_account_wide_search_metadata'] : null;
        $this->container['enable_adm_healthcare'] = isset($data['enable_adm_healthcare']) ? $data['enable_adm_healthcare'] : null;
        $this->container['enable_adm_healthcare_metadata'] = isset($data['enable_adm_healthcare_metadata']) ? $data['enable_adm_healthcare_metadata'] : null;
        $this->container['enable_advanced_envelopes_search'] = isset($data['enable_advanced_envelopes_search']) ? $data['enable_advanced_envelopes_search'] : null;
        $this->container['enable_advanced_envelopes_search_metadata'] = isset($data['enable_advanced_envelopes_search_metadata']) ? $data['enable_advanced_envelopes_search_metadata'] : null;
        $this->container['enable_advanced_payments'] = isset($data['enable_advanced_payments']) ? $data['enable_advanced_payments'] : null;
        $this->container['enable_advanced_payments_metadata'] = isset($data['enable_advanced_payments_metadata']) ? $data['enable_advanced_payments_metadata'] : null;
        $this->container['enable_advanced_power_forms'] = isset($data['enable_advanced_power_forms']) ? $data['enable_advanced_power_forms'] : null;
        $this->container['enable_advanced_power_forms_metadata'] = isset($data['enable_advanced_power_forms_metadata']) ? $data['enable_advanced_power_forms_metadata'] : null;
        $this->container['enable_agreement_actions_for_clm'] = isset($data['enable_agreement_actions_for_clm']) ? $data['enable_agreement_actions_for_clm'] : null;
        $this->container['enable_agreement_actions_for_clm_metadata'] = isset($data['enable_agreement_actions_for_clm_metadata']) ? $data['enable_agreement_actions_for_clm_metadata'] : null;
        $this->container['enable_agreement_actions_for_e_sign'] = isset($data['enable_agreement_actions_for_e_sign']) ? $data['enable_agreement_actions_for_e_sign'] : null;
        $this->container['enable_agreement_actions_for_e_sign_metadata'] = isset($data['enable_agreement_actions_for_e_sign_metadata']) ? $data['enable_agreement_actions_for_e_sign_metadata'] : null;
        $this->container['enable_auto_nav'] = isset($data['enable_auto_nav']) ? $data['enable_auto_nav'] : null;
        $this->container['enable_auto_nav_metadata'] = isset($data['enable_auto_nav_metadata']) ? $data['enable_auto_nav_metadata'] : null;
        $this->container['enable_bcc_dummy_link'] = isset($data['enable_bcc_dummy_link']) ? $data['enable_bcc_dummy_link'] : null;
        $this->container['enable_bcc_dummy_link_metadata'] = isset($data['enable_bcc_dummy_link_metadata']) ? $data['enable_bcc_dummy_link_metadata'] : null;
        $this->container['enable_calculated_fields'] = isset($data['enable_calculated_fields']) ? $data['enable_calculated_fields'] : null;
        $this->container['enable_calculated_fields_metadata'] = isset($data['enable_calculated_fields_metadata']) ? $data['enable_calculated_fields_metadata'] : null;
        $this->container['enable_click_plus'] = isset($data['enable_click_plus']) ? $data['enable_click_plus'] : null;
        $this->container['enable_click_plus_conditional_content'] = isset($data['enable_click_plus_conditional_content']) ? $data['enable_click_plus_conditional_content'] : null;
        $this->container['enable_click_plus_conditional_content_meta_data'] = isset($data['enable_click_plus_conditional_content_meta_data']) ? $data['enable_click_plus_conditional_content_meta_data'] : null;
        $this->container['enable_click_plus_custom_fields'] = isset($data['enable_click_plus_custom_fields']) ? $data['enable_click_plus_custom_fields'] : null;
        $this->container['enable_click_plus_custom_fields_meta_data'] = isset($data['enable_click_plus_custom_fields_meta_data']) ? $data['enable_click_plus_custom_fields_meta_data'] : null;
        $this->container['enable_click_plus_custom_style'] = isset($data['enable_click_plus_custom_style']) ? $data['enable_click_plus_custom_style'] : null;
        $this->container['enable_click_plus_custom_style_meta_data'] = isset($data['enable_click_plus_custom_style_meta_data']) ? $data['enable_click_plus_custom_style_meta_data'] : null;
        $this->container['enable_click_plus_dynamic_content'] = isset($data['enable_click_plus_dynamic_content']) ? $data['enable_click_plus_dynamic_content'] : null;
        $this->container['enable_click_plus_dynamic_content_meta_data'] = isset($data['enable_click_plus_dynamic_content_meta_data']) ? $data['enable_click_plus_dynamic_content_meta_data'] : null;
        $this->container['enable_click_plus_meta_data'] = isset($data['enable_click_plus_meta_data']) ? $data['enable_click_plus_meta_data'] : null;
        $this->container['enable_clickwraps'] = isset($data['enable_clickwraps']) ? $data['enable_clickwraps'] : null;
        $this->container['enable_clickwraps_metadata'] = isset($data['enable_clickwraps_metadata']) ? $data['enable_clickwraps_metadata'] : null;
        $this->container['enable_combined_pdf_download_for_sbs'] = isset($data['enable_combined_pdf_download_for_sbs']) ? $data['enable_combined_pdf_download_for_sbs'] : null;
        $this->container['enable_comments_history_download_in_signing'] = isset($data['enable_comments_history_download_in_signing']) ? $data['enable_comments_history_download_in_signing'] : null;
        $this->container['enable_comments_history_download_in_signing_metadata'] = isset($data['enable_comments_history_download_in_signing_metadata']) ? $data['enable_comments_history_download_in_signing_metadata'] : null;
        $this->container['enable_contact_suggestions'] = isset($data['enable_contact_suggestions']) ? $data['enable_contact_suggestions'] : null;
        $this->container['enable_contact_suggestions_metadata'] = isset($data['enable_contact_suggestions_metadata']) ? $data['enable_contact_suggestions_metadata'] : null;
        $this->container['enable_customer_satisfaction_metric_tracking'] = isset($data['enable_customer_satisfaction_metric_tracking']) ? $data['enable_customer_satisfaction_metric_tracking'] : null;
        $this->container['enable_customer_satisfaction_metric_tracking_metadata'] = isset($data['enable_customer_satisfaction_metric_tracking_metadata']) ? $data['enable_customer_satisfaction_metric_tracking_metadata'] : null;
        $this->container['enable_d_sig_eu_advanced_pens'] = isset($data['enable_d_sig_eu_advanced_pens']) ? $data['enable_d_sig_eu_advanced_pens'] : null;
        $this->container['enable_d_sig_eu_advanced_pens_metadata'] = isset($data['enable_d_sig_eu_advanced_pens_metadata']) ? $data['enable_d_sig_eu_advanced_pens_metadata'] : null;
        $this->container['enable_d_sig_express_pens'] = isset($data['enable_d_sig_express_pens']) ? $data['enable_d_sig_express_pens'] : null;
        $this->container['enable_d_sig_express_pens_metadata'] = isset($data['enable_d_sig_express_pens_metadata']) ? $data['enable_d_sig_express_pens_metadata'] : null;
        $this->container['enable_d_sig_id_check_for_aes_pens'] = isset($data['enable_d_sig_id_check_for_aes_pens']) ? $data['enable_d_sig_id_check_for_aes_pens'] : null;
        $this->container['enable_d_sig_id_check_for_aes_pens_metadata'] = isset($data['enable_d_sig_id_check_for_aes_pens_metadata']) ? $data['enable_d_sig_id_check_for_aes_pens_metadata'] : null;
        $this->container['enable_d_sig_id_check_in_person_for_qes_pens'] = isset($data['enable_d_sig_id_check_in_person_for_qes_pens']) ? $data['enable_d_sig_id_check_in_person_for_qes_pens'] : null;
        $this->container['enable_d_sig_id_check_in_person_for_qes_pens_metadata'] = isset($data['enable_d_sig_id_check_in_person_for_qes_pens_metadata']) ? $data['enable_d_sig_id_check_in_person_for_qes_pens_metadata'] : null;
        $this->container['enable_d_sig_id_check_remote_for_qes_pens'] = isset($data['enable_d_sig_id_check_remote_for_qes_pens']) ? $data['enable_d_sig_id_check_remote_for_qes_pens'] : null;
        $this->container['enable_d_sig_id_check_remote_for_qes_pens_metadata'] = isset($data['enable_d_sig_id_check_remote_for_qes_pens_metadata']) ? $data['enable_d_sig_id_check_remote_for_qes_pens_metadata'] : null;
        $this->container['enable_d_sig_id_verification_pens'] = isset($data['enable_d_sig_id_verification_pens']) ? $data['enable_d_sig_id_verification_pens'] : null;
        $this->container['enable_d_sig_id_verification_pens_metadata'] = isset($data['enable_d_sig_id_verification_pens_metadata']) ? $data['enable_d_sig_id_verification_pens_metadata'] : null;
        $this->container['enable_d_sig_id_verification_premier_pens'] = isset($data['enable_d_sig_id_verification_premier_pens']) ? $data['enable_d_sig_id_verification_premier_pens'] : null;
        $this->container['enable_d_sig_id_verification_premier_pens_metadata'] = isset($data['enable_d_sig_id_verification_premier_pens_metadata']) ? $data['enable_d_sig_id_verification_premier_pens_metadata'] : null;
        $this->container['enable_ds_pro'] = isset($data['enable_ds_pro']) ? $data['enable_ds_pro'] : null;
        $this->container['enable_ds_pro_metadata'] = isset($data['enable_ds_pro_metadata']) ? $data['enable_ds_pro_metadata'] : null;
        $this->container['enable_enforce_tls_emails_setting_metadata'] = isset($data['enable_enforce_tls_emails_setting_metadata']) ? $data['enable_enforce_tls_emails_setting_metadata'] : null;
        $this->container['enable_envelope_stamping_by_account_admin'] = isset($data['enable_envelope_stamping_by_account_admin']) ? $data['enable_envelope_stamping_by_account_admin'] : null;
        $this->container['enable_envelope_stamping_by_account_admin_metadata'] = isset($data['enable_envelope_stamping_by_account_admin_metadata']) ? $data['enable_envelope_stamping_by_account_admin_metadata'] : null;
        $this->container['enable_envelope_stamping_by_ds_admin'] = isset($data['enable_envelope_stamping_by_ds_admin']) ? $data['enable_envelope_stamping_by_ds_admin'] : null;
        $this->container['enable_envelope_stamping_by_ds_admin_metadata'] = isset($data['enable_envelope_stamping_by_ds_admin_metadata']) ? $data['enable_envelope_stamping_by_ds_admin_metadata'] : null;
        $this->container['enable_e_sign_api_hourly_limit_management'] = isset($data['enable_e_sign_api_hourly_limit_management']) ? $data['enable_e_sign_api_hourly_limit_management'] : null;
        $this->container['enable_e_sign_api_hourly_limit_management_metadata'] = isset($data['enable_e_sign_api_hourly_limit_management_metadata']) ? $data['enable_e_sign_api_hourly_limit_management_metadata'] : null;
        $this->container['enable_esign_communities'] = isset($data['enable_esign_communities']) ? $data['enable_esign_communities'] : null;
        $this->container['enable_esign_communities_metadata'] = isset($data['enable_esign_communities_metadata']) ? $data['enable_esign_communities_metadata'] : null;
        $this->container['enable_id_fx_accountless_sms_auth_for_part11'] = isset($data['enable_id_fx_accountless_sms_auth_for_part11']) ? $data['enable_id_fx_accountless_sms_auth_for_part11'] : null;
        $this->container['enable_id_fx_accountless_sms_auth_for_part11_metadata'] = isset($data['enable_id_fx_accountless_sms_auth_for_part11_metadata']) ? $data['enable_id_fx_accountless_sms_auth_for_part11_metadata'] : null;
        $this->container['enable_id_fx_intuit_kba'] = isset($data['enable_id_fx_intuit_kba']) ? $data['enable_id_fx_intuit_kba'] : null;
        $this->container['enable_id_fx_intuit_kba_metadata'] = isset($data['enable_id_fx_intuit_kba_metadata']) ? $data['enable_id_fx_intuit_kba_metadata'] : null;
        $this->container['enable_id_fx_phone_authentication'] = isset($data['enable_id_fx_phone_authentication']) ? $data['enable_id_fx_phone_authentication'] : null;
        $this->container['enable_id_fx_phone_authentication_metadata'] = isset($data['enable_id_fx_phone_authentication_metadata']) ? $data['enable_id_fx_phone_authentication_metadata'] : null;
        $this->container['enable_idfx_phone_auth_signature_auth_status'] = isset($data['enable_idfx_phone_auth_signature_auth_status']) ? $data['enable_idfx_phone_auth_signature_auth_status'] : null;
        $this->container['enable_idfx_phone_auth_signature_auth_status_metadata'] = isset($data['enable_idfx_phone_auth_signature_auth_status_metadata']) ? $data['enable_idfx_phone_auth_signature_auth_status_metadata'] : null;
        $this->container['enable_inbox_browse_views_powered_by_elastic_search'] = isset($data['enable_inbox_browse_views_powered_by_elastic_search']) ? $data['enable_inbox_browse_views_powered_by_elastic_search'] : null;
        $this->container['enable_inbox_browse_views_powered_by_elastic_search_metadata'] = isset($data['enable_inbox_browse_views_powered_by_elastic_search_metadata']) ? $data['enable_inbox_browse_views_powered_by_elastic_search_metadata'] : null;
        $this->container['enable_inbox_relevance_sort'] = isset($data['enable_inbox_relevance_sort']) ? $data['enable_inbox_relevance_sort'] : null;
        $this->container['enable_inbox_relevance_sort_for_recent_accounts'] = isset($data['enable_inbox_relevance_sort_for_recent_accounts']) ? $data['enable_inbox_relevance_sort_for_recent_accounts'] : null;
        $this->container['enable_inbox_relevance_sort_for_recent_accounts_metadata'] = isset($data['enable_inbox_relevance_sort_for_recent_accounts_metadata']) ? $data['enable_inbox_relevance_sort_for_recent_accounts_metadata'] : null;
        $this->container['enable_inbox_relevance_sort_metadata'] = isset($data['enable_inbox_relevance_sort_metadata']) ? $data['enable_inbox_relevance_sort_metadata'] : null;
        $this->container['enable_in_browser_editor'] = isset($data['enable_in_browser_editor']) ? $data['enable_in_browser_editor'] : null;
        $this->container['enable_in_browser_editor_metadata'] = isset($data['enable_in_browser_editor_metadata']) ? $data['enable_in_browser_editor_metadata'] : null;
        $this->container['enable_key_terms_suggestions_by_document_type'] = isset($data['enable_key_terms_suggestions_by_document_type']) ? $data['enable_key_terms_suggestions_by_document_type'] : null;
        $this->container['enable_key_terms_suggestions_by_document_type_metadata'] = isset($data['enable_key_terms_suggestions_by_document_type_metadata']) ? $data['enable_key_terms_suggestions_by_document_type_metadata'] : null;
        $this->container['enable_participant_recipient_setting_metadata'] = isset($data['enable_participant_recipient_setting_metadata']) ? $data['enable_participant_recipient_setting_metadata'] : null;
        $this->container['enable_payment_processing'] = isset($data['enable_payment_processing']) ? $data['enable_payment_processing'] : null;
        $this->container['enable_payment_processing_metadata'] = isset($data['enable_payment_processing_metadata']) ? $data['enable_payment_processing_metadata'] : null;
        $this->container['enable_pdfa_conversion'] = isset($data['enable_pdfa_conversion']) ? $data['enable_pdfa_conversion'] : null;
        $this->container['enable_pdfa_conversion_metadata'] = isset($data['enable_pdfa_conversion_metadata']) ? $data['enable_pdfa_conversion_metadata'] : null;
        $this->container['enable_power_form'] = isset($data['enable_power_form']) ? $data['enable_power_form'] : null;
        $this->container['enable_power_form_direct'] = isset($data['enable_power_form_direct']) ? $data['enable_power_form_direct'] : null;
        $this->container['enable_power_form_direct_metadata'] = isset($data['enable_power_form_direct_metadata']) ? $data['enable_power_form_direct_metadata'] : null;
        $this->container['enable_power_form_metadata'] = isset($data['enable_power_form_metadata']) ? $data['enable_power_form_metadata'] : null;
        $this->container['enable_recipient_domain_validation'] = isset($data['enable_recipient_domain_validation']) ? $data['enable_recipient_domain_validation'] : null;
        $this->container['enable_recipient_domain_validation_metadata'] = isset($data['enable_recipient_domain_validation_metadata']) ? $data['enable_recipient_domain_validation_metadata'] : null;
        $this->container['enable_recipient_may_provide_phone_number'] = isset($data['enable_recipient_may_provide_phone_number']) ? $data['enable_recipient_may_provide_phone_number'] : null;
        $this->container['enable_recipient_may_provide_phone_number_metadata'] = isset($data['enable_recipient_may_provide_phone_number_metadata']) ? $data['enable_recipient_may_provide_phone_number_metadata'] : null;
        $this->container['enable_report_links'] = isset($data['enable_report_links']) ? $data['enable_report_links'] : null;
        $this->container['enable_report_links_metadata'] = isset($data['enable_report_links_metadata']) ? $data['enable_report_links_metadata'] : null;
        $this->container['enable_require_sign_on_paper'] = isset($data['enable_require_sign_on_paper']) ? $data['enable_require_sign_on_paper'] : null;
        $this->container['enable_require_sign_on_paper_metadata'] = isset($data['enable_require_sign_on_paper_metadata']) ? $data['enable_require_sign_on_paper_metadata'] : null;
        $this->container['enable_reserved_domain'] = isset($data['enable_reserved_domain']) ? $data['enable_reserved_domain'] : null;
        $this->container['enable_reserved_domain_metadata'] = isset($data['enable_reserved_domain_metadata']) ? $data['enable_reserved_domain_metadata'] : null;
        $this->container['enable_responsive_signing'] = isset($data['enable_responsive_signing']) ? $data['enable_responsive_signing'] : null;
        $this->container['enable_responsive_signing_metadata'] = isset($data['enable_responsive_signing_metadata']) ? $data['enable_responsive_signing_metadata'] : null;
        $this->container['enable_scheduled_release'] = isset($data['enable_scheduled_release']) ? $data['enable_scheduled_release'] : null;
        $this->container['enable_scheduled_release_metadata'] = isset($data['enable_scheduled_release_metadata']) ? $data['enable_scheduled_release_metadata'] : null;
        $this->container['enable_search'] = isset($data['enable_search']) ? $data['enable_search'] : null;
        $this->container['enable_search_metadata'] = isset($data['enable_search_metadata']) ? $data['enable_search_metadata'] : null;
        $this->container['enable_search_service_azure_uri'] = isset($data['enable_search_service_azure_uri']) ? $data['enable_search_service_azure_uri'] : null;
        $this->container['enable_search_service_azure_uri_metadata'] = isset($data['enable_search_service_azure_uri_metadata']) ? $data['enable_search_service_azure_uri_metadata'] : null;
        $this->container['enable_search_site_specific_api'] = isset($data['enable_search_site_specific_api']) ? $data['enable_search_site_specific_api'] : null;
        $this->container['enable_search_site_specific_api_metadata'] = isset($data['enable_search_site_specific_api_metadata']) ? $data['enable_search_site_specific_api_metadata'] : null;
        $this->container['enable_search_ui'] = isset($data['enable_search_ui']) ? $data['enable_search_ui'] : null;
        $this->container['enable_search_ui_metadata'] = isset($data['enable_search_ui_metadata']) ? $data['enable_search_ui_metadata'] : null;
        $this->container['enable_sending_tags_font_settings'] = isset($data['enable_sending_tags_font_settings']) ? $data['enable_sending_tags_font_settings'] : null;
        $this->container['enable_sending_tags_font_settings_metadata'] = isset($data['enable_sending_tags_font_settings_metadata']) ? $data['enable_sending_tags_font_settings_metadata'] : null;
        $this->container['enable_send_to_agent'] = isset($data['enable_send_to_agent']) ? $data['enable_send_to_agent'] : null;
        $this->container['enable_send_to_agent_metadata'] = isset($data['enable_send_to_agent_metadata']) ? $data['enable_send_to_agent_metadata'] : null;
        $this->container['enable_send_to_intermediary'] = isset($data['enable_send_to_intermediary']) ? $data['enable_send_to_intermediary'] : null;
        $this->container['enable_send_to_intermediary_metadata'] = isset($data['enable_send_to_intermediary_metadata']) ? $data['enable_send_to_intermediary_metadata'] : null;
        $this->container['enable_send_to_manage'] = isset($data['enable_send_to_manage']) ? $data['enable_send_to_manage'] : null;
        $this->container['enable_send_to_manage_metadata'] = isset($data['enable_send_to_manage_metadata']) ? $data['enable_send_to_manage_metadata'] : null;
        $this->container['enable_sequential_signing_api'] = isset($data['enable_sequential_signing_api']) ? $data['enable_sequential_signing_api'] : null;
        $this->container['enable_sequential_signing_api_metadata'] = isset($data['enable_sequential_signing_api_metadata']) ? $data['enable_sequential_signing_api_metadata'] : null;
        $this->container['enable_sequential_signing_ui'] = isset($data['enable_sequential_signing_ui']) ? $data['enable_sequential_signing_ui'] : null;
        $this->container['enable_sequential_signing_ui_metadata'] = isset($data['enable_sequential_signing_ui_metadata']) ? $data['enable_sequential_signing_ui_metadata'] : null;
        $this->container['enable_signer_attachments'] = isset($data['enable_signer_attachments']) ? $data['enable_signer_attachments'] : null;
        $this->container['enable_signer_attachments_metadata'] = isset($data['enable_signer_attachments_metadata']) ? $data['enable_signer_attachments_metadata'] : null;
        $this->container['enable_signing_extension_comments'] = isset($data['enable_signing_extension_comments']) ? $data['enable_signing_extension_comments'] : null;
        $this->container['enable_signing_extension_comments_metadata'] = isset($data['enable_signing_extension_comments_metadata']) ? $data['enable_signing_extension_comments_metadata'] : null;
        $this->container['enable_signing_extension_conversations'] = isset($data['enable_signing_extension_conversations']) ? $data['enable_signing_extension_conversations'] : null;
        $this->container['enable_signing_extension_conversations_metadata'] = isset($data['enable_signing_extension_conversations_metadata']) ? $data['enable_signing_extension_conversations_metadata'] : null;
        $this->container['enable_signing_order_settings_for_account'] = isset($data['enable_signing_order_settings_for_account']) ? $data['enable_signing_order_settings_for_account'] : null;
        $this->container['enable_signing_order_settings_for_account_metadata'] = isset($data['enable_signing_order_settings_for_account_metadata']) ? $data['enable_signing_order_settings_for_account_metadata'] : null;
        $this->container['enable_sign_on_paper'] = isset($data['enable_sign_on_paper']) ? $data['enable_sign_on_paper'] : null;
        $this->container['enable_sign_on_paper_metadata'] = isset($data['enable_sign_on_paper_metadata']) ? $data['enable_sign_on_paper_metadata'] : null;
        $this->container['enable_sign_on_paper_override'] = isset($data['enable_sign_on_paper_override']) ? $data['enable_sign_on_paper_override'] : null;
        $this->container['enable_sign_on_paper_override_metadata'] = isset($data['enable_sign_on_paper_override_metadata']) ? $data['enable_sign_on_paper_override_metadata'] : null;
        $this->container['enable_sign_with_notary'] = isset($data['enable_sign_with_notary']) ? $data['enable_sign_with_notary'] : null;
        $this->container['enable_sign_with_notary_metadata'] = isset($data['enable_sign_with_notary_metadata']) ? $data['enable_sign_with_notary_metadata'] : null;
        $this->container['enable_smart_contracts'] = isset($data['enable_smart_contracts']) ? $data['enable_smart_contracts'] : null;
        $this->container['enable_smart_contracts_metadata'] = isset($data['enable_smart_contracts_metadata']) ? $data['enable_smart_contracts_metadata'] : null;
        $this->container['enable_sms_authentication'] = isset($data['enable_sms_authentication']) ? $data['enable_sms_authentication'] : null;
        $this->container['enable_sms_authentication_metadata'] = isset($data['enable_sms_authentication_metadata']) ? $data['enable_sms_authentication_metadata'] : null;
        $this->container['enable_sms_delivery_additional_notification'] = isset($data['enable_sms_delivery_additional_notification']) ? $data['enable_sms_delivery_additional_notification'] : null;
        $this->container['enable_sms_delivery_additional_notification_metadata'] = isset($data['enable_sms_delivery_additional_notification_metadata']) ? $data['enable_sms_delivery_additional_notification_metadata'] : null;
        $this->container['enable_sms_delivery_primary'] = isset($data['enable_sms_delivery_primary']) ? $data['enable_sms_delivery_primary'] : null;
        $this->container['enable_social_id_login'] = isset($data['enable_social_id_login']) ? $data['enable_social_id_login'] : null;
        $this->container['enable_social_id_login_metadata'] = isset($data['enable_social_id_login_metadata']) ? $data['enable_social_id_login_metadata'] : null;
        $this->container['enable_strike_through'] = isset($data['enable_strike_through']) ? $data['enable_strike_through'] : null;
        $this->container['enable_strike_through_metadata'] = isset($data['enable_strike_through_metadata']) ? $data['enable_strike_through_metadata'] : null;
        $this->container['enable_transaction_point'] = isset($data['enable_transaction_point']) ? $data['enable_transaction_point'] : null;
        $this->container['enable_transaction_point_metadata'] = isset($data['enable_transaction_point_metadata']) ? $data['enable_transaction_point_metadata'] : null;
        $this->container['enable_vaulting'] = isset($data['enable_vaulting']) ? $data['enable_vaulting'] : null;
        $this->container['enable_vaulting_metadata'] = isset($data['enable_vaulting_metadata']) ? $data['enable_vaulting_metadata'] : null;
        $this->container['enable_web_forms_separate_user_permissions'] = isset($data['enable_web_forms_separate_user_permissions']) ? $data['enable_web_forms_separate_user_permissions'] : null;
        $this->container['enable_web_forms_separate_user_permissions_metadata'] = isset($data['enable_web_forms_separate_user_permissions_metadata']) ? $data['enable_web_forms_separate_user_permissions_metadata'] : null;
        $this->container['enable_witnessing'] = isset($data['enable_witnessing']) ? $data['enable_witnessing'] : null;
        $this->container['enable_witnessing_metadata'] = isset($data['enable_witnessing_metadata']) ? $data['enable_witnessing_metadata'] : null;
        $this->container['enforce_template_name_uniqueness'] = isset($data['enforce_template_name_uniqueness']) ? $data['enforce_template_name_uniqueness'] : null;
        $this->container['enforce_template_name_uniqueness_metadata'] = isset($data['enforce_template_name_uniqueness_metadata']) ? $data['enforce_template_name_uniqueness_metadata'] : null;
        $this->container['enforce_tls_emails'] = isset($data['enforce_tls_emails']) ? $data['enforce_tls_emails'] : null;
        $this->container['enforce_tls_emails_metadata'] = isset($data['enforce_tls_emails_metadata']) ? $data['enforce_tls_emails_metadata'] : null;
        $this->container['envelope_integration_allowed'] = isset($data['envelope_integration_allowed']) ? $data['envelope_integration_allowed'] : null;
        $this->container['envelope_integration_allowed_metadata'] = isset($data['envelope_integration_allowed_metadata']) ? $data['envelope_integration_allowed_metadata'] : null;
        $this->container['envelope_integration_enabled'] = isset($data['envelope_integration_enabled']) ? $data['envelope_integration_enabled'] : null;
        $this->container['envelope_integration_enabled_metadata'] = isset($data['envelope_integration_enabled_metadata']) ? $data['envelope_integration_enabled_metadata'] : null;
        $this->container['envelope_limits_total_document_size_allowed_in_mb'] = isset($data['envelope_limits_total_document_size_allowed_in_mb']) ? $data['envelope_limits_total_document_size_allowed_in_mb'] : null;
        $this->container['envelope_limits_total_document_size_allowed_in_mb_enabled'] = isset($data['envelope_limits_total_document_size_allowed_in_mb_enabled']) ? $data['envelope_limits_total_document_size_allowed_in_mb_enabled'] : null;
        $this->container['envelope_limits_total_document_size_allowed_in_mb_enabled_metadata'] = isset($data['envelope_limits_total_document_size_allowed_in_mb_enabled_metadata']) ? $data['envelope_limits_total_document_size_allowed_in_mb_enabled_metadata'] : null;
        $this->container['envelope_limits_total_document_size_allowed_in_mb_metadata'] = isset($data['envelope_limits_total_document_size_allowed_in_mb_metadata']) ? $data['envelope_limits_total_document_size_allowed_in_mb_metadata'] : null;
        $this->container['envelope_search_mode'] = isset($data['envelope_search_mode']) ? $data['envelope_search_mode'] : null;
        $this->container['envelope_search_mode_metadata'] = isset($data['envelope_search_mode_metadata']) ? $data['envelope_search_mode_metadata'] : null;
        $this->container['envelope_stamping_default_value'] = isset($data['envelope_stamping_default_value']) ? $data['envelope_stamping_default_value'] : null;
        $this->container['envelope_stamping_default_value_metadata'] = isset($data['envelope_stamping_default_value_metadata']) ? $data['envelope_stamping_default_value_metadata'] : null;
        $this->container['exit_prompt'] = isset($data['exit_prompt']) ? $data['exit_prompt'] : null;
        $this->container['exit_prompt_metadata'] = isset($data['exit_prompt_metadata']) ? $data['exit_prompt_metadata'] : null;
        $this->container['express_send'] = isset($data['express_send']) ? $data['express_send'] : null;
        $this->container['express_send_allow_tabs'] = isset($data['express_send_allow_tabs']) ? $data['express_send_allow_tabs'] : null;
        $this->container['express_send_allow_tabs_metadata'] = isset($data['express_send_allow_tabs_metadata']) ? $data['express_send_allow_tabs_metadata'] : null;
        $this->container['express_send_metadata'] = isset($data['express_send_metadata']) ? $data['express_send_metadata'] : null;
        $this->container['external_document_sources'] = isset($data['external_document_sources']) ? $data['external_document_sources'] : null;
        $this->container['external_signature_pad_type'] = isset($data['external_signature_pad_type']) ? $data['external_signature_pad_type'] : null;
        $this->container['external_signature_pad_type_metadata'] = isset($data['external_signature_pad_type_metadata']) ? $data['external_signature_pad_type_metadata'] : null;
        $this->container['fax_out_enabled'] = isset($data['fax_out_enabled']) ? $data['fax_out_enabled'] : null;
        $this->container['fax_out_enabled_metadata'] = isset($data['fax_out_enabled_metadata']) ? $data['fax_out_enabled_metadata'] : null;
        $this->container['finish_reminder'] = isset($data['finish_reminder']) ? $data['finish_reminder'] : null;
        $this->container['finish_reminder_metadata'] = isset($data['finish_reminder_metadata']) ? $data['finish_reminder_metadata'] : null;
        $this->container['guided_forms_html_allowed'] = isset($data['guided_forms_html_allowed']) ? $data['guided_forms_html_allowed'] : null;
        $this->container['guided_forms_html_allowed_metadata'] = isset($data['guided_forms_html_allowed_metadata']) ? $data['guided_forms_html_allowed_metadata'] : null;
        $this->container['guided_forms_html_conversion_policy'] = isset($data['guided_forms_html_conversion_policy']) ? $data['guided_forms_html_conversion_policy'] : null;
        $this->container['guided_forms_html_conversion_policy_metadata'] = isset($data['guided_forms_html_conversion_policy_metadata']) ? $data['guided_forms_html_conversion_policy_metadata'] : null;
        $this->container['has_recipient_connect_claimed_domain'] = isset($data['has_recipient_connect_claimed_domain']) ? $data['has_recipient_connect_claimed_domain'] : null;
        $this->container['hide_account_address_in_co_c'] = isset($data['hide_account_address_in_co_c']) ? $data['hide_account_address_in_co_c'] : null;
        $this->container['hide_account_address_in_co_c_metadata'] = isset($data['hide_account_address_in_co_c_metadata']) ? $data['hide_account_address_in_co_c_metadata'] : null;
        $this->container['hide_pricing'] = isset($data['hide_pricing']) ? $data['hide_pricing'] : null;
        $this->container['hide_pricing_metadata'] = isset($data['hide_pricing_metadata']) ? $data['hide_pricing_metadata'] : null;
        $this->container['id_check_configurations'] = isset($data['id_check_configurations']) ? $data['id_check_configurations'] : null;
        $this->container['id_check_expire'] = isset($data['id_check_expire']) ? $data['id_check_expire'] : null;
        $this->container['id_check_expire_days'] = isset($data['id_check_expire_days']) ? $data['id_check_expire_days'] : null;
        $this->container['id_check_expire_days_metadata'] = isset($data['id_check_expire_days_metadata']) ? $data['id_check_expire_days_metadata'] : null;
        $this->container['id_check_expire_metadata'] = isset($data['id_check_expire_metadata']) ? $data['id_check_expire_metadata'] : null;
        $this->container['id_check_expire_minutes'] = isset($data['id_check_expire_minutes']) ? $data['id_check_expire_minutes'] : null;
        $this->container['id_check_expire_minutes_metadata'] = isset($data['id_check_expire_minutes_metadata']) ? $data['id_check_expire_minutes_metadata'] : null;
        $this->container['id_check_required'] = isset($data['id_check_required']) ? $data['id_check_required'] : null;
        $this->container['id_check_required_metadata'] = isset($data['id_check_required_metadata']) ? $data['id_check_required_metadata'] : null;
        $this->container['identity_verification'] = isset($data['identity_verification']) ? $data['identity_verification'] : null;
        $this->container['identity_verification_metadata'] = isset($data['identity_verification_metadata']) ? $data['identity_verification_metadata'] : null;
        $this->container['idfx_kba_authentication_override'] = isset($data['idfx_kba_authentication_override']) ? $data['idfx_kba_authentication_override'] : null;
        $this->container['idfx_kba_authentication_override_metadata'] = isset($data['idfx_kba_authentication_override_metadata']) ? $data['idfx_kba_authentication_override_metadata'] : null;
        $this->container['idfx_phone_authentication_override'] = isset($data['idfx_phone_authentication_override']) ? $data['idfx_phone_authentication_override'] : null;
        $this->container['idfx_phone_authentication_override_metadata'] = isset($data['idfx_phone_authentication_override_metadata']) ? $data['idfx_phone_authentication_override_metadata'] : null;
        $this->container['ignore_error_if_anchor_tab_not_found'] = isset($data['ignore_error_if_anchor_tab_not_found']) ? $data['ignore_error_if_anchor_tab_not_found'] : null;
        $this->container['ignore_error_if_anchor_tab_not_found_metadata_enabled'] = isset($data['ignore_error_if_anchor_tab_not_found_metadata_enabled']) ? $data['ignore_error_if_anchor_tab_not_found_metadata_enabled'] : null;
        $this->container['in_person_id_check_question'] = isset($data['in_person_id_check_question']) ? $data['in_person_id_check_question'] : null;
        $this->container['in_person_id_check_question_metadata'] = isset($data['in_person_id_check_question_metadata']) ? $data['in_person_id_check_question_metadata'] : null;
        $this->container['in_person_signing_enabled'] = isset($data['in_person_signing_enabled']) ? $data['in_person_signing_enabled'] : null;
        $this->container['in_person_signing_enabled_metadata'] = isset($data['in_person_signing_enabled_metadata']) ? $data['in_person_signing_enabled_metadata'] : null;
        $this->container['in_session_enabled'] = isset($data['in_session_enabled']) ? $data['in_session_enabled'] : null;
        $this->container['in_session_enabled_metadata'] = isset($data['in_session_enabled_metadata']) ? $data['in_session_enabled_metadata'] : null;
        $this->container['in_session_suppress_emails'] = isset($data['in_session_suppress_emails']) ? $data['in_session_suppress_emails'] : null;
        $this->container['in_session_suppress_emails_metadata'] = isset($data['in_session_suppress_emails_metadata']) ? $data['in_session_suppress_emails_metadata'] : null;
        $this->container['is_connect_document_fields_enabled'] = isset($data['is_connect_document_fields_enabled']) ? $data['is_connect_document_fields_enabled'] : null;
        $this->container['linked_external_primary_accounts'] = isset($data['linked_external_primary_accounts']) ? $data['linked_external_primary_accounts'] : null;
        $this->container['maximum_signing_groups'] = isset($data['maximum_signing_groups']) ? $data['maximum_signing_groups'] : null;
        $this->container['maximum_signing_groups_metadata'] = isset($data['maximum_signing_groups_metadata']) ? $data['maximum_signing_groups_metadata'] : null;
        $this->container['maximum_users_per_signing_group'] = isset($data['maximum_users_per_signing_group']) ? $data['maximum_users_per_signing_group'] : null;
        $this->container['maximum_users_per_signing_group_metadata'] = isset($data['maximum_users_per_signing_group_metadata']) ? $data['maximum_users_per_signing_group_metadata'] : null;
        $this->container['max_number_of_custom_stamps'] = isset($data['max_number_of_custom_stamps']) ? $data['max_number_of_custom_stamps'] : null;
        $this->container['merge_mixed_mode_results'] = isset($data['merge_mixed_mode_results']) ? $data['merge_mixed_mode_results'] : null;
        $this->container['merge_mixed_mode_results_metadata'] = isset($data['merge_mixed_mode_results_metadata']) ? $data['merge_mixed_mode_results_metadata'] : null;
        $this->container['mobile_session_timeout'] = isset($data['mobile_session_timeout']) ? $data['mobile_session_timeout'] : null;
        $this->container['mobile_session_timeout_metadata'] = isset($data['mobile_session_timeout_metadata']) ? $data['mobile_session_timeout_metadata'] : null;
        $this->container['number_of_active_custom_stamps'] = isset($data['number_of_active_custom_stamps']) ? $data['number_of_active_custom_stamps'] : null;
        $this->container['opt_in_mobile_signing_v02'] = isset($data['opt_in_mobile_signing_v02']) ? $data['opt_in_mobile_signing_v02'] : null;
        $this->container['opt_in_mobile_signing_v02_metadata'] = isset($data['opt_in_mobile_signing_v02_metadata']) ? $data['opt_in_mobile_signing_v02_metadata'] : null;
        $this->container['opt_in_universal_signatures'] = isset($data['opt_in_universal_signatures']) ? $data['opt_in_universal_signatures'] : null;
        $this->container['opt_out_auto_nav_text_and_tab_color_updates'] = isset($data['opt_out_auto_nav_text_and_tab_color_updates']) ? $data['opt_out_auto_nav_text_and_tab_color_updates'] : null;
        $this->container['opt_out_auto_nav_text_and_tab_color_updates_metadata'] = isset($data['opt_out_auto_nav_text_and_tab_color_updates_metadata']) ? $data['opt_out_auto_nav_text_and_tab_color_updates_metadata'] : null;
        $this->container['opt_out_new_platform_seal'] = isset($data['opt_out_new_platform_seal']) ? $data['opt_out_new_platform_seal'] : null;
        $this->container['opt_out_new_platform_seal_platform_metadata'] = isset($data['opt_out_new_platform_seal_platform_metadata']) ? $data['opt_out_new_platform_seal_platform_metadata'] : null;
        $this->container['pdf_max_chunked_upload_part_size'] = isset($data['pdf_max_chunked_upload_part_size']) ? $data['pdf_max_chunked_upload_part_size'] : null;
        $this->container['pdf_max_chunked_upload_part_size_metadata'] = isset($data['pdf_max_chunked_upload_part_size_metadata']) ? $data['pdf_max_chunked_upload_part_size_metadata'] : null;
        $this->container['pdf_max_chunked_upload_total_size'] = isset($data['pdf_max_chunked_upload_total_size']) ? $data['pdf_max_chunked_upload_total_size'] : null;
        $this->container['pdf_max_chunked_upload_total_size_metadata'] = isset($data['pdf_max_chunked_upload_total_size_metadata']) ? $data['pdf_max_chunked_upload_total_size_metadata'] : null;
        $this->container['pdf_max_individual_upload_size'] = isset($data['pdf_max_individual_upload_size']) ? $data['pdf_max_individual_upload_size'] : null;
        $this->container['pdf_max_individual_upload_size_metadata'] = isset($data['pdf_max_individual_upload_size_metadata']) ? $data['pdf_max_individual_upload_size_metadata'] : null;
        $this->container['phone_auth_recipient_may_provide_phone_number'] = isset($data['phone_auth_recipient_may_provide_phone_number']) ? $data['phone_auth_recipient_may_provide_phone_number'] : null;
        $this->container['phone_auth_recipient_may_provide_phone_number_metadata'] = isset($data['phone_auth_recipient_may_provide_phone_number_metadata']) ? $data['phone_auth_recipient_may_provide_phone_number_metadata'] : null;
        $this->container['pki_sign_downloaded_pdf_docs'] = isset($data['pki_sign_downloaded_pdf_docs']) ? $data['pki_sign_downloaded_pdf_docs'] : null;
        $this->container['pki_sign_downloaded_pdf_docs_metadata'] = isset($data['pki_sign_downloaded_pdf_docs_metadata']) ? $data['pki_sign_downloaded_pdf_docs_metadata'] : null;
        $this->container['read_only_mode'] = isset($data['read_only_mode']) ? $data['read_only_mode'] : null;
        $this->container['read_only_mode_metadata'] = isset($data['read_only_mode_metadata']) ? $data['read_only_mode_metadata'] : null;
        $this->container['recipients_can_sign_offline'] = isset($data['recipients_can_sign_offline']) ? $data['recipients_can_sign_offline'] : null;
        $this->container['recipients_can_sign_offline_metadata'] = isset($data['recipients_can_sign_offline_metadata']) ? $data['recipients_can_sign_offline_metadata'] : null;
        $this->container['recipient_signing_auto_navigation_control'] = isset($data['recipient_signing_auto_navigation_control']) ? $data['recipient_signing_auto_navigation_control'] : null;
        $this->container['recipient_signing_auto_navigation_control_metadata'] = isset($data['recipient_signing_auto_navigation_control_metadata']) ? $data['recipient_signing_auto_navigation_control_metadata'] : null;
        $this->container['require21_cf_rpt11_compliance'] = isset($data['require21_cf_rpt11_compliance']) ? $data['require21_cf_rpt11_compliance'] : null;
        $this->container['require21_cf_rpt11_compliance_metadata'] = isset($data['require21_cf_rpt11_compliance_metadata']) ? $data['require21_cf_rpt11_compliance_metadata'] : null;
        $this->container['require_decline_reason'] = isset($data['require_decline_reason']) ? $data['require_decline_reason'] : null;
        $this->container['require_decline_reason_metadata'] = isset($data['require_decline_reason_metadata']) ? $data['require_decline_reason_metadata'] : null;
        $this->container['require_external_user_management'] = isset($data['require_external_user_management']) ? $data['require_external_user_management'] : null;
        $this->container['require_external_user_management_metadata'] = isset($data['require_external_user_management_metadata']) ? $data['require_external_user_management_metadata'] : null;
        $this->container['require_signer_certificate_type'] = isset($data['require_signer_certificate_type']) ? $data['require_signer_certificate_type'] : null;
        $this->container['require_signer_certificate_type_metadata'] = isset($data['require_signer_certificate_type_metadata']) ? $data['require_signer_certificate_type_metadata'] : null;
        $this->container['rsa_verid_account_name'] = isset($data['rsa_verid_account_name']) ? $data['rsa_verid_account_name'] : null;
        $this->container['rsa_verid_password'] = isset($data['rsa_verid_password']) ? $data['rsa_verid_password'] : null;
        $this->container['rsa_verid_ruleset'] = isset($data['rsa_verid_ruleset']) ? $data['rsa_verid_ruleset'] : null;
        $this->container['rsa_verid_user_id'] = isset($data['rsa_verid_user_id']) ? $data['rsa_verid_user_id'] : null;
        $this->container['sbs_transaction_level'] = isset($data['sbs_transaction_level']) ? $data['sbs_transaction_level'] : null;
        $this->container['self_signed_recipient_email_document'] = isset($data['self_signed_recipient_email_document']) ? $data['self_signed_recipient_email_document'] : null;
        $this->container['self_signed_recipient_email_document_metadata'] = isset($data['self_signed_recipient_email_document_metadata']) ? $data['self_signed_recipient_email_document_metadata'] : null;
        $this->container['self_signed_recipient_email_document_user_override'] = isset($data['self_signed_recipient_email_document_user_override']) ? $data['self_signed_recipient_email_document_user_override'] : null;
        $this->container['self_signed_recipient_email_document_user_override_metadata'] = isset($data['self_signed_recipient_email_document_user_override_metadata']) ? $data['self_signed_recipient_email_document_user_override_metadata'] : null;
        $this->container['sender_can_sign_in_each_location'] = isset($data['sender_can_sign_in_each_location']) ? $data['sender_can_sign_in_each_location'] : null;
        $this->container['sender_can_sign_in_each_location_metadata'] = isset($data['sender_can_sign_in_each_location_metadata']) ? $data['sender_can_sign_in_each_location_metadata'] : null;
        $this->container['sender_must_authenticate_signing'] = isset($data['sender_must_authenticate_signing']) ? $data['sender_must_authenticate_signing'] : null;
        $this->container['sender_must_authenticate_signing_metadata'] = isset($data['sender_must_authenticate_signing_metadata']) ? $data['sender_must_authenticate_signing_metadata'] : null;
        $this->container['sending_tags_font_color'] = isset($data['sending_tags_font_color']) ? $data['sending_tags_font_color'] : null;
        $this->container['sending_tags_font_color_metadata'] = isset($data['sending_tags_font_color_metadata']) ? $data['sending_tags_font_color_metadata'] : null;
        $this->container['sending_tags_font_name'] = isset($data['sending_tags_font_name']) ? $data['sending_tags_font_name'] : null;
        $this->container['sending_tags_font_name_metadata'] = isset($data['sending_tags_font_name_metadata']) ? $data['sending_tags_font_name_metadata'] : null;
        $this->container['sending_tags_font_size'] = isset($data['sending_tags_font_size']) ? $data['sending_tags_font_size'] : null;
        $this->container['sending_tags_font_size_metadata'] = isset($data['sending_tags_font_size_metadata']) ? $data['sending_tags_font_size_metadata'] : null;
        $this->container['send_lockout_recipient_notification'] = isset($data['send_lockout_recipient_notification']) ? $data['send_lockout_recipient_notification'] : null;
        $this->container['send_lockout_recipient_notification_metadata'] = isset($data['send_lockout_recipient_notification_metadata']) ? $data['send_lockout_recipient_notification_metadata'] : null;
        $this->container['send_to_certified_delivery_enabled'] = isset($data['send_to_certified_delivery_enabled']) ? $data['send_to_certified_delivery_enabled'] : null;
        $this->container['send_to_certified_delivery_enabled_metadata'] = isset($data['send_to_certified_delivery_enabled_metadata']) ? $data['send_to_certified_delivery_enabled_metadata'] : null;
        $this->container['session_timeout'] = isset($data['session_timeout']) ? $data['session_timeout'] : null;
        $this->container['session_timeout_metadata'] = isset($data['session_timeout_metadata']) ? $data['session_timeout_metadata'] : null;
        $this->container['set_recip_email_lang'] = isset($data['set_recip_email_lang']) ? $data['set_recip_email_lang'] : null;
        $this->container['set_recip_email_lang_metadata'] = isset($data['set_recip_email_lang_metadata']) ? $data['set_recip_email_lang_metadata'] : null;
        $this->container['set_recip_sign_lang'] = isset($data['set_recip_sign_lang']) ? $data['set_recip_sign_lang'] : null;
        $this->container['set_recip_sign_lang_metadata'] = isset($data['set_recip_sign_lang_metadata']) ? $data['set_recip_sign_lang_metadata'] : null;
        $this->container['shared_template_folders'] = isset($data['shared_template_folders']) ? $data['shared_template_folders'] : null;
        $this->container['shared_template_folders_metadata'] = isset($data['shared_template_folders_metadata']) ? $data['shared_template_folders_metadata'] : null;
        $this->container['show_complete_dialog_in_embedded_session'] = isset($data['show_complete_dialog_in_embedded_session']) ? $data['show_complete_dialog_in_embedded_session'] : null;
        $this->container['show_complete_dialog_in_embedded_session_metadata'] = isset($data['show_complete_dialog_in_embedded_session_metadata']) ? $data['show_complete_dialog_in_embedded_session_metadata'] : null;
        $this->container['show_conditional_routing_on_send'] = isset($data['show_conditional_routing_on_send']) ? $data['show_conditional_routing_on_send'] : null;
        $this->container['show_conditional_routing_on_send_metadata'] = isset($data['show_conditional_routing_on_send_metadata']) ? $data['show_conditional_routing_on_send_metadata'] : null;
        $this->container['show_initial_conditional_fields'] = isset($data['show_initial_conditional_fields']) ? $data['show_initial_conditional_fields'] : null;
        $this->container['show_initial_conditional_fields_metadata'] = isset($data['show_initial_conditional_fields_metadata']) ? $data['show_initial_conditional_fields_metadata'] : null;
        $this->container['show_localized_watermarks'] = isset($data['show_localized_watermarks']) ? $data['show_localized_watermarks'] : null;
        $this->container['show_localized_watermarks_metadata'] = isset($data['show_localized_watermarks_metadata']) ? $data['show_localized_watermarks_metadata'] : null;
        $this->container['show_masked_fields_when_downloading_document_as_sender'] = isset($data['show_masked_fields_when_downloading_document_as_sender']) ? $data['show_masked_fields_when_downloading_document_as_sender'] : null;
        $this->container['show_masked_fields_when_downloading_document_as_sender_metadata'] = isset($data['show_masked_fields_when_downloading_document_as_sender_metadata']) ? $data['show_masked_fields_when_downloading_document_as_sender_metadata'] : null;
        $this->container['show_tutorials'] = isset($data['show_tutorials']) ? $data['show_tutorials'] : null;
        $this->container['show_tutorials_metadata'] = isset($data['show_tutorials_metadata']) ? $data['show_tutorials_metadata'] : null;
        $this->container['signature_providers'] = isset($data['signature_providers']) ? $data['signature_providers'] : null;
        $this->container['signature_providers_metadata'] = isset($data['signature_providers_metadata']) ? $data['signature_providers_metadata'] : null;
        $this->container['sign_date_format'] = isset($data['sign_date_format']) ? $data['sign_date_format'] : null;
        $this->container['sign_date_format_metadata'] = isset($data['sign_date_format_metadata']) ? $data['sign_date_format_metadata'] : null;
        $this->container['sign_date_time_account_language_override'] = isset($data['sign_date_time_account_language_override']) ? $data['sign_date_time_account_language_override'] : null;
        $this->container['sign_date_time_account_language_override_metadata'] = isset($data['sign_date_time_account_language_override_metadata']) ? $data['sign_date_time_account_language_override_metadata'] : null;
        $this->container['sign_date_time_account_timezone_override'] = isset($data['sign_date_time_account_timezone_override']) ? $data['sign_date_time_account_timezone_override'] : null;
        $this->container['sign_date_time_account_timezone_override_metadata'] = isset($data['sign_date_time_account_timezone_override_metadata']) ? $data['sign_date_time_account_timezone_override_metadata'] : null;
        $this->container['signer_attach_certificate_to_envelope_pdf'] = isset($data['signer_attach_certificate_to_envelope_pdf']) ? $data['signer_attach_certificate_to_envelope_pdf'] : null;
        $this->container['signer_attach_certificate_to_envelope_pdf_metadata'] = isset($data['signer_attach_certificate_to_envelope_pdf_metadata']) ? $data['signer_attach_certificate_to_envelope_pdf_metadata'] : null;
        $this->container['signer_attach_concat'] = isset($data['signer_attach_concat']) ? $data['signer_attach_concat'] : null;
        $this->container['signer_attach_concat_metadata'] = isset($data['signer_attach_concat_metadata']) ? $data['signer_attach_concat_metadata'] : null;
        $this->container['signer_can_create_account'] = isset($data['signer_can_create_account']) ? $data['signer_can_create_account'] : null;
        $this->container['signer_can_create_account_metadata'] = isset($data['signer_can_create_account_metadata']) ? $data['signer_can_create_account_metadata'] : null;
        $this->container['signer_can_sign_on_mobile'] = isset($data['signer_can_sign_on_mobile']) ? $data['signer_can_sign_on_mobile'] : null;
        $this->container['signer_can_sign_on_mobile_metadata'] = isset($data['signer_can_sign_on_mobile_metadata']) ? $data['signer_can_sign_on_mobile_metadata'] : null;
        $this->container['signer_in_session_use_envelope_complete_email'] = isset($data['signer_in_session_use_envelope_complete_email']) ? $data['signer_in_session_use_envelope_complete_email'] : null;
        $this->container['signer_in_session_use_envelope_complete_email_metadata'] = isset($data['signer_in_session_use_envelope_complete_email_metadata']) ? $data['signer_in_session_use_envelope_complete_email_metadata'] : null;
        $this->container['signer_login_requirements'] = isset($data['signer_login_requirements']) ? $data['signer_login_requirements'] : null;
        $this->container['signer_login_requirements_metadata'] = isset($data['signer_login_requirements_metadata']) ? $data['signer_login_requirements_metadata'] : null;
        $this->container['signer_must_have_account'] = isset($data['signer_must_have_account']) ? $data['signer_must_have_account'] : null;
        $this->container['signer_must_have_account_metadata'] = isset($data['signer_must_have_account_metadata']) ? $data['signer_must_have_account_metadata'] : null;
        $this->container['signer_must_login_to_sign'] = isset($data['signer_must_login_to_sign']) ? $data['signer_must_login_to_sign'] : null;
        $this->container['signer_must_login_to_sign_metadata'] = isset($data['signer_must_login_to_sign_metadata']) ? $data['signer_must_login_to_sign_metadata'] : null;
        $this->container['signer_show_secure_field_initial_values'] = isset($data['signer_show_secure_field_initial_values']) ? $data['signer_show_secure_field_initial_values'] : null;
        $this->container['signer_show_secure_field_initial_values_metadata'] = isset($data['signer_show_secure_field_initial_values_metadata']) ? $data['signer_show_secure_field_initial_values_metadata'] : null;
        $this->container['signing_session_timeout'] = isset($data['signing_session_timeout']) ? $data['signing_session_timeout'] : null;
        $this->container['signing_session_timeout_metadata'] = isset($data['signing_session_timeout_metadata']) ? $data['signing_session_timeout_metadata'] : null;
        $this->container['signing_ui_version'] = isset($data['signing_ui_version']) ? $data['signing_ui_version'] : null;
        $this->container['signing_ui_version_metadata'] = isset($data['signing_ui_version_metadata']) ? $data['signing_ui_version_metadata'] : null;
        $this->container['sign_time_format'] = isset($data['sign_time_format']) ? $data['sign_time_format'] : null;
        $this->container['sign_time_format_metadata'] = isset($data['sign_time_format_metadata']) ? $data['sign_time_format_metadata'] : null;
        $this->container['sign_time_show_am_pm'] = isset($data['sign_time_show_am_pm']) ? $data['sign_time_show_am_pm'] : null;
        $this->container['sign_time_show_am_pm_metadata'] = isset($data['sign_time_show_am_pm_metadata']) ? $data['sign_time_show_am_pm_metadata'] : null;
        $this->container['simplified_sending_enabled'] = isset($data['simplified_sending_enabled']) ? $data['simplified_sending_enabled'] : null;
        $this->container['simplified_sending_enabled_metadata'] = isset($data['simplified_sending_enabled_metadata']) ? $data['simplified_sending_enabled_metadata'] : null;
        $this->container['single_sign_on_enabled'] = isset($data['single_sign_on_enabled']) ? $data['single_sign_on_enabled'] : null;
        $this->container['single_sign_on_enabled_metadata'] = isset($data['single_sign_on_enabled_metadata']) ? $data['single_sign_on_enabled_metadata'] : null;
        $this->container['skip_auth_completed_envelopes'] = isset($data['skip_auth_completed_envelopes']) ? $data['skip_auth_completed_envelopes'] : null;
        $this->container['skip_auth_completed_envelopes_metadata'] = isset($data['skip_auth_completed_envelopes_metadata']) ? $data['skip_auth_completed_envelopes_metadata'] : null;
        $this->container['social_id_recip_auth'] = isset($data['social_id_recip_auth']) ? $data['social_id_recip_auth'] : null;
        $this->container['social_id_recip_auth_metadata'] = isset($data['social_id_recip_auth_metadata']) ? $data['social_id_recip_auth_metadata'] : null;
        $this->container['specify_document_visibility'] = isset($data['specify_document_visibility']) ? $data['specify_document_visibility'] : null;
        $this->container['specify_document_visibility_metadata'] = isset($data['specify_document_visibility_metadata']) ? $data['specify_document_visibility_metadata'] : null;
        $this->container['start_in_advanced_correct'] = isset($data['start_in_advanced_correct']) ? $data['start_in_advanced_correct'] : null;
        $this->container['start_in_advanced_correct_metadata'] = isset($data['start_in_advanced_correct_metadata']) ? $data['start_in_advanced_correct_metadata'] : null;
        $this->container['supplemental_documents_must_accept'] = isset($data['supplemental_documents_must_accept']) ? $data['supplemental_documents_must_accept'] : null;
        $this->container['supplemental_documents_must_accept_metadata'] = isset($data['supplemental_documents_must_accept_metadata']) ? $data['supplemental_documents_must_accept_metadata'] : null;
        $this->container['supplemental_documents_must_read'] = isset($data['supplemental_documents_must_read']) ? $data['supplemental_documents_must_read'] : null;
        $this->container['supplemental_documents_must_read_metadata'] = isset($data['supplemental_documents_must_read_metadata']) ? $data['supplemental_documents_must_read_metadata'] : null;
        $this->container['supplemental_documents_must_view'] = isset($data['supplemental_documents_must_view']) ? $data['supplemental_documents_must_view'] : null;
        $this->container['supplemental_documents_must_view_metadata'] = isset($data['supplemental_documents_must_view_metadata']) ? $data['supplemental_documents_must_view_metadata'] : null;
        $this->container['suppress_certificate_enforcement'] = isset($data['suppress_certificate_enforcement']) ? $data['suppress_certificate_enforcement'] : null;
        $this->container['suppress_certificate_enforcement_metadata'] = isset($data['suppress_certificate_enforcement_metadata']) ? $data['suppress_certificate_enforcement_metadata'] : null;
        $this->container['tab_account_settings'] = isset($data['tab_account_settings']) ? $data['tab_account_settings'] : null;
        $this->container['timezone_offset_api'] = isset($data['timezone_offset_api']) ? $data['timezone_offset_api'] : null;
        $this->container['timezone_offset_api_metadata'] = isset($data['timezone_offset_api_metadata']) ? $data['timezone_offset_api_metadata'] : null;
        $this->container['timezone_offset_ui'] = isset($data['timezone_offset_ui']) ? $data['timezone_offset_ui'] : null;
        $this->container['timezone_offset_ui_metadata'] = isset($data['timezone_offset_ui_metadata']) ? $data['timezone_offset_ui_metadata'] : null;
        $this->container['universal_signature_opt_in'] = isset($data['universal_signature_opt_in']) ? $data['universal_signature_opt_in'] : null;
        $this->container['use_account_level_email'] = isset($data['use_account_level_email']) ? $data['use_account_level_email'] : null;
        $this->container['use_account_level_email_metadata'] = isset($data['use_account_level_email_metadata']) ? $data['use_account_level_email_metadata'] : null;
        $this->container['use_consumer_disclosure'] = isset($data['use_consumer_disclosure']) ? $data['use_consumer_disclosure'] : null;
        $this->container['use_consumer_disclosure_metadata'] = isset($data['use_consumer_disclosure_metadata']) ? $data['use_consumer_disclosure_metadata'] : null;
        $this->container['use_consumer_disclosure_within_account'] = isset($data['use_consumer_disclosure_within_account']) ? $data['use_consumer_disclosure_within_account'] : null;
        $this->container['use_consumer_disclosure_within_account_metadata'] = isset($data['use_consumer_disclosure_within_account_metadata']) ? $data['use_consumer_disclosure_within_account_metadata'] : null;
        $this->container['use_derived_keys'] = isset($data['use_derived_keys']) ? $data['use_derived_keys'] : null;
        $this->container['use_derived_keys_metadata'] = isset($data['use_derived_keys_metadata']) ? $data['use_derived_keys_metadata'] : null;
        $this->container['use_docu_sign_express_signer_certificate'] = isset($data['use_docu_sign_express_signer_certificate']) ? $data['use_docu_sign_express_signer_certificate'] : null;
        $this->container['use_docu_sign_express_signer_certificate_metadata'] = isset($data['use_docu_sign_express_signer_certificate_metadata']) ? $data['use_docu_sign_express_signer_certificate_metadata'] : null;
        $this->container['use_envelope_search_mixed_mode'] = isset($data['use_envelope_search_mixed_mode']) ? $data['use_envelope_search_mixed_mode'] : null;
        $this->container['use_envelope_search_mixed_mode_metadata'] = isset($data['use_envelope_search_mixed_mode_metadata']) ? $data['use_envelope_search_mixed_mode_metadata'] : null;
        $this->container['use_multi_app_groups_data'] = isset($data['use_multi_app_groups_data']) ? $data['use_multi_app_groups_data'] : null;
        $this->container['use_multi_app_groups_data_metadata'] = isset($data['use_multi_app_groups_data_metadata']) ? $data['use_multi_app_groups_data_metadata'] : null;
        $this->container['use_new_blob_for_pdf'] = isset($data['use_new_blob_for_pdf']) ? $data['use_new_blob_for_pdf'] : null;
        $this->container['use_new_blob_for_pdf_metadata'] = isset($data['use_new_blob_for_pdf_metadata']) ? $data['use_new_blob_for_pdf_metadata'] : null;
        $this->container['use_new_envelope_search'] = isset($data['use_new_envelope_search']) ? $data['use_new_envelope_search'] : null;
        $this->container['use_new_envelope_search_metadata'] = isset($data['use_new_envelope_search_metadata']) ? $data['use_new_envelope_search_metadata'] : null;
        $this->container['use_new_envelope_search_only_when_searching_after_date'] = isset($data['use_new_envelope_search_only_when_searching_after_date']) ? $data['use_new_envelope_search_only_when_searching_after_date'] : null;
        $this->container['use_new_envelope_search_only_when_searching_after_date_metadata'] = isset($data['use_new_envelope_search_only_when_searching_after_date_metadata']) ? $data['use_new_envelope_search_only_when_searching_after_date_metadata'] : null;
        $this->container['use_new_envelope_search_only_with_search_term'] = isset($data['use_new_envelope_search_only_with_search_term']) ? $data['use_new_envelope_search_only_with_search_term'] : null;
        $this->container['use_new_envelope_search_only_with_search_term_metadata'] = isset($data['use_new_envelope_search_only_with_search_term_metadata']) ? $data['use_new_envelope_search_only_with_search_term_metadata'] : null;
        $this->container['use_safe_signer_certificates'] = isset($data['use_safe_signer_certificates']) ? $data['use_safe_signer_certificates'] : null;
        $this->container['use_safe_signer_certificates_metadata'] = isset($data['use_safe_signer_certificates_metadata']) ? $data['use_safe_signer_certificates_metadata'] : null;
        $this->container['uses_api'] = isset($data['uses_api']) ? $data['uses_api'] : null;
        $this->container['uses_api_metadata'] = isset($data['uses_api_metadata']) ? $data['uses_api_metadata'] : null;
        $this->container['use_signature_provider_platform'] = isset($data['use_signature_provider_platform']) ? $data['use_signature_provider_platform'] : null;
        $this->container['use_signature_provider_platform_metadata'] = isset($data['use_signature_provider_platform_metadata']) ? $data['use_signature_provider_platform_metadata'] : null;
        $this->container['use_smart_contracts_v1'] = isset($data['use_smart_contracts_v1']) ? $data['use_smart_contracts_v1'] : null;
        $this->container['validations_allowed'] = isset($data['validations_allowed']) ? $data['validations_allowed'] : null;
        $this->container['validations_allowed_metadata'] = isset($data['validations_allowed_metadata']) ? $data['validations_allowed_metadata'] : null;
        $this->container['validations_brand'] = isset($data['validations_brand']) ? $data['validations_brand'] : null;
        $this->container['validations_brand_metadata'] = isset($data['validations_brand_metadata']) ? $data['validations_brand_metadata'] : null;
        $this->container['validations_cadence'] = isset($data['validations_cadence']) ? $data['validations_cadence'] : null;
        $this->container['validations_cadence_metadata'] = isset($data['validations_cadence_metadata']) ? $data['validations_cadence_metadata'] : null;
        $this->container['validations_enabled'] = isset($data['validations_enabled']) ? $data['validations_enabled'] : null;
        $this->container['validations_enabled_metadata'] = isset($data['validations_enabled_metadata']) ? $data['validations_enabled_metadata'] : null;
        $this->container['validations_report'] = isset($data['validations_report']) ? $data['validations_report'] : null;
        $this->container['validations_report_metadata'] = isset($data['validations_report_metadata']) ? $data['validations_report_metadata'] : null;
        $this->container['water_mark_enabled'] = isset($data['water_mark_enabled']) ? $data['water_mark_enabled'] : null;
        $this->container['water_mark_enabled_metadata'] = isset($data['water_mark_enabled_metadata']) ? $data['water_mark_enabled_metadata'] : null;
        $this->container['write_reminder_to_envelope_history'] = isset($data['write_reminder_to_envelope_history']) ? $data['write_reminder_to_envelope_history'] : null;
        $this->container['write_reminder_to_envelope_history_metadata'] = isset($data['write_reminder_to_envelope_history_metadata']) ? $data['write_reminder_to_envelope_history_metadata'] : null;
        $this->container['wurfl_min_allowable_screen_size'] = isset($data['wurfl_min_allowable_screen_size']) ? $data['wurfl_min_allowable_screen_size'] : null;
        $this->container['wurfl_min_allowable_screen_size_metadata'] = isset($data['wurfl_min_allowable_screen_size_metadata']) ? $data['wurfl_min_allowable_screen_size_metadata'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets access_code_format
     *
     * @return \DocuSign\eSign\Model\AccessCodeFormat
     */
    public function getAccessCodeFormat()
    {
        return $this->container['access_code_format'];
    }

    /**
     * Sets access_code_format
     *
     * @param \DocuSign\eSign\Model\AccessCodeFormat $access_code_format Format of the string provided to a recipient in order to access an envelope.
     *
     * @return $this
     */
    public function setAccessCodeFormat($access_code_format)
    {
        $this->container['access_code_format'] = $access_code_format;

        return $this;
    }

    /**
     * Gets account_date_time_format
     *
     * @return ?string
     */
    public function getAccountDateTimeFormat()
    {
        return $this->container['account_date_time_format'];
    }

    /**
     * Sets account_date_time_format
     *
     * @param ?string $account_date_time_format 
     *
     * @return $this
     */
    public function setAccountDateTimeFormat($account_date_time_format)
    {
        $this->container['account_date_time_format'] = $account_date_time_format;

        return $this;
    }

    /**
     * Gets account_date_time_format_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAccountDateTimeFormatMetadata()
    {
        return $this->container['account_date_time_format_metadata'];
    }

    /**
     * Sets account_date_time_format_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $account_date_time_format_metadata Metadata that indicates whether the `accountDateTimeFormat` property is editable.
     *
     * @return $this
     */
    public function setAccountDateTimeFormatMetadata($account_date_time_format_metadata)
    {
        $this->container['account_date_time_format_metadata'] = $account_date_time_format_metadata;

        return $this;
    }

    /**
     * Gets account_default_language
     *
     * @return ?string
     */
    public function getAccountDefaultLanguage()
    {
        return $this->container['account_default_language'];
    }

    /**
     * Sets account_default_language
     *
     * @param ?string $account_default_language 
     *
     * @return $this
     */
    public function setAccountDefaultLanguage($account_default_language)
    {
        $this->container['account_default_language'] = $account_default_language;

        return $this;
    }

    /**
     * Gets account_default_language_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAccountDefaultLanguageMetadata()
    {
        return $this->container['account_default_language_metadata'];
    }

    /**
     * Sets account_default_language_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $account_default_language_metadata 
     *
     * @return $this
     */
    public function setAccountDefaultLanguageMetadata($account_default_language_metadata)
    {
        $this->container['account_default_language_metadata'] = $account_default_language_metadata;

        return $this;
    }

    /**
     * Gets account_name
     *
     * @return ?string
     */
    public function getAccountName()
    {
        return $this->container['account_name'];
    }

    /**
     * Sets account_name
     *
     * @param ?string $account_name 
     *
     * @return $this
     */
    public function setAccountName($account_name)
    {
        $this->container['account_name'] = $account_name;

        return $this;
    }

    /**
     * Gets account_name_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAccountNameMetadata()
    {
        return $this->container['account_name_metadata'];
    }

    /**
     * Sets account_name_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $account_name_metadata Metadata that indicates whether the `accountName` property is editable.
     *
     * @return $this
     */
    public function setAccountNameMetadata($account_name_metadata)
    {
        $this->container['account_name_metadata'] = $account_name_metadata;

        return $this;
    }

    /**
     * Gets account_notification
     *
     * @return \DocuSign\eSign\Model\AccountNotification
     */
    public function getAccountNotification()
    {
        return $this->container['account_notification'];
    }

    /**
     * Sets account_notification
     *
     * @param \DocuSign\eSign\Model\AccountNotification $account_notification An object that specifies notifications (expirations and reminders) for the envelope.
     *
     * @return $this
     */
    public function setAccountNotification($account_notification)
    {
        $this->container['account_notification'] = $account_notification;

        return $this;
    }

    /**
     * Gets account_ui_settings
     *
     * @return \DocuSign\eSign\Model\AccountUISettings
     */
    public function getAccountUiSettings()
    {
        return $this->container['account_ui_settings'];
    }

    /**
     * Sets account_ui_settings
     *
     * @param \DocuSign\eSign\Model\AccountUISettings $account_ui_settings An object that defines the settings to use in the UI.
     *
     * @return $this
     */
    public function setAccountUiSettings($account_ui_settings)
    {
        $this->container['account_ui_settings'] = $account_ui_settings;

        return $this;
    }

    /**
     * Gets adopt_sig_config
     *
     * @return ?string
     */
    public function getAdoptSigConfig()
    {
        return $this->container['adopt_sig_config'];
    }

    /**
     * Sets adopt_sig_config
     *
     * @param ?string $adopt_sig_config 
     *
     * @return $this
     */
    public function setAdoptSigConfig($adopt_sig_config)
    {
        $this->container['adopt_sig_config'] = $adopt_sig_config;

        return $this;
    }

    /**
     * Gets adopt_sig_config_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAdoptSigConfigMetadata()
    {
        return $this->container['adopt_sig_config_metadata'];
    }

    /**
     * Sets adopt_sig_config_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $adopt_sig_config_metadata Metadata that indicates whether the `adoptSigConfig` property is editable.
     *
     * @return $this
     */
    public function setAdoptSigConfigMetadata($adopt_sig_config_metadata)
    {
        $this->container['adopt_sig_config_metadata'] = $adopt_sig_config_metadata;

        return $this;
    }

    /**
     * Gets advanced_correct
     *
     * @return ?string
     */
    public function getAdvancedCorrect()
    {
        return $this->container['advanced_correct'];
    }

    /**
     * Sets advanced_correct
     *
     * @param ?string $advanced_correct 
     *
     * @return $this
     */
    public function setAdvancedCorrect($advanced_correct)
    {
        $this->container['advanced_correct'] = $advanced_correct;

        return $this;
    }

    /**
     * Gets advanced_correct_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAdvancedCorrectMetadata()
    {
        return $this->container['advanced_correct_metadata'];
    }

    /**
     * Sets advanced_correct_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $advanced_correct_metadata Metadata that indicates whether the `advancedCorrect` property is editable.
     *
     * @return $this
     */
    public function setAdvancedCorrectMetadata($advanced_correct_metadata)
    {
        $this->container['advanced_correct_metadata'] = $advanced_correct_metadata;

        return $this;
    }

    /**
     * Gets advanced_search_enable_tab_field
     *
     * @return ?string
     */
    public function getAdvancedSearchEnableTabField()
    {
        return $this->container['advanced_search_enable_tab_field'];
    }

    /**
     * Sets advanced_search_enable_tab_field
     *
     * @param ?string $advanced_search_enable_tab_field 
     *
     * @return $this
     */
    public function setAdvancedSearchEnableTabField($advanced_search_enable_tab_field)
    {
        $this->container['advanced_search_enable_tab_field'] = $advanced_search_enable_tab_field;

        return $this;
    }

    /**
     * Gets advanced_search_enable_tab_field_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAdvancedSearchEnableTabFieldMetadata()
    {
        return $this->container['advanced_search_enable_tab_field_metadata'];
    }

    /**
     * Sets advanced_search_enable_tab_field_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $advanced_search_enable_tab_field_metadata 
     *
     * @return $this
     */
    public function setAdvancedSearchEnableTabFieldMetadata($advanced_search_enable_tab_field_metadata)
    {
        $this->container['advanced_search_enable_tab_field_metadata'] = $advanced_search_enable_tab_field_metadata;

        return $this;
    }

    /**
     * Gets advanced_search_enable_template_id_field
     *
     * @return ?string
     */
    public function getAdvancedSearchEnableTemplateIdField()
    {
        return $this->container['advanced_search_enable_template_id_field'];
    }

    /**
     * Sets advanced_search_enable_template_id_field
     *
     * @param ?string $advanced_search_enable_template_id_field 
     *
     * @return $this
     */
    public function setAdvancedSearchEnableTemplateIdField($advanced_search_enable_template_id_field)
    {
        $this->container['advanced_search_enable_template_id_field'] = $advanced_search_enable_template_id_field;

        return $this;
    }

    /**
     * Gets advanced_search_enable_template_id_field_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAdvancedSearchEnableTemplateIdFieldMetadata()
    {
        return $this->container['advanced_search_enable_template_id_field_metadata'];
    }

    /**
     * Sets advanced_search_enable_template_id_field_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $advanced_search_enable_template_id_field_metadata 
     *
     * @return $this
     */
    public function setAdvancedSearchEnableTemplateIdFieldMetadata($advanced_search_enable_template_id_field_metadata)
    {
        $this->container['advanced_search_enable_template_id_field_metadata'] = $advanced_search_enable_template_id_field_metadata;

        return $this;
    }

    /**
     * Gets advanced_search_enable_template_name_field
     *
     * @return ?string
     */
    public function getAdvancedSearchEnableTemplateNameField()
    {
        return $this->container['advanced_search_enable_template_name_field'];
    }

    /**
     * Sets advanced_search_enable_template_name_field
     *
     * @param ?string $advanced_search_enable_template_name_field 
     *
     * @return $this
     */
    public function setAdvancedSearchEnableTemplateNameField($advanced_search_enable_template_name_field)
    {
        $this->container['advanced_search_enable_template_name_field'] = $advanced_search_enable_template_name_field;

        return $this;
    }

    /**
     * Gets advanced_search_enable_template_name_field_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAdvancedSearchEnableTemplateNameFieldMetadata()
    {
        return $this->container['advanced_search_enable_template_name_field_metadata'];
    }

    /**
     * Sets advanced_search_enable_template_name_field_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $advanced_search_enable_template_name_field_metadata 
     *
     * @return $this
     */
    public function setAdvancedSearchEnableTemplateNameFieldMetadata($advanced_search_enable_template_name_field_metadata)
    {
        $this->container['advanced_search_enable_template_name_field_metadata'] = $advanced_search_enable_template_name_field_metadata;

        return $this;
    }

    /**
     * Gets allow_access_code_format
     *
     * @return ?string
     */
    public function getAllowAccessCodeFormat()
    {
        return $this->container['allow_access_code_format'];
    }

    /**
     * Sets allow_access_code_format
     *
     * @param ?string $allow_access_code_format 
     *
     * @return $this
     */
    public function setAllowAccessCodeFormat($allow_access_code_format)
    {
        $this->container['allow_access_code_format'] = $allow_access_code_format;

        return $this;
    }

    /**
     * Gets allow_access_code_format_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowAccessCodeFormatMetadata()
    {
        return $this->container['allow_access_code_format_metadata'];
    }

    /**
     * Sets allow_access_code_format_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_access_code_format_metadata Metadata that indicates whether the `allowAccessCodeFormat` property is editable.
     *
     * @return $this
     */
    public function setAllowAccessCodeFormatMetadata($allow_access_code_format_metadata)
    {
        $this->container['allow_access_code_format_metadata'] = $allow_access_code_format_metadata;

        return $this;
    }

    /**
     * Gets allow_account_management_granular
     *
     * @return ?string
     */
    public function getAllowAccountManagementGranular()
    {
        return $this->container['allow_account_management_granular'];
    }

    /**
     * Sets allow_account_management_granular
     *
     * @param ?string $allow_account_management_granular 
     *
     * @return $this
     */
    public function setAllowAccountManagementGranular($allow_account_management_granular)
    {
        $this->container['allow_account_management_granular'] = $allow_account_management_granular;

        return $this;
    }

    /**
     * Gets allow_account_management_granular_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowAccountManagementGranularMetadata()
    {
        return $this->container['allow_account_management_granular_metadata'];
    }

    /**
     * Sets allow_account_management_granular_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_account_management_granular_metadata Metadata that indicates whether the `allowAccountManagementGranular` property is editable.
     *
     * @return $this
     */
    public function setAllowAccountManagementGranularMetadata($allow_account_management_granular_metadata)
    {
        $this->container['allow_account_management_granular_metadata'] = $allow_account_management_granular_metadata;

        return $this;
    }

    /**
     * Gets allow_account_member_name_change
     *
     * @return ?string
     */
    public function getAllowAccountMemberNameChange()
    {
        return $this->container['allow_account_member_name_change'];
    }

    /**
     * Sets allow_account_member_name_change
     *
     * @param ?string $allow_account_member_name_change 
     *
     * @return $this
     */
    public function setAllowAccountMemberNameChange($allow_account_member_name_change)
    {
        $this->container['allow_account_member_name_change'] = $allow_account_member_name_change;

        return $this;
    }

    /**
     * Gets allow_account_member_name_change_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowAccountMemberNameChangeMetadata()
    {
        return $this->container['allow_account_member_name_change_metadata'];
    }

    /**
     * Sets allow_account_member_name_change_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_account_member_name_change_metadata Metadata that indicates whether the `allowAccountMemberNameChange` property is editable.
     *
     * @return $this
     */
    public function setAllowAccountMemberNameChangeMetadata($allow_account_member_name_change_metadata)
    {
        $this->container['allow_account_member_name_change_metadata'] = $allow_account_member_name_change_metadata;

        return $this;
    }

    /**
     * Gets allow_ace
     *
     * @return ?string
     */
    public function getAllowAce()
    {
        return $this->container['allow_ace'];
    }

    /**
     * Sets allow_ace
     *
     * @param ?string $allow_ace 
     *
     * @return $this
     */
    public function setAllowAce($allow_ace)
    {
        $this->container['allow_ace'] = $allow_ace;

        return $this;
    }

    /**
     * Gets allow_ace_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowAceMetadata()
    {
        return $this->container['allow_ace_metadata'];
    }

    /**
     * Sets allow_ace_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_ace_metadata 
     *
     * @return $this
     */
    public function setAllowAceMetadata($allow_ace_metadata)
    {
        $this->container['allow_ace_metadata'] = $allow_ace_metadata;

        return $this;
    }

    /**
     * Gets allow_advanced_recipient_routing_conditional
     *
     * @return ?string
     */
    public function getAllowAdvancedRecipientRoutingConditional()
    {
        return $this->container['allow_advanced_recipient_routing_conditional'];
    }

    /**
     * Sets allow_advanced_recipient_routing_conditional
     *
     * @param ?string $allow_advanced_recipient_routing_conditional 
     *
     * @return $this
     */
    public function setAllowAdvancedRecipientRoutingConditional($allow_advanced_recipient_routing_conditional)
    {
        $this->container['allow_advanced_recipient_routing_conditional'] = $allow_advanced_recipient_routing_conditional;

        return $this;
    }

    /**
     * Gets allow_advanced_recipient_routing_conditional_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowAdvancedRecipientRoutingConditionalMetadata()
    {
        return $this->container['allow_advanced_recipient_routing_conditional_metadata'];
    }

    /**
     * Sets allow_advanced_recipient_routing_conditional_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_advanced_recipient_routing_conditional_metadata Metadata that indicates whether the ` allowAdvancedRecipientRoutingConditional` property is editable.
     *
     * @return $this
     */
    public function setAllowAdvancedRecipientRoutingConditionalMetadata($allow_advanced_recipient_routing_conditional_metadata)
    {
        $this->container['allow_advanced_recipient_routing_conditional_metadata'] = $allow_advanced_recipient_routing_conditional_metadata;

        return $this;
    }

    /**
     * Gets allow_agent_name_email_edit
     *
     * @return ?string
     */
    public function getAllowAgentNameEmailEdit()
    {
        return $this->container['allow_agent_name_email_edit'];
    }

    /**
     * Sets allow_agent_name_email_edit
     *
     * @param ?string $allow_agent_name_email_edit 
     *
     * @return $this
     */
    public function setAllowAgentNameEmailEdit($allow_agent_name_email_edit)
    {
        $this->container['allow_agent_name_email_edit'] = $allow_agent_name_email_edit;

        return $this;
    }

    /**
     * Gets allow_agent_name_email_edit_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowAgentNameEmailEditMetadata()
    {
        return $this->container['allow_agent_name_email_edit_metadata'];
    }

    /**
     * Sets allow_agent_name_email_edit_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_agent_name_email_edit_metadata Metadata that indicates whether the `allowAgentNameEmailEdit` property is editable.
     *
     * @return $this
     */
    public function setAllowAgentNameEmailEditMetadata($allow_agent_name_email_edit_metadata)
    {
        $this->container['allow_agent_name_email_edit_metadata'] = $allow_agent_name_email_edit_metadata;

        return $this;
    }

    /**
     * Gets allow_agreement_actions
     *
     * @return ?string
     */
    public function getAllowAgreementActions()
    {
        return $this->container['allow_agreement_actions'];
    }

    /**
     * Sets allow_agreement_actions
     *
     * @param ?string $allow_agreement_actions 
     *
     * @return $this
     */
    public function setAllowAgreementActions($allow_agreement_actions)
    {
        $this->container['allow_agreement_actions'] = $allow_agreement_actions;

        return $this;
    }

    /**
     * Gets allow_agreement_actions_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowAgreementActionsMetadata()
    {
        return $this->container['allow_agreement_actions_metadata'];
    }

    /**
     * Sets allow_agreement_actions_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_agreement_actions_metadata Metadata about the `allowAgreementActions` property.
     *
     * @return $this
     */
    public function setAllowAgreementActionsMetadata($allow_agreement_actions_metadata)
    {
        $this->container['allow_agreement_actions_metadata'] = $allow_agreement_actions_metadata;

        return $this;
    }

    /**
     * Gets allow_agreement_orchestrations
     *
     * @return ?string
     */
    public function getAllowAgreementOrchestrations()
    {
        return $this->container['allow_agreement_orchestrations'];
    }

    /**
     * Sets allow_agreement_orchestrations
     *
     * @param ?string $allow_agreement_orchestrations 
     *
     * @return $this
     */
    public function setAllowAgreementOrchestrations($allow_agreement_orchestrations)
    {
        $this->container['allow_agreement_orchestrations'] = $allow_agreement_orchestrations;

        return $this;
    }

    /**
     * Gets allow_agreement_orchestrations_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowAgreementOrchestrationsMetadata()
    {
        return $this->container['allow_agreement_orchestrations_metadata'];
    }

    /**
     * Sets allow_agreement_orchestrations_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_agreement_orchestrations_metadata 
     *
     * @return $this
     */
    public function setAllowAgreementOrchestrationsMetadata($allow_agreement_orchestrations_metadata)
    {
        $this->container['allow_agreement_orchestrations_metadata'] = $allow_agreement_orchestrations_metadata;

        return $this;
    }

    /**
     * Gets allow_auto_nav_settings
     *
     * @return ?string
     */
    public function getAllowAutoNavSettings()
    {
        return $this->container['allow_auto_nav_settings'];
    }

    /**
     * Sets allow_auto_nav_settings
     *
     * @param ?string $allow_auto_nav_settings 
     *
     * @return $this
     */
    public function setAllowAutoNavSettings($allow_auto_nav_settings)
    {
        $this->container['allow_auto_nav_settings'] = $allow_auto_nav_settings;

        return $this;
    }

    /**
     * Gets allow_auto_nav_settings_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowAutoNavSettingsMetadata()
    {
        return $this->container['allow_auto_nav_settings_metadata'];
    }

    /**
     * Sets allow_auto_nav_settings_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_auto_nav_settings_metadata Metadata that indicates whether the `allowAutoNavSettings` property is editable.
     *
     * @return $this
     */
    public function setAllowAutoNavSettingsMetadata($allow_auto_nav_settings_metadata)
    {
        $this->container['allow_auto_nav_settings_metadata'] = $allow_auto_nav_settings_metadata;

        return $this;
    }

    /**
     * Gets allow_auto_tagging
     *
     * @return ?string
     */
    public function getAllowAutoTagging()
    {
        return $this->container['allow_auto_tagging'];
    }

    /**
     * Sets allow_auto_tagging
     *
     * @param ?string $allow_auto_tagging 
     *
     * @return $this
     */
    public function setAllowAutoTagging($allow_auto_tagging)
    {
        $this->container['allow_auto_tagging'] = $allow_auto_tagging;

        return $this;
    }

    /**
     * Gets allow_auto_tagging_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowAutoTaggingMetadata()
    {
        return $this->container['allow_auto_tagging_metadata'];
    }

    /**
     * Sets allow_auto_tagging_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_auto_tagging_metadata Metadata that indicates whether the `allowAutoTagging` property is editable.
     *
     * @return $this
     */
    public function setAllowAutoTaggingMetadata($allow_auto_tagging_metadata)
    {
        $this->container['allow_auto_tagging_metadata'] = $allow_auto_tagging_metadata;

        return $this;
    }

    /**
     * Gets allow_bulk_send
     *
     * @return ?string
     */
    public function getAllowBulkSend()
    {
        return $this->container['allow_bulk_send'];
    }

    /**
     * Sets allow_bulk_send
     *
     * @param ?string $allow_bulk_send 
     *
     * @return $this
     */
    public function setAllowBulkSend($allow_bulk_send)
    {
        $this->container['allow_bulk_send'] = $allow_bulk_send;

        return $this;
    }

    /**
     * Gets allow_bulk_send_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowBulkSendMetadata()
    {
        return $this->container['allow_bulk_send_metadata'];
    }

    /**
     * Sets allow_bulk_send_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_bulk_send_metadata Metadata that indicates whether the `allowBulkSend` property is editable.
     *
     * @return $this
     */
    public function setAllowBulkSendMetadata($allow_bulk_send_metadata)
    {
        $this->container['allow_bulk_send_metadata'] = $allow_bulk_send_metadata;

        return $this;
    }

    /**
     * Gets allow_cd_withdraw
     *
     * @return ?string
     */
    public function getAllowCdWithdraw()
    {
        return $this->container['allow_cd_withdraw'];
    }

    /**
     * Sets allow_cd_withdraw
     *
     * @param ?string $allow_cd_withdraw 
     *
     * @return $this
     */
    public function setAllowCdWithdraw($allow_cd_withdraw)
    {
        $this->container['allow_cd_withdraw'] = $allow_cd_withdraw;

        return $this;
    }

    /**
     * Gets allow_cd_withdraw_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowCdWithdrawMetadata()
    {
        return $this->container['allow_cd_withdraw_metadata'];
    }

    /**
     * Sets allow_cd_withdraw_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_cd_withdraw_metadata Metadata that indicates whether the `allowCDWithdraw` property is editable.
     *
     * @return $this
     */
    public function setAllowCdWithdrawMetadata($allow_cd_withdraw_metadata)
    {
        $this->container['allow_cd_withdraw_metadata'] = $allow_cd_withdraw_metadata;

        return $this;
    }

    /**
     * Gets allow_connect_http_listener_configs
     *
     * @return ?string
     */
    public function getAllowConnectHttpListenerConfigs()
    {
        return $this->container['allow_connect_http_listener_configs'];
    }

    /**
     * Sets allow_connect_http_listener_configs
     *
     * @param ?string $allow_connect_http_listener_configs 
     *
     * @return $this
     */
    public function setAllowConnectHttpListenerConfigs($allow_connect_http_listener_configs)
    {
        $this->container['allow_connect_http_listener_configs'] = $allow_connect_http_listener_configs;

        return $this;
    }

    /**
     * Gets allow_connect_identity_verification_ui
     *
     * @return ?string
     */
    public function getAllowConnectIdentityVerificationUi()
    {
        return $this->container['allow_connect_identity_verification_ui'];
    }

    /**
     * Sets allow_connect_identity_verification_ui
     *
     * @param ?string $allow_connect_identity_verification_ui 
     *
     * @return $this
     */
    public function setAllowConnectIdentityVerificationUi($allow_connect_identity_verification_ui)
    {
        $this->container['allow_connect_identity_verification_ui'] = $allow_connect_identity_verification_ui;

        return $this;
    }

    /**
     * Gets allow_connect_o_auth_ui
     *
     * @return ?string
     */
    public function getAllowConnectOAuthUi()
    {
        return $this->container['allow_connect_o_auth_ui'];
    }

    /**
     * Sets allow_connect_o_auth_ui
     *
     * @param ?string $allow_connect_o_auth_ui 
     *
     * @return $this
     */
    public function setAllowConnectOAuthUi($allow_connect_o_auth_ui)
    {
        $this->container['allow_connect_o_auth_ui'] = $allow_connect_o_auth_ui;

        return $this;
    }

    /**
     * Gets allow_connect_send_finish_later
     *
     * @return ?string
     */
    public function getAllowConnectSendFinishLater()
    {
        return $this->container['allow_connect_send_finish_later'];
    }

    /**
     * Sets allow_connect_send_finish_later
     *
     * @param ?string $allow_connect_send_finish_later 
     *
     * @return $this
     */
    public function setAllowConnectSendFinishLater($allow_connect_send_finish_later)
    {
        $this->container['allow_connect_send_finish_later'] = $allow_connect_send_finish_later;

        return $this;
    }

    /**
     * Gets allow_connect_send_finish_later_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowConnectSendFinishLaterMetadata()
    {
        return $this->container['allow_connect_send_finish_later_metadata'];
    }

    /**
     * Sets allow_connect_send_finish_later_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_connect_send_finish_later_metadata Metadata that indicates whether the `allowConnectSendFinishLater` property is editable.
     *
     * @return $this
     */
    public function setAllowConnectSendFinishLaterMetadata($allow_connect_send_finish_later_metadata)
    {
        $this->container['allow_connect_send_finish_later_metadata'] = $allow_connect_send_finish_later_metadata;

        return $this;
    }

    /**
     * Gets allow_connect_unified_payload_ui
     *
     * @return ?string
     */
    public function getAllowConnectUnifiedPayloadUi()
    {
        return $this->container['allow_connect_unified_payload_ui'];
    }

    /**
     * Sets allow_connect_unified_payload_ui
     *
     * @param ?string $allow_connect_unified_payload_ui 
     *
     * @return $this
     */
    public function setAllowConnectUnifiedPayloadUi($allow_connect_unified_payload_ui)
    {
        $this->container['allow_connect_unified_payload_ui'] = $allow_connect_unified_payload_ui;

        return $this;
    }

    /**
     * Gets allow_consumer_disclosure_override
     *
     * @return ?string
     */
    public function getAllowConsumerDisclosureOverride()
    {
        return $this->container['allow_consumer_disclosure_override'];
    }

    /**
     * Sets allow_consumer_disclosure_override
     *
     * @param ?string $allow_consumer_disclosure_override 
     *
     * @return $this
     */
    public function setAllowConsumerDisclosureOverride($allow_consumer_disclosure_override)
    {
        $this->container['allow_consumer_disclosure_override'] = $allow_consumer_disclosure_override;

        return $this;
    }

    /**
     * Gets allow_consumer_disclosure_override_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowConsumerDisclosureOverrideMetadata()
    {
        return $this->container['allow_consumer_disclosure_override_metadata'];
    }

    /**
     * Sets allow_consumer_disclosure_override_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_consumer_disclosure_override_metadata Metadata that indicates whether the `allowConsumerDisclosureOverride` property is editable.
     *
     * @return $this
     */
    public function setAllowConsumerDisclosureOverrideMetadata($allow_consumer_disclosure_override_metadata)
    {
        $this->container['allow_consumer_disclosure_override_metadata'] = $allow_consumer_disclosure_override_metadata;

        return $this;
    }

    /**
     * Gets allow_data_download
     *
     * @return ?string
     */
    public function getAllowDataDownload()
    {
        return $this->container['allow_data_download'];
    }

    /**
     * Sets allow_data_download
     *
     * @param ?string $allow_data_download 
     *
     * @return $this
     */
    public function setAllowDataDownload($allow_data_download)
    {
        $this->container['allow_data_download'] = $allow_data_download;

        return $this;
    }

    /**
     * Gets allow_data_download_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowDataDownloadMetadata()
    {
        return $this->container['allow_data_download_metadata'];
    }

    /**
     * Sets allow_data_download_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_data_download_metadata Metadata that indicates whether the `allowDataDownload` property is editable.
     *
     * @return $this
     */
    public function setAllowDataDownloadMetadata($allow_data_download_metadata)
    {
        $this->container['allow_data_download_metadata'] = $allow_data_download_metadata;

        return $this;
    }

    /**
     * Gets allow_delayed_routing
     *
     * @return ?string
     */
    public function getAllowDelayedRouting()
    {
        return $this->container['allow_delayed_routing'];
    }

    /**
     * Sets allow_delayed_routing
     *
     * @param ?string $allow_delayed_routing \\\"true\\\" if the account has permission to use the delayed routing feature to insert delays before routing an envelope to a recipient, \\\"false\\\" otherwise.
     *
     * @return $this
     */
    public function setAllowDelayedRouting($allow_delayed_routing)
    {
        $this->container['allow_delayed_routing'] = $allow_delayed_routing;

        return $this;
    }

    /**
     * Gets allow_delayed_routing_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowDelayedRoutingMetadata()
    {
        return $this->container['allow_delayed_routing_metadata'];
    }

    /**
     * Sets allow_delayed_routing_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_delayed_routing_metadata 
     *
     * @return $this
     */
    public function setAllowDelayedRoutingMetadata($allow_delayed_routing_metadata)
    {
        $this->container['allow_delayed_routing_metadata'] = $allow_delayed_routing_metadata;

        return $this;
    }

    /**
     * Gets allow_delegated_signing
     *
     * @return ?string
     */
    public function getAllowDelegatedSigning()
    {
        return $this->container['allow_delegated_signing'];
    }

    /**
     * Sets allow_delegated_signing
     *
     * @param ?string $allow_delegated_signing 
     *
     * @return $this
     */
    public function setAllowDelegatedSigning($allow_delegated_signing)
    {
        $this->container['allow_delegated_signing'] = $allow_delegated_signing;

        return $this;
    }

    /**
     * Gets allow_delegated_signing_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowDelegatedSigningMetadata()
    {
        return $this->container['allow_delegated_signing_metadata'];
    }

    /**
     * Sets allow_delegated_signing_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_delegated_signing_metadata 
     *
     * @return $this
     */
    public function setAllowDelegatedSigningMetadata($allow_delegated_signing_metadata)
    {
        $this->container['allow_delegated_signing_metadata'] = $allow_delegated_signing_metadata;

        return $this;
    }

    /**
     * Gets allow_doc_gen_documents
     *
     * @return ?string
     */
    public function getAllowDocGenDocuments()
    {
        return $this->container['allow_doc_gen_documents'];
    }

    /**
     * Sets allow_doc_gen_documents
     *
     * @param ?string $allow_doc_gen_documents 
     *
     * @return $this
     */
    public function setAllowDocGenDocuments($allow_doc_gen_documents)
    {
        $this->container['allow_doc_gen_documents'] = $allow_doc_gen_documents;

        return $this;
    }

    /**
     * Gets allow_doc_gen_documents_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowDocGenDocumentsMetadata()
    {
        return $this->container['allow_doc_gen_documents_metadata'];
    }

    /**
     * Sets allow_doc_gen_documents_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_doc_gen_documents_metadata 
     *
     * @return $this
     */
    public function setAllowDocGenDocumentsMetadata($allow_doc_gen_documents_metadata)
    {
        $this->container['allow_doc_gen_documents_metadata'] = $allow_doc_gen_documents_metadata;

        return $this;
    }

    /**
     * Gets allow_document_disclosures
     *
     * @return ?string
     */
    public function getAllowDocumentDisclosures()
    {
        return $this->container['allow_document_disclosures'];
    }

    /**
     * Sets allow_document_disclosures
     *
     * @param ?string $allow_document_disclosures 
     *
     * @return $this
     */
    public function setAllowDocumentDisclosures($allow_document_disclosures)
    {
        $this->container['allow_document_disclosures'] = $allow_document_disclosures;

        return $this;
    }

    /**
     * Gets allow_document_disclosures_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowDocumentDisclosuresMetadata()
    {
        return $this->container['allow_document_disclosures_metadata'];
    }

    /**
     * Sets allow_document_disclosures_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_document_disclosures_metadata Metadata that indicates whether the `allowDocumentDisclosures` property is editable.
     *
     * @return $this
     */
    public function setAllowDocumentDisclosuresMetadata($allow_document_disclosures_metadata)
    {
        $this->container['allow_document_disclosures_metadata'] = $allow_document_disclosures_metadata;

        return $this;
    }

    /**
     * Gets allow_documents_on_signed_envelopes
     *
     * @return ?string
     */
    public function getAllowDocumentsOnSignedEnvelopes()
    {
        return $this->container['allow_documents_on_signed_envelopes'];
    }

    /**
     * Sets allow_documents_on_signed_envelopes
     *
     * @param ?string $allow_documents_on_signed_envelopes 
     *
     * @return $this
     */
    public function setAllowDocumentsOnSignedEnvelopes($allow_documents_on_signed_envelopes)
    {
        $this->container['allow_documents_on_signed_envelopes'] = $allow_documents_on_signed_envelopes;

        return $this;
    }

    /**
     * Gets allow_documents_on_signed_envelopes_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowDocumentsOnSignedEnvelopesMetadata()
    {
        return $this->container['allow_documents_on_signed_envelopes_metadata'];
    }

    /**
     * Sets allow_documents_on_signed_envelopes_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_documents_on_signed_envelopes_metadata Metadata that indicates whether the `allowDocumentsOnSignedEnvelopes` property is editable.
     *
     * @return $this
     */
    public function setAllowDocumentsOnSignedEnvelopesMetadata($allow_documents_on_signed_envelopes_metadata)
    {
        $this->container['allow_documents_on_signed_envelopes_metadata'] = $allow_documents_on_signed_envelopes_metadata;

        return $this;
    }

    /**
     * Gets allow_document_visibility
     *
     * @return ?string
     */
    public function getAllowDocumentVisibility()
    {
        return $this->container['allow_document_visibility'];
    }

    /**
     * Sets allow_document_visibility
     *
     * @param ?string $allow_document_visibility 
     *
     * @return $this
     */
    public function setAllowDocumentVisibility($allow_document_visibility)
    {
        $this->container['allow_document_visibility'] = $allow_document_visibility;

        return $this;
    }

    /**
     * Gets allow_document_visibility_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowDocumentVisibilityMetadata()
    {
        return $this->container['allow_document_visibility_metadata'];
    }

    /**
     * Sets allow_document_visibility_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_document_visibility_metadata Metadata that indicates whether the `allowDocumentVisibility` property is editable.
     *
     * @return $this
     */
    public function setAllowDocumentVisibilityMetadata($allow_document_visibility_metadata)
    {
        $this->container['allow_document_visibility_metadata'] = $allow_document_visibility_metadata;

        return $this;
    }

    /**
     * Gets allow_editing_envelopes_on_behalf_of_others
     *
     * @return ?string
     */
    public function getAllowEditingEnvelopesOnBehalfOfOthers()
    {
        return $this->container['allow_editing_envelopes_on_behalf_of_others'];
    }

    /**
     * Sets allow_editing_envelopes_on_behalf_of_others
     *
     * @param ?string $allow_editing_envelopes_on_behalf_of_others 
     *
     * @return $this
     */
    public function setAllowEditingEnvelopesOnBehalfOfOthers($allow_editing_envelopes_on_behalf_of_others)
    {
        $this->container['allow_editing_envelopes_on_behalf_of_others'] = $allow_editing_envelopes_on_behalf_of_others;

        return $this;
    }

    /**
     * Gets allow_editing_envelopes_on_behalf_of_others_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowEditingEnvelopesOnBehalfOfOthersMetadata()
    {
        return $this->container['allow_editing_envelopes_on_behalf_of_others_metadata'];
    }

    /**
     * Sets allow_editing_envelopes_on_behalf_of_others_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_editing_envelopes_on_behalf_of_others_metadata 
     *
     * @return $this
     */
    public function setAllowEditingEnvelopesOnBehalfOfOthersMetadata($allow_editing_envelopes_on_behalf_of_others_metadata)
    {
        $this->container['allow_editing_envelopes_on_behalf_of_others_metadata'] = $allow_editing_envelopes_on_behalf_of_others_metadata;

        return $this;
    }

    /**
     * Gets allow_e_hanko_stamps
     *
     * @return ?string
     */
    public function getAllowEHankoStamps()
    {
        return $this->container['allow_e_hanko_stamps'];
    }

    /**
     * Sets allow_e_hanko_stamps
     *
     * @param ?string $allow_e_hanko_stamps 
     *
     * @return $this
     */
    public function setAllowEHankoStamps($allow_e_hanko_stamps)
    {
        $this->container['allow_e_hanko_stamps'] = $allow_e_hanko_stamps;

        return $this;
    }

    /**
     * Gets allow_e_hanko_stamps_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowEHankoStampsMetadata()
    {
        return $this->container['allow_e_hanko_stamps_metadata'];
    }

    /**
     * Sets allow_e_hanko_stamps_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_e_hanko_stamps_metadata Metadata that indicates whether the `allowEHankoStamps` property is editable.
     *
     * @return $this
     */
    public function setAllowEHankoStampsMetadata($allow_e_hanko_stamps_metadata)
    {
        $this->container['allow_e_hanko_stamps_metadata'] = $allow_e_hanko_stamps_metadata;

        return $this;
    }

    /**
     * Gets allow_e_note_e_original
     *
     * @return ?string
     */
    public function getAllowENoteEOriginal()
    {
        return $this->container['allow_e_note_e_original'];
    }

    /**
     * Sets allow_e_note_e_original
     *
     * @param ?string $allow_e_note_e_original 
     *
     * @return $this
     */
    public function setAllowENoteEOriginal($allow_e_note_e_original)
    {
        $this->container['allow_e_note_e_original'] = $allow_e_note_e_original;

        return $this;
    }

    /**
     * Gets allow_e_note_e_original_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowENoteEOriginalMetadata()
    {
        return $this->container['allow_e_note_e_original_metadata'];
    }

    /**
     * Sets allow_e_note_e_original_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_e_note_e_original_metadata Metadata that indicates whether the `allowENoteEOriginal` property is editable.
     *
     * @return $this
     */
    public function setAllowENoteEOriginalMetadata($allow_e_note_e_original_metadata)
    {
        $this->container['allow_e_note_e_original_metadata'] = $allow_e_note_e_original_metadata;

        return $this;
    }

    /**
     * Gets allow_envelope_correct
     *
     * @return ?string
     */
    public function getAllowEnvelopeCorrect()
    {
        return $this->container['allow_envelope_correct'];
    }

    /**
     * Sets allow_envelope_correct
     *
     * @param ?string $allow_envelope_correct 
     *
     * @return $this
     */
    public function setAllowEnvelopeCorrect($allow_envelope_correct)
    {
        $this->container['allow_envelope_correct'] = $allow_envelope_correct;

        return $this;
    }

    /**
     * Gets allow_envelope_correct_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowEnvelopeCorrectMetadata()
    {
        return $this->container['allow_envelope_correct_metadata'];
    }

    /**
     * Sets allow_envelope_correct_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_envelope_correct_metadata Metadata that indicates whether the `allowEnvelopeCorrect` property is editable.
     *
     * @return $this
     */
    public function setAllowEnvelopeCorrectMetadata($allow_envelope_correct_metadata)
    {
        $this->container['allow_envelope_correct_metadata'] = $allow_envelope_correct_metadata;

        return $this;
    }

    /**
     * Gets allow_envelope_custody_transfer
     *
     * @return ?string
     */
    public function getAllowEnvelopeCustodyTransfer()
    {
        return $this->container['allow_envelope_custody_transfer'];
    }

    /**
     * Sets allow_envelope_custody_transfer
     *
     * @param ?string $allow_envelope_custody_transfer 
     *
     * @return $this
     */
    public function setAllowEnvelopeCustodyTransfer($allow_envelope_custody_transfer)
    {
        $this->container['allow_envelope_custody_transfer'] = $allow_envelope_custody_transfer;

        return $this;
    }

    /**
     * Gets allow_envelope_custody_transfer_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowEnvelopeCustodyTransferMetadata()
    {
        return $this->container['allow_envelope_custody_transfer_metadata'];
    }

    /**
     * Sets allow_envelope_custody_transfer_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_envelope_custody_transfer_metadata Metadata that indicates whether the `allowEnvelopeCustodyTransfer` property is editable.
     *
     * @return $this
     */
    public function setAllowEnvelopeCustodyTransferMetadata($allow_envelope_custody_transfer_metadata)
    {
        $this->container['allow_envelope_custody_transfer_metadata'] = $allow_envelope_custody_transfer_metadata;

        return $this;
    }

    /**
     * Gets allow_envelope_custom_fields
     *
     * @return ?string
     */
    public function getAllowEnvelopeCustomFields()
    {
        return $this->container['allow_envelope_custom_fields'];
    }

    /**
     * Sets allow_envelope_custom_fields
     *
     * @param ?string $allow_envelope_custom_fields 
     *
     * @return $this
     */
    public function setAllowEnvelopeCustomFields($allow_envelope_custom_fields)
    {
        $this->container['allow_envelope_custom_fields'] = $allow_envelope_custom_fields;

        return $this;
    }

    /**
     * Gets allow_envelope_custom_fields_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowEnvelopeCustomFieldsMetadata()
    {
        return $this->container['allow_envelope_custom_fields_metadata'];
    }

    /**
     * Sets allow_envelope_custom_fields_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_envelope_custom_fields_metadata Metadata that indicates whether the `allowEnvelopeCustomFields` property is editable.
     *
     * @return $this
     */
    public function setAllowEnvelopeCustomFieldsMetadata($allow_envelope_custom_fields_metadata)
    {
        $this->container['allow_envelope_custom_fields_metadata'] = $allow_envelope_custom_fields_metadata;

        return $this;
    }

    /**
     * Gets allow_envelope_publish_reporting
     *
     * @return ?string
     */
    public function getAllowEnvelopePublishReporting()
    {
        return $this->container['allow_envelope_publish_reporting'];
    }

    /**
     * Sets allow_envelope_publish_reporting
     *
     * @param ?string $allow_envelope_publish_reporting 
     *
     * @return $this
     */
    public function setAllowEnvelopePublishReporting($allow_envelope_publish_reporting)
    {
        $this->container['allow_envelope_publish_reporting'] = $allow_envelope_publish_reporting;

        return $this;
    }

    /**
     * Gets allow_envelope_publish_reporting_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowEnvelopePublishReportingMetadata()
    {
        return $this->container['allow_envelope_publish_reporting_metadata'];
    }

    /**
     * Sets allow_envelope_publish_reporting_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_envelope_publish_reporting_metadata Metadata that indicates whether the `allowEnvelopePublishReporting` property is editable.
     *
     * @return $this
     */
    public function setAllowEnvelopePublishReportingMetadata($allow_envelope_publish_reporting_metadata)
    {
        $this->container['allow_envelope_publish_reporting_metadata'] = $allow_envelope_publish_reporting_metadata;

        return $this;
    }

    /**
     * Gets allow_envelope_reporting
     *
     * @return ?string
     */
    public function getAllowEnvelopeReporting()
    {
        return $this->container['allow_envelope_reporting'];
    }

    /**
     * Sets allow_envelope_reporting
     *
     * @param ?string $allow_envelope_reporting 
     *
     * @return $this
     */
    public function setAllowEnvelopeReporting($allow_envelope_reporting)
    {
        $this->container['allow_envelope_reporting'] = $allow_envelope_reporting;

        return $this;
    }

    /**
     * Gets allow_envelope_reporting_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowEnvelopeReportingMetadata()
    {
        return $this->container['allow_envelope_reporting_metadata'];
    }

    /**
     * Sets allow_envelope_reporting_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_envelope_reporting_metadata Metadata that indicates whether the `allowEnvelopeReporting` property is editable.
     *
     * @return $this
     */
    public function setAllowEnvelopeReportingMetadata($allow_envelope_reporting_metadata)
    {
        $this->container['allow_envelope_reporting_metadata'] = $allow_envelope_reporting_metadata;

        return $this;
    }

    /**
     * Gets allow_expression
     *
     * @return ?string
     */
    public function getAllowExpression()
    {
        return $this->container['allow_expression'];
    }

    /**
     * Sets allow_expression
     *
     * @param ?string $allow_expression 
     *
     * @return $this
     */
    public function setAllowExpression($allow_expression)
    {
        $this->container['allow_expression'] = $allow_expression;

        return $this;
    }

    /**
     * Gets allow_expression_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowExpressionMetadata()
    {
        return $this->container['allow_expression_metadata'];
    }

    /**
     * Sets allow_expression_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_expression_metadata Metadata that indicates whether the `allowExpression` property is editable.
     *
     * @return $this
     */
    public function setAllowExpressionMetadata($allow_expression_metadata)
    {
        $this->container['allow_expression_metadata'] = $allow_expression_metadata;

        return $this;
    }

    /**
     * Gets allow_express_signer_certificate
     *
     * @return ?string
     */
    public function getAllowExpressSignerCertificate()
    {
        return $this->container['allow_express_signer_certificate'];
    }

    /**
     * Sets allow_express_signer_certificate
     *
     * @param ?string $allow_express_signer_certificate 
     *
     * @return $this
     */
    public function setAllowExpressSignerCertificate($allow_express_signer_certificate)
    {
        $this->container['allow_express_signer_certificate'] = $allow_express_signer_certificate;

        return $this;
    }

    /**
     * Gets allow_express_signer_certificate_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowExpressSignerCertificateMetadata()
    {
        return $this->container['allow_express_signer_certificate_metadata'];
    }

    /**
     * Sets allow_express_signer_certificate_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_express_signer_certificate_metadata Metadata that indicates whether the `allowExpressSignerCertificate` property is editable.
     *
     * @return $this
     */
    public function setAllowExpressSignerCertificateMetadata($allow_express_signer_certificate_metadata)
    {
        $this->container['allow_express_signer_certificate_metadata'] = $allow_express_signer_certificate_metadata;

        return $this;
    }

    /**
     * Gets allow_extended_sending_resource_file
     *
     * @return ?string
     */
    public function getAllowExtendedSendingResourceFile()
    {
        return $this->container['allow_extended_sending_resource_file'];
    }

    /**
     * Sets allow_extended_sending_resource_file
     *
     * @param ?string $allow_extended_sending_resource_file 
     *
     * @return $this
     */
    public function setAllowExtendedSendingResourceFile($allow_extended_sending_resource_file)
    {
        $this->container['allow_extended_sending_resource_file'] = $allow_extended_sending_resource_file;

        return $this;
    }

    /**
     * Gets allow_extended_sending_resource_file_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowExtendedSendingResourceFileMetadata()
    {
        return $this->container['allow_extended_sending_resource_file_metadata'];
    }

    /**
     * Sets allow_extended_sending_resource_file_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_extended_sending_resource_file_metadata Metadata that indicates whether the `allowExtendedSendingResourceFile` property is editable.
     *
     * @return $this
     */
    public function setAllowExtendedSendingResourceFileMetadata($allow_extended_sending_resource_file_metadata)
    {
        $this->container['allow_extended_sending_resource_file_metadata'] = $allow_extended_sending_resource_file_metadata;

        return $this;
    }

    /**
     * Gets allow_external_linked_accounts
     *
     * @return ?string
     */
    public function getAllowExternalLinkedAccounts()
    {
        return $this->container['allow_external_linked_accounts'];
    }

    /**
     * Sets allow_external_linked_accounts
     *
     * @param ?string $allow_external_linked_accounts 
     *
     * @return $this
     */
    public function setAllowExternalLinkedAccounts($allow_external_linked_accounts)
    {
        $this->container['allow_external_linked_accounts'] = $allow_external_linked_accounts;

        return $this;
    }

    /**
     * Gets allow_external_linked_accounts_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowExternalLinkedAccountsMetadata()
    {
        return $this->container['allow_external_linked_accounts_metadata'];
    }

    /**
     * Sets allow_external_linked_accounts_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_external_linked_accounts_metadata 
     *
     * @return $this
     */
    public function setAllowExternalLinkedAccountsMetadata($allow_external_linked_accounts_metadata)
    {
        $this->container['allow_external_linked_accounts_metadata'] = $allow_external_linked_accounts_metadata;

        return $this;
    }

    /**
     * Gets allow_external_signature_pad
     *
     * @return ?string
     */
    public function getAllowExternalSignaturePad()
    {
        return $this->container['allow_external_signature_pad'];
    }

    /**
     * Sets allow_external_signature_pad
     *
     * @param ?string $allow_external_signature_pad 
     *
     * @return $this
     */
    public function setAllowExternalSignaturePad($allow_external_signature_pad)
    {
        $this->container['allow_external_signature_pad'] = $allow_external_signature_pad;

        return $this;
    }

    /**
     * Gets allow_external_signature_pad_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowExternalSignaturePadMetadata()
    {
        return $this->container['allow_external_signature_pad_metadata'];
    }

    /**
     * Sets allow_external_signature_pad_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_external_signature_pad_metadata Metadata that indicates whether the `allowExternalSignaturePad` property is editable.
     *
     * @return $this
     */
    public function setAllowExternalSignaturePadMetadata($allow_external_signature_pad_metadata)
    {
        $this->container['allow_external_signature_pad_metadata'] = $allow_external_signature_pad_metadata;

        return $this;
    }

    /**
     * Gets allow_idv_for_eu_qualified_signatures
     *
     * @return ?string
     */
    public function getAllowIdvForEuQualifiedSignatures()
    {
        return $this->container['allow_idv_for_eu_qualified_signatures'];
    }

    /**
     * Sets allow_idv_for_eu_qualified_signatures
     *
     * @param ?string $allow_idv_for_eu_qualified_signatures 
     *
     * @return $this
     */
    public function setAllowIdvForEuQualifiedSignatures($allow_idv_for_eu_qualified_signatures)
    {
        $this->container['allow_idv_for_eu_qualified_signatures'] = $allow_idv_for_eu_qualified_signatures;

        return $this;
    }

    /**
     * Gets allow_idv_for_eu_qualified_signatures_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowIdvForEuQualifiedSignaturesMetadata()
    {
        return $this->container['allow_idv_for_eu_qualified_signatures_metadata'];
    }

    /**
     * Sets allow_idv_for_eu_qualified_signatures_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_idv_for_eu_qualified_signatures_metadata 
     *
     * @return $this
     */
    public function setAllowIdvForEuQualifiedSignaturesMetadata($allow_idv_for_eu_qualified_signatures_metadata)
    {
        $this->container['allow_idv_for_eu_qualified_signatures_metadata'] = $allow_idv_for_eu_qualified_signatures_metadata;

        return $this;
    }

    /**
     * Gets allow_idv_level1
     *
     * @return ?string
     */
    public function getAllowIdvLevel1()
    {
        return $this->container['allow_idv_level1'];
    }

    /**
     * Sets allow_idv_level1
     *
     * @param ?string $allow_idv_level1 
     *
     * @return $this
     */
    public function setAllowIdvLevel1($allow_idv_level1)
    {
        $this->container['allow_idv_level1'] = $allow_idv_level1;

        return $this;
    }

    /**
     * Gets allow_idv_level1_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowIdvLevel1Metadata()
    {
        return $this->container['allow_idv_level1_metadata'];
    }

    /**
     * Sets allow_idv_level1_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_idv_level1_metadata Metadata that indicates whether the `allowIDVLevel1` property is editable.
     *
     * @return $this
     */
    public function setAllowIdvLevel1Metadata($allow_idv_level1_metadata)
    {
        $this->container['allow_idv_level1_metadata'] = $allow_idv_level1_metadata;

        return $this;
    }

    /**
     * Gets allow_idv_level1_trial
     *
     * @return ?string
     */
    public function getAllowIdvLevel1Trial()
    {
        return $this->container['allow_idv_level1_trial'];
    }

    /**
     * Sets allow_idv_level1_trial
     *
     * @param ?string $allow_idv_level1_trial 
     *
     * @return $this
     */
    public function setAllowIdvLevel1Trial($allow_idv_level1_trial)
    {
        $this->container['allow_idv_level1_trial'] = $allow_idv_level1_trial;

        return $this;
    }

    /**
     * Gets allow_idv_level1_trial_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowIdvLevel1TrialMetadata()
    {
        return $this->container['allow_idv_level1_trial_metadata'];
    }

    /**
     * Sets allow_idv_level1_trial_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_idv_level1_trial_metadata 
     *
     * @return $this
     */
    public function setAllowIdvLevel1TrialMetadata($allow_idv_level1_trial_metadata)
    {
        $this->container['allow_idv_level1_trial_metadata'] = $allow_idv_level1_trial_metadata;

        return $this;
    }

    /**
     * Gets allow_idv_level2
     *
     * @return ?string
     */
    public function getAllowIdvLevel2()
    {
        return $this->container['allow_idv_level2'];
    }

    /**
     * Sets allow_idv_level2
     *
     * @param ?string $allow_idv_level2 
     *
     * @return $this
     */
    public function setAllowIdvLevel2($allow_idv_level2)
    {
        $this->container['allow_idv_level2'] = $allow_idv_level2;

        return $this;
    }

    /**
     * Gets allow_idv_level2_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowIdvLevel2Metadata()
    {
        return $this->container['allow_idv_level2_metadata'];
    }

    /**
     * Sets allow_idv_level2_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_idv_level2_metadata 
     *
     * @return $this
     */
    public function setAllowIdvLevel2Metadata($allow_idv_level2_metadata)
    {
        $this->container['allow_idv_level2_metadata'] = $allow_idv_level2_metadata;

        return $this;
    }

    /**
     * Gets allow_idv_level3
     *
     * @return ?string
     */
    public function getAllowIdvLevel3()
    {
        return $this->container['allow_idv_level3'];
    }

    /**
     * Sets allow_idv_level3
     *
     * @param ?string $allow_idv_level3 
     *
     * @return $this
     */
    public function setAllowIdvLevel3($allow_idv_level3)
    {
        $this->container['allow_idv_level3'] = $allow_idv_level3;

        return $this;
    }

    /**
     * Gets allow_idv_level3_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowIdvLevel3Metadata()
    {
        return $this->container['allow_idv_level3_metadata'];
    }

    /**
     * Sets allow_idv_level3_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_idv_level3_metadata 
     *
     * @return $this
     */
    public function setAllowIdvLevel3Metadata($allow_idv_level3_metadata)
    {
        $this->container['allow_idv_level3_metadata'] = $allow_idv_level3_metadata;

        return $this;
    }

    /**
     * Gets allow_idv_platform
     *
     * @return ?string
     */
    public function getAllowIdvPlatform()
    {
        return $this->container['allow_idv_platform'];
    }

    /**
     * Sets allow_idv_platform
     *
     * @param ?string $allow_idv_platform 
     *
     * @return $this
     */
    public function setAllowIdvPlatform($allow_idv_platform)
    {
        $this->container['allow_idv_platform'] = $allow_idv_platform;

        return $this;
    }

    /**
     * Gets allow_idv_platform_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowIdvPlatformMetadata()
    {
        return $this->container['allow_idv_platform_metadata'];
    }

    /**
     * Sets allow_idv_platform_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_idv_platform_metadata Metadata that indicates whether the `allowIDVPlatform` property is editable.
     *
     * @return $this
     */
    public function setAllowIdvPlatformMetadata($allow_idv_platform_metadata)
    {
        $this->container['allow_idv_platform_metadata'] = $allow_idv_platform_metadata;

        return $this;
    }

    /**
     * Gets allow_in_person
     *
     * @return ?string
     */
    public function getAllowInPerson()
    {
        return $this->container['allow_in_person'];
    }

    /**
     * Sets allow_in_person
     *
     * @param ?string $allow_in_person 
     *
     * @return $this
     */
    public function setAllowInPerson($allow_in_person)
    {
        $this->container['allow_in_person'] = $allow_in_person;

        return $this;
    }

    /**
     * Gets allow_in_person_electronic_notary
     *
     * @return ?string
     */
    public function getAllowInPersonElectronicNotary()
    {
        return $this->container['allow_in_person_electronic_notary'];
    }

    /**
     * Sets allow_in_person_electronic_notary
     *
     * @param ?string $allow_in_person_electronic_notary Account Level Flag that determines the availability to perform In Person Electronic Notarial (IPEN) actions
     *
     * @return $this
     */
    public function setAllowInPersonElectronicNotary($allow_in_person_electronic_notary)
    {
        $this->container['allow_in_person_electronic_notary'] = $allow_in_person_electronic_notary;

        return $this;
    }

    /**
     * Gets allow_in_person_electronic_notary_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowInPersonElectronicNotaryMetadata()
    {
        return $this->container['allow_in_person_electronic_notary_metadata'];
    }

    /**
     * Sets allow_in_person_electronic_notary_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_in_person_electronic_notary_metadata MetaData for the Account Level Flag that determines the availability to perform In Person Electronic Notarial (IPEN) actions
     *
     * @return $this
     */
    public function setAllowInPersonElectronicNotaryMetadata($allow_in_person_electronic_notary_metadata)
    {
        $this->container['allow_in_person_electronic_notary_metadata'] = $allow_in_person_electronic_notary_metadata;

        return $this;
    }

    /**
     * Gets allow_in_person_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowInPersonMetadata()
    {
        return $this->container['allow_in_person_metadata'];
    }

    /**
     * Sets allow_in_person_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_in_person_metadata Metadata that indicates whether the `allowInPerson` property is editable.
     *
     * @return $this
     */
    public function setAllowInPersonMetadata($allow_in_person_metadata)
    {
        $this->container['allow_in_person_metadata'] = $allow_in_person_metadata;

        return $this;
    }

    /**
     * Gets allow_managed_stamps
     *
     * @return ?string
     */
    public function getAllowManagedStamps()
    {
        return $this->container['allow_managed_stamps'];
    }

    /**
     * Sets allow_managed_stamps
     *
     * @param ?string $allow_managed_stamps 
     *
     * @return $this
     */
    public function setAllowManagedStamps($allow_managed_stamps)
    {
        $this->container['allow_managed_stamps'] = $allow_managed_stamps;

        return $this;
    }

    /**
     * Gets allow_managed_stamps_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowManagedStampsMetadata()
    {
        return $this->container['allow_managed_stamps_metadata'];
    }

    /**
     * Sets allow_managed_stamps_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_managed_stamps_metadata Metadata that indicates whether the `allowManagedStamps` property is editable.
     *
     * @return $this
     */
    public function setAllowManagedStampsMetadata($allow_managed_stamps_metadata)
    {
        $this->container['allow_managed_stamps_metadata'] = $allow_managed_stamps_metadata;

        return $this;
    }

    /**
     * Gets allow_managing_envelopes_on_behalf_of_others
     *
     * @return ?string
     */
    public function getAllowManagingEnvelopesOnBehalfOfOthers()
    {
        return $this->container['allow_managing_envelopes_on_behalf_of_others'];
    }

    /**
     * Sets allow_managing_envelopes_on_behalf_of_others
     *
     * @param ?string $allow_managing_envelopes_on_behalf_of_others 
     *
     * @return $this
     */
    public function setAllowManagingEnvelopesOnBehalfOfOthers($allow_managing_envelopes_on_behalf_of_others)
    {
        $this->container['allow_managing_envelopes_on_behalf_of_others'] = $allow_managing_envelopes_on_behalf_of_others;

        return $this;
    }

    /**
     * Gets allow_managing_envelopes_on_behalf_of_others_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowManagingEnvelopesOnBehalfOfOthersMetadata()
    {
        return $this->container['allow_managing_envelopes_on_behalf_of_others_metadata'];
    }

    /**
     * Sets allow_managing_envelopes_on_behalf_of_others_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_managing_envelopes_on_behalf_of_others_metadata 
     *
     * @return $this
     */
    public function setAllowManagingEnvelopesOnBehalfOfOthersMetadata($allow_managing_envelopes_on_behalf_of_others_metadata)
    {
        $this->container['allow_managing_envelopes_on_behalf_of_others_metadata'] = $allow_managing_envelopes_on_behalf_of_others_metadata;

        return $this;
    }

    /**
     * Gets allow_markup
     *
     * @return ?string
     */
    public function getAllowMarkup()
    {
        return $this->container['allow_markup'];
    }

    /**
     * Sets allow_markup
     *
     * @param ?string $allow_markup When set to **true**, Document Markup is enabled for envelope. Account must have Document Markup enabled to use this
     *
     * @return $this
     */
    public function setAllowMarkup($allow_markup)
    {
        $this->container['allow_markup'] = $allow_markup;

        return $this;
    }

    /**
     * Gets allow_markup_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowMarkupMetadata()
    {
        return $this->container['allow_markup_metadata'];
    }

    /**
     * Sets allow_markup_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_markup_metadata Metadata that indicates whether the `allowMarkup` property is editable.
     *
     * @return $this
     */
    public function setAllowMarkupMetadata($allow_markup_metadata)
    {
        $this->container['allow_markup_metadata'] = $allow_markup_metadata;

        return $this;
    }

    /**
     * Gets allow_member_time_zone
     *
     * @return ?string
     */
    public function getAllowMemberTimeZone()
    {
        return $this->container['allow_member_time_zone'];
    }

    /**
     * Sets allow_member_time_zone
     *
     * @param ?string $allow_member_time_zone 
     *
     * @return $this
     */
    public function setAllowMemberTimeZone($allow_member_time_zone)
    {
        $this->container['allow_member_time_zone'] = $allow_member_time_zone;

        return $this;
    }

    /**
     * Gets allow_member_time_zone_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowMemberTimeZoneMetadata()
    {
        return $this->container['allow_member_time_zone_metadata'];
    }

    /**
     * Sets allow_member_time_zone_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_member_time_zone_metadata Metadata that indicates whether the `allowMemberTimeZone` property is editable.
     *
     * @return $this
     */
    public function setAllowMemberTimeZoneMetadata($allow_member_time_zone_metadata)
    {
        $this->container['allow_member_time_zone_metadata'] = $allow_member_time_zone_metadata;

        return $this;
    }

    /**
     * Gets allow_merge_fields
     *
     * @return ?string
     */
    public function getAllowMergeFields()
    {
        return $this->container['allow_merge_fields'];
    }

    /**
     * Sets allow_merge_fields
     *
     * @param ?string $allow_merge_fields 
     *
     * @return $this
     */
    public function setAllowMergeFields($allow_merge_fields)
    {
        $this->container['allow_merge_fields'] = $allow_merge_fields;

        return $this;
    }

    /**
     * Gets allow_merge_fields_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowMergeFieldsMetadata()
    {
        return $this->container['allow_merge_fields_metadata'];
    }

    /**
     * Sets allow_merge_fields_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_merge_fields_metadata Metadata that indicates whether the `allowMergeFields` property is editable.
     *
     * @return $this
     */
    public function setAllowMergeFieldsMetadata($allow_merge_fields_metadata)
    {
        $this->container['allow_merge_fields_metadata'] = $allow_merge_fields_metadata;

        return $this;
    }

    /**
     * Gets allow_multiple_brand_profiles
     *
     * @return ?string
     */
    public function getAllowMultipleBrandProfiles()
    {
        return $this->container['allow_multiple_brand_profiles'];
    }

    /**
     * Sets allow_multiple_brand_profiles
     *
     * @param ?string $allow_multiple_brand_profiles 
     *
     * @return $this
     */
    public function setAllowMultipleBrandProfiles($allow_multiple_brand_profiles)
    {
        $this->container['allow_multiple_brand_profiles'] = $allow_multiple_brand_profiles;

        return $this;
    }

    /**
     * Gets allow_multiple_brand_profiles_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowMultipleBrandProfilesMetadata()
    {
        return $this->container['allow_multiple_brand_profiles_metadata'];
    }

    /**
     * Sets allow_multiple_brand_profiles_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_multiple_brand_profiles_metadata Metadata that indicates whether the `allowMultipleBrandProfiles` property is editable.
     *
     * @return $this
     */
    public function setAllowMultipleBrandProfilesMetadata($allow_multiple_brand_profiles_metadata)
    {
        $this->container['allow_multiple_brand_profiles_metadata'] = $allow_multiple_brand_profiles_metadata;

        return $this;
    }

    /**
     * Gets allow_multiple_signer_attachments
     *
     * @return ?string
     */
    public function getAllowMultipleSignerAttachments()
    {
        return $this->container['allow_multiple_signer_attachments'];
    }

    /**
     * Sets allow_multiple_signer_attachments
     *
     * @param ?string $allow_multiple_signer_attachments 
     *
     * @return $this
     */
    public function setAllowMultipleSignerAttachments($allow_multiple_signer_attachments)
    {
        $this->container['allow_multiple_signer_attachments'] = $allow_multiple_signer_attachments;

        return $this;
    }

    /**
     * Gets allow_multiple_signer_attachments_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowMultipleSignerAttachmentsMetadata()
    {
        return $this->container['allow_multiple_signer_attachments_metadata'];
    }

    /**
     * Sets allow_multiple_signer_attachments_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_multiple_signer_attachments_metadata Metadata that indicates whether the `allowMultipleSignerAttachments` property is editable.
     *
     * @return $this
     */
    public function setAllowMultipleSignerAttachmentsMetadata($allow_multiple_signer_attachments_metadata)
    {
        $this->container['allow_multiple_signer_attachments_metadata'] = $allow_multiple_signer_attachments_metadata;

        return $this;
    }

    /**
     * Gets allow_non_us_phone_auth
     *
     * @return ?string
     */
    public function getAllowNonUsPhoneAuth()
    {
        return $this->container['allow_non_us_phone_auth'];
    }

    /**
     * Sets allow_non_us_phone_auth
     *
     * @param ?string $allow_non_us_phone_auth 
     *
     * @return $this
     */
    public function setAllowNonUsPhoneAuth($allow_non_us_phone_auth)
    {
        $this->container['allow_non_us_phone_auth'] = $allow_non_us_phone_auth;

        return $this;
    }

    /**
     * Gets allow_non_us_phone_auth_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowNonUsPhoneAuthMetadata()
    {
        return $this->container['allow_non_us_phone_auth_metadata'];
    }

    /**
     * Sets allow_non_us_phone_auth_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_non_us_phone_auth_metadata Metadata that indicates whether the `allowNonUSPhoneAuth` property is editable.
     *
     * @return $this
     */
    public function setAllowNonUsPhoneAuthMetadata($allow_non_us_phone_auth_metadata)
    {
        $this->container['allow_non_us_phone_auth_metadata'] = $allow_non_us_phone_auth_metadata;

        return $this;
    }

    /**
     * Gets allow_ocr_of_envelope_documents
     *
     * @return ?string
     */
    public function getAllowOcrOfEnvelopeDocuments()
    {
        return $this->container['allow_ocr_of_envelope_documents'];
    }

    /**
     * Sets allow_ocr_of_envelope_documents
     *
     * @param ?string $allow_ocr_of_envelope_documents 
     *
     * @return $this
     */
    public function setAllowOcrOfEnvelopeDocuments($allow_ocr_of_envelope_documents)
    {
        $this->container['allow_ocr_of_envelope_documents'] = $allow_ocr_of_envelope_documents;

        return $this;
    }

    /**
     * Gets allow_ocr_of_envelope_documents_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowOcrOfEnvelopeDocumentsMetadata()
    {
        return $this->container['allow_ocr_of_envelope_documents_metadata'];
    }

    /**
     * Sets allow_ocr_of_envelope_documents_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_ocr_of_envelope_documents_metadata 
     *
     * @return $this
     */
    public function setAllowOcrOfEnvelopeDocumentsMetadata($allow_ocr_of_envelope_documents_metadata)
    {
        $this->container['allow_ocr_of_envelope_documents_metadata'] = $allow_ocr_of_envelope_documents_metadata;

        return $this;
    }

    /**
     * Gets allow_offline_signing
     *
     * @return ?string
     */
    public function getAllowOfflineSigning()
    {
        return $this->container['allow_offline_signing'];
    }

    /**
     * Sets allow_offline_signing
     *
     * @param ?string $allow_offline_signing 
     *
     * @return $this
     */
    public function setAllowOfflineSigning($allow_offline_signing)
    {
        $this->container['allow_offline_signing'] = $allow_offline_signing;

        return $this;
    }

    /**
     * Gets allow_offline_signing_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowOfflineSigningMetadata()
    {
        return $this->container['allow_offline_signing_metadata'];
    }

    /**
     * Sets allow_offline_signing_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_offline_signing_metadata Metadata that indicates whether the `allowOfflineSigning` property is editable.
     *
     * @return $this
     */
    public function setAllowOfflineSigningMetadata($allow_offline_signing_metadata)
    {
        $this->container['allow_offline_signing_metadata'] = $allow_offline_signing_metadata;

        return $this;
    }

    /**
     * Gets allow_open_trust_signer_certificate
     *
     * @return ?string
     */
    public function getAllowOpenTrustSignerCertificate()
    {
        return $this->container['allow_open_trust_signer_certificate'];
    }

    /**
     * Sets allow_open_trust_signer_certificate
     *
     * @param ?string $allow_open_trust_signer_certificate 
     *
     * @return $this
     */
    public function setAllowOpenTrustSignerCertificate($allow_open_trust_signer_certificate)
    {
        $this->container['allow_open_trust_signer_certificate'] = $allow_open_trust_signer_certificate;

        return $this;
    }

    /**
     * Gets allow_open_trust_signer_certificate_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowOpenTrustSignerCertificateMetadata()
    {
        return $this->container['allow_open_trust_signer_certificate_metadata'];
    }

    /**
     * Sets allow_open_trust_signer_certificate_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_open_trust_signer_certificate_metadata Metadata that indicates whether the `allowOpenTrustSignerCertificate` property is editable.
     *
     * @return $this
     */
    public function setAllowOpenTrustSignerCertificateMetadata($allow_open_trust_signer_certificate_metadata)
    {
        $this->container['allow_open_trust_signer_certificate_metadata'] = $allow_open_trust_signer_certificate_metadata;

        return $this;
    }

    /**
     * Gets allow_organization_docusign_monitor
     *
     * @return ?string
     */
    public function getAllowOrganizationDocusignMonitor()
    {
        return $this->container['allow_organization_docusign_monitor'];
    }

    /**
     * Sets allow_organization_docusign_monitor
     *
     * @param ?string $allow_organization_docusign_monitor 
     *
     * @return $this
     */
    public function setAllowOrganizationDocusignMonitor($allow_organization_docusign_monitor)
    {
        $this->container['allow_organization_docusign_monitor'] = $allow_organization_docusign_monitor;

        return $this;
    }

    /**
     * Gets allow_organization_docusign_monitor_free
     *
     * @return ?string
     */
    public function getAllowOrganizationDocusignMonitorFree()
    {
        return $this->container['allow_organization_docusign_monitor_free'];
    }

    /**
     * Sets allow_organization_docusign_monitor_free
     *
     * @param ?string $allow_organization_docusign_monitor_free 
     *
     * @return $this
     */
    public function setAllowOrganizationDocusignMonitorFree($allow_organization_docusign_monitor_free)
    {
        $this->container['allow_organization_docusign_monitor_free'] = $allow_organization_docusign_monitor_free;

        return $this;
    }

    /**
     * Gets allow_organization_docusign_monitor_free_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowOrganizationDocusignMonitorFreeMetadata()
    {
        return $this->container['allow_organization_docusign_monitor_free_metadata'];
    }

    /**
     * Sets allow_organization_docusign_monitor_free_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_organization_docusign_monitor_free_metadata 
     *
     * @return $this
     */
    public function setAllowOrganizationDocusignMonitorFreeMetadata($allow_organization_docusign_monitor_free_metadata)
    {
        $this->container['allow_organization_docusign_monitor_free_metadata'] = $allow_organization_docusign_monitor_free_metadata;

        return $this;
    }

    /**
     * Gets allow_organization_docusign_monitor_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowOrganizationDocusignMonitorMetadata()
    {
        return $this->container['allow_organization_docusign_monitor_metadata'];
    }

    /**
     * Sets allow_organization_docusign_monitor_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_organization_docusign_monitor_metadata 
     *
     * @return $this
     */
    public function setAllowOrganizationDocusignMonitorMetadata($allow_organization_docusign_monitor_metadata)
    {
        $this->container['allow_organization_docusign_monitor_metadata'] = $allow_organization_docusign_monitor_metadata;

        return $this;
    }

    /**
     * Gets allow_organization_domain_user_management
     *
     * @return ?string
     */
    public function getAllowOrganizationDomainUserManagement()
    {
        return $this->container['allow_organization_domain_user_management'];
    }

    /**
     * Sets allow_organization_domain_user_management
     *
     * @param ?string $allow_organization_domain_user_management 
     *
     * @return $this
     */
    public function setAllowOrganizationDomainUserManagement($allow_organization_domain_user_management)
    {
        $this->container['allow_organization_domain_user_management'] = $allow_organization_domain_user_management;

        return $this;
    }

    /**
     * Gets allow_organization_domain_user_management_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowOrganizationDomainUserManagementMetadata()
    {
        return $this->container['allow_organization_domain_user_management_metadata'];
    }

    /**
     * Sets allow_organization_domain_user_management_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_organization_domain_user_management_metadata 
     *
     * @return $this
     */
    public function setAllowOrganizationDomainUserManagementMetadata($allow_organization_domain_user_management_metadata)
    {
        $this->container['allow_organization_domain_user_management_metadata'] = $allow_organization_domain_user_management_metadata;

        return $this;
    }

    /**
     * Gets allow_organizations
     *
     * @return ?string
     */
    public function getAllowOrganizations()
    {
        return $this->container['allow_organizations'];
    }

    /**
     * Sets allow_organizations
     *
     * @param ?string $allow_organizations 
     *
     * @return $this
     */
    public function setAllowOrganizations($allow_organizations)
    {
        $this->container['allow_organizations'] = $allow_organizations;

        return $this;
    }

    /**
     * Gets allow_organizations_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowOrganizationsMetadata()
    {
        return $this->container['allow_organizations_metadata'];
    }

    /**
     * Sets allow_organizations_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_organizations_metadata Metadata that indicates whether the `allowOrganizations` property is editable.
     *
     * @return $this
     */
    public function setAllowOrganizationsMetadata($allow_organizations_metadata)
    {
        $this->container['allow_organizations_metadata'] = $allow_organizations_metadata;

        return $this;
    }

    /**
     * Gets allow_organization_sso_management
     *
     * @return ?string
     */
    public function getAllowOrganizationSsoManagement()
    {
        return $this->container['allow_organization_sso_management'];
    }

    /**
     * Sets allow_organization_sso_management
     *
     * @param ?string $allow_organization_sso_management 
     *
     * @return $this
     */
    public function setAllowOrganizationSsoManagement($allow_organization_sso_management)
    {
        $this->container['allow_organization_sso_management'] = $allow_organization_sso_management;

        return $this;
    }

    /**
     * Gets allow_organization_sso_management_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowOrganizationSsoManagementMetadata()
    {
        return $this->container['allow_organization_sso_management_metadata'];
    }

    /**
     * Sets allow_organization_sso_management_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_organization_sso_management_metadata 
     *
     * @return $this
     */
    public function setAllowOrganizationSsoManagementMetadata($allow_organization_sso_management_metadata)
    {
        $this->container['allow_organization_sso_management_metadata'] = $allow_organization_sso_management_metadata;

        return $this;
    }

    /**
     * Gets allow_organization_to_use_in_person_electronic_notary
     *
     * @return ?string
     */
    public function getAllowOrganizationToUseInPersonElectronicNotary()
    {
        return $this->container['allow_organization_to_use_in_person_electronic_notary'];
    }

    /**
     * Sets allow_organization_to_use_in_person_electronic_notary
     *
     * @param ?string $allow_organization_to_use_in_person_electronic_notary Organization Level Flag that determines the availability to perform In Person Electronic Notarial (IPEN) actions
     *
     * @return $this
     */
    public function setAllowOrganizationToUseInPersonElectronicNotary($allow_organization_to_use_in_person_electronic_notary)
    {
        $this->container['allow_organization_to_use_in_person_electronic_notary'] = $allow_organization_to_use_in_person_electronic_notary;

        return $this;
    }

    /**
     * Gets allow_organization_to_use_in_person_electronic_notary_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowOrganizationToUseInPersonElectronicNotaryMetadata()
    {
        return $this->container['allow_organization_to_use_in_person_electronic_notary_metadata'];
    }

    /**
     * Sets allow_organization_to_use_in_person_electronic_notary_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_organization_to_use_in_person_electronic_notary_metadata MetaData for the Organization Level Flag that determines the availability to perform In Person Electronic Notarial (IPEN) actions
     *
     * @return $this
     */
    public function setAllowOrganizationToUseInPersonElectronicNotaryMetadata($allow_organization_to_use_in_person_electronic_notary_metadata)
    {
        $this->container['allow_organization_to_use_in_person_electronic_notary_metadata'] = $allow_organization_to_use_in_person_electronic_notary_metadata;

        return $this;
    }

    /**
     * Gets allow_organization_to_use_remote_notary
     *
     * @return ?string
     */
    public function getAllowOrganizationToUseRemoteNotary()
    {
        return $this->container['allow_organization_to_use_remote_notary'];
    }

    /**
     * Sets allow_organization_to_use_remote_notary
     *
     * @param ?string $allow_organization_to_use_remote_notary 
     *
     * @return $this
     */
    public function setAllowOrganizationToUseRemoteNotary($allow_organization_to_use_remote_notary)
    {
        $this->container['allow_organization_to_use_remote_notary'] = $allow_organization_to_use_remote_notary;

        return $this;
    }

    /**
     * Gets allow_organization_to_use_remote_notary_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowOrganizationToUseRemoteNotaryMetadata()
    {
        return $this->container['allow_organization_to_use_remote_notary_metadata'];
    }

    /**
     * Sets allow_organization_to_use_remote_notary_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_organization_to_use_remote_notary_metadata 
     *
     * @return $this
     */
    public function setAllowOrganizationToUseRemoteNotaryMetadata($allow_organization_to_use_remote_notary_metadata)
    {
        $this->container['allow_organization_to_use_remote_notary_metadata'] = $allow_organization_to_use_remote_notary_metadata;

        return $this;
    }

    /**
     * Gets allow_organization_to_use_third_party_electronic_notary
     *
     * @return ?string
     */
    public function getAllowOrganizationToUseThirdPartyElectronicNotary()
    {
        return $this->container['allow_organization_to_use_third_party_electronic_notary'];
    }

    /**
     * Sets allow_organization_to_use_third_party_electronic_notary
     *
     * @param ?string $allow_organization_to_use_third_party_electronic_notary Org level flag that determines the abailability to perform Third Party Notary (3PN) actions.
     *
     * @return $this
     */
    public function setAllowOrganizationToUseThirdPartyElectronicNotary($allow_organization_to_use_third_party_electronic_notary)
    {
        $this->container['allow_organization_to_use_third_party_electronic_notary'] = $allow_organization_to_use_third_party_electronic_notary;

        return $this;
    }

    /**
     * Gets allow_organization_to_use_third_party_electronic_notary_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowOrganizationToUseThirdPartyElectronicNotaryMetadata()
    {
        return $this->container['allow_organization_to_use_third_party_electronic_notary_metadata'];
    }

    /**
     * Sets allow_organization_to_use_third_party_electronic_notary_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_organization_to_use_third_party_electronic_notary_metadata Metadata for the org level flag that dtermines the availablity to perform Third Party Notary (3PN) actions.
     *
     * @return $this
     */
    public function setAllowOrganizationToUseThirdPartyElectronicNotaryMetadata($allow_organization_to_use_third_party_electronic_notary_metadata)
    {
        $this->container['allow_organization_to_use_third_party_electronic_notary_metadata'] = $allow_organization_to_use_third_party_electronic_notary_metadata;

        return $this;
    }

    /**
     * Gets allow_participant_recipient_type
     *
     * @return ?string
     */
    public function getAllowParticipantRecipientType()
    {
        return $this->container['allow_participant_recipient_type'];
    }

    /**
     * Sets allow_participant_recipient_type
     *
     * @param ?string $allow_participant_recipient_type 
     *
     * @return $this
     */
    public function setAllowParticipantRecipientType($allow_participant_recipient_type)
    {
        $this->container['allow_participant_recipient_type'] = $allow_participant_recipient_type;

        return $this;
    }

    /**
     * Gets allow_participant_recipient_type_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowParticipantRecipientTypeMetadata()
    {
        return $this->container['allow_participant_recipient_type_metadata'];
    }

    /**
     * Sets allow_participant_recipient_type_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_participant_recipient_type_metadata 
     *
     * @return $this
     */
    public function setAllowParticipantRecipientTypeMetadata($allow_participant_recipient_type_metadata)
    {
        $this->container['allow_participant_recipient_type_metadata'] = $allow_participant_recipient_type_metadata;

        return $this;
    }

    /**
     * Gets allow_payment_processing
     *
     * @return ?string
     */
    public function getAllowPaymentProcessing()
    {
        return $this->container['allow_payment_processing'];
    }

    /**
     * Sets allow_payment_processing
     *
     * @param ?string $allow_payment_processing 
     *
     * @return $this
     */
    public function setAllowPaymentProcessing($allow_payment_processing)
    {
        $this->container['allow_payment_processing'] = $allow_payment_processing;

        return $this;
    }

    /**
     * Gets allow_payment_processing_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowPaymentProcessingMetadata()
    {
        return $this->container['allow_payment_processing_metadata'];
    }

    /**
     * Sets allow_payment_processing_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_payment_processing_metadata Metadata that indicates whether the `allowPaymentProcessing` property is editable.
     *
     * @return $this
     */
    public function setAllowPaymentProcessingMetadata($allow_payment_processing_metadata)
    {
        $this->container['allow_payment_processing_metadata'] = $allow_payment_processing_metadata;

        return $this;
    }

    /**
     * Gets allow_performance_analytics
     *
     * @return ?string
     */
    public function getAllowPerformanceAnalytics()
    {
        return $this->container['allow_performance_analytics'];
    }

    /**
     * Sets allow_performance_analytics
     *
     * @param ?string $allow_performance_analytics 
     *
     * @return $this
     */
    public function setAllowPerformanceAnalytics($allow_performance_analytics)
    {
        $this->container['allow_performance_analytics'] = $allow_performance_analytics;

        return $this;
    }

    /**
     * Gets allow_performance_analytics_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowPerformanceAnalyticsMetadata()
    {
        return $this->container['allow_performance_analytics_metadata'];
    }

    /**
     * Sets allow_performance_analytics_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_performance_analytics_metadata 
     *
     * @return $this
     */
    public function setAllowPerformanceAnalyticsMetadata($allow_performance_analytics_metadata)
    {
        $this->container['allow_performance_analytics_metadata'] = $allow_performance_analytics_metadata;

        return $this;
    }

    /**
     * Gets allow_phone_authentication
     *
     * @return ?string
     */
    public function getAllowPhoneAuthentication()
    {
        return $this->container['allow_phone_authentication'];
    }

    /**
     * Sets allow_phone_authentication
     *
     * @param ?string $allow_phone_authentication 
     *
     * @return $this
     */
    public function setAllowPhoneAuthentication($allow_phone_authentication)
    {
        $this->container['allow_phone_authentication'] = $allow_phone_authentication;

        return $this;
    }

    /**
     * Gets allow_phone_authentication_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowPhoneAuthenticationMetadata()
    {
        return $this->container['allow_phone_authentication_metadata'];
    }

    /**
     * Sets allow_phone_authentication_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_phone_authentication_metadata Metadata that indicates whether the `allowPhoneAuthentication` property is editable.
     *
     * @return $this
     */
    public function setAllowPhoneAuthenticationMetadata($allow_phone_authentication_metadata)
    {
        $this->container['allow_phone_authentication_metadata'] = $allow_phone_authentication_metadata;

        return $this;
    }

    /**
     * Gets allow_phone_auth_override
     *
     * @return ?string
     */
    public function getAllowPhoneAuthOverride()
    {
        return $this->container['allow_phone_auth_override'];
    }

    /**
     * Sets allow_phone_auth_override
     *
     * @param ?string $allow_phone_auth_override 
     *
     * @return $this
     */
    public function setAllowPhoneAuthOverride($allow_phone_auth_override)
    {
        $this->container['allow_phone_auth_override'] = $allow_phone_auth_override;

        return $this;
    }

    /**
     * Gets allow_phone_auth_override_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowPhoneAuthOverrideMetadata()
    {
        return $this->container['allow_phone_auth_override_metadata'];
    }

    /**
     * Sets allow_phone_auth_override_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_phone_auth_override_metadata Metadata that indicates whether the `allowPhoneAuthOverride` property is editable.
     *
     * @return $this
     */
    public function setAllowPhoneAuthOverrideMetadata($allow_phone_auth_override_metadata)
    {
        $this->container['allow_phone_auth_override_metadata'] = $allow_phone_auth_override_metadata;

        return $this;
    }

    /**
     * Gets allow_private_signing_groups
     *
     * @return ?string
     */
    public function getAllowPrivateSigningGroups()
    {
        return $this->container['allow_private_signing_groups'];
    }

    /**
     * Sets allow_private_signing_groups
     *
     * @param ?string $allow_private_signing_groups 
     *
     * @return $this
     */
    public function setAllowPrivateSigningGroups($allow_private_signing_groups)
    {
        $this->container['allow_private_signing_groups'] = $allow_private_signing_groups;

        return $this;
    }

    /**
     * Gets allow_private_signing_groups_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowPrivateSigningGroupsMetadata()
    {
        return $this->container['allow_private_signing_groups_metadata'];
    }

    /**
     * Sets allow_private_signing_groups_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_private_signing_groups_metadata Metadata that indicates whether the `allowPrivateSigningGroups` property is editable.
     *
     * @return $this
     */
    public function setAllowPrivateSigningGroupsMetadata($allow_private_signing_groups_metadata)
    {
        $this->container['allow_private_signing_groups_metadata'] = $allow_private_signing_groups_metadata;

        return $this;
    }

    /**
     * Gets allow_recipient_connect
     *
     * @return ?string
     */
    public function getAllowRecipientConnect()
    {
        return $this->container['allow_recipient_connect'];
    }

    /**
     * Sets allow_recipient_connect
     *
     * @param ?string $allow_recipient_connect 
     *
     * @return $this
     */
    public function setAllowRecipientConnect($allow_recipient_connect)
    {
        $this->container['allow_recipient_connect'] = $allow_recipient_connect;

        return $this;
    }

    /**
     * Gets allow_recipient_connect_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowRecipientConnectMetadata()
    {
        return $this->container['allow_recipient_connect_metadata'];
    }

    /**
     * Sets allow_recipient_connect_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_recipient_connect_metadata 
     *
     * @return $this
     */
    public function setAllowRecipientConnectMetadata($allow_recipient_connect_metadata)
    {
        $this->container['allow_recipient_connect_metadata'] = $allow_recipient_connect_metadata;

        return $this;
    }

    /**
     * Gets allow_reminders
     *
     * @return ?string
     */
    public function getAllowReminders()
    {
        return $this->container['allow_reminders'];
    }

    /**
     * Sets allow_reminders
     *
     * @param ?string $allow_reminders 
     *
     * @return $this
     */
    public function setAllowReminders($allow_reminders)
    {
        $this->container['allow_reminders'] = $allow_reminders;

        return $this;
    }

    /**
     * Gets allow_reminders_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowRemindersMetadata()
    {
        return $this->container['allow_reminders_metadata'];
    }

    /**
     * Sets allow_reminders_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_reminders_metadata Metadata that indicates whether the `allowReminders` property is editable.
     *
     * @return $this
     */
    public function setAllowRemindersMetadata($allow_reminders_metadata)
    {
        $this->container['allow_reminders_metadata'] = $allow_reminders_metadata;

        return $this;
    }

    /**
     * Gets allow_remote_notary
     *
     * @return ?string
     */
    public function getAllowRemoteNotary()
    {
        return $this->container['allow_remote_notary'];
    }

    /**
     * Sets allow_remote_notary
     *
     * @param ?string $allow_remote_notary 
     *
     * @return $this
     */
    public function setAllowRemoteNotary($allow_remote_notary)
    {
        $this->container['allow_remote_notary'] = $allow_remote_notary;

        return $this;
    }

    /**
     * Gets allow_remote_notary_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowRemoteNotaryMetadata()
    {
        return $this->container['allow_remote_notary_metadata'];
    }

    /**
     * Sets allow_remote_notary_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_remote_notary_metadata 
     *
     * @return $this
     */
    public function setAllowRemoteNotaryMetadata($allow_remote_notary_metadata)
    {
        $this->container['allow_remote_notary_metadata'] = $allow_remote_notary_metadata;

        return $this;
    }

    /**
     * Gets allow_resource_file_branding
     *
     * @return ?string
     */
    public function getAllowResourceFileBranding()
    {
        return $this->container['allow_resource_file_branding'];
    }

    /**
     * Sets allow_resource_file_branding
     *
     * @param ?string $allow_resource_file_branding 
     *
     * @return $this
     */
    public function setAllowResourceFileBranding($allow_resource_file_branding)
    {
        $this->container['allow_resource_file_branding'] = $allow_resource_file_branding;

        return $this;
    }

    /**
     * Gets allow_resource_file_branding_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowResourceFileBrandingMetadata()
    {
        return $this->container['allow_resource_file_branding_metadata'];
    }

    /**
     * Sets allow_resource_file_branding_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_resource_file_branding_metadata Metadata that indicates whether the `allowResourceFileBranding` property is editable.
     *
     * @return $this
     */
    public function setAllowResourceFileBrandingMetadata($allow_resource_file_branding_metadata)
    {
        $this->container['allow_resource_file_branding_metadata'] = $allow_resource_file_branding_metadata;

        return $this;
    }

    /**
     * Gets allow_safe_bio_pharma_signer_certificate
     *
     * @return ?string
     */
    public function getAllowSafeBioPharmaSignerCertificate()
    {
        return $this->container['allow_safe_bio_pharma_signer_certificate'];
    }

    /**
     * Sets allow_safe_bio_pharma_signer_certificate
     *
     * @param ?string $allow_safe_bio_pharma_signer_certificate 
     *
     * @return $this
     */
    public function setAllowSafeBioPharmaSignerCertificate($allow_safe_bio_pharma_signer_certificate)
    {
        $this->container['allow_safe_bio_pharma_signer_certificate'] = $allow_safe_bio_pharma_signer_certificate;

        return $this;
    }

    /**
     * Gets allow_safe_bio_pharma_signer_certificate_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSafeBioPharmaSignerCertificateMetadata()
    {
        return $this->container['allow_safe_bio_pharma_signer_certificate_metadata'];
    }

    /**
     * Sets allow_safe_bio_pharma_signer_certificate_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_safe_bio_pharma_signer_certificate_metadata Metadata that indicates whether the `allowSafeBioPharmaSignerCertificate` property is editable.
     *
     * @return $this
     */
    public function setAllowSafeBioPharmaSignerCertificateMetadata($allow_safe_bio_pharma_signer_certificate_metadata)
    {
        $this->container['allow_safe_bio_pharma_signer_certificate_metadata'] = $allow_safe_bio_pharma_signer_certificate_metadata;

        return $this;
    }

    /**
     * Gets allow_scheduled_sending
     *
     * @return ?string
     */
    public function getAllowScheduledSending()
    {
        return $this->container['allow_scheduled_sending'];
    }

    /**
     * Sets allow_scheduled_sending
     *
     * @param ?string $allow_scheduled_sending \\\"true\\\" if the account has permission to use the scheduled sending feature to send envelopes at a specified datetime in the future, \\\"false\\\" otherwise.
     *
     * @return $this
     */
    public function setAllowScheduledSending($allow_scheduled_sending)
    {
        $this->container['allow_scheduled_sending'] = $allow_scheduled_sending;

        return $this;
    }

    /**
     * Gets allow_scheduled_sending_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowScheduledSendingMetadata()
    {
        return $this->container['allow_scheduled_sending_metadata'];
    }

    /**
     * Sets allow_scheduled_sending_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_scheduled_sending_metadata 
     *
     * @return $this
     */
    public function setAllowScheduledSendingMetadata($allow_scheduled_sending_metadata)
    {
        $this->container['allow_scheduled_sending_metadata'] = $allow_scheduled_sending_metadata;

        return $this;
    }

    /**
     * Gets allow_security_appliance
     *
     * @return ?string
     */
    public function getAllowSecurityAppliance()
    {
        return $this->container['allow_security_appliance'];
    }

    /**
     * Sets allow_security_appliance
     *
     * @param ?string $allow_security_appliance 
     *
     * @return $this
     */
    public function setAllowSecurityAppliance($allow_security_appliance)
    {
        $this->container['allow_security_appliance'] = $allow_security_appliance;

        return $this;
    }

    /**
     * Gets allow_security_appliance_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSecurityApplianceMetadata()
    {
        return $this->container['allow_security_appliance_metadata'];
    }

    /**
     * Sets allow_security_appliance_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_security_appliance_metadata Metadata that indicates whether the `allowSecurityAppliance` property is editable.
     *
     * @return $this
     */
    public function setAllowSecurityApplianceMetadata($allow_security_appliance_metadata)
    {
        $this->container['allow_security_appliance_metadata'] = $allow_security_appliance_metadata;

        return $this;
    }

    /**
     * Gets allow_sending_envelopes_on_behalf_of_others
     *
     * @return ?string
     */
    public function getAllowSendingEnvelopesOnBehalfOfOthers()
    {
        return $this->container['allow_sending_envelopes_on_behalf_of_others'];
    }

    /**
     * Sets allow_sending_envelopes_on_behalf_of_others
     *
     * @param ?string $allow_sending_envelopes_on_behalf_of_others 
     *
     * @return $this
     */
    public function setAllowSendingEnvelopesOnBehalfOfOthers($allow_sending_envelopes_on_behalf_of_others)
    {
        $this->container['allow_sending_envelopes_on_behalf_of_others'] = $allow_sending_envelopes_on_behalf_of_others;

        return $this;
    }

    /**
     * Gets allow_sending_envelopes_on_behalf_of_others_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSendingEnvelopesOnBehalfOfOthersMetadata()
    {
        return $this->container['allow_sending_envelopes_on_behalf_of_others_metadata'];
    }

    /**
     * Sets allow_sending_envelopes_on_behalf_of_others_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_sending_envelopes_on_behalf_of_others_metadata 
     *
     * @return $this
     */
    public function setAllowSendingEnvelopesOnBehalfOfOthersMetadata($allow_sending_envelopes_on_behalf_of_others_metadata)
    {
        $this->container['allow_sending_envelopes_on_behalf_of_others_metadata'] = $allow_sending_envelopes_on_behalf_of_others_metadata;

        return $this;
    }

    /**
     * Gets allow_send_to_certified_delivery
     *
     * @return ?string
     */
    public function getAllowSendToCertifiedDelivery()
    {
        return $this->container['allow_send_to_certified_delivery'];
    }

    /**
     * Sets allow_send_to_certified_delivery
     *
     * @param ?string $allow_send_to_certified_delivery 
     *
     * @return $this
     */
    public function setAllowSendToCertifiedDelivery($allow_send_to_certified_delivery)
    {
        $this->container['allow_send_to_certified_delivery'] = $allow_send_to_certified_delivery;

        return $this;
    }

    /**
     * Gets allow_send_to_certified_delivery_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSendToCertifiedDeliveryMetadata()
    {
        return $this->container['allow_send_to_certified_delivery_metadata'];
    }

    /**
     * Sets allow_send_to_certified_delivery_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_send_to_certified_delivery_metadata Metadata that indicates whether the `allowSendToCertifiedDelivery` property is editable.
     *
     * @return $this
     */
    public function setAllowSendToCertifiedDeliveryMetadata($allow_send_to_certified_delivery_metadata)
    {
        $this->container['allow_send_to_certified_delivery_metadata'] = $allow_send_to_certified_delivery_metadata;

        return $this;
    }

    /**
     * Gets allow_send_to_intermediary
     *
     * @return ?string
     */
    public function getAllowSendToIntermediary()
    {
        return $this->container['allow_send_to_intermediary'];
    }

    /**
     * Sets allow_send_to_intermediary
     *
     * @param ?string $allow_send_to_intermediary 
     *
     * @return $this
     */
    public function setAllowSendToIntermediary($allow_send_to_intermediary)
    {
        $this->container['allow_send_to_intermediary'] = $allow_send_to_intermediary;

        return $this;
    }

    /**
     * Gets allow_send_to_intermediary_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSendToIntermediaryMetadata()
    {
        return $this->container['allow_send_to_intermediary_metadata'];
    }

    /**
     * Sets allow_send_to_intermediary_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_send_to_intermediary_metadata Metadata that indicates whether the `allowSendToIntermediary` property is editable.
     *
     * @return $this
     */
    public function setAllowSendToIntermediaryMetadata($allow_send_to_intermediary_metadata)
    {
        $this->container['allow_send_to_intermediary_metadata'] = $allow_send_to_intermediary_metadata;

        return $this;
    }

    /**
     * Gets allow_server_templates
     *
     * @return ?string
     */
    public function getAllowServerTemplates()
    {
        return $this->container['allow_server_templates'];
    }

    /**
     * Sets allow_server_templates
     *
     * @param ?string $allow_server_templates 
     *
     * @return $this
     */
    public function setAllowServerTemplates($allow_server_templates)
    {
        $this->container['allow_server_templates'] = $allow_server_templates;

        return $this;
    }

    /**
     * Gets allow_server_templates_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowServerTemplatesMetadata()
    {
        return $this->container['allow_server_templates_metadata'];
    }

    /**
     * Sets allow_server_templates_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_server_templates_metadata Metadata that indicates whether the `allowServerTemplates` property is editable.
     *
     * @return $this
     */
    public function setAllowServerTemplatesMetadata($allow_server_templates_metadata)
    {
        $this->container['allow_server_templates_metadata'] = $allow_server_templates_metadata;

        return $this;
    }

    /**
     * Gets allow_set_embedded_recipient_start_url
     *
     * @return ?string
     */
    public function getAllowSetEmbeddedRecipientStartUrl()
    {
        return $this->container['allow_set_embedded_recipient_start_url'];
    }

    /**
     * Sets allow_set_embedded_recipient_start_url
     *
     * @param ?string $allow_set_embedded_recipient_start_url 
     *
     * @return $this
     */
    public function setAllowSetEmbeddedRecipientStartUrl($allow_set_embedded_recipient_start_url)
    {
        $this->container['allow_set_embedded_recipient_start_url'] = $allow_set_embedded_recipient_start_url;

        return $this;
    }

    /**
     * Gets allow_set_embedded_recipient_start_url_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSetEmbeddedRecipientStartUrlMetadata()
    {
        return $this->container['allow_set_embedded_recipient_start_url_metadata'];
    }

    /**
     * Sets allow_set_embedded_recipient_start_url_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_set_embedded_recipient_start_url_metadata 
     *
     * @return $this
     */
    public function setAllowSetEmbeddedRecipientStartUrlMetadata($allow_set_embedded_recipient_start_url_metadata)
    {
        $this->container['allow_set_embedded_recipient_start_url_metadata'] = $allow_set_embedded_recipient_start_url_metadata;

        return $this;
    }

    /**
     * Gets allow_shared_tabs
     *
     * @return ?string
     */
    public function getAllowSharedTabs()
    {
        return $this->container['allow_shared_tabs'];
    }

    /**
     * Sets allow_shared_tabs
     *
     * @param ?string $allow_shared_tabs 
     *
     * @return $this
     */
    public function setAllowSharedTabs($allow_shared_tabs)
    {
        $this->container['allow_shared_tabs'] = $allow_shared_tabs;

        return $this;
    }

    /**
     * Gets allow_shared_tabs_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSharedTabsMetadata()
    {
        return $this->container['allow_shared_tabs_metadata'];
    }

    /**
     * Sets allow_shared_tabs_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_shared_tabs_metadata Metadata that indicates whether the `allowSharedTabs` property is editable.
     *
     * @return $this
     */
    public function setAllowSharedTabsMetadata($allow_shared_tabs_metadata)
    {
        $this->container['allow_shared_tabs_metadata'] = $allow_shared_tabs_metadata;

        return $this;
    }

    /**
     * Gets allow_signature_stamps
     *
     * @return ?string
     */
    public function getAllowSignatureStamps()
    {
        return $this->container['allow_signature_stamps'];
    }

    /**
     * Sets allow_signature_stamps
     *
     * @param ?string $allow_signature_stamps 
     *
     * @return $this
     */
    public function setAllowSignatureStamps($allow_signature_stamps)
    {
        $this->container['allow_signature_stamps'] = $allow_signature_stamps;

        return $this;
    }

    /**
     * Gets allow_signature_stamps_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSignatureStampsMetadata()
    {
        return $this->container['allow_signature_stamps_metadata'];
    }

    /**
     * Sets allow_signature_stamps_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_signature_stamps_metadata Metadata that indicates whether the `allowSignatureStamps` property is editable.
     *
     * @return $this
     */
    public function setAllowSignatureStampsMetadata($allow_signature_stamps_metadata)
    {
        $this->container['allow_signature_stamps_metadata'] = $allow_signature_stamps_metadata;

        return $this;
    }

    /**
     * Gets allow_sign_document_from_home_page
     *
     * @return ?string
     */
    public function getAllowSignDocumentFromHomePage()
    {
        return $this->container['allow_sign_document_from_home_page'];
    }

    /**
     * Sets allow_sign_document_from_home_page
     *
     * @param ?string $allow_sign_document_from_home_page 
     *
     * @return $this
     */
    public function setAllowSignDocumentFromHomePage($allow_sign_document_from_home_page)
    {
        $this->container['allow_sign_document_from_home_page'] = $allow_sign_document_from_home_page;

        return $this;
    }

    /**
     * Gets allow_sign_document_from_home_page_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSignDocumentFromHomePageMetadata()
    {
        return $this->container['allow_sign_document_from_home_page_metadata'];
    }

    /**
     * Sets allow_sign_document_from_home_page_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_sign_document_from_home_page_metadata Metadata that indicates whether the `allowSignDocumentFromHomePage` property is editable.
     *
     * @return $this
     */
    public function setAllowSignDocumentFromHomePageMetadata($allow_sign_document_from_home_page_metadata)
    {
        $this->container['allow_sign_document_from_home_page_metadata'] = $allow_sign_document_from_home_page_metadata;

        return $this;
    }

    /**
     * Gets allow_signer_reassign
     *
     * @return ?string
     */
    public function getAllowSignerReassign()
    {
        return $this->container['allow_signer_reassign'];
    }

    /**
     * Sets allow_signer_reassign
     *
     * @param ?string $allow_signer_reassign 
     *
     * @return $this
     */
    public function setAllowSignerReassign($allow_signer_reassign)
    {
        $this->container['allow_signer_reassign'] = $allow_signer_reassign;

        return $this;
    }

    /**
     * Gets allow_signer_reassign_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSignerReassignMetadata()
    {
        return $this->container['allow_signer_reassign_metadata'];
    }

    /**
     * Sets allow_signer_reassign_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_signer_reassign_metadata Metadata that indicates whether the `allowSignerReassign` property is editable.
     *
     * @return $this
     */
    public function setAllowSignerReassignMetadata($allow_signer_reassign_metadata)
    {
        $this->container['allow_signer_reassign_metadata'] = $allow_signer_reassign_metadata;

        return $this;
    }

    /**
     * Gets allow_signer_reassign_override
     *
     * @return ?string
     */
    public function getAllowSignerReassignOverride()
    {
        return $this->container['allow_signer_reassign_override'];
    }

    /**
     * Sets allow_signer_reassign_override
     *
     * @param ?string $allow_signer_reassign_override 
     *
     * @return $this
     */
    public function setAllowSignerReassignOverride($allow_signer_reassign_override)
    {
        $this->container['allow_signer_reassign_override'] = $allow_signer_reassign_override;

        return $this;
    }

    /**
     * Gets allow_signer_reassign_override_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSignerReassignOverrideMetadata()
    {
        return $this->container['allow_signer_reassign_override_metadata'];
    }

    /**
     * Sets allow_signer_reassign_override_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_signer_reassign_override_metadata Metadata that indicates whether the `allowSignerReassignOverride` property is editable.
     *
     * @return $this
     */
    public function setAllowSignerReassignOverrideMetadata($allow_signer_reassign_override_metadata)
    {
        $this->container['allow_signer_reassign_override_metadata'] = $allow_signer_reassign_override_metadata;

        return $this;
    }

    /**
     * Gets allow_signing_extensions
     *
     * @return ?string
     */
    public function getAllowSigningExtensions()
    {
        return $this->container['allow_signing_extensions'];
    }

    /**
     * Sets allow_signing_extensions
     *
     * @param ?string $allow_signing_extensions 
     *
     * @return $this
     */
    public function setAllowSigningExtensions($allow_signing_extensions)
    {
        $this->container['allow_signing_extensions'] = $allow_signing_extensions;

        return $this;
    }

    /**
     * Gets allow_signing_extensions_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSigningExtensionsMetadata()
    {
        return $this->container['allow_signing_extensions_metadata'];
    }

    /**
     * Sets allow_signing_extensions_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_signing_extensions_metadata Metadata that indicates whether the `allowSigningExtensions` property is editable.
     *
     * @return $this
     */
    public function setAllowSigningExtensionsMetadata($allow_signing_extensions_metadata)
    {
        $this->container['allow_signing_extensions_metadata'] = $allow_signing_extensions_metadata;

        return $this;
    }

    /**
     * Gets allow_signing_groups
     *
     * @return ?string
     */
    public function getAllowSigningGroups()
    {
        return $this->container['allow_signing_groups'];
    }

    /**
     * Sets allow_signing_groups
     *
     * @param ?string $allow_signing_groups 
     *
     * @return $this
     */
    public function setAllowSigningGroups($allow_signing_groups)
    {
        $this->container['allow_signing_groups'] = $allow_signing_groups;

        return $this;
    }

    /**
     * Gets allow_signing_groups_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSigningGroupsMetadata()
    {
        return $this->container['allow_signing_groups_metadata'];
    }

    /**
     * Sets allow_signing_groups_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_signing_groups_metadata Metadata that indicates whether the `allowSigningGroups` property is editable.
     *
     * @return $this
     */
    public function setAllowSigningGroupsMetadata($allow_signing_groups_metadata)
    {
        $this->container['allow_signing_groups_metadata'] = $allow_signing_groups_metadata;

        return $this;
    }

    /**
     * Gets allow_signing_insights
     *
     * @return ?string
     */
    public function getAllowSigningInsights()
    {
        return $this->container['allow_signing_insights'];
    }

    /**
     * Sets allow_signing_insights
     *
     * @param ?string $allow_signing_insights 
     *
     * @return $this
     */
    public function setAllowSigningInsights($allow_signing_insights)
    {
        $this->container['allow_signing_insights'] = $allow_signing_insights;

        return $this;
    }

    /**
     * Gets allow_signing_insights_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSigningInsightsMetadata()
    {
        return $this->container['allow_signing_insights_metadata'];
    }

    /**
     * Sets allow_signing_insights_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_signing_insights_metadata 
     *
     * @return $this
     */
    public function setAllowSigningInsightsMetadata($allow_signing_insights_metadata)
    {
        $this->container['allow_signing_insights_metadata'] = $allow_signing_insights_metadata;

        return $this;
    }

    /**
     * Gets allow_signing_radio_deselect
     *
     * @return ?string
     */
    public function getAllowSigningRadioDeselect()
    {
        return $this->container['allow_signing_radio_deselect'];
    }

    /**
     * Sets allow_signing_radio_deselect
     *
     * @param ?string $allow_signing_radio_deselect 
     *
     * @return $this
     */
    public function setAllowSigningRadioDeselect($allow_signing_radio_deselect)
    {
        $this->container['allow_signing_radio_deselect'] = $allow_signing_radio_deselect;

        return $this;
    }

    /**
     * Gets allow_signing_radio_deselect_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSigningRadioDeselectMetadata()
    {
        return $this->container['allow_signing_radio_deselect_metadata'];
    }

    /**
     * Sets allow_signing_radio_deselect_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_signing_radio_deselect_metadata Metadata that indicates whether the `allowSigningRadioDeselect` property is editable.
     *
     * @return $this
     */
    public function setAllowSigningRadioDeselectMetadata($allow_signing_radio_deselect_metadata)
    {
        $this->container['allow_signing_radio_deselect_metadata'] = $allow_signing_radio_deselect_metadata;

        return $this;
    }

    /**
     * Gets allow_sign_now
     *
     * @return ?string
     */
    public function getAllowSignNow()
    {
        return $this->container['allow_sign_now'];
    }

    /**
     * Sets allow_sign_now
     *
     * @param ?string $allow_sign_now 
     *
     * @return $this
     */
    public function setAllowSignNow($allow_sign_now)
    {
        $this->container['allow_sign_now'] = $allow_sign_now;

        return $this;
    }

    /**
     * Gets allow_sign_now_metadata
     *
     * @return ?string
     */
    public function getAllowSignNowMetadata()
    {
        return $this->container['allow_sign_now_metadata'];
    }

    /**
     * Sets allow_sign_now_metadata
     *
     * @param ?string $allow_sign_now_metadata 
     *
     * @return $this
     */
    public function setAllowSignNowMetadata($allow_sign_now_metadata)
    {
        $this->container['allow_sign_now_metadata'] = $allow_sign_now_metadata;

        return $this;
    }

    /**
     * Gets allow_sms_delivery
     *
     * @return ?string
     */
    public function getAllowSmsDelivery()
    {
        return $this->container['allow_sms_delivery'];
    }

    /**
     * Sets allow_sms_delivery
     *
     * @param ?string $allow_sms_delivery 
     *
     * @return $this
     */
    public function setAllowSmsDelivery($allow_sms_delivery)
    {
        $this->container['allow_sms_delivery'] = $allow_sms_delivery;

        return $this;
    }

    /**
     * Gets allow_sms_delivery_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSmsDeliveryMetadata()
    {
        return $this->container['allow_sms_delivery_metadata'];
    }

    /**
     * Sets allow_sms_delivery_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_sms_delivery_metadata 
     *
     * @return $this
     */
    public function setAllowSmsDeliveryMetadata($allow_sms_delivery_metadata)
    {
        $this->container['allow_sms_delivery_metadata'] = $allow_sms_delivery_metadata;

        return $this;
    }

    /**
     * Gets allow_social_id_login
     *
     * @return ?string
     */
    public function getAllowSocialIdLogin()
    {
        return $this->container['allow_social_id_login'];
    }

    /**
     * Sets allow_social_id_login
     *
     * @param ?string $allow_social_id_login 
     *
     * @return $this
     */
    public function setAllowSocialIdLogin($allow_social_id_login)
    {
        $this->container['allow_social_id_login'] = $allow_social_id_login;

        return $this;
    }

    /**
     * Gets allow_social_id_login_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSocialIdLoginMetadata()
    {
        return $this->container['allow_social_id_login_metadata'];
    }

    /**
     * Sets allow_social_id_login_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_social_id_login_metadata Deprecated.
     *
     * @return $this
     */
    public function setAllowSocialIdLoginMetadata($allow_social_id_login_metadata)
    {
        $this->container['allow_social_id_login_metadata'] = $allow_social_id_login_metadata;

        return $this;
    }

    /**
     * Gets allow_supplemental_documents
     *
     * @return ?string
     */
    public function getAllowSupplementalDocuments()
    {
        return $this->container['allow_supplemental_documents'];
    }

    /**
     * Sets allow_supplemental_documents
     *
     * @param ?string $allow_supplemental_documents 
     *
     * @return $this
     */
    public function setAllowSupplementalDocuments($allow_supplemental_documents)
    {
        $this->container['allow_supplemental_documents'] = $allow_supplemental_documents;

        return $this;
    }

    /**
     * Gets allow_supplemental_documents_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSupplementalDocumentsMetadata()
    {
        return $this->container['allow_supplemental_documents_metadata'];
    }

    /**
     * Sets allow_supplemental_documents_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_supplemental_documents_metadata Metadata that indicates whether the `allowSupplementalDocuments` property is editable.
     *
     * @return $this
     */
    public function setAllowSupplementalDocumentsMetadata($allow_supplemental_documents_metadata)
    {
        $this->container['allow_supplemental_documents_metadata'] = $allow_supplemental_documents_metadata;

        return $this;
    }

    /**
     * Gets allow_third_party_electronic_notary
     *
     * @return ?string
     */
    public function getAllowThirdPartyElectronicNotary()
    {
        return $this->container['allow_third_party_electronic_notary'];
    }

    /**
     * Sets allow_third_party_electronic_notary
     *
     * @param ?string $allow_third_party_electronic_notary Account level flag that determines the availability to perform Third Party Notary (3PN) actions.
     *
     * @return $this
     */
    public function setAllowThirdPartyElectronicNotary($allow_third_party_electronic_notary)
    {
        $this->container['allow_third_party_electronic_notary'] = $allow_third_party_electronic_notary;

        return $this;
    }

    /**
     * Gets allow_third_party_electronic_notary_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowThirdPartyElectronicNotaryMetadata()
    {
        return $this->container['allow_third_party_electronic_notary_metadata'];
    }

    /**
     * Sets allow_third_party_electronic_notary_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_third_party_electronic_notary_metadata 
     *
     * @return $this
     */
    public function setAllowThirdPartyElectronicNotaryMetadata($allow_third_party_electronic_notary_metadata)
    {
        $this->container['allow_third_party_electronic_notary_metadata'] = $allow_third_party_electronic_notary_metadata;

        return $this;
    }

    /**
     * Gets allow_transactions_workspace
     *
     * @return ?string
     */
    public function getAllowTransactionsWorkspace()
    {
        return $this->container['allow_transactions_workspace'];
    }

    /**
     * Sets allow_transactions_workspace
     *
     * @param ?string $allow_transactions_workspace 
     *
     * @return $this
     */
    public function setAllowTransactionsWorkspace($allow_transactions_workspace)
    {
        $this->container['allow_transactions_workspace'] = $allow_transactions_workspace;

        return $this;
    }

    /**
     * Gets allow_transactions_workspace_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowTransactionsWorkspaceMetadata()
    {
        return $this->container['allow_transactions_workspace_metadata'];
    }

    /**
     * Sets allow_transactions_workspace_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_transactions_workspace_metadata 
     *
     * @return $this
     */
    public function setAllowTransactionsWorkspaceMetadata($allow_transactions_workspace_metadata)
    {
        $this->container['allow_transactions_workspace_metadata'] = $allow_transactions_workspace_metadata;

        return $this;
    }

    /**
     * Gets allow_transactions_workspace_original
     *
     * @return ?string
     */
    public function getAllowTransactionsWorkspaceOriginal()
    {
        return $this->container['allow_transactions_workspace_original'];
    }

    /**
     * Sets allow_transactions_workspace_original
     *
     * @param ?string $allow_transactions_workspace_original 
     *
     * @return $this
     */
    public function setAllowTransactionsWorkspaceOriginal($allow_transactions_workspace_original)
    {
        $this->container['allow_transactions_workspace_original'] = $allow_transactions_workspace_original;

        return $this;
    }

    /**
     * Gets allow_transactions_workspace_original_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowTransactionsWorkspaceOriginalMetadata()
    {
        return $this->container['allow_transactions_workspace_original_metadata'];
    }

    /**
     * Sets allow_transactions_workspace_original_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_transactions_workspace_original_metadata 
     *
     * @return $this
     */
    public function setAllowTransactionsWorkspaceOriginalMetadata($allow_transactions_workspace_original_metadata)
    {
        $this->container['allow_transactions_workspace_original_metadata'] = $allow_transactions_workspace_original_metadata;

        return $this;
    }

    /**
     * Gets allow_users_to_access_directory
     *
     * @return ?string
     */
    public function getAllowUsersToAccessDirectory()
    {
        return $this->container['allow_users_to_access_directory'];
    }

    /**
     * Sets allow_users_to_access_directory
     *
     * @param ?string $allow_users_to_access_directory 
     *
     * @return $this
     */
    public function setAllowUsersToAccessDirectory($allow_users_to_access_directory)
    {
        $this->container['allow_users_to_access_directory'] = $allow_users_to_access_directory;

        return $this;
    }

    /**
     * Gets allow_users_to_access_directory_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowUsersToAccessDirectoryMetadata()
    {
        return $this->container['allow_users_to_access_directory_metadata'];
    }

    /**
     * Sets allow_users_to_access_directory_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_users_to_access_directory_metadata 
     *
     * @return $this
     */
    public function setAllowUsersToAccessDirectoryMetadata($allow_users_to_access_directory_metadata)
    {
        $this->container['allow_users_to_access_directory_metadata'] = $allow_users_to_access_directory_metadata;

        return $this;
    }

    /**
     * Gets allow_value_insights
     *
     * @return ?string
     */
    public function getAllowValueInsights()
    {
        return $this->container['allow_value_insights'];
    }

    /**
     * Sets allow_value_insights
     *
     * @param ?string $allow_value_insights 
     *
     * @return $this
     */
    public function setAllowValueInsights($allow_value_insights)
    {
        $this->container['allow_value_insights'] = $allow_value_insights;

        return $this;
    }

    /**
     * Gets allow_value_insights_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowValueInsightsMetadata()
    {
        return $this->container['allow_value_insights_metadata'];
    }

    /**
     * Sets allow_value_insights_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_value_insights_metadata 
     *
     * @return $this
     */
    public function setAllowValueInsightsMetadata($allow_value_insights_metadata)
    {
        $this->container['allow_value_insights_metadata'] = $allow_value_insights_metadata;

        return $this;
    }

    /**
     * Gets allow_web_forms
     *
     * @return ?string
     */
    public function getAllowWebForms()
    {
        return $this->container['allow_web_forms'];
    }

    /**
     * Sets allow_web_forms
     *
     * @param ?string $allow_web_forms 
     *
     * @return $this
     */
    public function setAllowWebForms($allow_web_forms)
    {
        $this->container['allow_web_forms'] = $allow_web_forms;

        return $this;
    }

    /**
     * Gets allow_web_forms_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowWebFormsMetadata()
    {
        return $this->container['allow_web_forms_metadata'];
    }

    /**
     * Sets allow_web_forms_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_web_forms_metadata 
     *
     * @return $this
     */
    public function setAllowWebFormsMetadata($allow_web_forms_metadata)
    {
        $this->container['allow_web_forms_metadata'] = $allow_web_forms_metadata;

        return $this;
    }

    /**
     * Gets allow_whats_app_delivery
     *
     * @return ?string
     */
    public function getAllowWhatsAppDelivery()
    {
        return $this->container['allow_whats_app_delivery'];
    }

    /**
     * Sets allow_whats_app_delivery
     *
     * @param ?string $allow_whats_app_delivery 
     *
     * @return $this
     */
    public function setAllowWhatsAppDelivery($allow_whats_app_delivery)
    {
        $this->container['allow_whats_app_delivery'] = $allow_whats_app_delivery;

        return $this;
    }

    /**
     * Gets allow_whats_app_delivery_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowWhatsAppDeliveryMetadata()
    {
        return $this->container['allow_whats_app_delivery_metadata'];
    }

    /**
     * Sets allow_whats_app_delivery_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_whats_app_delivery_metadata 
     *
     * @return $this
     */
    public function setAllowWhatsAppDeliveryMetadata($allow_whats_app_delivery_metadata)
    {
        $this->container['allow_whats_app_delivery_metadata'] = $allow_whats_app_delivery_metadata;

        return $this;
    }

    /**
     * Gets anchor_population_scope
     *
     * @return ?string
     */
    public function getAnchorPopulationScope()
    {
        return $this->container['anchor_population_scope'];
    }

    /**
     * Sets anchor_population_scope
     *
     * @param ?string $anchor_population_scope 
     *
     * @return $this
     */
    public function setAnchorPopulationScope($anchor_population_scope)
    {
        $this->container['anchor_population_scope'] = $anchor_population_scope;

        return $this;
    }

    /**
     * Gets anchor_population_scope_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAnchorPopulationScopeMetadata()
    {
        return $this->container['anchor_population_scope_metadata'];
    }

    /**
     * Sets anchor_population_scope_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $anchor_population_scope_metadata Metadata that indicates whether the `anchorPopulationScope` property is editable.
     *
     * @return $this
     */
    public function setAnchorPopulationScopeMetadata($anchor_population_scope_metadata)
    {
        $this->container['anchor_population_scope_metadata'] = $anchor_population_scope_metadata;

        return $this;
    }

    /**
     * Gets anchor_tag_versioned_placement_enabled
     *
     * @return ?string
     */
    public function getAnchorTagVersionedPlacementEnabled()
    {
        return $this->container['anchor_tag_versioned_placement_enabled'];
    }

    /**
     * Sets anchor_tag_versioned_placement_enabled
     *
     * @param ?string $anchor_tag_versioned_placement_enabled 
     *
     * @return $this
     */
    public function setAnchorTagVersionedPlacementEnabled($anchor_tag_versioned_placement_enabled)
    {
        $this->container['anchor_tag_versioned_placement_enabled'] = $anchor_tag_versioned_placement_enabled;

        return $this;
    }

    /**
     * Gets anchor_tag_versioned_placement_metadata_enabled
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAnchorTagVersionedPlacementMetadataEnabled()
    {
        return $this->container['anchor_tag_versioned_placement_metadata_enabled'];
    }

    /**
     * Sets anchor_tag_versioned_placement_metadata_enabled
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $anchor_tag_versioned_placement_metadata_enabled 
     *
     * @return $this
     */
    public function setAnchorTagVersionedPlacementMetadataEnabled($anchor_tag_versioned_placement_metadata_enabled)
    {
        $this->container['anchor_tag_versioned_placement_metadata_enabled'] = $anchor_tag_versioned_placement_metadata_enabled;

        return $this;
    }

    /**
     * Gets attach_completed_envelope
     *
     * @return ?string
     */
    public function getAttachCompletedEnvelope()
    {
        return $this->container['attach_completed_envelope'];
    }

    /**
     * Sets attach_completed_envelope
     *
     * @param ?string $attach_completed_envelope 
     *
     * @return $this
     */
    public function setAttachCompletedEnvelope($attach_completed_envelope)
    {
        $this->container['attach_completed_envelope'] = $attach_completed_envelope;

        return $this;
    }

    /**
     * Gets attach_completed_envelope_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAttachCompletedEnvelopeMetadata()
    {
        return $this->container['attach_completed_envelope_metadata'];
    }

    /**
     * Sets attach_completed_envelope_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $attach_completed_envelope_metadata Metadata that indicates whether the `attachCompletedEnvelope` property is editable.
     *
     * @return $this
     */
    public function setAttachCompletedEnvelopeMetadata($attach_completed_envelope_metadata)
    {
        $this->container['attach_completed_envelope_metadata'] = $attach_completed_envelope_metadata;

        return $this;
    }

    /**
     * Gets authentication_check
     *
     * @return ?string
     */
    public function getAuthenticationCheck()
    {
        return $this->container['authentication_check'];
    }

    /**
     * Sets authentication_check
     *
     * @param ?string $authentication_check 
     *
     * @return $this
     */
    public function setAuthenticationCheck($authentication_check)
    {
        $this->container['authentication_check'] = $authentication_check;

        return $this;
    }

    /**
     * Gets authentication_check_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAuthenticationCheckMetadata()
    {
        return $this->container['authentication_check_metadata'];
    }

    /**
     * Sets authentication_check_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $authentication_check_metadata Metadata that indicates whether the `authenticationCheck` property is editable.
     *
     * @return $this
     */
    public function setAuthenticationCheckMetadata($authentication_check_metadata)
    {
        $this->container['authentication_check_metadata'] = $authentication_check_metadata;

        return $this;
    }

    /**
     * Gets auto_nav_rule
     *
     * @return ?string
     */
    public function getAutoNavRule()
    {
        return $this->container['auto_nav_rule'];
    }

    /**
     * Sets auto_nav_rule
     *
     * @param ?string $auto_nav_rule 
     *
     * @return $this
     */
    public function setAutoNavRule($auto_nav_rule)
    {
        $this->container['auto_nav_rule'] = $auto_nav_rule;

        return $this;
    }

    /**
     * Gets auto_nav_rule_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAutoNavRuleMetadata()
    {
        return $this->container['auto_nav_rule_metadata'];
    }

    /**
     * Sets auto_nav_rule_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $auto_nav_rule_metadata Metadata that indicates whether the `autoNavRule` property is editable.
     *
     * @return $this
     */
    public function setAutoNavRuleMetadata($auto_nav_rule_metadata)
    {
        $this->container['auto_nav_rule_metadata'] = $auto_nav_rule_metadata;

        return $this;
    }

    /**
     * Gets auto_provision_signer_account
     *
     * @return ?string
     */
    public function getAutoProvisionSignerAccount()
    {
        return $this->container['auto_provision_signer_account'];
    }

    /**
     * Sets auto_provision_signer_account
     *
     * @param ?string $auto_provision_signer_account 
     *
     * @return $this
     */
    public function setAutoProvisionSignerAccount($auto_provision_signer_account)
    {
        $this->container['auto_provision_signer_account'] = $auto_provision_signer_account;

        return $this;
    }

    /**
     * Gets auto_provision_signer_account_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAutoProvisionSignerAccountMetadata()
    {
        return $this->container['auto_provision_signer_account_metadata'];
    }

    /**
     * Sets auto_provision_signer_account_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $auto_provision_signer_account_metadata Metadata that indicates whether the `autoProvisionSignerAccount` property is editable.
     *
     * @return $this
     */
    public function setAutoProvisionSignerAccountMetadata($auto_provision_signer_account_metadata)
    {
        $this->container['auto_provision_signer_account_metadata'] = $auto_provision_signer_account_metadata;

        return $this;
    }

    /**
     * Gets bcc_email_archive
     *
     * @return ?string
     */
    public function getBccEmailArchive()
    {
        return $this->container['bcc_email_archive'];
    }

    /**
     * Sets bcc_email_archive
     *
     * @param ?string $bcc_email_archive 
     *
     * @return $this
     */
    public function setBccEmailArchive($bcc_email_archive)
    {
        $this->container['bcc_email_archive'] = $bcc_email_archive;

        return $this;
    }

    /**
     * Gets bcc_email_archive_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getBccEmailArchiveMetadata()
    {
        return $this->container['bcc_email_archive_metadata'];
    }

    /**
     * Sets bcc_email_archive_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $bcc_email_archive_metadata Metadata that indicates whether the `bccEmailArchive` property is editable.
     *
     * @return $this
     */
    public function setBccEmailArchiveMetadata($bcc_email_archive_metadata)
    {
        $this->container['bcc_email_archive_metadata'] = $bcc_email_archive_metadata;

        return $this;
    }

    /**
     * Gets beta_switch_configuration
     *
     * @return ?string
     */
    public function getBetaSwitchConfiguration()
    {
        return $this->container['beta_switch_configuration'];
    }

    /**
     * Sets beta_switch_configuration
     *
     * @param ?string $beta_switch_configuration 
     *
     * @return $this
     */
    public function setBetaSwitchConfiguration($beta_switch_configuration)
    {
        $this->container['beta_switch_configuration'] = $beta_switch_configuration;

        return $this;
    }

    /**
     * Gets beta_switch_configuration_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getBetaSwitchConfigurationMetadata()
    {
        return $this->container['beta_switch_configuration_metadata'];
    }

    /**
     * Sets beta_switch_configuration_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $beta_switch_configuration_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setBetaSwitchConfigurationMetadata($beta_switch_configuration_metadata)
    {
        $this->container['beta_switch_configuration_metadata'] = $beta_switch_configuration_metadata;

        return $this;
    }

    /**
     * Gets billing_address
     *
     * @return \DocuSign\eSign\Model\AddressInformation
     */
    public function getBillingAddress()
    {
        return $this->container['billing_address'];
    }

    /**
     * Sets billing_address
     *
     * @param \DocuSign\eSign\Model\AddressInformation $billing_address The billing address for the account.
     *
     * @return $this
     */
    public function setBillingAddress($billing_address)
    {
        $this->container['billing_address'] = $billing_address;

        return $this;
    }

    /**
     * Gets billing_address_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getBillingAddressMetadata()
    {
        return $this->container['billing_address_metadata'];
    }

    /**
     * Sets billing_address_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $billing_address_metadata Metadata that indicates whether the `billingAddress` property is editable.
     *
     * @return $this
     */
    public function setBillingAddressMetadata($billing_address_metadata)
    {
        $this->container['billing_address_metadata'] = $billing_address_metadata;

        return $this;
    }

    /**
     * Gets bulk_send
     *
     * @return ?string
     */
    public function getBulkSend()
    {
        return $this->container['bulk_send'];
    }

    /**
     * Sets bulk_send
     *
     * @param ?string $bulk_send 
     *
     * @return $this
     */
    public function setBulkSend($bulk_send)
    {
        $this->container['bulk_send'] = $bulk_send;

        return $this;
    }

    /**
     * Gets bulk_send_action_resend_limit
     *
     * @return ?string
     */
    public function getBulkSendActionResendLimit()
    {
        return $this->container['bulk_send_action_resend_limit'];
    }

    /**
     * Sets bulk_send_action_resend_limit
     *
     * @param ?string $bulk_send_action_resend_limit 
     *
     * @return $this
     */
    public function setBulkSendActionResendLimit($bulk_send_action_resend_limit)
    {
        $this->container['bulk_send_action_resend_limit'] = $bulk_send_action_resend_limit;

        return $this;
    }

    /**
     * Gets bulk_send_max_copies_in_batch
     *
     * @return ?string
     */
    public function getBulkSendMaxCopiesInBatch()
    {
        return $this->container['bulk_send_max_copies_in_batch'];
    }

    /**
     * Sets bulk_send_max_copies_in_batch
     *
     * @param ?string $bulk_send_max_copies_in_batch 
     *
     * @return $this
     */
    public function setBulkSendMaxCopiesInBatch($bulk_send_max_copies_in_batch)
    {
        $this->container['bulk_send_max_copies_in_batch'] = $bulk_send_max_copies_in_batch;

        return $this;
    }

    /**
     * Gets bulk_send_max_unprocessed_envelopes_count
     *
     * @return ?string
     */
    public function getBulkSendMaxUnprocessedEnvelopesCount()
    {
        return $this->container['bulk_send_max_unprocessed_envelopes_count'];
    }

    /**
     * Sets bulk_send_max_unprocessed_envelopes_count
     *
     * @param ?string $bulk_send_max_unprocessed_envelopes_count 
     *
     * @return $this
     */
    public function setBulkSendMaxUnprocessedEnvelopesCount($bulk_send_max_unprocessed_envelopes_count)
    {
        $this->container['bulk_send_max_unprocessed_envelopes_count'] = $bulk_send_max_unprocessed_envelopes_count;

        return $this;
    }

    /**
     * Gets bulk_send_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getBulkSendMetadata()
    {
        return $this->container['bulk_send_metadata'];
    }

    /**
     * Sets bulk_send_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $bulk_send_metadata Metadata that indicates whether the `bulkSend` property is editable.
     *
     * @return $this
     */
    public function setBulkSendMetadata($bulk_send_metadata)
    {
        $this->container['bulk_send_metadata'] = $bulk_send_metadata;

        return $this;
    }

    /**
     * Gets can_self_brand_send
     *
     * @return ?string
     */
    public function getCanSelfBrandSend()
    {
        return $this->container['can_self_brand_send'];
    }

    /**
     * Sets can_self_brand_send
     *
     * @param ?string $can_self_brand_send 
     *
     * @return $this
     */
    public function setCanSelfBrandSend($can_self_brand_send)
    {
        $this->container['can_self_brand_send'] = $can_self_brand_send;

        return $this;
    }

    /**
     * Gets can_self_brand_send_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCanSelfBrandSendMetadata()
    {
        return $this->container['can_self_brand_send_metadata'];
    }

    /**
     * Sets can_self_brand_send_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $can_self_brand_send_metadata Metadata that indicates whether the `canSelfBrandSend` property is editable.
     *
     * @return $this
     */
    public function setCanSelfBrandSendMetadata($can_self_brand_send_metadata)
    {
        $this->container['can_self_brand_send_metadata'] = $can_self_brand_send_metadata;

        return $this;
    }

    /**
     * Gets can_self_brand_sign
     *
     * @return ?string
     */
    public function getCanSelfBrandSign()
    {
        return $this->container['can_self_brand_sign'];
    }

    /**
     * Sets can_self_brand_sign
     *
     * @param ?string $can_self_brand_sign 
     *
     * @return $this
     */
    public function setCanSelfBrandSign($can_self_brand_sign)
    {
        $this->container['can_self_brand_sign'] = $can_self_brand_sign;

        return $this;
    }

    /**
     * Gets can_self_brand_sign_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCanSelfBrandSignMetadata()
    {
        return $this->container['can_self_brand_sign_metadata'];
    }

    /**
     * Sets can_self_brand_sign_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $can_self_brand_sign_metadata Metadata that indicates whether the `canSelfBrandSign` property is editable.
     *
     * @return $this
     */
    public function setCanSelfBrandSignMetadata($can_self_brand_sign_metadata)
    {
        $this->container['can_self_brand_sign_metadata'] = $can_self_brand_sign_metadata;

        return $this;
    }

    /**
     * Gets can_use_salesforce_o_auth
     *
     * @return ?string
     */
    public function getCanUseSalesforceOAuth()
    {
        return $this->container['can_use_salesforce_o_auth'];
    }

    /**
     * Sets can_use_salesforce_o_auth
     *
     * @param ?string $can_use_salesforce_o_auth 
     *
     * @return $this
     */
    public function setCanUseSalesforceOAuth($can_use_salesforce_o_auth)
    {
        $this->container['can_use_salesforce_o_auth'] = $can_use_salesforce_o_auth;

        return $this;
    }

    /**
     * Gets can_use_salesforce_o_auth_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCanUseSalesforceOAuthMetadata()
    {
        return $this->container['can_use_salesforce_o_auth_metadata'];
    }

    /**
     * Sets can_use_salesforce_o_auth_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $can_use_salesforce_o_auth_metadata 
     *
     * @return $this
     */
    public function setCanUseSalesforceOAuthMetadata($can_use_salesforce_o_auth_metadata)
    {
        $this->container['can_use_salesforce_o_auth_metadata'] = $can_use_salesforce_o_auth_metadata;

        return $this;
    }

    /**
     * Gets capture_voice_recording
     *
     * @return ?string
     */
    public function getCaptureVoiceRecording()
    {
        return $this->container['capture_voice_recording'];
    }

    /**
     * Sets capture_voice_recording
     *
     * @param ?string $capture_voice_recording 
     *
     * @return $this
     */
    public function setCaptureVoiceRecording($capture_voice_recording)
    {
        $this->container['capture_voice_recording'] = $capture_voice_recording;

        return $this;
    }

    /**
     * Gets capture_voice_recording_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCaptureVoiceRecordingMetadata()
    {
        return $this->container['capture_voice_recording_metadata'];
    }

    /**
     * Sets capture_voice_recording_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $capture_voice_recording_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setCaptureVoiceRecordingMetadata($capture_voice_recording_metadata)
    {
        $this->container['capture_voice_recording_metadata'] = $capture_voice_recording_metadata;

        return $this;
    }

    /**
     * Gets cfr21_simplified_signing_enabled
     *
     * @return ?string
     */
    public function getCfr21SimplifiedSigningEnabled()
    {
        return $this->container['cfr21_simplified_signing_enabled'];
    }

    /**
     * Sets cfr21_simplified_signing_enabled
     *
     * @param ?string $cfr21_simplified_signing_enabled 
     *
     * @return $this
     */
    public function setCfr21SimplifiedSigningEnabled($cfr21_simplified_signing_enabled)
    {
        $this->container['cfr21_simplified_signing_enabled'] = $cfr21_simplified_signing_enabled;

        return $this;
    }

    /**
     * Gets cfr21_simplified_signing_enabled_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCfr21SimplifiedSigningEnabledMetadata()
    {
        return $this->container['cfr21_simplified_signing_enabled_metadata'];
    }

    /**
     * Sets cfr21_simplified_signing_enabled_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $cfr21_simplified_signing_enabled_metadata 
     *
     * @return $this
     */
    public function setCfr21SimplifiedSigningEnabledMetadata($cfr21_simplified_signing_enabled_metadata)
    {
        $this->container['cfr21_simplified_signing_enabled_metadata'] = $cfr21_simplified_signing_enabled_metadata;

        return $this;
    }

    /**
     * Gets cfr_use_wide_image
     *
     * @return ?string
     */
    public function getCfrUseWideImage()
    {
        return $this->container['cfr_use_wide_image'];
    }

    /**
     * Sets cfr_use_wide_image
     *
     * @param ?string $cfr_use_wide_image 
     *
     * @return $this
     */
    public function setCfrUseWideImage($cfr_use_wide_image)
    {
        $this->container['cfr_use_wide_image'] = $cfr_use_wide_image;

        return $this;
    }

    /**
     * Gets cfr_use_wide_image_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCfrUseWideImageMetadata()
    {
        return $this->container['cfr_use_wide_image_metadata'];
    }

    /**
     * Sets cfr_use_wide_image_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $cfr_use_wide_image_metadata Metadata that indicates whether the `cfrUseWideImage` property is editable.
     *
     * @return $this
     */
    public function setCfrUseWideImageMetadata($cfr_use_wide_image_metadata)
    {
        $this->container['cfr_use_wide_image_metadata'] = $cfr_use_wide_image_metadata;

        return $this;
    }

    /**
     * Gets check_for_multiple_admins_on_account
     *
     * @return ?string
     */
    public function getCheckForMultipleAdminsOnAccount()
    {
        return $this->container['check_for_multiple_admins_on_account'];
    }

    /**
     * Sets check_for_multiple_admins_on_account
     *
     * @param ?string $check_for_multiple_admins_on_account 
     *
     * @return $this
     */
    public function setCheckForMultipleAdminsOnAccount($check_for_multiple_admins_on_account)
    {
        $this->container['check_for_multiple_admins_on_account'] = $check_for_multiple_admins_on_account;

        return $this;
    }

    /**
     * Gets check_for_multiple_admins_on_account_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCheckForMultipleAdminsOnAccountMetadata()
    {
        return $this->container['check_for_multiple_admins_on_account_metadata'];
    }

    /**
     * Sets check_for_multiple_admins_on_account_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $check_for_multiple_admins_on_account_metadata Metadata that indicates whether the `checkForMultipleAdminsOnAccount` property is editable.
     *
     * @return $this
     */
    public function setCheckForMultipleAdminsOnAccountMetadata($check_for_multiple_admins_on_account_metadata)
    {
        $this->container['check_for_multiple_admins_on_account_metadata'] = $check_for_multiple_admins_on_account_metadata;

        return $this;
    }

    /**
     * Gets chrome_signature_enabled
     *
     * @return ?string
     */
    public function getChromeSignatureEnabled()
    {
        return $this->container['chrome_signature_enabled'];
    }

    /**
     * Sets chrome_signature_enabled
     *
     * @param ?string $chrome_signature_enabled 
     *
     * @return $this
     */
    public function setChromeSignatureEnabled($chrome_signature_enabled)
    {
        $this->container['chrome_signature_enabled'] = $chrome_signature_enabled;

        return $this;
    }

    /**
     * Gets chrome_signature_enabled_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getChromeSignatureEnabledMetadata()
    {
        return $this->container['chrome_signature_enabled_metadata'];
    }

    /**
     * Sets chrome_signature_enabled_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $chrome_signature_enabled_metadata Metadata that indicates whether the `chromeSignatureEnabled` property is editable.
     *
     * @return $this
     */
    public function setChromeSignatureEnabledMetadata($chrome_signature_enabled_metadata)
    {
        $this->container['chrome_signature_enabled_metadata'] = $chrome_signature_enabled_metadata;

        return $this;
    }

    /**
     * Gets comment_email_show_message_text
     *
     * @return ?string
     */
    public function getCommentEmailShowMessageText()
    {
        return $this->container['comment_email_show_message_text'];
    }

    /**
     * Sets comment_email_show_message_text
     *
     * @param ?string $comment_email_show_message_text 
     *
     * @return $this
     */
    public function setCommentEmailShowMessageText($comment_email_show_message_text)
    {
        $this->container['comment_email_show_message_text'] = $comment_email_show_message_text;

        return $this;
    }

    /**
     * Gets comment_email_show_message_text_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCommentEmailShowMessageTextMetadata()
    {
        return $this->container['comment_email_show_message_text_metadata'];
    }

    /**
     * Sets comment_email_show_message_text_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $comment_email_show_message_text_metadata Metadata that indicates whether the `commentEmailShowMessageText` property is editable.
     *
     * @return $this
     */
    public function setCommentEmailShowMessageTextMetadata($comment_email_show_message_text_metadata)
    {
        $this->container['comment_email_show_message_text_metadata'] = $comment_email_show_message_text_metadata;

        return $this;
    }

    /**
     * Gets comments_allow_envelope_override
     *
     * @return ?string
     */
    public function getCommentsAllowEnvelopeOverride()
    {
        return $this->container['comments_allow_envelope_override'];
    }

    /**
     * Sets comments_allow_envelope_override
     *
     * @param ?string $comments_allow_envelope_override 
     *
     * @return $this
     */
    public function setCommentsAllowEnvelopeOverride($comments_allow_envelope_override)
    {
        $this->container['comments_allow_envelope_override'] = $comments_allow_envelope_override;

        return $this;
    }

    /**
     * Gets comments_allow_envelope_override_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCommentsAllowEnvelopeOverrideMetadata()
    {
        return $this->container['comments_allow_envelope_override_metadata'];
    }

    /**
     * Sets comments_allow_envelope_override_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $comments_allow_envelope_override_metadata Metadata that indicates whether the `commentsAllowEnvelopeOverride` property is editable.
     *
     * @return $this
     */
    public function setCommentsAllowEnvelopeOverrideMetadata($comments_allow_envelope_override_metadata)
    {
        $this->container['comments_allow_envelope_override_metadata'] = $comments_allow_envelope_override_metadata;

        return $this;
    }

    /**
     * Gets conditional_fields_enabled
     *
     * @return ?string
     */
    public function getConditionalFieldsEnabled()
    {
        return $this->container['conditional_fields_enabled'];
    }

    /**
     * Sets conditional_fields_enabled
     *
     * @param ?string $conditional_fields_enabled 
     *
     * @return $this
     */
    public function setConditionalFieldsEnabled($conditional_fields_enabled)
    {
        $this->container['conditional_fields_enabled'] = $conditional_fields_enabled;

        return $this;
    }

    /**
     * Gets conditional_fields_enabled_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getConditionalFieldsEnabledMetadata()
    {
        return $this->container['conditional_fields_enabled_metadata'];
    }

    /**
     * Sets conditional_fields_enabled_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $conditional_fields_enabled_metadata Metadata that indicates whether the `conditionalFieldsEnabled` property is editable.
     *
     * @return $this
     */
    public function setConditionalFieldsEnabledMetadata($conditional_fields_enabled_metadata)
    {
        $this->container['conditional_fields_enabled_metadata'] = $conditional_fields_enabled_metadata;

        return $this;
    }

    /**
     * Gets consumer_disclosure_frequency
     *
     * @return ?string
     */
    public function getConsumerDisclosureFrequency()
    {
        return $this->container['consumer_disclosure_frequency'];
    }

    /**
     * Sets consumer_disclosure_frequency
     *
     * @param ?string $consumer_disclosure_frequency 
     *
     * @return $this
     */
    public function setConsumerDisclosureFrequency($consumer_disclosure_frequency)
    {
        $this->container['consumer_disclosure_frequency'] = $consumer_disclosure_frequency;

        return $this;
    }

    /**
     * Gets consumer_disclosure_frequency_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getConsumerDisclosureFrequencyMetadata()
    {
        return $this->container['consumer_disclosure_frequency_metadata'];
    }

    /**
     * Sets consumer_disclosure_frequency_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $consumer_disclosure_frequency_metadata Metadata that indicates whether the `consumerDisclosureFrequency` property is editable.
     *
     * @return $this
     */
    public function setConsumerDisclosureFrequencyMetadata($consumer_disclosure_frequency_metadata)
    {
        $this->container['consumer_disclosure_frequency_metadata'] = $consumer_disclosure_frequency_metadata;

        return $this;
    }

    /**
     * Gets convert_pdf_fields
     *
     * @return ?string
     */
    public function getConvertPdfFields()
    {
        return $this->container['convert_pdf_fields'];
    }

    /**
     * Sets convert_pdf_fields
     *
     * @param ?string $convert_pdf_fields 
     *
     * @return $this
     */
    public function setConvertPdfFields($convert_pdf_fields)
    {
        $this->container['convert_pdf_fields'] = $convert_pdf_fields;

        return $this;
    }

    /**
     * Gets convert_pdf_fields_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getConvertPdfFieldsMetadata()
    {
        return $this->container['convert_pdf_fields_metadata'];
    }

    /**
     * Sets convert_pdf_fields_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $convert_pdf_fields_metadata Metadata that indicates whether the `convertPdfFields` property is editable.
     *
     * @return $this
     */
    public function setConvertPdfFieldsMetadata($convert_pdf_fields_metadata)
    {
        $this->container['convert_pdf_fields_metadata'] = $convert_pdf_fields_metadata;

        return $this;
    }

    /**
     * Gets data_population_scope
     *
     * @return ?string
     */
    public function getDataPopulationScope()
    {
        return $this->container['data_population_scope'];
    }

    /**
     * Sets data_population_scope
     *
     * @param ?string $data_population_scope 
     *
     * @return $this
     */
    public function setDataPopulationScope($data_population_scope)
    {
        $this->container['data_population_scope'] = $data_population_scope;

        return $this;
    }

    /**
     * Gets data_population_scope_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDataPopulationScopeMetadata()
    {
        return $this->container['data_population_scope_metadata'];
    }

    /**
     * Sets data_population_scope_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $data_population_scope_metadata Metadata that indicates whether the `dataPopulationScope` property is editable.
     *
     * @return $this
     */
    public function setDataPopulationScopeMetadata($data_population_scope_metadata)
    {
        $this->container['data_population_scope_metadata'] = $data_population_scope_metadata;

        return $this;
    }

    /**
     * Gets default_to_advanced_envelopes_filter_form
     *
     * @return ?string
     */
    public function getDefaultToAdvancedEnvelopesFilterForm()
    {
        return $this->container['default_to_advanced_envelopes_filter_form'];
    }

    /**
     * Sets default_to_advanced_envelopes_filter_form
     *
     * @param ?string $default_to_advanced_envelopes_filter_form 
     *
     * @return $this
     */
    public function setDefaultToAdvancedEnvelopesFilterForm($default_to_advanced_envelopes_filter_form)
    {
        $this->container['default_to_advanced_envelopes_filter_form'] = $default_to_advanced_envelopes_filter_form;

        return $this;
    }

    /**
     * Gets default_to_advanced_envelopes_filter_form_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDefaultToAdvancedEnvelopesFilterFormMetadata()
    {
        return $this->container['default_to_advanced_envelopes_filter_form_metadata'];
    }

    /**
     * Sets default_to_advanced_envelopes_filter_form_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $default_to_advanced_envelopes_filter_form_metadata 
     *
     * @return $this
     */
    public function setDefaultToAdvancedEnvelopesFilterFormMetadata($default_to_advanced_envelopes_filter_form_metadata)
    {
        $this->container['default_to_advanced_envelopes_filter_form_metadata'] = $default_to_advanced_envelopes_filter_form_metadata;

        return $this;
    }

    /**
     * Gets disable_auto_template_matching
     *
     * @return ?string
     */
    public function getDisableAutoTemplateMatching()
    {
        return $this->container['disable_auto_template_matching'];
    }

    /**
     * Sets disable_auto_template_matching
     *
     * @param ?string $disable_auto_template_matching 
     *
     * @return $this
     */
    public function setDisableAutoTemplateMatching($disable_auto_template_matching)
    {
        $this->container['disable_auto_template_matching'] = $disable_auto_template_matching;

        return $this;
    }

    /**
     * Gets disable_auto_template_matching_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDisableAutoTemplateMatchingMetadata()
    {
        return $this->container['disable_auto_template_matching_metadata'];
    }

    /**
     * Sets disable_auto_template_matching_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $disable_auto_template_matching_metadata 
     *
     * @return $this
     */
    public function setDisableAutoTemplateMatchingMetadata($disable_auto_template_matching_metadata)
    {
        $this->container['disable_auto_template_matching_metadata'] = $disable_auto_template_matching_metadata;

        return $this;
    }

    /**
     * Gets disable_mobile_app
     *
     * @return ?string
     */
    public function getDisableMobileApp()
    {
        return $this->container['disable_mobile_app'];
    }

    /**
     * Sets disable_mobile_app
     *
     * @param ?string $disable_mobile_app 
     *
     * @return $this
     */
    public function setDisableMobileApp($disable_mobile_app)
    {
        $this->container['disable_mobile_app'] = $disable_mobile_app;

        return $this;
    }

    /**
     * Gets disable_mobile_app_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDisableMobileAppMetadata()
    {
        return $this->container['disable_mobile_app_metadata'];
    }

    /**
     * Sets disable_mobile_app_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $disable_mobile_app_metadata Metadata that indicates whether the `disableMobileApp` property is editable.
     *
     * @return $this
     */
    public function setDisableMobileAppMetadata($disable_mobile_app_metadata)
    {
        $this->container['disable_mobile_app_metadata'] = $disable_mobile_app_metadata;

        return $this;
    }

    /**
     * Gets disable_mobile_push_notifications
     *
     * @return ?string
     */
    public function getDisableMobilePushNotifications()
    {
        return $this->container['disable_mobile_push_notifications'];
    }

    /**
     * Sets disable_mobile_push_notifications
     *
     * @param ?string $disable_mobile_push_notifications 
     *
     * @return $this
     */
    public function setDisableMobilePushNotifications($disable_mobile_push_notifications)
    {
        $this->container['disable_mobile_push_notifications'] = $disable_mobile_push_notifications;

        return $this;
    }

    /**
     * Gets disable_mobile_push_notifications_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDisableMobilePushNotificationsMetadata()
    {
        return $this->container['disable_mobile_push_notifications_metadata'];
    }

    /**
     * Sets disable_mobile_push_notifications_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $disable_mobile_push_notifications_metadata Metadata that indicates whether the `disableMobilePushNotifications` property is editable.
     *
     * @return $this
     */
    public function setDisableMobilePushNotificationsMetadata($disable_mobile_push_notifications_metadata)
    {
        $this->container['disable_mobile_push_notifications_metadata'] = $disable_mobile_push_notifications_metadata;

        return $this;
    }

    /**
     * Gets disable_mobile_sending
     *
     * @return ?string
     */
    public function getDisableMobileSending()
    {
        return $this->container['disable_mobile_sending'];
    }

    /**
     * Sets disable_mobile_sending
     *
     * @param ?string $disable_mobile_sending 
     *
     * @return $this
     */
    public function setDisableMobileSending($disable_mobile_sending)
    {
        $this->container['disable_mobile_sending'] = $disable_mobile_sending;

        return $this;
    }

    /**
     * Gets disable_mobile_sending_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDisableMobileSendingMetadata()
    {
        return $this->container['disable_mobile_sending_metadata'];
    }

    /**
     * Sets disable_mobile_sending_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $disable_mobile_sending_metadata Metadata that indicates whether the `disableMobileSending` property is editable.
     *
     * @return $this
     */
    public function setDisableMobileSendingMetadata($disable_mobile_sending_metadata)
    {
        $this->container['disable_mobile_sending_metadata'] = $disable_mobile_sending_metadata;

        return $this;
    }

    /**
     * Gets disable_multiple_sessions
     *
     * @return ?string
     */
    public function getDisableMultipleSessions()
    {
        return $this->container['disable_multiple_sessions'];
    }

    /**
     * Sets disable_multiple_sessions
     *
     * @param ?string $disable_multiple_sessions 
     *
     * @return $this
     */
    public function setDisableMultipleSessions($disable_multiple_sessions)
    {
        $this->container['disable_multiple_sessions'] = $disable_multiple_sessions;

        return $this;
    }

    /**
     * Gets disable_multiple_sessions_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDisableMultipleSessionsMetadata()
    {
        return $this->container['disable_multiple_sessions_metadata'];
    }

    /**
     * Sets disable_multiple_sessions_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $disable_multiple_sessions_metadata Metadata that indicates whether the `disableMultipleSessions` property is editable.
     *
     * @return $this
     */
    public function setDisableMultipleSessionsMetadata($disable_multiple_sessions_metadata)
    {
        $this->container['disable_multiple_sessions_metadata'] = $disable_multiple_sessions_metadata;

        return $this;
    }

    /**
     * Gets disable_purge_notifications_for_sender_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDisablePurgeNotificationsForSenderMetadata()
    {
        return $this->container['disable_purge_notifications_for_sender_metadata'];
    }

    /**
     * Sets disable_purge_notifications_for_sender_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $disable_purge_notifications_for_sender_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setDisablePurgeNotificationsForSenderMetadata($disable_purge_notifications_for_sender_metadata)
    {
        $this->container['disable_purge_notifications_for_sender_metadata'] = $disable_purge_notifications_for_sender_metadata;

        return $this;
    }

    /**
     * Gets disable_signer_cert_view
     *
     * @return ?string
     */
    public function getDisableSignerCertView()
    {
        return $this->container['disable_signer_cert_view'];
    }

    /**
     * Sets disable_signer_cert_view
     *
     * @param ?string $disable_signer_cert_view 
     *
     * @return $this
     */
    public function setDisableSignerCertView($disable_signer_cert_view)
    {
        $this->container['disable_signer_cert_view'] = $disable_signer_cert_view;

        return $this;
    }

    /**
     * Gets disable_signer_cert_view_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDisableSignerCertViewMetadata()
    {
        return $this->container['disable_signer_cert_view_metadata'];
    }

    /**
     * Sets disable_signer_cert_view_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $disable_signer_cert_view_metadata Metadata that indicates whether the `disableSignerCertView` property is editable.
     *
     * @return $this
     */
    public function setDisableSignerCertViewMetadata($disable_signer_cert_view_metadata)
    {
        $this->container['disable_signer_cert_view_metadata'] = $disable_signer_cert_view_metadata;

        return $this;
    }

    /**
     * Gets disable_signer_history_view
     *
     * @return ?string
     */
    public function getDisableSignerHistoryView()
    {
        return $this->container['disable_signer_history_view'];
    }

    /**
     * Sets disable_signer_history_view
     *
     * @param ?string $disable_signer_history_view 
     *
     * @return $this
     */
    public function setDisableSignerHistoryView($disable_signer_history_view)
    {
        $this->container['disable_signer_history_view'] = $disable_signer_history_view;

        return $this;
    }

    /**
     * Gets disable_signer_history_view_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDisableSignerHistoryViewMetadata()
    {
        return $this->container['disable_signer_history_view_metadata'];
    }

    /**
     * Sets disable_signer_history_view_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $disable_signer_history_view_metadata Metadata that indicates whether the `disableSignerHistoryView` property is editable.
     *
     * @return $this
     */
    public function setDisableSignerHistoryViewMetadata($disable_signer_history_view_metadata)
    {
        $this->container['disable_signer_history_view_metadata'] = $disable_signer_history_view_metadata;

        return $this;
    }

    /**
     * Gets disable_style_signature
     *
     * @return ?string
     */
    public function getDisableStyleSignature()
    {
        return $this->container['disable_style_signature'];
    }

    /**
     * Sets disable_style_signature
     *
     * @param ?string $disable_style_signature 
     *
     * @return $this
     */
    public function setDisableStyleSignature($disable_style_signature)
    {
        $this->container['disable_style_signature'] = $disable_style_signature;

        return $this;
    }

    /**
     * Gets disable_style_signature_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDisableStyleSignatureMetadata()
    {
        return $this->container['disable_style_signature_metadata'];
    }

    /**
     * Sets disable_style_signature_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $disable_style_signature_metadata Metadata that indicates whether the `disableStyleSignature` property is editable.
     *
     * @return $this
     */
    public function setDisableStyleSignatureMetadata($disable_style_signature_metadata)
    {
        $this->container['disable_style_signature_metadata'] = $disable_style_signature_metadata;

        return $this;
    }

    /**
     * Gets disable_upload_signature
     *
     * @return ?string
     */
    public function getDisableUploadSignature()
    {
        return $this->container['disable_upload_signature'];
    }

    /**
     * Sets disable_upload_signature
     *
     * @param ?string $disable_upload_signature 
     *
     * @return $this
     */
    public function setDisableUploadSignature($disable_upload_signature)
    {
        $this->container['disable_upload_signature'] = $disable_upload_signature;

        return $this;
    }

    /**
     * Gets disable_upload_signature_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDisableUploadSignatureMetadata()
    {
        return $this->container['disable_upload_signature_metadata'];
    }

    /**
     * Sets disable_upload_signature_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $disable_upload_signature_metadata Metadata that indicates whether the `disableUploadSignature` property is editable.
     *
     * @return $this
     */
    public function setDisableUploadSignatureMetadata($disable_upload_signature_metadata)
    {
        $this->container['disable_upload_signature_metadata'] = $disable_upload_signature_metadata;

        return $this;
    }

    /**
     * Gets disable_user_sharing
     *
     * @return ?string
     */
    public function getDisableUserSharing()
    {
        return $this->container['disable_user_sharing'];
    }

    /**
     * Sets disable_user_sharing
     *
     * @param ?string $disable_user_sharing 
     *
     * @return $this
     */
    public function setDisableUserSharing($disable_user_sharing)
    {
        $this->container['disable_user_sharing'] = $disable_user_sharing;

        return $this;
    }

    /**
     * Gets disable_user_sharing_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDisableUserSharingMetadata()
    {
        return $this->container['disable_user_sharing_metadata'];
    }

    /**
     * Sets disable_user_sharing_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $disable_user_sharing_metadata Metadata that indicates whether the `disableUserSharing` property is editable.
     *
     * @return $this
     */
    public function setDisableUserSharingMetadata($disable_user_sharing_metadata)
    {
        $this->container['disable_user_sharing_metadata'] = $disable_user_sharing_metadata;

        return $this;
    }

    /**
     * Gets display_beta_switch
     *
     * @return ?string
     */
    public function getDisplayBetaSwitch()
    {
        return $this->container['display_beta_switch'];
    }

    /**
     * Sets display_beta_switch
     *
     * @param ?string $display_beta_switch 
     *
     * @return $this
     */
    public function setDisplayBetaSwitch($display_beta_switch)
    {
        $this->container['display_beta_switch'] = $display_beta_switch;

        return $this;
    }

    /**
     * Gets display_beta_switch_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDisplayBetaSwitchMetadata()
    {
        return $this->container['display_beta_switch_metadata'];
    }

    /**
     * Sets display_beta_switch_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $display_beta_switch_metadata Metadata that indicates whether the `displayBetaSwitch` property is editable.
     *
     * @return $this
     */
    public function setDisplayBetaSwitchMetadata($display_beta_switch_metadata)
    {
        $this->container['display_beta_switch_metadata'] = $display_beta_switch_metadata;

        return $this;
    }

    /**
     * Gets document_conversion_restrictions
     *
     * @return ?string
     */
    public function getDocumentConversionRestrictions()
    {
        return $this->container['document_conversion_restrictions'];
    }

    /**
     * Sets document_conversion_restrictions
     *
     * @param ?string $document_conversion_restrictions 
     *
     * @return $this
     */
    public function setDocumentConversionRestrictions($document_conversion_restrictions)
    {
        $this->container['document_conversion_restrictions'] = $document_conversion_restrictions;

        return $this;
    }

    /**
     * Gets document_conversion_restrictions_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDocumentConversionRestrictionsMetadata()
    {
        return $this->container['document_conversion_restrictions_metadata'];
    }

    /**
     * Sets document_conversion_restrictions_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $document_conversion_restrictions_metadata Metadata that indicates whether the `documentConversionRestrictions` property is editable.
     *
     * @return $this
     */
    public function setDocumentConversionRestrictionsMetadata($document_conversion_restrictions_metadata)
    {
        $this->container['document_conversion_restrictions_metadata'] = $document_conversion_restrictions_metadata;

        return $this;
    }

    /**
     * Gets document_retention
     *
     * @return ?string
     */
    public function getDocumentRetention()
    {
        return $this->container['document_retention'];
    }

    /**
     * Sets document_retention
     *
     * @param ?string $document_retention 
     *
     * @return $this
     */
    public function setDocumentRetention($document_retention)
    {
        $this->container['document_retention'] = $document_retention;

        return $this;
    }

    /**
     * Gets document_retention_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDocumentRetentionMetadata()
    {
        return $this->container['document_retention_metadata'];
    }

    /**
     * Sets document_retention_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $document_retention_metadata Metadata that indicates whether the `documentRetention` property is editable.
     *
     * @return $this
     */
    public function setDocumentRetentionMetadata($document_retention_metadata)
    {
        $this->container['document_retention_metadata'] = $document_retention_metadata;

        return $this;
    }

    /**
     * Gets document_retention_purge_tabs
     *
     * @return ?string
     */
    public function getDocumentRetentionPurgeTabs()
    {
        return $this->container['document_retention_purge_tabs'];
    }

    /**
     * Sets document_retention_purge_tabs
     *
     * @param ?string $document_retention_purge_tabs 
     *
     * @return $this
     */
    public function setDocumentRetentionPurgeTabs($document_retention_purge_tabs)
    {
        $this->container['document_retention_purge_tabs'] = $document_retention_purge_tabs;

        return $this;
    }

    /**
     * Gets document_visibility
     *
     * @return ?string
     */
    public function getDocumentVisibility()
    {
        return $this->container['document_visibility'];
    }

    /**
     * Sets document_visibility
     *
     * @param ?string $document_visibility 
     *
     * @return $this
     */
    public function setDocumentVisibility($document_visibility)
    {
        $this->container['document_visibility'] = $document_visibility;

        return $this;
    }

    /**
     * Gets document_visibility_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDocumentVisibilityMetadata()
    {
        return $this->container['document_visibility_metadata'];
    }

    /**
     * Sets document_visibility_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $document_visibility_metadata Metadata that indicates whether the `documentVisibility` property is editable.
     *
     * @return $this
     */
    public function setDocumentVisibilityMetadata($document_visibility_metadata)
    {
        $this->container['document_visibility_metadata'] = $document_visibility_metadata;

        return $this;
    }

    /**
     * Gets draft_envelope_retention
     *
     * @return ?string
     */
    public function getDraftEnvelopeRetention()
    {
        return $this->container['draft_envelope_retention'];
    }

    /**
     * Sets draft_envelope_retention
     *
     * @param ?string $draft_envelope_retention 
     *
     * @return $this
     */
    public function setDraftEnvelopeRetention($draft_envelope_retention)
    {
        $this->container['draft_envelope_retention'] = $draft_envelope_retention;

        return $this;
    }

    /**
     * Gets draft_envelope_retention_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDraftEnvelopeRetentionMetadata()
    {
        return $this->container['draft_envelope_retention_metadata'];
    }

    /**
     * Sets draft_envelope_retention_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $draft_envelope_retention_metadata 
     *
     * @return $this
     */
    public function setDraftEnvelopeRetentionMetadata($draft_envelope_retention_metadata)
    {
        $this->container['draft_envelope_retention_metadata'] = $draft_envelope_retention_metadata;

        return $this;
    }

    /**
     * Gets dss_enable_provisioning_pen_configuration_radmin_option
     *
     * @return ?string
     */
    public function getDssEnableProvisioningPenConfigurationRadminOption()
    {
        return $this->container['dss_enable_provisioning_pen_configuration_radmin_option'];
    }

    /**
     * Sets dss_enable_provisioning_pen_configuration_radmin_option
     *
     * @param ?string $dss_enable_provisioning_pen_configuration_radmin_option 
     *
     * @return $this
     */
    public function setDssEnableProvisioningPenConfigurationRadminOption($dss_enable_provisioning_pen_configuration_radmin_option)
    {
        $this->container['dss_enable_provisioning_pen_configuration_radmin_option'] = $dss_enable_provisioning_pen_configuration_radmin_option;

        return $this;
    }

    /**
     * Gets dss_sign_28411_enable_leave_page_prompt_radmin_option
     *
     * @return ?string
     */
    public function getDssSign28411EnableLeavePagePromptRadminOption()
    {
        return $this->container['dss_sign_28411_enable_leave_page_prompt_radmin_option'];
    }

    /**
     * Sets dss_sign_28411_enable_leave_page_prompt_radmin_option
     *
     * @param ?string $dss_sign_28411_enable_leave_page_prompt_radmin_option 
     *
     * @return $this
     */
    public function setDssSign28411EnableLeavePagePromptRadminOption($dss_sign_28411_enable_leave_page_prompt_radmin_option)
    {
        $this->container['dss_sign_28411_enable_leave_page_prompt_radmin_option'] = $dss_sign_28411_enable_leave_page_prompt_radmin_option;

        return $this;
    }

    /**
     * Gets dss_sign_29182_slide_up_bar_radmin_option
     *
     * @return ?string
     */
    public function getDssSign29182SlideUpBarRadminOption()
    {
        return $this->container['dss_sign_29182_slide_up_bar_radmin_option'];
    }

    /**
     * Sets dss_sign_29182_slide_up_bar_radmin_option
     *
     * @param ?string $dss_sign_29182_slide_up_bar_radmin_option 
     *
     * @return $this
     */
    public function setDssSign29182SlideUpBarRadminOption($dss_sign_29182_slide_up_bar_radmin_option)
    {
        $this->container['dss_sign_29182_slide_up_bar_radmin_option'] = $dss_sign_29182_slide_up_bar_radmin_option;

        return $this;
    }

    /**
     * Gets email_template_version
     *
     * @return ?string
     */
    public function getEmailTemplateVersion()
    {
        return $this->container['email_template_version'];
    }

    /**
     * Sets email_template_version
     *
     * @param ?string $email_template_version 
     *
     * @return $this
     */
    public function setEmailTemplateVersion($email_template_version)
    {
        $this->container['email_template_version'] = $email_template_version;

        return $this;
    }

    /**
     * Gets email_template_version_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEmailTemplateVersionMetadata()
    {
        return $this->container['email_template_version_metadata'];
    }

    /**
     * Sets email_template_version_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $email_template_version_metadata Metadata that indicates whether the `emailTemplateVersion` property is editable.
     *
     * @return $this
     */
    public function setEmailTemplateVersionMetadata($email_template_version_metadata)
    {
        $this->container['email_template_version_metadata'] = $email_template_version_metadata;

        return $this;
    }

    /**
     * Gets enable_access_code_generator
     *
     * @return ?string
     */
    public function getEnableAccessCodeGenerator()
    {
        return $this->container['enable_access_code_generator'];
    }

    /**
     * Sets enable_access_code_generator
     *
     * @param ?string $enable_access_code_generator 
     *
     * @return $this
     */
    public function setEnableAccessCodeGenerator($enable_access_code_generator)
    {
        $this->container['enable_access_code_generator'] = $enable_access_code_generator;

        return $this;
    }

    /**
     * Gets enable_access_code_generator_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableAccessCodeGeneratorMetadata()
    {
        return $this->container['enable_access_code_generator_metadata'];
    }

    /**
     * Sets enable_access_code_generator_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_access_code_generator_metadata Metadata that indicates whether the `enableAccessCodeGenerator` property is editable.
     *
     * @return $this
     */
    public function setEnableAccessCodeGeneratorMetadata($enable_access_code_generator_metadata)
    {
        $this->container['enable_access_code_generator_metadata'] = $enable_access_code_generator_metadata;

        return $this;
    }

    /**
     * Gets enable_account_wide_search
     *
     * @return ?string
     */
    public function getEnableAccountWideSearch()
    {
        return $this->container['enable_account_wide_search'];
    }

    /**
     * Sets enable_account_wide_search
     *
     * @param ?string $enable_account_wide_search 
     *
     * @return $this
     */
    public function setEnableAccountWideSearch($enable_account_wide_search)
    {
        $this->container['enable_account_wide_search'] = $enable_account_wide_search;

        return $this;
    }

    /**
     * Gets enable_account_wide_search_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableAccountWideSearchMetadata()
    {
        return $this->container['enable_account_wide_search_metadata'];
    }

    /**
     * Sets enable_account_wide_search_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_account_wide_search_metadata 
     *
     * @return $this
     */
    public function setEnableAccountWideSearchMetadata($enable_account_wide_search_metadata)
    {
        $this->container['enable_account_wide_search_metadata'] = $enable_account_wide_search_metadata;

        return $this;
    }

    /**
     * Gets enable_adm_healthcare
     *
     * @return ?string
     */
    public function getEnableAdmHealthcare()
    {
        return $this->container['enable_adm_healthcare'];
    }

    /**
     * Sets enable_adm_healthcare
     *
     * @param ?string $enable_adm_healthcare Account Level Flag that determines the availability to use ADM Healthcare fields
     *
     * @return $this
     */
    public function setEnableAdmHealthcare($enable_adm_healthcare)
    {
        $this->container['enable_adm_healthcare'] = $enable_adm_healthcare;

        return $this;
    }

    /**
     * Gets enable_adm_healthcare_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableAdmHealthcareMetadata()
    {
        return $this->container['enable_adm_healthcare_metadata'];
    }

    /**
     * Sets enable_adm_healthcare_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_adm_healthcare_metadata Metadata for account Level Flag that determines the availability to use ADM Healthcare fields
     *
     * @return $this
     */
    public function setEnableAdmHealthcareMetadata($enable_adm_healthcare_metadata)
    {
        $this->container['enable_adm_healthcare_metadata'] = $enable_adm_healthcare_metadata;

        return $this;
    }

    /**
     * Gets enable_advanced_envelopes_search
     *
     * @return ?string
     */
    public function getEnableAdvancedEnvelopesSearch()
    {
        return $this->container['enable_advanced_envelopes_search'];
    }

    /**
     * Sets enable_advanced_envelopes_search
     *
     * @param ?string $enable_advanced_envelopes_search 
     *
     * @return $this
     */
    public function setEnableAdvancedEnvelopesSearch($enable_advanced_envelopes_search)
    {
        $this->container['enable_advanced_envelopes_search'] = $enable_advanced_envelopes_search;

        return $this;
    }

    /**
     * Gets enable_advanced_envelopes_search_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableAdvancedEnvelopesSearchMetadata()
    {
        return $this->container['enable_advanced_envelopes_search_metadata'];
    }

    /**
     * Sets enable_advanced_envelopes_search_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_advanced_envelopes_search_metadata 
     *
     * @return $this
     */
    public function setEnableAdvancedEnvelopesSearchMetadata($enable_advanced_envelopes_search_metadata)
    {
        $this->container['enable_advanced_envelopes_search_metadata'] = $enable_advanced_envelopes_search_metadata;

        return $this;
    }

    /**
     * Gets enable_advanced_payments
     *
     * @return ?string
     */
    public function getEnableAdvancedPayments()
    {
        return $this->container['enable_advanced_payments'];
    }

    /**
     * Sets enable_advanced_payments
     *
     * @param ?string $enable_advanced_payments 
     *
     * @return $this
     */
    public function setEnableAdvancedPayments($enable_advanced_payments)
    {
        $this->container['enable_advanced_payments'] = $enable_advanced_payments;

        return $this;
    }

    /**
     * Gets enable_advanced_payments_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableAdvancedPaymentsMetadata()
    {
        return $this->container['enable_advanced_payments_metadata'];
    }

    /**
     * Sets enable_advanced_payments_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_advanced_payments_metadata Metadata that indicates whether the `enableAdvancedPayments` property is editable.
     *
     * @return $this
     */
    public function setEnableAdvancedPaymentsMetadata($enable_advanced_payments_metadata)
    {
        $this->container['enable_advanced_payments_metadata'] = $enable_advanced_payments_metadata;

        return $this;
    }

    /**
     * Gets enable_advanced_power_forms
     *
     * @return ?string
     */
    public function getEnableAdvancedPowerForms()
    {
        return $this->container['enable_advanced_power_forms'];
    }

    /**
     * Sets enable_advanced_power_forms
     *
     * @param ?string $enable_advanced_power_forms 
     *
     * @return $this
     */
    public function setEnableAdvancedPowerForms($enable_advanced_power_forms)
    {
        $this->container['enable_advanced_power_forms'] = $enable_advanced_power_forms;

        return $this;
    }

    /**
     * Gets enable_advanced_power_forms_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableAdvancedPowerFormsMetadata()
    {
        return $this->container['enable_advanced_power_forms_metadata'];
    }

    /**
     * Sets enable_advanced_power_forms_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_advanced_power_forms_metadata Metadata that indicates whether the `enableAdvancedPowerForms` property is editable.
     *
     * @return $this
     */
    public function setEnableAdvancedPowerFormsMetadata($enable_advanced_power_forms_metadata)
    {
        $this->container['enable_advanced_power_forms_metadata'] = $enable_advanced_power_forms_metadata;

        return $this;
    }

    /**
     * Gets enable_agreement_actions_for_clm
     *
     * @return ?string
     */
    public function getEnableAgreementActionsForClm()
    {
        return $this->container['enable_agreement_actions_for_clm'];
    }

    /**
     * Sets enable_agreement_actions_for_clm
     *
     * @param ?string $enable_agreement_actions_for_clm 
     *
     * @return $this
     */
    public function setEnableAgreementActionsForClm($enable_agreement_actions_for_clm)
    {
        $this->container['enable_agreement_actions_for_clm'] = $enable_agreement_actions_for_clm;

        return $this;
    }

    /**
     * Gets enable_agreement_actions_for_clm_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableAgreementActionsForClmMetadata()
    {
        return $this->container['enable_agreement_actions_for_clm_metadata'];
    }

    /**
     * Sets enable_agreement_actions_for_clm_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_agreement_actions_for_clm_metadata 
     *
     * @return $this
     */
    public function setEnableAgreementActionsForClmMetadata($enable_agreement_actions_for_clm_metadata)
    {
        $this->container['enable_agreement_actions_for_clm_metadata'] = $enable_agreement_actions_for_clm_metadata;

        return $this;
    }

    /**
     * Gets enable_agreement_actions_for_e_sign
     *
     * @return ?string
     */
    public function getEnableAgreementActionsForESign()
    {
        return $this->container['enable_agreement_actions_for_e_sign'];
    }

    /**
     * Sets enable_agreement_actions_for_e_sign
     *
     * @param ?string $enable_agreement_actions_for_e_sign 
     *
     * @return $this
     */
    public function setEnableAgreementActionsForESign($enable_agreement_actions_for_e_sign)
    {
        $this->container['enable_agreement_actions_for_e_sign'] = $enable_agreement_actions_for_e_sign;

        return $this;
    }

    /**
     * Gets enable_agreement_actions_for_e_sign_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableAgreementActionsForESignMetadata()
    {
        return $this->container['enable_agreement_actions_for_e_sign_metadata'];
    }

    /**
     * Sets enable_agreement_actions_for_e_sign_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_agreement_actions_for_e_sign_metadata 
     *
     * @return $this
     */
    public function setEnableAgreementActionsForESignMetadata($enable_agreement_actions_for_e_sign_metadata)
    {
        $this->container['enable_agreement_actions_for_e_sign_metadata'] = $enable_agreement_actions_for_e_sign_metadata;

        return $this;
    }

    /**
     * Gets enable_auto_nav
     *
     * @return ?string
     */
    public function getEnableAutoNav()
    {
        return $this->container['enable_auto_nav'];
    }

    /**
     * Sets enable_auto_nav
     *
     * @param ?string $enable_auto_nav 
     *
     * @return $this
     */
    public function setEnableAutoNav($enable_auto_nav)
    {
        $this->container['enable_auto_nav'] = $enable_auto_nav;

        return $this;
    }

    /**
     * Gets enable_auto_nav_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableAutoNavMetadata()
    {
        return $this->container['enable_auto_nav_metadata'];
    }

    /**
     * Sets enable_auto_nav_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_auto_nav_metadata Metadata that indicates whether the `enableAutoNav` property is editable.
     *
     * @return $this
     */
    public function setEnableAutoNavMetadata($enable_auto_nav_metadata)
    {
        $this->container['enable_auto_nav_metadata'] = $enable_auto_nav_metadata;

        return $this;
    }

    /**
     * Gets enable_bcc_dummy_link
     *
     * @return ?string
     */
    public function getEnableBccDummyLink()
    {
        return $this->container['enable_bcc_dummy_link'];
    }

    /**
     * Sets enable_bcc_dummy_link
     *
     * @param ?string $enable_bcc_dummy_link 
     *
     * @return $this
     */
    public function setEnableBccDummyLink($enable_bcc_dummy_link)
    {
        $this->container['enable_bcc_dummy_link'] = $enable_bcc_dummy_link;

        return $this;
    }

    /**
     * Gets enable_bcc_dummy_link_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableBccDummyLinkMetadata()
    {
        return $this->container['enable_bcc_dummy_link_metadata'];
    }

    /**
     * Sets enable_bcc_dummy_link_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_bcc_dummy_link_metadata 
     *
     * @return $this
     */
    public function setEnableBccDummyLinkMetadata($enable_bcc_dummy_link_metadata)
    {
        $this->container['enable_bcc_dummy_link_metadata'] = $enable_bcc_dummy_link_metadata;

        return $this;
    }

    /**
     * Gets enable_calculated_fields
     *
     * @return ?string
     */
    public function getEnableCalculatedFields()
    {
        return $this->container['enable_calculated_fields'];
    }

    /**
     * Sets enable_calculated_fields
     *
     * @param ?string $enable_calculated_fields 
     *
     * @return $this
     */
    public function setEnableCalculatedFields($enable_calculated_fields)
    {
        $this->container['enable_calculated_fields'] = $enable_calculated_fields;

        return $this;
    }

    /**
     * Gets enable_calculated_fields_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableCalculatedFieldsMetadata()
    {
        return $this->container['enable_calculated_fields_metadata'];
    }

    /**
     * Sets enable_calculated_fields_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_calculated_fields_metadata Metadata that indicates whether the `enableCalculatedFields` property is editable.
     *
     * @return $this
     */
    public function setEnableCalculatedFieldsMetadata($enable_calculated_fields_metadata)
    {
        $this->container['enable_calculated_fields_metadata'] = $enable_calculated_fields_metadata;

        return $this;
    }

    /**
     * Gets enable_click_plus
     *
     * @return ?string
     */
    public function getEnableClickPlus()
    {
        return $this->container['enable_click_plus'];
    }

    /**
     * Sets enable_click_plus
     *
     * @param ?string $enable_click_plus 
     *
     * @return $this
     */
    public function setEnableClickPlus($enable_click_plus)
    {
        $this->container['enable_click_plus'] = $enable_click_plus;

        return $this;
    }

    /**
     * Gets enable_click_plus_conditional_content
     *
     * @return ?string
     */
    public function getEnableClickPlusConditionalContent()
    {
        return $this->container['enable_click_plus_conditional_content'];
    }

    /**
     * Sets enable_click_plus_conditional_content
     *
     * @param ?string $enable_click_plus_conditional_content 
     *
     * @return $this
     */
    public function setEnableClickPlusConditionalContent($enable_click_plus_conditional_content)
    {
        $this->container['enable_click_plus_conditional_content'] = $enable_click_plus_conditional_content;

        return $this;
    }

    /**
     * Gets enable_click_plus_conditional_content_meta_data
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableClickPlusConditionalContentMetaData()
    {
        return $this->container['enable_click_plus_conditional_content_meta_data'];
    }

    /**
     * Sets enable_click_plus_conditional_content_meta_data
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_click_plus_conditional_content_meta_data 
     *
     * @return $this
     */
    public function setEnableClickPlusConditionalContentMetaData($enable_click_plus_conditional_content_meta_data)
    {
        $this->container['enable_click_plus_conditional_content_meta_data'] = $enable_click_plus_conditional_content_meta_data;

        return $this;
    }

    /**
     * Gets enable_click_plus_custom_fields
     *
     * @return ?string
     */
    public function getEnableClickPlusCustomFields()
    {
        return $this->container['enable_click_plus_custom_fields'];
    }

    /**
     * Sets enable_click_plus_custom_fields
     *
     * @param ?string $enable_click_plus_custom_fields 
     *
     * @return $this
     */
    public function setEnableClickPlusCustomFields($enable_click_plus_custom_fields)
    {
        $this->container['enable_click_plus_custom_fields'] = $enable_click_plus_custom_fields;

        return $this;
    }

    /**
     * Gets enable_click_plus_custom_fields_meta_data
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableClickPlusCustomFieldsMetaData()
    {
        return $this->container['enable_click_plus_custom_fields_meta_data'];
    }

    /**
     * Sets enable_click_plus_custom_fields_meta_data
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_click_plus_custom_fields_meta_data 
     *
     * @return $this
     */
    public function setEnableClickPlusCustomFieldsMetaData($enable_click_plus_custom_fields_meta_data)
    {
        $this->container['enable_click_plus_custom_fields_meta_data'] = $enable_click_plus_custom_fields_meta_data;

        return $this;
    }

    /**
     * Gets enable_click_plus_custom_style
     *
     * @return ?string
     */
    public function getEnableClickPlusCustomStyle()
    {
        return $this->container['enable_click_plus_custom_style'];
    }

    /**
     * Sets enable_click_plus_custom_style
     *
     * @param ?string $enable_click_plus_custom_style 
     *
     * @return $this
     */
    public function setEnableClickPlusCustomStyle($enable_click_plus_custom_style)
    {
        $this->container['enable_click_plus_custom_style'] = $enable_click_plus_custom_style;

        return $this;
    }

    /**
     * Gets enable_click_plus_custom_style_meta_data
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableClickPlusCustomStyleMetaData()
    {
        return $this->container['enable_click_plus_custom_style_meta_data'];
    }

    /**
     * Sets enable_click_plus_custom_style_meta_data
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_click_plus_custom_style_meta_data 
     *
     * @return $this
     */
    public function setEnableClickPlusCustomStyleMetaData($enable_click_plus_custom_style_meta_data)
    {
        $this->container['enable_click_plus_custom_style_meta_data'] = $enable_click_plus_custom_style_meta_data;

        return $this;
    }

    /**
     * Gets enable_click_plus_dynamic_content
     *
     * @return ?string
     */
    public function getEnableClickPlusDynamicContent()
    {
        return $this->container['enable_click_plus_dynamic_content'];
    }

    /**
     * Sets enable_click_plus_dynamic_content
     *
     * @param ?string $enable_click_plus_dynamic_content 
     *
     * @return $this
     */
    public function setEnableClickPlusDynamicContent($enable_click_plus_dynamic_content)
    {
        $this->container['enable_click_plus_dynamic_content'] = $enable_click_plus_dynamic_content;

        return $this;
    }

    /**
     * Gets enable_click_plus_dynamic_content_meta_data
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableClickPlusDynamicContentMetaData()
    {
        return $this->container['enable_click_plus_dynamic_content_meta_data'];
    }

    /**
     * Sets enable_click_plus_dynamic_content_meta_data
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_click_plus_dynamic_content_meta_data 
     *
     * @return $this
     */
    public function setEnableClickPlusDynamicContentMetaData($enable_click_plus_dynamic_content_meta_data)
    {
        $this->container['enable_click_plus_dynamic_content_meta_data'] = $enable_click_plus_dynamic_content_meta_data;

        return $this;
    }

    /**
     * Gets enable_click_plus_meta_data
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableClickPlusMetaData()
    {
        return $this->container['enable_click_plus_meta_data'];
    }

    /**
     * Sets enable_click_plus_meta_data
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_click_plus_meta_data 
     *
     * @return $this
     */
    public function setEnableClickPlusMetaData($enable_click_plus_meta_data)
    {
        $this->container['enable_click_plus_meta_data'] = $enable_click_plus_meta_data;

        return $this;
    }

    /**
     * Gets enable_clickwraps
     *
     * @return ?string
     */
    public function getEnableClickwraps()
    {
        return $this->container['enable_clickwraps'];
    }

    /**
     * Sets enable_clickwraps
     *
     * @param ?string $enable_clickwraps 
     *
     * @return $this
     */
    public function setEnableClickwraps($enable_clickwraps)
    {
        $this->container['enable_clickwraps'] = $enable_clickwraps;

        return $this;
    }

    /**
     * Gets enable_clickwraps_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableClickwrapsMetadata()
    {
        return $this->container['enable_clickwraps_metadata'];
    }

    /**
     * Sets enable_clickwraps_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_clickwraps_metadata Metadata that indicates whether the `enableClickwraps` property is editable.
     *
     * @return $this
     */
    public function setEnableClickwrapsMetadata($enable_clickwraps_metadata)
    {
        $this->container['enable_clickwraps_metadata'] = $enable_clickwraps_metadata;

        return $this;
    }

    /**
     * Gets enable_combined_pdf_download_for_sbs
     *
     * @return ?string
     */
    public function getEnableCombinedPdfDownloadForSbs()
    {
        return $this->container['enable_combined_pdf_download_for_sbs'];
    }

    /**
     * Sets enable_combined_pdf_download_for_sbs
     *
     * @param ?string $enable_combined_pdf_download_for_sbs 
     *
     * @return $this
     */
    public function setEnableCombinedPdfDownloadForSbs($enable_combined_pdf_download_for_sbs)
    {
        $this->container['enable_combined_pdf_download_for_sbs'] = $enable_combined_pdf_download_for_sbs;

        return $this;
    }

    /**
     * Gets enable_comments_history_download_in_signing
     *
     * @return ?string
     */
    public function getEnableCommentsHistoryDownloadInSigning()
    {
        return $this->container['enable_comments_history_download_in_signing'];
    }

    /**
     * Sets enable_comments_history_download_in_signing
     *
     * @param ?string $enable_comments_history_download_in_signing 
     *
     * @return $this
     */
    public function setEnableCommentsHistoryDownloadInSigning($enable_comments_history_download_in_signing)
    {
        $this->container['enable_comments_history_download_in_signing'] = $enable_comments_history_download_in_signing;

        return $this;
    }

    /**
     * Gets enable_comments_history_download_in_signing_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableCommentsHistoryDownloadInSigningMetadata()
    {
        return $this->container['enable_comments_history_download_in_signing_metadata'];
    }

    /**
     * Sets enable_comments_history_download_in_signing_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_comments_history_download_in_signing_metadata 
     *
     * @return $this
     */
    public function setEnableCommentsHistoryDownloadInSigningMetadata($enable_comments_history_download_in_signing_metadata)
    {
        $this->container['enable_comments_history_download_in_signing_metadata'] = $enable_comments_history_download_in_signing_metadata;

        return $this;
    }

    /**
     * Gets enable_contact_suggestions
     *
     * @return ?string
     */
    public function getEnableContactSuggestions()
    {
        return $this->container['enable_contact_suggestions'];
    }

    /**
     * Sets enable_contact_suggestions
     *
     * @param ?string $enable_contact_suggestions 
     *
     * @return $this
     */
    public function setEnableContactSuggestions($enable_contact_suggestions)
    {
        $this->container['enable_contact_suggestions'] = $enable_contact_suggestions;

        return $this;
    }

    /**
     * Gets enable_contact_suggestions_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableContactSuggestionsMetadata()
    {
        return $this->container['enable_contact_suggestions_metadata'];
    }

    /**
     * Sets enable_contact_suggestions_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_contact_suggestions_metadata 
     *
     * @return $this
     */
    public function setEnableContactSuggestionsMetadata($enable_contact_suggestions_metadata)
    {
        $this->container['enable_contact_suggestions_metadata'] = $enable_contact_suggestions_metadata;

        return $this;
    }

    /**
     * Gets enable_customer_satisfaction_metric_tracking
     *
     * @return ?string
     */
    public function getEnableCustomerSatisfactionMetricTracking()
    {
        return $this->container['enable_customer_satisfaction_metric_tracking'];
    }

    /**
     * Sets enable_customer_satisfaction_metric_tracking
     *
     * @param ?string $enable_customer_satisfaction_metric_tracking 
     *
     * @return $this
     */
    public function setEnableCustomerSatisfactionMetricTracking($enable_customer_satisfaction_metric_tracking)
    {
        $this->container['enable_customer_satisfaction_metric_tracking'] = $enable_customer_satisfaction_metric_tracking;

        return $this;
    }

    /**
     * Gets enable_customer_satisfaction_metric_tracking_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableCustomerSatisfactionMetricTrackingMetadata()
    {
        return $this->container['enable_customer_satisfaction_metric_tracking_metadata'];
    }

    /**
     * Sets enable_customer_satisfaction_metric_tracking_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_customer_satisfaction_metric_tracking_metadata Metadata that indicates whether the `enableCustomerSatisfactionMetricTracking` property is editable.
     *
     * @return $this
     */
    public function setEnableCustomerSatisfactionMetricTrackingMetadata($enable_customer_satisfaction_metric_tracking_metadata)
    {
        $this->container['enable_customer_satisfaction_metric_tracking_metadata'] = $enable_customer_satisfaction_metric_tracking_metadata;

        return $this;
    }

    /**
     * Gets enable_d_sig_eu_advanced_pens
     *
     * @return ?string
     */
    public function getEnableDSigEuAdvancedPens()
    {
        return $this->container['enable_d_sig_eu_advanced_pens'];
    }

    /**
     * Sets enable_d_sig_eu_advanced_pens
     *
     * @param ?string $enable_d_sig_eu_advanced_pens 
     *
     * @return $this
     */
    public function setEnableDSigEuAdvancedPens($enable_d_sig_eu_advanced_pens)
    {
        $this->container['enable_d_sig_eu_advanced_pens'] = $enable_d_sig_eu_advanced_pens;

        return $this;
    }

    /**
     * Gets enable_d_sig_eu_advanced_pens_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableDSigEuAdvancedPensMetadata()
    {
        return $this->container['enable_d_sig_eu_advanced_pens_metadata'];
    }

    /**
     * Sets enable_d_sig_eu_advanced_pens_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_d_sig_eu_advanced_pens_metadata 
     *
     * @return $this
     */
    public function setEnableDSigEuAdvancedPensMetadata($enable_d_sig_eu_advanced_pens_metadata)
    {
        $this->container['enable_d_sig_eu_advanced_pens_metadata'] = $enable_d_sig_eu_advanced_pens_metadata;

        return $this;
    }

    /**
     * Gets enable_d_sig_express_pens
     *
     * @return ?string
     */
    public function getEnableDSigExpressPens()
    {
        return $this->container['enable_d_sig_express_pens'];
    }

    /**
     * Sets enable_d_sig_express_pens
     *
     * @param ?string $enable_d_sig_express_pens 
     *
     * @return $this
     */
    public function setEnableDSigExpressPens($enable_d_sig_express_pens)
    {
        $this->container['enable_d_sig_express_pens'] = $enable_d_sig_express_pens;

        return $this;
    }

    /**
     * Gets enable_d_sig_express_pens_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableDSigExpressPensMetadata()
    {
        return $this->container['enable_d_sig_express_pens_metadata'];
    }

    /**
     * Sets enable_d_sig_express_pens_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_d_sig_express_pens_metadata 
     *
     * @return $this
     */
    public function setEnableDSigExpressPensMetadata($enable_d_sig_express_pens_metadata)
    {
        $this->container['enable_d_sig_express_pens_metadata'] = $enable_d_sig_express_pens_metadata;

        return $this;
    }

    /**
     * Gets enable_d_sig_id_check_for_aes_pens
     *
     * @return ?string
     */
    public function getEnableDSigIdCheckForAesPens()
    {
        return $this->container['enable_d_sig_id_check_for_aes_pens'];
    }

    /**
     * Sets enable_d_sig_id_check_for_aes_pens
     *
     * @param ?string $enable_d_sig_id_check_for_aes_pens 
     *
     * @return $this
     */
    public function setEnableDSigIdCheckForAesPens($enable_d_sig_id_check_for_aes_pens)
    {
        $this->container['enable_d_sig_id_check_for_aes_pens'] = $enable_d_sig_id_check_for_aes_pens;

        return $this;
    }

    /**
     * Gets enable_d_sig_id_check_for_aes_pens_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableDSigIdCheckForAesPensMetadata()
    {
        return $this->container['enable_d_sig_id_check_for_aes_pens_metadata'];
    }

    /**
     * Sets enable_d_sig_id_check_for_aes_pens_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_d_sig_id_check_for_aes_pens_metadata 
     *
     * @return $this
     */
    public function setEnableDSigIdCheckForAesPensMetadata($enable_d_sig_id_check_for_aes_pens_metadata)
    {
        $this->container['enable_d_sig_id_check_for_aes_pens_metadata'] = $enable_d_sig_id_check_for_aes_pens_metadata;

        return $this;
    }

    /**
     * Gets enable_d_sig_id_check_in_person_for_qes_pens
     *
     * @return ?string
     */
    public function getEnableDSigIdCheckInPersonForQesPens()
    {
        return $this->container['enable_d_sig_id_check_in_person_for_qes_pens'];
    }

    /**
     * Sets enable_d_sig_id_check_in_person_for_qes_pens
     *
     * @param ?string $enable_d_sig_id_check_in_person_for_qes_pens 
     *
     * @return $this
     */
    public function setEnableDSigIdCheckInPersonForQesPens($enable_d_sig_id_check_in_person_for_qes_pens)
    {
        $this->container['enable_d_sig_id_check_in_person_for_qes_pens'] = $enable_d_sig_id_check_in_person_for_qes_pens;

        return $this;
    }

    /**
     * Gets enable_d_sig_id_check_in_person_for_qes_pens_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableDSigIdCheckInPersonForQesPensMetadata()
    {
        return $this->container['enable_d_sig_id_check_in_person_for_qes_pens_metadata'];
    }

    /**
     * Sets enable_d_sig_id_check_in_person_for_qes_pens_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_d_sig_id_check_in_person_for_qes_pens_metadata 
     *
     * @return $this
     */
    public function setEnableDSigIdCheckInPersonForQesPensMetadata($enable_d_sig_id_check_in_person_for_qes_pens_metadata)
    {
        $this->container['enable_d_sig_id_check_in_person_for_qes_pens_metadata'] = $enable_d_sig_id_check_in_person_for_qes_pens_metadata;

        return $this;
    }

    /**
     * Gets enable_d_sig_id_check_remote_for_qes_pens
     *
     * @return ?string
     */
    public function getEnableDSigIdCheckRemoteForQesPens()
    {
        return $this->container['enable_d_sig_id_check_remote_for_qes_pens'];
    }

    /**
     * Sets enable_d_sig_id_check_remote_for_qes_pens
     *
     * @param ?string $enable_d_sig_id_check_remote_for_qes_pens 
     *
     * @return $this
     */
    public function setEnableDSigIdCheckRemoteForQesPens($enable_d_sig_id_check_remote_for_qes_pens)
    {
        $this->container['enable_d_sig_id_check_remote_for_qes_pens'] = $enable_d_sig_id_check_remote_for_qes_pens;

        return $this;
    }

    /**
     * Gets enable_d_sig_id_check_remote_for_qes_pens_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableDSigIdCheckRemoteForQesPensMetadata()
    {
        return $this->container['enable_d_sig_id_check_remote_for_qes_pens_metadata'];
    }

    /**
     * Sets enable_d_sig_id_check_remote_for_qes_pens_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_d_sig_id_check_remote_for_qes_pens_metadata 
     *
     * @return $this
     */
    public function setEnableDSigIdCheckRemoteForQesPensMetadata($enable_d_sig_id_check_remote_for_qes_pens_metadata)
    {
        $this->container['enable_d_sig_id_check_remote_for_qes_pens_metadata'] = $enable_d_sig_id_check_remote_for_qes_pens_metadata;

        return $this;
    }

    /**
     * Gets enable_d_sig_id_verification_pens
     *
     * @return ?string
     */
    public function getEnableDSigIdVerificationPens()
    {
        return $this->container['enable_d_sig_id_verification_pens'];
    }

    /**
     * Sets enable_d_sig_id_verification_pens
     *
     * @param ?string $enable_d_sig_id_verification_pens 
     *
     * @return $this
     */
    public function setEnableDSigIdVerificationPens($enable_d_sig_id_verification_pens)
    {
        $this->container['enable_d_sig_id_verification_pens'] = $enable_d_sig_id_verification_pens;

        return $this;
    }

    /**
     * Gets enable_d_sig_id_verification_pens_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableDSigIdVerificationPensMetadata()
    {
        return $this->container['enable_d_sig_id_verification_pens_metadata'];
    }

    /**
     * Sets enable_d_sig_id_verification_pens_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_d_sig_id_verification_pens_metadata 
     *
     * @return $this
     */
    public function setEnableDSigIdVerificationPensMetadata($enable_d_sig_id_verification_pens_metadata)
    {
        $this->container['enable_d_sig_id_verification_pens_metadata'] = $enable_d_sig_id_verification_pens_metadata;

        return $this;
    }

    /**
     * Gets enable_d_sig_id_verification_premier_pens
     *
     * @return ?string
     */
    public function getEnableDSigIdVerificationPremierPens()
    {
        return $this->container['enable_d_sig_id_verification_premier_pens'];
    }

    /**
     * Sets enable_d_sig_id_verification_premier_pens
     *
     * @param ?string $enable_d_sig_id_verification_premier_pens 
     *
     * @return $this
     */
    public function setEnableDSigIdVerificationPremierPens($enable_d_sig_id_verification_premier_pens)
    {
        $this->container['enable_d_sig_id_verification_premier_pens'] = $enable_d_sig_id_verification_premier_pens;

        return $this;
    }

    /**
     * Gets enable_d_sig_id_verification_premier_pens_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableDSigIdVerificationPremierPensMetadata()
    {
        return $this->container['enable_d_sig_id_verification_premier_pens_metadata'];
    }

    /**
     * Sets enable_d_sig_id_verification_premier_pens_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_d_sig_id_verification_premier_pens_metadata 
     *
     * @return $this
     */
    public function setEnableDSigIdVerificationPremierPensMetadata($enable_d_sig_id_verification_premier_pens_metadata)
    {
        $this->container['enable_d_sig_id_verification_premier_pens_metadata'] = $enable_d_sig_id_verification_premier_pens_metadata;

        return $this;
    }

    /**
     * Gets enable_ds_pro
     *
     * @return ?string
     */
    public function getEnableDsPro()
    {
        return $this->container['enable_ds_pro'];
    }

    /**
     * Sets enable_ds_pro
     *
     * @param ?string $enable_ds_pro 
     *
     * @return $this
     */
    public function setEnableDsPro($enable_ds_pro)
    {
        $this->container['enable_ds_pro'] = $enable_ds_pro;

        return $this;
    }

    /**
     * Gets enable_ds_pro_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableDsProMetadata()
    {
        return $this->container['enable_ds_pro_metadata'];
    }

    /**
     * Sets enable_ds_pro_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_ds_pro_metadata Metadata that indicates whether the `enableDSPro` property is editable.
     *
     * @return $this
     */
    public function setEnableDsProMetadata($enable_ds_pro_metadata)
    {
        $this->container['enable_ds_pro_metadata'] = $enable_ds_pro_metadata;

        return $this;
    }

    /**
     * Gets enable_enforce_tls_emails_setting_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableEnforceTlsEmailsSettingMetadata()
    {
        return $this->container['enable_enforce_tls_emails_setting_metadata'];
    }

    /**
     * Sets enable_enforce_tls_emails_setting_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_enforce_tls_emails_setting_metadata 
     *
     * @return $this
     */
    public function setEnableEnforceTlsEmailsSettingMetadata($enable_enforce_tls_emails_setting_metadata)
    {
        $this->container['enable_enforce_tls_emails_setting_metadata'] = $enable_enforce_tls_emails_setting_metadata;

        return $this;
    }

    /**
     * Gets enable_envelope_stamping_by_account_admin
     *
     * @return ?string
     */
    public function getEnableEnvelopeStampingByAccountAdmin()
    {
        return $this->container['enable_envelope_stamping_by_account_admin'];
    }

    /**
     * Sets enable_envelope_stamping_by_account_admin
     *
     * @param ?string $enable_envelope_stamping_by_account_admin 
     *
     * @return $this
     */
    public function setEnableEnvelopeStampingByAccountAdmin($enable_envelope_stamping_by_account_admin)
    {
        $this->container['enable_envelope_stamping_by_account_admin'] = $enable_envelope_stamping_by_account_admin;

        return $this;
    }

    /**
     * Gets enable_envelope_stamping_by_account_admin_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableEnvelopeStampingByAccountAdminMetadata()
    {
        return $this->container['enable_envelope_stamping_by_account_admin_metadata'];
    }

    /**
     * Sets enable_envelope_stamping_by_account_admin_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_envelope_stamping_by_account_admin_metadata Metadata that indicates whether the `enableEnvelopeStampingByAccountAdmin` property is editable.
     *
     * @return $this
     */
    public function setEnableEnvelopeStampingByAccountAdminMetadata($enable_envelope_stamping_by_account_admin_metadata)
    {
        $this->container['enable_envelope_stamping_by_account_admin_metadata'] = $enable_envelope_stamping_by_account_admin_metadata;

        return $this;
    }

    /**
     * Gets enable_envelope_stamping_by_ds_admin
     *
     * @return ?string
     */
    public function getEnableEnvelopeStampingByDsAdmin()
    {
        return $this->container['enable_envelope_stamping_by_ds_admin'];
    }

    /**
     * Sets enable_envelope_stamping_by_ds_admin
     *
     * @param ?string $enable_envelope_stamping_by_ds_admin 
     *
     * @return $this
     */
    public function setEnableEnvelopeStampingByDsAdmin($enable_envelope_stamping_by_ds_admin)
    {
        $this->container['enable_envelope_stamping_by_ds_admin'] = $enable_envelope_stamping_by_ds_admin;

        return $this;
    }

    /**
     * Gets enable_envelope_stamping_by_ds_admin_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableEnvelopeStampingByDsAdminMetadata()
    {
        return $this->container['enable_envelope_stamping_by_ds_admin_metadata'];
    }

    /**
     * Sets enable_envelope_stamping_by_ds_admin_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_envelope_stamping_by_ds_admin_metadata Metadata that indicates whether the `enableEnvelopeStampingByDSAdmin` property is editable.
     *
     * @return $this
     */
    public function setEnableEnvelopeStampingByDsAdminMetadata($enable_envelope_stamping_by_ds_admin_metadata)
    {
        $this->container['enable_envelope_stamping_by_ds_admin_metadata'] = $enable_envelope_stamping_by_ds_admin_metadata;

        return $this;
    }

    /**
     * Gets enable_e_sign_api_hourly_limit_management
     *
     * @return ?string
     */
    public function getEnableESignApiHourlyLimitManagement()
    {
        return $this->container['enable_e_sign_api_hourly_limit_management'];
    }

    /**
     * Sets enable_e_sign_api_hourly_limit_management
     *
     * @param ?string $enable_e_sign_api_hourly_limit_management 
     *
     * @return $this
     */
    public function setEnableESignApiHourlyLimitManagement($enable_e_sign_api_hourly_limit_management)
    {
        $this->container['enable_e_sign_api_hourly_limit_management'] = $enable_e_sign_api_hourly_limit_management;

        return $this;
    }

    /**
     * Gets enable_e_sign_api_hourly_limit_management_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableESignApiHourlyLimitManagementMetadata()
    {
        return $this->container['enable_e_sign_api_hourly_limit_management_metadata'];
    }

    /**
     * Sets enable_e_sign_api_hourly_limit_management_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_e_sign_api_hourly_limit_management_metadata 
     *
     * @return $this
     */
    public function setEnableESignApiHourlyLimitManagementMetadata($enable_e_sign_api_hourly_limit_management_metadata)
    {
        $this->container['enable_e_sign_api_hourly_limit_management_metadata'] = $enable_e_sign_api_hourly_limit_management_metadata;

        return $this;
    }

    /**
     * Gets enable_esign_communities
     *
     * @return ?string
     */
    public function getEnableEsignCommunities()
    {
        return $this->container['enable_esign_communities'];
    }

    /**
     * Sets enable_esign_communities
     *
     * @param ?string $enable_esign_communities 
     *
     * @return $this
     */
    public function setEnableEsignCommunities($enable_esign_communities)
    {
        $this->container['enable_esign_communities'] = $enable_esign_communities;

        return $this;
    }

    /**
     * Gets enable_esign_communities_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableEsignCommunitiesMetadata()
    {
        return $this->container['enable_esign_communities_metadata'];
    }

    /**
     * Sets enable_esign_communities_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_esign_communities_metadata 
     *
     * @return $this
     */
    public function setEnableEsignCommunitiesMetadata($enable_esign_communities_metadata)
    {
        $this->container['enable_esign_communities_metadata'] = $enable_esign_communities_metadata;

        return $this;
    }

    /**
     * Gets enable_id_fx_accountless_sms_auth_for_part11
     *
     * @return ?string
     */
    public function getEnableIdFxAccountlessSmsAuthForPart11()
    {
        return $this->container['enable_id_fx_accountless_sms_auth_for_part11'];
    }

    /**
     * Sets enable_id_fx_accountless_sms_auth_for_part11
     *
     * @param ?string $enable_id_fx_accountless_sms_auth_for_part11 
     *
     * @return $this
     */
    public function setEnableIdFxAccountlessSmsAuthForPart11($enable_id_fx_accountless_sms_auth_for_part11)
    {
        $this->container['enable_id_fx_accountless_sms_auth_for_part11'] = $enable_id_fx_accountless_sms_auth_for_part11;

        return $this;
    }

    /**
     * Gets enable_id_fx_accountless_sms_auth_for_part11_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableIdFxAccountlessSmsAuthForPart11Metadata()
    {
        return $this->container['enable_id_fx_accountless_sms_auth_for_part11_metadata'];
    }

    /**
     * Sets enable_id_fx_accountless_sms_auth_for_part11_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_id_fx_accountless_sms_auth_for_part11_metadata 
     *
     * @return $this
     */
    public function setEnableIdFxAccountlessSmsAuthForPart11Metadata($enable_id_fx_accountless_sms_auth_for_part11_metadata)
    {
        $this->container['enable_id_fx_accountless_sms_auth_for_part11_metadata'] = $enable_id_fx_accountless_sms_auth_for_part11_metadata;

        return $this;
    }

    /**
     * Gets enable_id_fx_intuit_kba
     *
     * @return ?string
     */
    public function getEnableIdFxIntuitKba()
    {
        return $this->container['enable_id_fx_intuit_kba'];
    }

    /**
     * Sets enable_id_fx_intuit_kba
     *
     * @param ?string $enable_id_fx_intuit_kba 
     *
     * @return $this
     */
    public function setEnableIdFxIntuitKba($enable_id_fx_intuit_kba)
    {
        $this->container['enable_id_fx_intuit_kba'] = $enable_id_fx_intuit_kba;

        return $this;
    }

    /**
     * Gets enable_id_fx_intuit_kba_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableIdFxIntuitKbaMetadata()
    {
        return $this->container['enable_id_fx_intuit_kba_metadata'];
    }

    /**
     * Sets enable_id_fx_intuit_kba_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_id_fx_intuit_kba_metadata 
     *
     * @return $this
     */
    public function setEnableIdFxIntuitKbaMetadata($enable_id_fx_intuit_kba_metadata)
    {
        $this->container['enable_id_fx_intuit_kba_metadata'] = $enable_id_fx_intuit_kba_metadata;

        return $this;
    }

    /**
     * Gets enable_id_fx_phone_authentication
     *
     * @return ?string
     */
    public function getEnableIdFxPhoneAuthentication()
    {
        return $this->container['enable_id_fx_phone_authentication'];
    }

    /**
     * Sets enable_id_fx_phone_authentication
     *
     * @param ?string $enable_id_fx_phone_authentication 
     *
     * @return $this
     */
    public function setEnableIdFxPhoneAuthentication($enable_id_fx_phone_authentication)
    {
        $this->container['enable_id_fx_phone_authentication'] = $enable_id_fx_phone_authentication;

        return $this;
    }

    /**
     * Gets enable_id_fx_phone_authentication_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableIdFxPhoneAuthenticationMetadata()
    {
        return $this->container['enable_id_fx_phone_authentication_metadata'];
    }

    /**
     * Sets enable_id_fx_phone_authentication_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_id_fx_phone_authentication_metadata 
     *
     * @return $this
     */
    public function setEnableIdFxPhoneAuthenticationMetadata($enable_id_fx_phone_authentication_metadata)
    {
        $this->container['enable_id_fx_phone_authentication_metadata'] = $enable_id_fx_phone_authentication_metadata;

        return $this;
    }

    /**
     * Gets enable_idfx_phone_auth_signature_auth_status
     *
     * @return ?string
     */
    public function getEnableIdfxPhoneAuthSignatureAuthStatus()
    {
        return $this->container['enable_idfx_phone_auth_signature_auth_status'];
    }

    /**
     * Sets enable_idfx_phone_auth_signature_auth_status
     *
     * @param ?string $enable_idfx_phone_auth_signature_auth_status 
     *
     * @return $this
     */
    public function setEnableIdfxPhoneAuthSignatureAuthStatus($enable_idfx_phone_auth_signature_auth_status)
    {
        $this->container['enable_idfx_phone_auth_signature_auth_status'] = $enable_idfx_phone_auth_signature_auth_status;

        return $this;
    }

    /**
     * Gets enable_idfx_phone_auth_signature_auth_status_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableIdfxPhoneAuthSignatureAuthStatusMetadata()
    {
        return $this->container['enable_idfx_phone_auth_signature_auth_status_metadata'];
    }

    /**
     * Sets enable_idfx_phone_auth_signature_auth_status_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_idfx_phone_auth_signature_auth_status_metadata 
     *
     * @return $this
     */
    public function setEnableIdfxPhoneAuthSignatureAuthStatusMetadata($enable_idfx_phone_auth_signature_auth_status_metadata)
    {
        $this->container['enable_idfx_phone_auth_signature_auth_status_metadata'] = $enable_idfx_phone_auth_signature_auth_status_metadata;

        return $this;
    }

    /**
     * Gets enable_inbox_browse_views_powered_by_elastic_search
     *
     * @return ?string
     */
    public function getEnableInboxBrowseViewsPoweredByElasticSearch()
    {
        return $this->container['enable_inbox_browse_views_powered_by_elastic_search'];
    }

    /**
     * Sets enable_inbox_browse_views_powered_by_elastic_search
     *
     * @param ?string $enable_inbox_browse_views_powered_by_elastic_search 
     *
     * @return $this
     */
    public function setEnableInboxBrowseViewsPoweredByElasticSearch($enable_inbox_browse_views_powered_by_elastic_search)
    {
        $this->container['enable_inbox_browse_views_powered_by_elastic_search'] = $enable_inbox_browse_views_powered_by_elastic_search;

        return $this;
    }

    /**
     * Gets enable_inbox_browse_views_powered_by_elastic_search_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableInboxBrowseViewsPoweredByElasticSearchMetadata()
    {
        return $this->container['enable_inbox_browse_views_powered_by_elastic_search_metadata'];
    }

    /**
     * Sets enable_inbox_browse_views_powered_by_elastic_search_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_inbox_browse_views_powered_by_elastic_search_metadata 
     *
     * @return $this
     */
    public function setEnableInboxBrowseViewsPoweredByElasticSearchMetadata($enable_inbox_browse_views_powered_by_elastic_search_metadata)
    {
        $this->container['enable_inbox_browse_views_powered_by_elastic_search_metadata'] = $enable_inbox_browse_views_powered_by_elastic_search_metadata;

        return $this;
    }

    /**
     * Gets enable_inbox_relevance_sort
     *
     * @return ?string
     */
    public function getEnableInboxRelevanceSort()
    {
        return $this->container['enable_inbox_relevance_sort'];
    }

    /**
     * Sets enable_inbox_relevance_sort
     *
     * @param ?string $enable_inbox_relevance_sort 
     *
     * @return $this
     */
    public function setEnableInboxRelevanceSort($enable_inbox_relevance_sort)
    {
        $this->container['enable_inbox_relevance_sort'] = $enable_inbox_relevance_sort;

        return $this;
    }

    /**
     * Gets enable_inbox_relevance_sort_for_recent_accounts
     *
     * @return ?string
     */
    public function getEnableInboxRelevanceSortForRecentAccounts()
    {
        return $this->container['enable_inbox_relevance_sort_for_recent_accounts'];
    }

    /**
     * Sets enable_inbox_relevance_sort_for_recent_accounts
     *
     * @param ?string $enable_inbox_relevance_sort_for_recent_accounts 
     *
     * @return $this
     */
    public function setEnableInboxRelevanceSortForRecentAccounts($enable_inbox_relevance_sort_for_recent_accounts)
    {
        $this->container['enable_inbox_relevance_sort_for_recent_accounts'] = $enable_inbox_relevance_sort_for_recent_accounts;

        return $this;
    }

    /**
     * Gets enable_inbox_relevance_sort_for_recent_accounts_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableInboxRelevanceSortForRecentAccountsMetadata()
    {
        return $this->container['enable_inbox_relevance_sort_for_recent_accounts_metadata'];
    }

    /**
     * Sets enable_inbox_relevance_sort_for_recent_accounts_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_inbox_relevance_sort_for_recent_accounts_metadata 
     *
     * @return $this
     */
    public function setEnableInboxRelevanceSortForRecentAccountsMetadata($enable_inbox_relevance_sort_for_recent_accounts_metadata)
    {
        $this->container['enable_inbox_relevance_sort_for_recent_accounts_metadata'] = $enable_inbox_relevance_sort_for_recent_accounts_metadata;

        return $this;
    }

    /**
     * Gets enable_inbox_relevance_sort_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableInboxRelevanceSortMetadata()
    {
        return $this->container['enable_inbox_relevance_sort_metadata'];
    }

    /**
     * Sets enable_inbox_relevance_sort_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_inbox_relevance_sort_metadata 
     *
     * @return $this
     */
    public function setEnableInboxRelevanceSortMetadata($enable_inbox_relevance_sort_metadata)
    {
        $this->container['enable_inbox_relevance_sort_metadata'] = $enable_inbox_relevance_sort_metadata;

        return $this;
    }

    /**
     * Gets enable_in_browser_editor
     *
     * @return ?string
     */
    public function getEnableInBrowserEditor()
    {
        return $this->container['enable_in_browser_editor'];
    }

    /**
     * Sets enable_in_browser_editor
     *
     * @param ?string $enable_in_browser_editor 
     *
     * @return $this
     */
    public function setEnableInBrowserEditor($enable_in_browser_editor)
    {
        $this->container['enable_in_browser_editor'] = $enable_in_browser_editor;

        return $this;
    }

    /**
     * Gets enable_in_browser_editor_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableInBrowserEditorMetadata()
    {
        return $this->container['enable_in_browser_editor_metadata'];
    }

    /**
     * Sets enable_in_browser_editor_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_in_browser_editor_metadata 
     *
     * @return $this
     */
    public function setEnableInBrowserEditorMetadata($enable_in_browser_editor_metadata)
    {
        $this->container['enable_in_browser_editor_metadata'] = $enable_in_browser_editor_metadata;

        return $this;
    }

    /**
     * Gets enable_key_terms_suggestions_by_document_type
     *
     * @return ?string
     */
    public function getEnableKeyTermsSuggestionsByDocumentType()
    {
        return $this->container['enable_key_terms_suggestions_by_document_type'];
    }

    /**
     * Sets enable_key_terms_suggestions_by_document_type
     *
     * @param ?string $enable_key_terms_suggestions_by_document_type 
     *
     * @return $this
     */
    public function setEnableKeyTermsSuggestionsByDocumentType($enable_key_terms_suggestions_by_document_type)
    {
        $this->container['enable_key_terms_suggestions_by_document_type'] = $enable_key_terms_suggestions_by_document_type;

        return $this;
    }

    /**
     * Gets enable_key_terms_suggestions_by_document_type_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableKeyTermsSuggestionsByDocumentTypeMetadata()
    {
        return $this->container['enable_key_terms_suggestions_by_document_type_metadata'];
    }

    /**
     * Sets enable_key_terms_suggestions_by_document_type_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_key_terms_suggestions_by_document_type_metadata 
     *
     * @return $this
     */
    public function setEnableKeyTermsSuggestionsByDocumentTypeMetadata($enable_key_terms_suggestions_by_document_type_metadata)
    {
        $this->container['enable_key_terms_suggestions_by_document_type_metadata'] = $enable_key_terms_suggestions_by_document_type_metadata;

        return $this;
    }

    /**
     * Gets enable_participant_recipient_setting_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableParticipantRecipientSettingMetadata()
    {
        return $this->container['enable_participant_recipient_setting_metadata'];
    }

    /**
     * Sets enable_participant_recipient_setting_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_participant_recipient_setting_metadata 
     *
     * @return $this
     */
    public function setEnableParticipantRecipientSettingMetadata($enable_participant_recipient_setting_metadata)
    {
        $this->container['enable_participant_recipient_setting_metadata'] = $enable_participant_recipient_setting_metadata;

        return $this;
    }

    /**
     * Gets enable_payment_processing
     *
     * @return ?string
     */
    public function getEnablePaymentProcessing()
    {
        return $this->container['enable_payment_processing'];
    }

    /**
     * Sets enable_payment_processing
     *
     * @param ?string $enable_payment_processing 
     *
     * @return $this
     */
    public function setEnablePaymentProcessing($enable_payment_processing)
    {
        $this->container['enable_payment_processing'] = $enable_payment_processing;

        return $this;
    }

    /**
     * Gets enable_payment_processing_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnablePaymentProcessingMetadata()
    {
        return $this->container['enable_payment_processing_metadata'];
    }

    /**
     * Sets enable_payment_processing_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_payment_processing_metadata Metadata that indicates whether the `enablePaymentProcessing` property is editable.
     *
     * @return $this
     */
    public function setEnablePaymentProcessingMetadata($enable_payment_processing_metadata)
    {
        $this->container['enable_payment_processing_metadata'] = $enable_payment_processing_metadata;

        return $this;
    }

    /**
     * Gets enable_pdfa_conversion
     *
     * @return ?string
     */
    public function getEnablePdfaConversion()
    {
        return $this->container['enable_pdfa_conversion'];
    }

    /**
     * Sets enable_pdfa_conversion
     *
     * @param ?string $enable_pdfa_conversion 
     *
     * @return $this
     */
    public function setEnablePdfaConversion($enable_pdfa_conversion)
    {
        $this->container['enable_pdfa_conversion'] = $enable_pdfa_conversion;

        return $this;
    }

    /**
     * Gets enable_pdfa_conversion_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnablePdfaConversionMetadata()
    {
        return $this->container['enable_pdfa_conversion_metadata'];
    }

    /**
     * Sets enable_pdfa_conversion_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_pdfa_conversion_metadata 
     *
     * @return $this
     */
    public function setEnablePdfaConversionMetadata($enable_pdfa_conversion_metadata)
    {
        $this->container['enable_pdfa_conversion_metadata'] = $enable_pdfa_conversion_metadata;

        return $this;
    }

    /**
     * Gets enable_power_form
     *
     * @return ?string
     */
    public function getEnablePowerForm()
    {
        return $this->container['enable_power_form'];
    }

    /**
     * Sets enable_power_form
     *
     * @param ?string $enable_power_form 
     *
     * @return $this
     */
    public function setEnablePowerForm($enable_power_form)
    {
        $this->container['enable_power_form'] = $enable_power_form;

        return $this;
    }

    /**
     * Gets enable_power_form_direct
     *
     * @return ?string
     */
    public function getEnablePowerFormDirect()
    {
        return $this->container['enable_power_form_direct'];
    }

    /**
     * Sets enable_power_form_direct
     *
     * @param ?string $enable_power_form_direct 
     *
     * @return $this
     */
    public function setEnablePowerFormDirect($enable_power_form_direct)
    {
        $this->container['enable_power_form_direct'] = $enable_power_form_direct;

        return $this;
    }

    /**
     * Gets enable_power_form_direct_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnablePowerFormDirectMetadata()
    {
        return $this->container['enable_power_form_direct_metadata'];
    }

    /**
     * Sets enable_power_form_direct_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_power_form_direct_metadata Metadata that indicates whether the `enablePowerFormDirect` property is editable.
     *
     * @return $this
     */
    public function setEnablePowerFormDirectMetadata($enable_power_form_direct_metadata)
    {
        $this->container['enable_power_form_direct_metadata'] = $enable_power_form_direct_metadata;

        return $this;
    }

    /**
     * Gets enable_power_form_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnablePowerFormMetadata()
    {
        return $this->container['enable_power_form_metadata'];
    }

    /**
     * Sets enable_power_form_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_power_form_metadata Metadata that indicates whether the `enablePowerForm` property is editable.
     *
     * @return $this
     */
    public function setEnablePowerFormMetadata($enable_power_form_metadata)
    {
        $this->container['enable_power_form_metadata'] = $enable_power_form_metadata;

        return $this;
    }

    /**
     * Gets enable_recipient_domain_validation
     *
     * @return ?string
     */
    public function getEnableRecipientDomainValidation()
    {
        return $this->container['enable_recipient_domain_validation'];
    }

    /**
     * Sets enable_recipient_domain_validation
     *
     * @param ?string $enable_recipient_domain_validation 
     *
     * @return $this
     */
    public function setEnableRecipientDomainValidation($enable_recipient_domain_validation)
    {
        $this->container['enable_recipient_domain_validation'] = $enable_recipient_domain_validation;

        return $this;
    }

    /**
     * Gets enable_recipient_domain_validation_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableRecipientDomainValidationMetadata()
    {
        return $this->container['enable_recipient_domain_validation_metadata'];
    }

    /**
     * Sets enable_recipient_domain_validation_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_recipient_domain_validation_metadata Metadata that indicates whether the `enableRecipientDomainValidation` property is editable.
     *
     * @return $this
     */
    public function setEnableRecipientDomainValidationMetadata($enable_recipient_domain_validation_metadata)
    {
        $this->container['enable_recipient_domain_validation_metadata'] = $enable_recipient_domain_validation_metadata;

        return $this;
    }

    /**
     * Gets enable_recipient_may_provide_phone_number
     *
     * @return ?string
     */
    public function getEnableRecipientMayProvidePhoneNumber()
    {
        return $this->container['enable_recipient_may_provide_phone_number'];
    }

    /**
     * Sets enable_recipient_may_provide_phone_number
     *
     * @param ?string $enable_recipient_may_provide_phone_number 
     *
     * @return $this
     */
    public function setEnableRecipientMayProvidePhoneNumber($enable_recipient_may_provide_phone_number)
    {
        $this->container['enable_recipient_may_provide_phone_number'] = $enable_recipient_may_provide_phone_number;

        return $this;
    }

    /**
     * Gets enable_recipient_may_provide_phone_number_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableRecipientMayProvidePhoneNumberMetadata()
    {
        return $this->container['enable_recipient_may_provide_phone_number_metadata'];
    }

    /**
     * Sets enable_recipient_may_provide_phone_number_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_recipient_may_provide_phone_number_metadata 
     *
     * @return $this
     */
    public function setEnableRecipientMayProvidePhoneNumberMetadata($enable_recipient_may_provide_phone_number_metadata)
    {
        $this->container['enable_recipient_may_provide_phone_number_metadata'] = $enable_recipient_may_provide_phone_number_metadata;

        return $this;
    }

    /**
     * Gets enable_report_links
     *
     * @return ?string
     */
    public function getEnableReportLinks()
    {
        return $this->container['enable_report_links'];
    }

    /**
     * Sets enable_report_links
     *
     * @param ?string $enable_report_links 
     *
     * @return $this
     */
    public function setEnableReportLinks($enable_report_links)
    {
        $this->container['enable_report_links'] = $enable_report_links;

        return $this;
    }

    /**
     * Gets enable_report_links_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableReportLinksMetadata()
    {
        return $this->container['enable_report_links_metadata'];
    }

    /**
     * Sets enable_report_links_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_report_links_metadata Metadata that indicates whether the `enableReportLinks` property is editable.
     *
     * @return $this
     */
    public function setEnableReportLinksMetadata($enable_report_links_metadata)
    {
        $this->container['enable_report_links_metadata'] = $enable_report_links_metadata;

        return $this;
    }

    /**
     * Gets enable_require_sign_on_paper
     *
     * @return ?string
     */
    public function getEnableRequireSignOnPaper()
    {
        return $this->container['enable_require_sign_on_paper'];
    }

    /**
     * Sets enable_require_sign_on_paper
     *
     * @param ?string $enable_require_sign_on_paper 
     *
     * @return $this
     */
    public function setEnableRequireSignOnPaper($enable_require_sign_on_paper)
    {
        $this->container['enable_require_sign_on_paper'] = $enable_require_sign_on_paper;

        return $this;
    }

    /**
     * Gets enable_require_sign_on_paper_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableRequireSignOnPaperMetadata()
    {
        return $this->container['enable_require_sign_on_paper_metadata'];
    }

    /**
     * Sets enable_require_sign_on_paper_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_require_sign_on_paper_metadata Metadata that indicates whether the `enableRequireSignOnPaper` property is editable.
     *
     * @return $this
     */
    public function setEnableRequireSignOnPaperMetadata($enable_require_sign_on_paper_metadata)
    {
        $this->container['enable_require_sign_on_paper_metadata'] = $enable_require_sign_on_paper_metadata;

        return $this;
    }

    /**
     * Gets enable_reserved_domain
     *
     * @return ?string
     */
    public function getEnableReservedDomain()
    {
        return $this->container['enable_reserved_domain'];
    }

    /**
     * Sets enable_reserved_domain
     *
     * @param ?string $enable_reserved_domain 
     *
     * @return $this
     */
    public function setEnableReservedDomain($enable_reserved_domain)
    {
        $this->container['enable_reserved_domain'] = $enable_reserved_domain;

        return $this;
    }

    /**
     * Gets enable_reserved_domain_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableReservedDomainMetadata()
    {
        return $this->container['enable_reserved_domain_metadata'];
    }

    /**
     * Sets enable_reserved_domain_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_reserved_domain_metadata Metadata that indicates whether the `enableReservedDomain` property is editable.
     *
     * @return $this
     */
    public function setEnableReservedDomainMetadata($enable_reserved_domain_metadata)
    {
        $this->container['enable_reserved_domain_metadata'] = $enable_reserved_domain_metadata;

        return $this;
    }

    /**
     * Gets enable_responsive_signing
     *
     * @return ?string
     */
    public function getEnableResponsiveSigning()
    {
        return $this->container['enable_responsive_signing'];
    }

    /**
     * Sets enable_responsive_signing
     *
     * @param ?string $enable_responsive_signing 
     *
     * @return $this
     */
    public function setEnableResponsiveSigning($enable_responsive_signing)
    {
        $this->container['enable_responsive_signing'] = $enable_responsive_signing;

        return $this;
    }

    /**
     * Gets enable_responsive_signing_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableResponsiveSigningMetadata()
    {
        return $this->container['enable_responsive_signing_metadata'];
    }

    /**
     * Sets enable_responsive_signing_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_responsive_signing_metadata Metadata that indicates whether the `enableResponsiveSigning` property is editable.
     *
     * @return $this
     */
    public function setEnableResponsiveSigningMetadata($enable_responsive_signing_metadata)
    {
        $this->container['enable_responsive_signing_metadata'] = $enable_responsive_signing_metadata;

        return $this;
    }

    /**
     * Gets enable_scheduled_release
     *
     * @return ?string
     */
    public function getEnableScheduledRelease()
    {
        return $this->container['enable_scheduled_release'];
    }

    /**
     * Sets enable_scheduled_release
     *
     * @param ?string $enable_scheduled_release 
     *
     * @return $this
     */
    public function setEnableScheduledRelease($enable_scheduled_release)
    {
        $this->container['enable_scheduled_release'] = $enable_scheduled_release;

        return $this;
    }

    /**
     * Gets enable_scheduled_release_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableScheduledReleaseMetadata()
    {
        return $this->container['enable_scheduled_release_metadata'];
    }

    /**
     * Sets enable_scheduled_release_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_scheduled_release_metadata Metadata that indicates whether the `enableScheduledRelease` property is editable.
     *
     * @return $this
     */
    public function setEnableScheduledReleaseMetadata($enable_scheduled_release_metadata)
    {
        $this->container['enable_scheduled_release_metadata'] = $enable_scheduled_release_metadata;

        return $this;
    }

    /**
     * Gets enable_search
     *
     * @return ?string
     */
    public function getEnableSearch()
    {
        return $this->container['enable_search'];
    }

    /**
     * Sets enable_search
     *
     * @param ?string $enable_search 
     *
     * @return $this
     */
    public function setEnableSearch($enable_search)
    {
        $this->container['enable_search'] = $enable_search;

        return $this;
    }

    /**
     * Gets enable_search_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSearchMetadata()
    {
        return $this->container['enable_search_metadata'];
    }

    /**
     * Sets enable_search_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_search_metadata 
     *
     * @return $this
     */
    public function setEnableSearchMetadata($enable_search_metadata)
    {
        $this->container['enable_search_metadata'] = $enable_search_metadata;

        return $this;
    }

    /**
     * Gets enable_search_service_azure_uri
     *
     * @return ?string
     */
    public function getEnableSearchServiceAzureUri()
    {
        return $this->container['enable_search_service_azure_uri'];
    }

    /**
     * Sets enable_search_service_azure_uri
     *
     * @param ?string $enable_search_service_azure_uri 
     *
     * @return $this
     */
    public function setEnableSearchServiceAzureUri($enable_search_service_azure_uri)
    {
        $this->container['enable_search_service_azure_uri'] = $enable_search_service_azure_uri;

        return $this;
    }

    /**
     * Gets enable_search_service_azure_uri_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSearchServiceAzureUriMetadata()
    {
        return $this->container['enable_search_service_azure_uri_metadata'];
    }

    /**
     * Sets enable_search_service_azure_uri_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_search_service_azure_uri_metadata 
     *
     * @return $this
     */
    public function setEnableSearchServiceAzureUriMetadata($enable_search_service_azure_uri_metadata)
    {
        $this->container['enable_search_service_azure_uri_metadata'] = $enable_search_service_azure_uri_metadata;

        return $this;
    }

    /**
     * Gets enable_search_site_specific_api
     *
     * @return ?string
     */
    public function getEnableSearchSiteSpecificApi()
    {
        return $this->container['enable_search_site_specific_api'];
    }

    /**
     * Sets enable_search_site_specific_api
     *
     * @param ?string $enable_search_site_specific_api 
     *
     * @return $this
     */
    public function setEnableSearchSiteSpecificApi($enable_search_site_specific_api)
    {
        $this->container['enable_search_site_specific_api'] = $enable_search_site_specific_api;

        return $this;
    }

    /**
     * Gets enable_search_site_specific_api_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSearchSiteSpecificApiMetadata()
    {
        return $this->container['enable_search_site_specific_api_metadata'];
    }

    /**
     * Sets enable_search_site_specific_api_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_search_site_specific_api_metadata 
     *
     * @return $this
     */
    public function setEnableSearchSiteSpecificApiMetadata($enable_search_site_specific_api_metadata)
    {
        $this->container['enable_search_site_specific_api_metadata'] = $enable_search_site_specific_api_metadata;

        return $this;
    }

    /**
     * Gets enable_search_ui
     *
     * @return ?string
     */
    public function getEnableSearchUi()
    {
        return $this->container['enable_search_ui'];
    }

    /**
     * Sets enable_search_ui
     *
     * @param ?string $enable_search_ui 
     *
     * @return $this
     */
    public function setEnableSearchUi($enable_search_ui)
    {
        $this->container['enable_search_ui'] = $enable_search_ui;

        return $this;
    }

    /**
     * Gets enable_search_ui_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSearchUiMetadata()
    {
        return $this->container['enable_search_ui_metadata'];
    }

    /**
     * Sets enable_search_ui_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_search_ui_metadata 
     *
     * @return $this
     */
    public function setEnableSearchUiMetadata($enable_search_ui_metadata)
    {
        $this->container['enable_search_ui_metadata'] = $enable_search_ui_metadata;

        return $this;
    }

    /**
     * Gets enable_sending_tags_font_settings
     *
     * @return ?string
     */
    public function getEnableSendingTagsFontSettings()
    {
        return $this->container['enable_sending_tags_font_settings'];
    }

    /**
     * Sets enable_sending_tags_font_settings
     *
     * @param ?string $enable_sending_tags_font_settings 
     *
     * @return $this
     */
    public function setEnableSendingTagsFontSettings($enable_sending_tags_font_settings)
    {
        $this->container['enable_sending_tags_font_settings'] = $enable_sending_tags_font_settings;

        return $this;
    }

    /**
     * Gets enable_sending_tags_font_settings_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSendingTagsFontSettingsMetadata()
    {
        return $this->container['enable_sending_tags_font_settings_metadata'];
    }

    /**
     * Sets enable_sending_tags_font_settings_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_sending_tags_font_settings_metadata Metadata that indicates whether the `enableSendingTagsFontSettings` property is editable.
     *
     * @return $this
     */
    public function setEnableSendingTagsFontSettingsMetadata($enable_sending_tags_font_settings_metadata)
    {
        $this->container['enable_sending_tags_font_settings_metadata'] = $enable_sending_tags_font_settings_metadata;

        return $this;
    }

    /**
     * Gets enable_send_to_agent
     *
     * @return ?string
     */
    public function getEnableSendToAgent()
    {
        return $this->container['enable_send_to_agent'];
    }

    /**
     * Sets enable_send_to_agent
     *
     * @param ?string $enable_send_to_agent 
     *
     * @return $this
     */
    public function setEnableSendToAgent($enable_send_to_agent)
    {
        $this->container['enable_send_to_agent'] = $enable_send_to_agent;

        return $this;
    }

    /**
     * Gets enable_send_to_agent_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSendToAgentMetadata()
    {
        return $this->container['enable_send_to_agent_metadata'];
    }

    /**
     * Sets enable_send_to_agent_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_send_to_agent_metadata Metadata that indicates whether the `enableSendToAgent` property is editable.
     *
     * @return $this
     */
    public function setEnableSendToAgentMetadata($enable_send_to_agent_metadata)
    {
        $this->container['enable_send_to_agent_metadata'] = $enable_send_to_agent_metadata;

        return $this;
    }

    /**
     * Gets enable_send_to_intermediary
     *
     * @return ?string
     */
    public function getEnableSendToIntermediary()
    {
        return $this->container['enable_send_to_intermediary'];
    }

    /**
     * Sets enable_send_to_intermediary
     *
     * @param ?string $enable_send_to_intermediary 
     *
     * @return $this
     */
    public function setEnableSendToIntermediary($enable_send_to_intermediary)
    {
        $this->container['enable_send_to_intermediary'] = $enable_send_to_intermediary;

        return $this;
    }

    /**
     * Gets enable_send_to_intermediary_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSendToIntermediaryMetadata()
    {
        return $this->container['enable_send_to_intermediary_metadata'];
    }

    /**
     * Sets enable_send_to_intermediary_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_send_to_intermediary_metadata Metadata that indicates whether the `enableSendToIntermediary` property is editable.
     *
     * @return $this
     */
    public function setEnableSendToIntermediaryMetadata($enable_send_to_intermediary_metadata)
    {
        $this->container['enable_send_to_intermediary_metadata'] = $enable_send_to_intermediary_metadata;

        return $this;
    }

    /**
     * Gets enable_send_to_manage
     *
     * @return ?string
     */
    public function getEnableSendToManage()
    {
        return $this->container['enable_send_to_manage'];
    }

    /**
     * Sets enable_send_to_manage
     *
     * @param ?string $enable_send_to_manage 
     *
     * @return $this
     */
    public function setEnableSendToManage($enable_send_to_manage)
    {
        $this->container['enable_send_to_manage'] = $enable_send_to_manage;

        return $this;
    }

    /**
     * Gets enable_send_to_manage_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSendToManageMetadata()
    {
        return $this->container['enable_send_to_manage_metadata'];
    }

    /**
     * Sets enable_send_to_manage_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_send_to_manage_metadata Metadata that indicates whether the `enableSendToManage` property is editable.
     *
     * @return $this
     */
    public function setEnableSendToManageMetadata($enable_send_to_manage_metadata)
    {
        $this->container['enable_send_to_manage_metadata'] = $enable_send_to_manage_metadata;

        return $this;
    }

    /**
     * Gets enable_sequential_signing_api
     *
     * @return ?string
     */
    public function getEnableSequentialSigningApi()
    {
        return $this->container['enable_sequential_signing_api'];
    }

    /**
     * Sets enable_sequential_signing_api
     *
     * @param ?string $enable_sequential_signing_api 
     *
     * @return $this
     */
    public function setEnableSequentialSigningApi($enable_sequential_signing_api)
    {
        $this->container['enable_sequential_signing_api'] = $enable_sequential_signing_api;

        return $this;
    }

    /**
     * Gets enable_sequential_signing_api_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSequentialSigningApiMetadata()
    {
        return $this->container['enable_sequential_signing_api_metadata'];
    }

    /**
     * Sets enable_sequential_signing_api_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_sequential_signing_api_metadata Metadata that indicates whether the `enableSequentialSigningAPI` property is editable.
     *
     * @return $this
     */
    public function setEnableSequentialSigningApiMetadata($enable_sequential_signing_api_metadata)
    {
        $this->container['enable_sequential_signing_api_metadata'] = $enable_sequential_signing_api_metadata;

        return $this;
    }

    /**
     * Gets enable_sequential_signing_ui
     *
     * @return ?string
     */
    public function getEnableSequentialSigningUi()
    {
        return $this->container['enable_sequential_signing_ui'];
    }

    /**
     * Sets enable_sequential_signing_ui
     *
     * @param ?string $enable_sequential_signing_ui 
     *
     * @return $this
     */
    public function setEnableSequentialSigningUi($enable_sequential_signing_ui)
    {
        $this->container['enable_sequential_signing_ui'] = $enable_sequential_signing_ui;

        return $this;
    }

    /**
     * Gets enable_sequential_signing_ui_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSequentialSigningUiMetadata()
    {
        return $this->container['enable_sequential_signing_ui_metadata'];
    }

    /**
     * Sets enable_sequential_signing_ui_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_sequential_signing_ui_metadata Metadata that indicates whether the `enableSequentialSigningUI` property is editable.
     *
     * @return $this
     */
    public function setEnableSequentialSigningUiMetadata($enable_sequential_signing_ui_metadata)
    {
        $this->container['enable_sequential_signing_ui_metadata'] = $enable_sequential_signing_ui_metadata;

        return $this;
    }

    /**
     * Gets enable_signer_attachments
     *
     * @return ?string
     */
    public function getEnableSignerAttachments()
    {
        return $this->container['enable_signer_attachments'];
    }

    /**
     * Sets enable_signer_attachments
     *
     * @param ?string $enable_signer_attachments 
     *
     * @return $this
     */
    public function setEnableSignerAttachments($enable_signer_attachments)
    {
        $this->container['enable_signer_attachments'] = $enable_signer_attachments;

        return $this;
    }

    /**
     * Gets enable_signer_attachments_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSignerAttachmentsMetadata()
    {
        return $this->container['enable_signer_attachments_metadata'];
    }

    /**
     * Sets enable_signer_attachments_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_signer_attachments_metadata Metadata that indicates whether the `enableSignerAttachments` property is editable.
     *
     * @return $this
     */
    public function setEnableSignerAttachmentsMetadata($enable_signer_attachments_metadata)
    {
        $this->container['enable_signer_attachments_metadata'] = $enable_signer_attachments_metadata;

        return $this;
    }

    /**
     * Gets enable_signing_extension_comments
     *
     * @return ?string
     */
    public function getEnableSigningExtensionComments()
    {
        return $this->container['enable_signing_extension_comments'];
    }

    /**
     * Sets enable_signing_extension_comments
     *
     * @param ?string $enable_signing_extension_comments 
     *
     * @return $this
     */
    public function setEnableSigningExtensionComments($enable_signing_extension_comments)
    {
        $this->container['enable_signing_extension_comments'] = $enable_signing_extension_comments;

        return $this;
    }

    /**
     * Gets enable_signing_extension_comments_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSigningExtensionCommentsMetadata()
    {
        return $this->container['enable_signing_extension_comments_metadata'];
    }

    /**
     * Sets enable_signing_extension_comments_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_signing_extension_comments_metadata Metadata that indicates whether the `enableSigningExtensionComments` property is editable.
     *
     * @return $this
     */
    public function setEnableSigningExtensionCommentsMetadata($enable_signing_extension_comments_metadata)
    {
        $this->container['enable_signing_extension_comments_metadata'] = $enable_signing_extension_comments_metadata;

        return $this;
    }

    /**
     * Gets enable_signing_extension_conversations
     *
     * @return ?string
     */
    public function getEnableSigningExtensionConversations()
    {
        return $this->container['enable_signing_extension_conversations'];
    }

    /**
     * Sets enable_signing_extension_conversations
     *
     * @param ?string $enable_signing_extension_conversations 
     *
     * @return $this
     */
    public function setEnableSigningExtensionConversations($enable_signing_extension_conversations)
    {
        $this->container['enable_signing_extension_conversations'] = $enable_signing_extension_conversations;

        return $this;
    }

    /**
     * Gets enable_signing_extension_conversations_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSigningExtensionConversationsMetadata()
    {
        return $this->container['enable_signing_extension_conversations_metadata'];
    }

    /**
     * Sets enable_signing_extension_conversations_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_signing_extension_conversations_metadata Metadata that indicates whether the `enableSigningExtensionConversations` property is editable.
     *
     * @return $this
     */
    public function setEnableSigningExtensionConversationsMetadata($enable_signing_extension_conversations_metadata)
    {
        $this->container['enable_signing_extension_conversations_metadata'] = $enable_signing_extension_conversations_metadata;

        return $this;
    }

    /**
     * Gets enable_signing_order_settings_for_account
     *
     * @return ?string
     */
    public function getEnableSigningOrderSettingsForAccount()
    {
        return $this->container['enable_signing_order_settings_for_account'];
    }

    /**
     * Sets enable_signing_order_settings_for_account
     *
     * @param ?string $enable_signing_order_settings_for_account 
     *
     * @return $this
     */
    public function setEnableSigningOrderSettingsForAccount($enable_signing_order_settings_for_account)
    {
        $this->container['enable_signing_order_settings_for_account'] = $enable_signing_order_settings_for_account;

        return $this;
    }

    /**
     * Gets enable_signing_order_settings_for_account_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSigningOrderSettingsForAccountMetadata()
    {
        return $this->container['enable_signing_order_settings_for_account_metadata'];
    }

    /**
     * Sets enable_signing_order_settings_for_account_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_signing_order_settings_for_account_metadata Metadata that indicates whether the `enableSigningOrderSettingsForAccount` property is editable.
     *
     * @return $this
     */
    public function setEnableSigningOrderSettingsForAccountMetadata($enable_signing_order_settings_for_account_metadata)
    {
        $this->container['enable_signing_order_settings_for_account_metadata'] = $enable_signing_order_settings_for_account_metadata;

        return $this;
    }

    /**
     * Gets enable_sign_on_paper
     *
     * @return ?string
     */
    public function getEnableSignOnPaper()
    {
        return $this->container['enable_sign_on_paper'];
    }

    /**
     * Sets enable_sign_on_paper
     *
     * @param ?string $enable_sign_on_paper 
     *
     * @return $this
     */
    public function setEnableSignOnPaper($enable_sign_on_paper)
    {
        $this->container['enable_sign_on_paper'] = $enable_sign_on_paper;

        return $this;
    }

    /**
     * Gets enable_sign_on_paper_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSignOnPaperMetadata()
    {
        return $this->container['enable_sign_on_paper_metadata'];
    }

    /**
     * Sets enable_sign_on_paper_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_sign_on_paper_metadata Metadata that indicates whether the `enableSignOnPaper` property is editable.
     *
     * @return $this
     */
    public function setEnableSignOnPaperMetadata($enable_sign_on_paper_metadata)
    {
        $this->container['enable_sign_on_paper_metadata'] = $enable_sign_on_paper_metadata;

        return $this;
    }

    /**
     * Gets enable_sign_on_paper_override
     *
     * @return ?string
     */
    public function getEnableSignOnPaperOverride()
    {
        return $this->container['enable_sign_on_paper_override'];
    }

    /**
     * Sets enable_sign_on_paper_override
     *
     * @param ?string $enable_sign_on_paper_override 
     *
     * @return $this
     */
    public function setEnableSignOnPaperOverride($enable_sign_on_paper_override)
    {
        $this->container['enable_sign_on_paper_override'] = $enable_sign_on_paper_override;

        return $this;
    }

    /**
     * Gets enable_sign_on_paper_override_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSignOnPaperOverrideMetadata()
    {
        return $this->container['enable_sign_on_paper_override_metadata'];
    }

    /**
     * Sets enable_sign_on_paper_override_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_sign_on_paper_override_metadata Metadata that indicates whether the `enableSignOnPaperOverride` property is editable.
     *
     * @return $this
     */
    public function setEnableSignOnPaperOverrideMetadata($enable_sign_on_paper_override_metadata)
    {
        $this->container['enable_sign_on_paper_override_metadata'] = $enable_sign_on_paper_override_metadata;

        return $this;
    }

    /**
     * Gets enable_sign_with_notary
     *
     * @return ?string
     */
    public function getEnableSignWithNotary()
    {
        return $this->container['enable_sign_with_notary'];
    }

    /**
     * Sets enable_sign_with_notary
     *
     * @param ?string $enable_sign_with_notary 
     *
     * @return $this
     */
    public function setEnableSignWithNotary($enable_sign_with_notary)
    {
        $this->container['enable_sign_with_notary'] = $enable_sign_with_notary;

        return $this;
    }

    /**
     * Gets enable_sign_with_notary_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSignWithNotaryMetadata()
    {
        return $this->container['enable_sign_with_notary_metadata'];
    }

    /**
     * Sets enable_sign_with_notary_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_sign_with_notary_metadata Metadata that indicates whether the `enableSignWithNotary` property is editable.
     *
     * @return $this
     */
    public function setEnableSignWithNotaryMetadata($enable_sign_with_notary_metadata)
    {
        $this->container['enable_sign_with_notary_metadata'] = $enable_sign_with_notary_metadata;

        return $this;
    }

    /**
     * Gets enable_smart_contracts
     *
     * @return ?string
     */
    public function getEnableSmartContracts()
    {
        return $this->container['enable_smart_contracts'];
    }

    /**
     * Sets enable_smart_contracts
     *
     * @param ?string $enable_smart_contracts 
     *
     * @return $this
     */
    public function setEnableSmartContracts($enable_smart_contracts)
    {
        $this->container['enable_smart_contracts'] = $enable_smart_contracts;

        return $this;
    }

    /**
     * Gets enable_smart_contracts_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSmartContractsMetadata()
    {
        return $this->container['enable_smart_contracts_metadata'];
    }

    /**
     * Sets enable_smart_contracts_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_smart_contracts_metadata Metadata that indicates whether the `enableSmartContracts` property is editable.
     *
     * @return $this
     */
    public function setEnableSmartContractsMetadata($enable_smart_contracts_metadata)
    {
        $this->container['enable_smart_contracts_metadata'] = $enable_smart_contracts_metadata;

        return $this;
    }

    /**
     * Gets enable_sms_authentication
     *
     * @return ?string
     */
    public function getEnableSmsAuthentication()
    {
        return $this->container['enable_sms_authentication'];
    }

    /**
     * Sets enable_sms_authentication
     *
     * @param ?string $enable_sms_authentication 
     *
     * @return $this
     */
    public function setEnableSmsAuthentication($enable_sms_authentication)
    {
        $this->container['enable_sms_authentication'] = $enable_sms_authentication;

        return $this;
    }

    /**
     * Gets enable_sms_authentication_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSmsAuthenticationMetadata()
    {
        return $this->container['enable_sms_authentication_metadata'];
    }

    /**
     * Sets enable_sms_authentication_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_sms_authentication_metadata Metadata that indicates whether the `enableSMSAuthentication` property is editable.
     *
     * @return $this
     */
    public function setEnableSmsAuthenticationMetadata($enable_sms_authentication_metadata)
    {
        $this->container['enable_sms_authentication_metadata'] = $enable_sms_authentication_metadata;

        return $this;
    }

    /**
     * Gets enable_sms_delivery_additional_notification
     *
     * @return ?string
     */
    public function getEnableSmsDeliveryAdditionalNotification()
    {
        return $this->container['enable_sms_delivery_additional_notification'];
    }

    /**
     * Sets enable_sms_delivery_additional_notification
     *
     * @param ?string $enable_sms_delivery_additional_notification 
     *
     * @return $this
     */
    public function setEnableSmsDeliveryAdditionalNotification($enable_sms_delivery_additional_notification)
    {
        $this->container['enable_sms_delivery_additional_notification'] = $enable_sms_delivery_additional_notification;

        return $this;
    }

    /**
     * Gets enable_sms_delivery_additional_notification_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSmsDeliveryAdditionalNotificationMetadata()
    {
        return $this->container['enable_sms_delivery_additional_notification_metadata'];
    }

    /**
     * Sets enable_sms_delivery_additional_notification_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_sms_delivery_additional_notification_metadata 
     *
     * @return $this
     */
    public function setEnableSmsDeliveryAdditionalNotificationMetadata($enable_sms_delivery_additional_notification_metadata)
    {
        $this->container['enable_sms_delivery_additional_notification_metadata'] = $enable_sms_delivery_additional_notification_metadata;

        return $this;
    }

    /**
     * Gets enable_sms_delivery_primary
     *
     * @return ?string
     */
    public function getEnableSmsDeliveryPrimary()
    {
        return $this->container['enable_sms_delivery_primary'];
    }

    /**
     * Sets enable_sms_delivery_primary
     *
     * @param ?string $enable_sms_delivery_primary 
     *
     * @return $this
     */
    public function setEnableSmsDeliveryPrimary($enable_sms_delivery_primary)
    {
        $this->container['enable_sms_delivery_primary'] = $enable_sms_delivery_primary;

        return $this;
    }

    /**
     * Gets enable_social_id_login
     *
     * @return ?string
     */
    public function getEnableSocialIdLogin()
    {
        return $this->container['enable_social_id_login'];
    }

    /**
     * Sets enable_social_id_login
     *
     * @param ?string $enable_social_id_login 
     *
     * @return $this
     */
    public function setEnableSocialIdLogin($enable_social_id_login)
    {
        $this->container['enable_social_id_login'] = $enable_social_id_login;

        return $this;
    }

    /**
     * Gets enable_social_id_login_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSocialIdLoginMetadata()
    {
        return $this->container['enable_social_id_login_metadata'];
    }

    /**
     * Sets enable_social_id_login_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_social_id_login_metadata Deprecated.
     *
     * @return $this
     */
    public function setEnableSocialIdLoginMetadata($enable_social_id_login_metadata)
    {
        $this->container['enable_social_id_login_metadata'] = $enable_social_id_login_metadata;

        return $this;
    }

    /**
     * Gets enable_strike_through
     *
     * @return ?string
     */
    public function getEnableStrikeThrough()
    {
        return $this->container['enable_strike_through'];
    }

    /**
     * Sets enable_strike_through
     *
     * @param ?string $enable_strike_through 
     *
     * @return $this
     */
    public function setEnableStrikeThrough($enable_strike_through)
    {
        $this->container['enable_strike_through'] = $enable_strike_through;

        return $this;
    }

    /**
     * Gets enable_strike_through_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableStrikeThroughMetadata()
    {
        return $this->container['enable_strike_through_metadata'];
    }

    /**
     * Sets enable_strike_through_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_strike_through_metadata Metadata that indicates whether the `enableStrikeThrough` property is editable.
     *
     * @return $this
     */
    public function setEnableStrikeThroughMetadata($enable_strike_through_metadata)
    {
        $this->container['enable_strike_through_metadata'] = $enable_strike_through_metadata;

        return $this;
    }

    /**
     * Gets enable_transaction_point
     *
     * @return ?string
     */
    public function getEnableTransactionPoint()
    {
        return $this->container['enable_transaction_point'];
    }

    /**
     * Sets enable_transaction_point
     *
     * @param ?string $enable_transaction_point 
     *
     * @return $this
     */
    public function setEnableTransactionPoint($enable_transaction_point)
    {
        $this->container['enable_transaction_point'] = $enable_transaction_point;

        return $this;
    }

    /**
     * Gets enable_transaction_point_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableTransactionPointMetadata()
    {
        return $this->container['enable_transaction_point_metadata'];
    }

    /**
     * Sets enable_transaction_point_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_transaction_point_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setEnableTransactionPointMetadata($enable_transaction_point_metadata)
    {
        $this->container['enable_transaction_point_metadata'] = $enable_transaction_point_metadata;

        return $this;
    }

    /**
     * Gets enable_vaulting
     *
     * @return ?string
     */
    public function getEnableVaulting()
    {
        return $this->container['enable_vaulting'];
    }

    /**
     * Sets enable_vaulting
     *
     * @param ?string $enable_vaulting 
     *
     * @return $this
     */
    public function setEnableVaulting($enable_vaulting)
    {
        $this->container['enable_vaulting'] = $enable_vaulting;

        return $this;
    }

    /**
     * Gets enable_vaulting_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableVaultingMetadata()
    {
        return $this->container['enable_vaulting_metadata'];
    }

    /**
     * Sets enable_vaulting_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_vaulting_metadata Metadata that indicates whether the `enableVaulting` property is editable.
     *
     * @return $this
     */
    public function setEnableVaultingMetadata($enable_vaulting_metadata)
    {
        $this->container['enable_vaulting_metadata'] = $enable_vaulting_metadata;

        return $this;
    }

    /**
     * Gets enable_web_forms_separate_user_permissions
     *
     * @return ?string
     */
    public function getEnableWebFormsSeparateUserPermissions()
    {
        return $this->container['enable_web_forms_separate_user_permissions'];
    }

    /**
     * Sets enable_web_forms_separate_user_permissions
     *
     * @param ?string $enable_web_forms_separate_user_permissions 
     *
     * @return $this
     */
    public function setEnableWebFormsSeparateUserPermissions($enable_web_forms_separate_user_permissions)
    {
        $this->container['enable_web_forms_separate_user_permissions'] = $enable_web_forms_separate_user_permissions;

        return $this;
    }

    /**
     * Gets enable_web_forms_separate_user_permissions_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableWebFormsSeparateUserPermissionsMetadata()
    {
        return $this->container['enable_web_forms_separate_user_permissions_metadata'];
    }

    /**
     * Sets enable_web_forms_separate_user_permissions_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_web_forms_separate_user_permissions_metadata 
     *
     * @return $this
     */
    public function setEnableWebFormsSeparateUserPermissionsMetadata($enable_web_forms_separate_user_permissions_metadata)
    {
        $this->container['enable_web_forms_separate_user_permissions_metadata'] = $enable_web_forms_separate_user_permissions_metadata;

        return $this;
    }

    /**
     * Gets enable_witnessing
     *
     * @return ?string
     */
    public function getEnableWitnessing()
    {
        return $this->container['enable_witnessing'];
    }

    /**
     * Sets enable_witnessing
     *
     * @param ?string $enable_witnessing 
     *
     * @return $this
     */
    public function setEnableWitnessing($enable_witnessing)
    {
        $this->container['enable_witnessing'] = $enable_witnessing;

        return $this;
    }

    /**
     * Gets enable_witnessing_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableWitnessingMetadata()
    {
        return $this->container['enable_witnessing_metadata'];
    }

    /**
     * Sets enable_witnessing_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_witnessing_metadata Metadata that indicates whether the `enableWitnessing` property is editable.
     *
     * @return $this
     */
    public function setEnableWitnessingMetadata($enable_witnessing_metadata)
    {
        $this->container['enable_witnessing_metadata'] = $enable_witnessing_metadata;

        return $this;
    }

    /**
     * Gets enforce_template_name_uniqueness
     *
     * @return ?string
     */
    public function getEnforceTemplateNameUniqueness()
    {
        return $this->container['enforce_template_name_uniqueness'];
    }

    /**
     * Sets enforce_template_name_uniqueness
     *
     * @param ?string $enforce_template_name_uniqueness 
     *
     * @return $this
     */
    public function setEnforceTemplateNameUniqueness($enforce_template_name_uniqueness)
    {
        $this->container['enforce_template_name_uniqueness'] = $enforce_template_name_uniqueness;

        return $this;
    }

    /**
     * Gets enforce_template_name_uniqueness_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnforceTemplateNameUniquenessMetadata()
    {
        return $this->container['enforce_template_name_uniqueness_metadata'];
    }

    /**
     * Sets enforce_template_name_uniqueness_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enforce_template_name_uniqueness_metadata Metadata that indicates whether the `enforceTemplateNameUniqueness` property is editable.
     *
     * @return $this
     */
    public function setEnforceTemplateNameUniquenessMetadata($enforce_template_name_uniqueness_metadata)
    {
        $this->container['enforce_template_name_uniqueness_metadata'] = $enforce_template_name_uniqueness_metadata;

        return $this;
    }

    /**
     * Gets enforce_tls_emails
     *
     * @return ?string
     */
    public function getEnforceTlsEmails()
    {
        return $this->container['enforce_tls_emails'];
    }

    /**
     * Sets enforce_tls_emails
     *
     * @param ?string $enforce_tls_emails 
     *
     * @return $this
     */
    public function setEnforceTlsEmails($enforce_tls_emails)
    {
        $this->container['enforce_tls_emails'] = $enforce_tls_emails;

        return $this;
    }

    /**
     * Gets enforce_tls_emails_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnforceTlsEmailsMetadata()
    {
        return $this->container['enforce_tls_emails_metadata'];
    }

    /**
     * Sets enforce_tls_emails_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $enforce_tls_emails_metadata 
     *
     * @return $this
     */
    public function setEnforceTlsEmailsMetadata($enforce_tls_emails_metadata)
    {
        $this->container['enforce_tls_emails_metadata'] = $enforce_tls_emails_metadata;

        return $this;
    }

    /**
     * Gets envelope_integration_allowed
     *
     * @return ?string
     */
    public function getEnvelopeIntegrationAllowed()
    {
        return $this->container['envelope_integration_allowed'];
    }

    /**
     * Sets envelope_integration_allowed
     *
     * @param ?string $envelope_integration_allowed 
     *
     * @return $this
     */
    public function setEnvelopeIntegrationAllowed($envelope_integration_allowed)
    {
        $this->container['envelope_integration_allowed'] = $envelope_integration_allowed;

        return $this;
    }

    /**
     * Gets envelope_integration_allowed_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnvelopeIntegrationAllowedMetadata()
    {
        return $this->container['envelope_integration_allowed_metadata'];
    }

    /**
     * Sets envelope_integration_allowed_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $envelope_integration_allowed_metadata Metadata that indicates whether the `envelopeIntegrationAllowed` property is editable.
     *
     * @return $this
     */
    public function setEnvelopeIntegrationAllowedMetadata($envelope_integration_allowed_metadata)
    {
        $this->container['envelope_integration_allowed_metadata'] = $envelope_integration_allowed_metadata;

        return $this;
    }

    /**
     * Gets envelope_integration_enabled
     *
     * @return ?string
     */
    public function getEnvelopeIntegrationEnabled()
    {
        return $this->container['envelope_integration_enabled'];
    }

    /**
     * Sets envelope_integration_enabled
     *
     * @param ?string $envelope_integration_enabled 
     *
     * @return $this
     */
    public function setEnvelopeIntegrationEnabled($envelope_integration_enabled)
    {
        $this->container['envelope_integration_enabled'] = $envelope_integration_enabled;

        return $this;
    }

    /**
     * Gets envelope_integration_enabled_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnvelopeIntegrationEnabledMetadata()
    {
        return $this->container['envelope_integration_enabled_metadata'];
    }

    /**
     * Sets envelope_integration_enabled_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $envelope_integration_enabled_metadata Metadata that indicates whether the `envelopeIntegrationEnabled` property is editable.
     *
     * @return $this
     */
    public function setEnvelopeIntegrationEnabledMetadata($envelope_integration_enabled_metadata)
    {
        $this->container['envelope_integration_enabled_metadata'] = $envelope_integration_enabled_metadata;

        return $this;
    }

    /**
     * Gets envelope_limits_total_document_size_allowed_in_mb
     *
     * @return ?string
     */
    public function getEnvelopeLimitsTotalDocumentSizeAllowedInMb()
    {
        return $this->container['envelope_limits_total_document_size_allowed_in_mb'];
    }

    /**
     * Sets envelope_limits_total_document_size_allowed_in_mb
     *
     * @param ?string $envelope_limits_total_document_size_allowed_in_mb 
     *
     * @return $this
     */
    public function setEnvelopeLimitsTotalDocumentSizeAllowedInMb($envelope_limits_total_document_size_allowed_in_mb)
    {
        $this->container['envelope_limits_total_document_size_allowed_in_mb'] = $envelope_limits_total_document_size_allowed_in_mb;

        return $this;
    }

    /**
     * Gets envelope_limits_total_document_size_allowed_in_mb_enabled
     *
     * @return ?string
     */
    public function getEnvelopeLimitsTotalDocumentSizeAllowedInMbEnabled()
    {
        return $this->container['envelope_limits_total_document_size_allowed_in_mb_enabled'];
    }

    /**
     * Sets envelope_limits_total_document_size_allowed_in_mb_enabled
     *
     * @param ?string $envelope_limits_total_document_size_allowed_in_mb_enabled 
     *
     * @return $this
     */
    public function setEnvelopeLimitsTotalDocumentSizeAllowedInMbEnabled($envelope_limits_total_document_size_allowed_in_mb_enabled)
    {
        $this->container['envelope_limits_total_document_size_allowed_in_mb_enabled'] = $envelope_limits_total_document_size_allowed_in_mb_enabled;

        return $this;
    }

    /**
     * Gets envelope_limits_total_document_size_allowed_in_mb_enabled_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnvelopeLimitsTotalDocumentSizeAllowedInMbEnabledMetadata()
    {
        return $this->container['envelope_limits_total_document_size_allowed_in_mb_enabled_metadata'];
    }

    /**
     * Sets envelope_limits_total_document_size_allowed_in_mb_enabled_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $envelope_limits_total_document_size_allowed_in_mb_enabled_metadata 
     *
     * @return $this
     */
    public function setEnvelopeLimitsTotalDocumentSizeAllowedInMbEnabledMetadata($envelope_limits_total_document_size_allowed_in_mb_enabled_metadata)
    {
        $this->container['envelope_limits_total_document_size_allowed_in_mb_enabled_metadata'] = $envelope_limits_total_document_size_allowed_in_mb_enabled_metadata;

        return $this;
    }

    /**
     * Gets envelope_limits_total_document_size_allowed_in_mb_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnvelopeLimitsTotalDocumentSizeAllowedInMbMetadata()
    {
        return $this->container['envelope_limits_total_document_size_allowed_in_mb_metadata'];
    }

    /**
     * Sets envelope_limits_total_document_size_allowed_in_mb_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $envelope_limits_total_document_size_allowed_in_mb_metadata 
     *
     * @return $this
     */
    public function setEnvelopeLimitsTotalDocumentSizeAllowedInMbMetadata($envelope_limits_total_document_size_allowed_in_mb_metadata)
    {
        $this->container['envelope_limits_total_document_size_allowed_in_mb_metadata'] = $envelope_limits_total_document_size_allowed_in_mb_metadata;

        return $this;
    }

    /**
     * Gets envelope_search_mode
     *
     * @return ?string
     */
    public function getEnvelopeSearchMode()
    {
        return $this->container['envelope_search_mode'];
    }

    /**
     * Sets envelope_search_mode
     *
     * @param ?string $envelope_search_mode 
     *
     * @return $this
     */
    public function setEnvelopeSearchMode($envelope_search_mode)
    {
        $this->container['envelope_search_mode'] = $envelope_search_mode;

        return $this;
    }

    /**
     * Gets envelope_search_mode_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnvelopeSearchModeMetadata()
    {
        return $this->container['envelope_search_mode_metadata'];
    }

    /**
     * Sets envelope_search_mode_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $envelope_search_mode_metadata 
     *
     * @return $this
     */
    public function setEnvelopeSearchModeMetadata($envelope_search_mode_metadata)
    {
        $this->container['envelope_search_mode_metadata'] = $envelope_search_mode_metadata;

        return $this;
    }

    /**
     * Gets envelope_stamping_default_value
     *
     * @return ?string
     */
    public function getEnvelopeStampingDefaultValue()
    {
        return $this->container['envelope_stamping_default_value'];
    }

    /**
     * Sets envelope_stamping_default_value
     *
     * @param ?string $envelope_stamping_default_value 
     *
     * @return $this
     */
    public function setEnvelopeStampingDefaultValue($envelope_stamping_default_value)
    {
        $this->container['envelope_stamping_default_value'] = $envelope_stamping_default_value;

        return $this;
    }

    /**
     * Gets envelope_stamping_default_value_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnvelopeStampingDefaultValueMetadata()
    {
        return $this->container['envelope_stamping_default_value_metadata'];
    }

    /**
     * Sets envelope_stamping_default_value_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $envelope_stamping_default_value_metadata Metadata that indicates whether the `envelopeStampingDefaultValue` property is editable.
     *
     * @return $this
     */
    public function setEnvelopeStampingDefaultValueMetadata($envelope_stamping_default_value_metadata)
    {
        $this->container['envelope_stamping_default_value_metadata'] = $envelope_stamping_default_value_metadata;

        return $this;
    }

    /**
     * Gets exit_prompt
     *
     * @return ?string
     */
    public function getExitPrompt()
    {
        return $this->container['exit_prompt'];
    }

    /**
     * Sets exit_prompt
     *
     * @param ?string $exit_prompt 
     *
     * @return $this
     */
    public function setExitPrompt($exit_prompt)
    {
        $this->container['exit_prompt'] = $exit_prompt;

        return $this;
    }

    /**
     * Gets exit_prompt_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getExitPromptMetadata()
    {
        return $this->container['exit_prompt_metadata'];
    }

    /**
     * Sets exit_prompt_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $exit_prompt_metadata 
     *
     * @return $this
     */
    public function setExitPromptMetadata($exit_prompt_metadata)
    {
        $this->container['exit_prompt_metadata'] = $exit_prompt_metadata;

        return $this;
    }

    /**
     * Gets express_send
     *
     * @return ?string
     */
    public function getExpressSend()
    {
        return $this->container['express_send'];
    }

    /**
     * Sets express_send
     *
     * @param ?string $express_send 
     *
     * @return $this
     */
    public function setExpressSend($express_send)
    {
        $this->container['express_send'] = $express_send;

        return $this;
    }

    /**
     * Gets express_send_allow_tabs
     *
     * @return ?string
     */
    public function getExpressSendAllowTabs()
    {
        return $this->container['express_send_allow_tabs'];
    }

    /**
     * Sets express_send_allow_tabs
     *
     * @param ?string $express_send_allow_tabs 
     *
     * @return $this
     */
    public function setExpressSendAllowTabs($express_send_allow_tabs)
    {
        $this->container['express_send_allow_tabs'] = $express_send_allow_tabs;

        return $this;
    }

    /**
     * Gets express_send_allow_tabs_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getExpressSendAllowTabsMetadata()
    {
        return $this->container['express_send_allow_tabs_metadata'];
    }

    /**
     * Sets express_send_allow_tabs_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $express_send_allow_tabs_metadata Metadata that indicates whether the `expressSendAllowTabs` property is editable.
     *
     * @return $this
     */
    public function setExpressSendAllowTabsMetadata($express_send_allow_tabs_metadata)
    {
        $this->container['express_send_allow_tabs_metadata'] = $express_send_allow_tabs_metadata;

        return $this;
    }

    /**
     * Gets express_send_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getExpressSendMetadata()
    {
        return $this->container['express_send_metadata'];
    }

    /**
     * Sets express_send_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $express_send_metadata Metadata that indicates whether the `expressSend` property is editable.
     *
     * @return $this
     */
    public function setExpressSendMetadata($express_send_metadata)
    {
        $this->container['express_send_metadata'] = $express_send_metadata;

        return $this;
    }

    /**
     * Gets external_document_sources
     *
     * @return \DocuSign\eSign\Model\ExternalDocumentSources
     */
    public function getExternalDocumentSources()
    {
        return $this->container['external_document_sources'];
    }

    /**
     * Sets external_document_sources
     *
     * @param \DocuSign\eSign\Model\ExternalDocumentSources $external_document_sources A list of external document sources such as DropBox and OneDrive.
     *
     * @return $this
     */
    public function setExternalDocumentSources($external_document_sources)
    {
        $this->container['external_document_sources'] = $external_document_sources;

        return $this;
    }

    /**
     * Gets external_signature_pad_type
     *
     * @return ?string
     */
    public function getExternalSignaturePadType()
    {
        return $this->container['external_signature_pad_type'];
    }

    /**
     * Sets external_signature_pad_type
     *
     * @param ?string $external_signature_pad_type 
     *
     * @return $this
     */
    public function setExternalSignaturePadType($external_signature_pad_type)
    {
        $this->container['external_signature_pad_type'] = $external_signature_pad_type;

        return $this;
    }

    /**
     * Gets external_signature_pad_type_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getExternalSignaturePadTypeMetadata()
    {
        return $this->container['external_signature_pad_type_metadata'];
    }

    /**
     * Sets external_signature_pad_type_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $external_signature_pad_type_metadata Metadata that indicates whether the `externalSignaturePadType` property is editable.
     *
     * @return $this
     */
    public function setExternalSignaturePadTypeMetadata($external_signature_pad_type_metadata)
    {
        $this->container['external_signature_pad_type_metadata'] = $external_signature_pad_type_metadata;

        return $this;
    }

    /**
     * Gets fax_out_enabled
     *
     * @return ?string
     */
    public function getFaxOutEnabled()
    {
        return $this->container['fax_out_enabled'];
    }

    /**
     * Sets fax_out_enabled
     *
     * @param ?string $fax_out_enabled 
     *
     * @return $this
     */
    public function setFaxOutEnabled($fax_out_enabled)
    {
        $this->container['fax_out_enabled'] = $fax_out_enabled;

        return $this;
    }

    /**
     * Gets fax_out_enabled_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getFaxOutEnabledMetadata()
    {
        return $this->container['fax_out_enabled_metadata'];
    }

    /**
     * Sets fax_out_enabled_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $fax_out_enabled_metadata Metadata that indicates whether the `faxOutEnabled` property is editable.
     *
     * @return $this
     */
    public function setFaxOutEnabledMetadata($fax_out_enabled_metadata)
    {
        $this->container['fax_out_enabled_metadata'] = $fax_out_enabled_metadata;

        return $this;
    }

    /**
     * Gets finish_reminder
     *
     * @return ?string
     */
    public function getFinishReminder()
    {
        return $this->container['finish_reminder'];
    }

    /**
     * Sets finish_reminder
     *
     * @param ?string $finish_reminder 
     *
     * @return $this
     */
    public function setFinishReminder($finish_reminder)
    {
        $this->container['finish_reminder'] = $finish_reminder;

        return $this;
    }

    /**
     * Gets finish_reminder_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getFinishReminderMetadata()
    {
        return $this->container['finish_reminder_metadata'];
    }

    /**
     * Sets finish_reminder_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $finish_reminder_metadata 
     *
     * @return $this
     */
    public function setFinishReminderMetadata($finish_reminder_metadata)
    {
        $this->container['finish_reminder_metadata'] = $finish_reminder_metadata;

        return $this;
    }

    /**
     * Gets guided_forms_html_allowed
     *
     * @return ?string
     */
    public function getGuidedFormsHtmlAllowed()
    {
        return $this->container['guided_forms_html_allowed'];
    }

    /**
     * Sets guided_forms_html_allowed
     *
     * @param ?string $guided_forms_html_allowed 
     *
     * @return $this
     */
    public function setGuidedFormsHtmlAllowed($guided_forms_html_allowed)
    {
        $this->container['guided_forms_html_allowed'] = $guided_forms_html_allowed;

        return $this;
    }

    /**
     * Gets guided_forms_html_allowed_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getGuidedFormsHtmlAllowedMetadata()
    {
        return $this->container['guided_forms_html_allowed_metadata'];
    }

    /**
     * Sets guided_forms_html_allowed_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $guided_forms_html_allowed_metadata 
     *
     * @return $this
     */
    public function setGuidedFormsHtmlAllowedMetadata($guided_forms_html_allowed_metadata)
    {
        $this->container['guided_forms_html_allowed_metadata'] = $guided_forms_html_allowed_metadata;

        return $this;
    }

    /**
     * Gets guided_forms_html_conversion_policy
     *
     * @return ?string
     */
    public function getGuidedFormsHtmlConversionPolicy()
    {
        return $this->container['guided_forms_html_conversion_policy'];
    }

    /**
     * Sets guided_forms_html_conversion_policy
     *
     * @param ?string $guided_forms_html_conversion_policy 
     *
     * @return $this
     */
    public function setGuidedFormsHtmlConversionPolicy($guided_forms_html_conversion_policy)
    {
        $this->container['guided_forms_html_conversion_policy'] = $guided_forms_html_conversion_policy;

        return $this;
    }

    /**
     * Gets guided_forms_html_conversion_policy_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getGuidedFormsHtmlConversionPolicyMetadata()
    {
        return $this->container['guided_forms_html_conversion_policy_metadata'];
    }

    /**
     * Sets guided_forms_html_conversion_policy_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $guided_forms_html_conversion_policy_metadata 
     *
     * @return $this
     */
    public function setGuidedFormsHtmlConversionPolicyMetadata($guided_forms_html_conversion_policy_metadata)
    {
        $this->container['guided_forms_html_conversion_policy_metadata'] = $guided_forms_html_conversion_policy_metadata;

        return $this;
    }

    /**
     * Gets has_recipient_connect_claimed_domain
     *
     * @return ?string
     */
    public function getHasRecipientConnectClaimedDomain()
    {
        return $this->container['has_recipient_connect_claimed_domain'];
    }

    /**
     * Sets has_recipient_connect_claimed_domain
     *
     * @param ?string $has_recipient_connect_claimed_domain 
     *
     * @return $this
     */
    public function setHasRecipientConnectClaimedDomain($has_recipient_connect_claimed_domain)
    {
        $this->container['has_recipient_connect_claimed_domain'] = $has_recipient_connect_claimed_domain;

        return $this;
    }

    /**
     * Gets hide_account_address_in_co_c
     *
     * @return ?string
     */
    public function getHideAccountAddressInCoC()
    {
        return $this->container['hide_account_address_in_co_c'];
    }

    /**
     * Sets hide_account_address_in_co_c
     *
     * @param ?string $hide_account_address_in_co_c 
     *
     * @return $this
     */
    public function setHideAccountAddressInCoC($hide_account_address_in_co_c)
    {
        $this->container['hide_account_address_in_co_c'] = $hide_account_address_in_co_c;

        return $this;
    }

    /**
     * Gets hide_account_address_in_co_c_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getHideAccountAddressInCoCMetadata()
    {
        return $this->container['hide_account_address_in_co_c_metadata'];
    }

    /**
     * Sets hide_account_address_in_co_c_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $hide_account_address_in_co_c_metadata Metadata that indicates whether the `hideAccountAddressInCoC` property is editable.
     *
     * @return $this
     */
    public function setHideAccountAddressInCoCMetadata($hide_account_address_in_co_c_metadata)
    {
        $this->container['hide_account_address_in_co_c_metadata'] = $hide_account_address_in_co_c_metadata;

        return $this;
    }

    /**
     * Gets hide_pricing
     *
     * @return ?string
     */
    public function getHidePricing()
    {
        return $this->container['hide_pricing'];
    }

    /**
     * Sets hide_pricing
     *
     * @param ?string $hide_pricing 
     *
     * @return $this
     */
    public function setHidePricing($hide_pricing)
    {
        $this->container['hide_pricing'] = $hide_pricing;

        return $this;
    }

    /**
     * Gets hide_pricing_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getHidePricingMetadata()
    {
        return $this->container['hide_pricing_metadata'];
    }

    /**
     * Sets hide_pricing_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $hide_pricing_metadata Metadata that indicates whether the `hidePricing` property is editable.
     *
     * @return $this
     */
    public function setHidePricingMetadata($hide_pricing_metadata)
    {
        $this->container['hide_pricing_metadata'] = $hide_pricing_metadata;

        return $this;
    }

    /**
     * Gets id_check_configurations
     *
     * @return \DocuSign\eSign\Model\IdCheckConfiguration[]
     */
    public function getIdCheckConfigurations()
    {
        return $this->container['id_check_configurations'];
    }

    /**
     * Sets id_check_configurations
     *
     * @param \DocuSign\eSign\Model\IdCheckConfiguration[] $id_check_configurations 
     *
     * @return $this
     */
    public function setIdCheckConfigurations($id_check_configurations)
    {
        $this->container['id_check_configurations'] = $id_check_configurations;

        return $this;
    }

    /**
     * Gets id_check_expire
     *
     * @return ?string
     */
    public function getIdCheckExpire()
    {
        return $this->container['id_check_expire'];
    }

    /**
     * Sets id_check_expire
     *
     * @param ?string $id_check_expire 
     *
     * @return $this
     */
    public function setIdCheckExpire($id_check_expire)
    {
        $this->container['id_check_expire'] = $id_check_expire;

        return $this;
    }

    /**
     * Gets id_check_expire_days
     *
     * @return ?string
     */
    public function getIdCheckExpireDays()
    {
        return $this->container['id_check_expire_days'];
    }

    /**
     * Sets id_check_expire_days
     *
     * @param ?string $id_check_expire_days 
     *
     * @return $this
     */
    public function setIdCheckExpireDays($id_check_expire_days)
    {
        $this->container['id_check_expire_days'] = $id_check_expire_days;

        return $this;
    }

    /**
     * Gets id_check_expire_days_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getIdCheckExpireDaysMetadata()
    {
        return $this->container['id_check_expire_days_metadata'];
    }

    /**
     * Sets id_check_expire_days_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $id_check_expire_days_metadata Metadata that indicates whether the `idCheckExpireDays` property is editable.
     *
     * @return $this
     */
    public function setIdCheckExpireDaysMetadata($id_check_expire_days_metadata)
    {
        $this->container['id_check_expire_days_metadata'] = $id_check_expire_days_metadata;

        return $this;
    }

    /**
     * Gets id_check_expire_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getIdCheckExpireMetadata()
    {
        return $this->container['id_check_expire_metadata'];
    }

    /**
     * Sets id_check_expire_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $id_check_expire_metadata Metadata that indicates whether the `idCheckExpire` property is editable.
     *
     * @return $this
     */
    public function setIdCheckExpireMetadata($id_check_expire_metadata)
    {
        $this->container['id_check_expire_metadata'] = $id_check_expire_metadata;

        return $this;
    }

    /**
     * Gets id_check_expire_minutes
     *
     * @return ?string
     */
    public function getIdCheckExpireMinutes()
    {
        return $this->container['id_check_expire_minutes'];
    }

    /**
     * Sets id_check_expire_minutes
     *
     * @param ?string $id_check_expire_minutes 
     *
     * @return $this
     */
    public function setIdCheckExpireMinutes($id_check_expire_minutes)
    {
        $this->container['id_check_expire_minutes'] = $id_check_expire_minutes;

        return $this;
    }

    /**
     * Gets id_check_expire_minutes_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getIdCheckExpireMinutesMetadata()
    {
        return $this->container['id_check_expire_minutes_metadata'];
    }

    /**
     * Sets id_check_expire_minutes_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $id_check_expire_minutes_metadata Metadata that indicates whether the `idCheckExpireMinutes` property is editable.
     *
     * @return $this
     */
    public function setIdCheckExpireMinutesMetadata($id_check_expire_minutes_metadata)
    {
        $this->container['id_check_expire_minutes_metadata'] = $id_check_expire_minutes_metadata;

        return $this;
    }

    /**
     * Gets id_check_required
     *
     * @return ?string
     */
    public function getIdCheckRequired()
    {
        return $this->container['id_check_required'];
    }

    /**
     * Sets id_check_required
     *
     * @param ?string $id_check_required 
     *
     * @return $this
     */
    public function setIdCheckRequired($id_check_required)
    {
        $this->container['id_check_required'] = $id_check_required;

        return $this;
    }

    /**
     * Gets id_check_required_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getIdCheckRequiredMetadata()
    {
        return $this->container['id_check_required_metadata'];
    }

    /**
     * Sets id_check_required_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $id_check_required_metadata Metadata that indicates whether the `idCheckRequired` property is editable.
     *
     * @return $this
     */
    public function setIdCheckRequiredMetadata($id_check_required_metadata)
    {
        $this->container['id_check_required_metadata'] = $id_check_required_metadata;

        return $this;
    }

    /**
     * Gets identity_verification
     *
     * @return \DocuSign\eSign\Model\AccountIdentityVerificationWorkflow[]
     */
    public function getIdentityVerification()
    {
        return $this->container['identity_verification'];
    }

    /**
     * Sets identity_verification
     *
     * @param \DocuSign\eSign\Model\AccountIdentityVerificationWorkflow[] $identity_verification 
     *
     * @return $this
     */
    public function setIdentityVerification($identity_verification)
    {
        $this->container['identity_verification'] = $identity_verification;

        return $this;
    }

    /**
     * Gets identity_verification_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getIdentityVerificationMetadata()
    {
        return $this->container['identity_verification_metadata'];
    }

    /**
     * Sets identity_verification_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $identity_verification_metadata Metadata that indicates whether the `identityVerification` property is editable.
     *
     * @return $this
     */
    public function setIdentityVerificationMetadata($identity_verification_metadata)
    {
        $this->container['identity_verification_metadata'] = $identity_verification_metadata;

        return $this;
    }

    /**
     * Gets idfx_kba_authentication_override
     *
     * @return ?string
     */
    public function getIdfxKbaAuthenticationOverride()
    {
        return $this->container['idfx_kba_authentication_override'];
    }

    /**
     * Sets idfx_kba_authentication_override
     *
     * @param ?string $idfx_kba_authentication_override 
     *
     * @return $this
     */
    public function setIdfxKbaAuthenticationOverride($idfx_kba_authentication_override)
    {
        $this->container['idfx_kba_authentication_override'] = $idfx_kba_authentication_override;

        return $this;
    }

    /**
     * Gets idfx_kba_authentication_override_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getIdfxKbaAuthenticationOverrideMetadata()
    {
        return $this->container['idfx_kba_authentication_override_metadata'];
    }

    /**
     * Sets idfx_kba_authentication_override_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $idfx_kba_authentication_override_metadata 
     *
     * @return $this
     */
    public function setIdfxKbaAuthenticationOverrideMetadata($idfx_kba_authentication_override_metadata)
    {
        $this->container['idfx_kba_authentication_override_metadata'] = $idfx_kba_authentication_override_metadata;

        return $this;
    }

    /**
     * Gets idfx_phone_authentication_override
     *
     * @return ?string
     */
    public function getIdfxPhoneAuthenticationOverride()
    {
        return $this->container['idfx_phone_authentication_override'];
    }

    /**
     * Sets idfx_phone_authentication_override
     *
     * @param ?string $idfx_phone_authentication_override 
     *
     * @return $this
     */
    public function setIdfxPhoneAuthenticationOverride($idfx_phone_authentication_override)
    {
        $this->container['idfx_phone_authentication_override'] = $idfx_phone_authentication_override;

        return $this;
    }

    /**
     * Gets idfx_phone_authentication_override_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getIdfxPhoneAuthenticationOverrideMetadata()
    {
        return $this->container['idfx_phone_authentication_override_metadata'];
    }

    /**
     * Sets idfx_phone_authentication_override_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $idfx_phone_authentication_override_metadata 
     *
     * @return $this
     */
    public function setIdfxPhoneAuthenticationOverrideMetadata($idfx_phone_authentication_override_metadata)
    {
        $this->container['idfx_phone_authentication_override_metadata'] = $idfx_phone_authentication_override_metadata;

        return $this;
    }

    /**
     * Gets ignore_error_if_anchor_tab_not_found
     *
     * @return ?string
     */
    public function getIgnoreErrorIfAnchorTabNotFound()
    {
        return $this->container['ignore_error_if_anchor_tab_not_found'];
    }

    /**
     * Sets ignore_error_if_anchor_tab_not_found
     *
     * @param ?string $ignore_error_if_anchor_tab_not_found 
     *
     * @return $this
     */
    public function setIgnoreErrorIfAnchorTabNotFound($ignore_error_if_anchor_tab_not_found)
    {
        $this->container['ignore_error_if_anchor_tab_not_found'] = $ignore_error_if_anchor_tab_not_found;

        return $this;
    }

    /**
     * Gets ignore_error_if_anchor_tab_not_found_metadata_enabled
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getIgnoreErrorIfAnchorTabNotFoundMetadataEnabled()
    {
        return $this->container['ignore_error_if_anchor_tab_not_found_metadata_enabled'];
    }

    /**
     * Sets ignore_error_if_anchor_tab_not_found_metadata_enabled
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $ignore_error_if_anchor_tab_not_found_metadata_enabled Reserved for DocuSign.
     *
     * @return $this
     */
    public function setIgnoreErrorIfAnchorTabNotFoundMetadataEnabled($ignore_error_if_anchor_tab_not_found_metadata_enabled)
    {
        $this->container['ignore_error_if_anchor_tab_not_found_metadata_enabled'] = $ignore_error_if_anchor_tab_not_found_metadata_enabled;

        return $this;
    }

    /**
     * Gets in_person_id_check_question
     *
     * @return ?string
     */
    public function getInPersonIdCheckQuestion()
    {
        return $this->container['in_person_id_check_question'];
    }

    /**
     * Sets in_person_id_check_question
     *
     * @param ?string $in_person_id_check_question 
     *
     * @return $this
     */
    public function setInPersonIdCheckQuestion($in_person_id_check_question)
    {
        $this->container['in_person_id_check_question'] = $in_person_id_check_question;

        return $this;
    }

    /**
     * Gets in_person_id_check_question_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getInPersonIdCheckQuestionMetadata()
    {
        return $this->container['in_person_id_check_question_metadata'];
    }

    /**
     * Sets in_person_id_check_question_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $in_person_id_check_question_metadata Metadata that indicates whether the `inPersonIDCheckQuestion` property is editable.
     *
     * @return $this
     */
    public function setInPersonIdCheckQuestionMetadata($in_person_id_check_question_metadata)
    {
        $this->container['in_person_id_check_question_metadata'] = $in_person_id_check_question_metadata;

        return $this;
    }

    /**
     * Gets in_person_signing_enabled
     *
     * @return ?string
     */
    public function getInPersonSigningEnabled()
    {
        return $this->container['in_person_signing_enabled'];
    }

    /**
     * Sets in_person_signing_enabled
     *
     * @param ?string $in_person_signing_enabled 
     *
     * @return $this
     */
    public function setInPersonSigningEnabled($in_person_signing_enabled)
    {
        $this->container['in_person_signing_enabled'] = $in_person_signing_enabled;

        return $this;
    }

    /**
     * Gets in_person_signing_enabled_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getInPersonSigningEnabledMetadata()
    {
        return $this->container['in_person_signing_enabled_metadata'];
    }

    /**
     * Sets in_person_signing_enabled_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $in_person_signing_enabled_metadata Metadata that indicates whether the `inPersonSigningEnabled` property is editable.
     *
     * @return $this
     */
    public function setInPersonSigningEnabledMetadata($in_person_signing_enabled_metadata)
    {
        $this->container['in_person_signing_enabled_metadata'] = $in_person_signing_enabled_metadata;

        return $this;
    }

    /**
     * Gets in_session_enabled
     *
     * @return ?string
     */
    public function getInSessionEnabled()
    {
        return $this->container['in_session_enabled'];
    }

    /**
     * Sets in_session_enabled
     *
     * @param ?string $in_session_enabled 
     *
     * @return $this
     */
    public function setInSessionEnabled($in_session_enabled)
    {
        $this->container['in_session_enabled'] = $in_session_enabled;

        return $this;
    }

    /**
     * Gets in_session_enabled_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getInSessionEnabledMetadata()
    {
        return $this->container['in_session_enabled_metadata'];
    }

    /**
     * Sets in_session_enabled_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $in_session_enabled_metadata Metadata that indicates whether the `inSessionEnabled` property is editable.
     *
     * @return $this
     */
    public function setInSessionEnabledMetadata($in_session_enabled_metadata)
    {
        $this->container['in_session_enabled_metadata'] = $in_session_enabled_metadata;

        return $this;
    }

    /**
     * Gets in_session_suppress_emails
     *
     * @return ?string
     */
    public function getInSessionSuppressEmails()
    {
        return $this->container['in_session_suppress_emails'];
    }

    /**
     * Sets in_session_suppress_emails
     *
     * @param ?string $in_session_suppress_emails 
     *
     * @return $this
     */
    public function setInSessionSuppressEmails($in_session_suppress_emails)
    {
        $this->container['in_session_suppress_emails'] = $in_session_suppress_emails;

        return $this;
    }

    /**
     * Gets in_session_suppress_emails_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getInSessionSuppressEmailsMetadata()
    {
        return $this->container['in_session_suppress_emails_metadata'];
    }

    /**
     * Sets in_session_suppress_emails_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $in_session_suppress_emails_metadata Metadata that indicates whether the `inSessionSuppressEmails` property is editable.
     *
     * @return $this
     */
    public function setInSessionSuppressEmailsMetadata($in_session_suppress_emails_metadata)
    {
        $this->container['in_session_suppress_emails_metadata'] = $in_session_suppress_emails_metadata;

        return $this;
    }

    /**
     * Gets is_connect_document_fields_enabled
     *
     * @return ?string
     */
    public function getIsConnectDocumentFieldsEnabled()
    {
        return $this->container['is_connect_document_fields_enabled'];
    }

    /**
     * Sets is_connect_document_fields_enabled
     *
     * @param ?string $is_connect_document_fields_enabled 
     *
     * @return $this
     */
    public function setIsConnectDocumentFieldsEnabled($is_connect_document_fields_enabled)
    {
        $this->container['is_connect_document_fields_enabled'] = $is_connect_document_fields_enabled;

        return $this;
    }

    /**
     * Gets linked_external_primary_accounts
     *
     * @return \DocuSign\eSign\Model\LinkedExternalPrimaryAccount[]
     */
    public function getLinkedExternalPrimaryAccounts()
    {
        return $this->container['linked_external_primary_accounts'];
    }

    /**
     * Sets linked_external_primary_accounts
     *
     * @param \DocuSign\eSign\Model\LinkedExternalPrimaryAccount[] $linked_external_primary_accounts 
     *
     * @return $this
     */
    public function setLinkedExternalPrimaryAccounts($linked_external_primary_accounts)
    {
        $this->container['linked_external_primary_accounts'] = $linked_external_primary_accounts;

        return $this;
    }

    /**
     * Gets maximum_signing_groups
     *
     * @return ?string
     */
    public function getMaximumSigningGroups()
    {
        return $this->container['maximum_signing_groups'];
    }

    /**
     * Sets maximum_signing_groups
     *
     * @param ?string $maximum_signing_groups 
     *
     * @return $this
     */
    public function setMaximumSigningGroups($maximum_signing_groups)
    {
        $this->container['maximum_signing_groups'] = $maximum_signing_groups;

        return $this;
    }

    /**
     * Gets maximum_signing_groups_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getMaximumSigningGroupsMetadata()
    {
        return $this->container['maximum_signing_groups_metadata'];
    }

    /**
     * Sets maximum_signing_groups_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $maximum_signing_groups_metadata Metadata that indicates whether the `maximumSigningGroups` property is editable.
     *
     * @return $this
     */
    public function setMaximumSigningGroupsMetadata($maximum_signing_groups_metadata)
    {
        $this->container['maximum_signing_groups_metadata'] = $maximum_signing_groups_metadata;

        return $this;
    }

    /**
     * Gets maximum_users_per_signing_group
     *
     * @return ?string
     */
    public function getMaximumUsersPerSigningGroup()
    {
        return $this->container['maximum_users_per_signing_group'];
    }

    /**
     * Sets maximum_users_per_signing_group
     *
     * @param ?string $maximum_users_per_signing_group 
     *
     * @return $this
     */
    public function setMaximumUsersPerSigningGroup($maximum_users_per_signing_group)
    {
        $this->container['maximum_users_per_signing_group'] = $maximum_users_per_signing_group;

        return $this;
    }

    /**
     * Gets maximum_users_per_signing_group_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getMaximumUsersPerSigningGroupMetadata()
    {
        return $this->container['maximum_users_per_signing_group_metadata'];
    }

    /**
     * Sets maximum_users_per_signing_group_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $maximum_users_per_signing_group_metadata Metadata that indicates whether the `maximumUsersPerSigningGroup` property is editable.
     *
     * @return $this
     */
    public function setMaximumUsersPerSigningGroupMetadata($maximum_users_per_signing_group_metadata)
    {
        $this->container['maximum_users_per_signing_group_metadata'] = $maximum_users_per_signing_group_metadata;

        return $this;
    }

    /**
     * Gets max_number_of_custom_stamps
     *
     * @return ?string
     */
    public function getMaxNumberOfCustomStamps()
    {
        return $this->container['max_number_of_custom_stamps'];
    }

    /**
     * Sets max_number_of_custom_stamps
     *
     * @param ?string $max_number_of_custom_stamps 
     *
     * @return $this
     */
    public function setMaxNumberOfCustomStamps($max_number_of_custom_stamps)
    {
        $this->container['max_number_of_custom_stamps'] = $max_number_of_custom_stamps;

        return $this;
    }

    /**
     * Gets merge_mixed_mode_results
     *
     * @return ?string
     */
    public function getMergeMixedModeResults()
    {
        return $this->container['merge_mixed_mode_results'];
    }

    /**
     * Sets merge_mixed_mode_results
     *
     * @param ?string $merge_mixed_mode_results 
     *
     * @return $this
     */
    public function setMergeMixedModeResults($merge_mixed_mode_results)
    {
        $this->container['merge_mixed_mode_results'] = $merge_mixed_mode_results;

        return $this;
    }

    /**
     * Gets merge_mixed_mode_results_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getMergeMixedModeResultsMetadata()
    {
        return $this->container['merge_mixed_mode_results_metadata'];
    }

    /**
     * Sets merge_mixed_mode_results_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $merge_mixed_mode_results_metadata 
     *
     * @return $this
     */
    public function setMergeMixedModeResultsMetadata($merge_mixed_mode_results_metadata)
    {
        $this->container['merge_mixed_mode_results_metadata'] = $merge_mixed_mode_results_metadata;

        return $this;
    }

    /**
     * Gets mobile_session_timeout
     *
     * @return ?string
     */
    public function getMobileSessionTimeout()
    {
        return $this->container['mobile_session_timeout'];
    }

    /**
     * Sets mobile_session_timeout
     *
     * @param ?string $mobile_session_timeout 
     *
     * @return $this
     */
    public function setMobileSessionTimeout($mobile_session_timeout)
    {
        $this->container['mobile_session_timeout'] = $mobile_session_timeout;

        return $this;
    }

    /**
     * Gets mobile_session_timeout_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getMobileSessionTimeoutMetadata()
    {
        return $this->container['mobile_session_timeout_metadata'];
    }

    /**
     * Sets mobile_session_timeout_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $mobile_session_timeout_metadata Metadata that indicates whether the `mobileSessionTimeout` property is editable.
     *
     * @return $this
     */
    public function setMobileSessionTimeoutMetadata($mobile_session_timeout_metadata)
    {
        $this->container['mobile_session_timeout_metadata'] = $mobile_session_timeout_metadata;

        return $this;
    }

    /**
     * Gets number_of_active_custom_stamps
     *
     * @return ?string
     */
    public function getNumberOfActiveCustomStamps()
    {
        return $this->container['number_of_active_custom_stamps'];
    }

    /**
     * Sets number_of_active_custom_stamps
     *
     * @param ?string $number_of_active_custom_stamps 
     *
     * @return $this
     */
    public function setNumberOfActiveCustomStamps($number_of_active_custom_stamps)
    {
        $this->container['number_of_active_custom_stamps'] = $number_of_active_custom_stamps;

        return $this;
    }

    /**
     * Gets opt_in_mobile_signing_v02
     *
     * @return ?string
     */
    public function getOptInMobileSigningV02()
    {
        return $this->container['opt_in_mobile_signing_v02'];
    }

    /**
     * Sets opt_in_mobile_signing_v02
     *
     * @param ?string $opt_in_mobile_signing_v02 
     *
     * @return $this
     */
    public function setOptInMobileSigningV02($opt_in_mobile_signing_v02)
    {
        $this->container['opt_in_mobile_signing_v02'] = $opt_in_mobile_signing_v02;

        return $this;
    }

    /**
     * Gets opt_in_mobile_signing_v02_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getOptInMobileSigningV02Metadata()
    {
        return $this->container['opt_in_mobile_signing_v02_metadata'];
    }

    /**
     * Sets opt_in_mobile_signing_v02_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $opt_in_mobile_signing_v02_metadata Metadata that indicates whether the `optInMobileSigningV02` property is editable.
     *
     * @return $this
     */
    public function setOptInMobileSigningV02Metadata($opt_in_mobile_signing_v02_metadata)
    {
        $this->container['opt_in_mobile_signing_v02_metadata'] = $opt_in_mobile_signing_v02_metadata;

        return $this;
    }

    /**
     * Gets opt_in_universal_signatures
     *
     * @return ?string
     */
    public function getOptInUniversalSignatures()
    {
        return $this->container['opt_in_universal_signatures'];
    }

    /**
     * Sets opt_in_universal_signatures
     *
     * @param ?string $opt_in_universal_signatures 
     *
     * @return $this
     */
    public function setOptInUniversalSignatures($opt_in_universal_signatures)
    {
        $this->container['opt_in_universal_signatures'] = $opt_in_universal_signatures;

        return $this;
    }

    /**
     * Gets opt_out_auto_nav_text_and_tab_color_updates
     *
     * @return ?string
     */
    public function getOptOutAutoNavTextAndTabColorUpdates()
    {
        return $this->container['opt_out_auto_nav_text_and_tab_color_updates'];
    }

    /**
     * Sets opt_out_auto_nav_text_and_tab_color_updates
     *
     * @param ?string $opt_out_auto_nav_text_and_tab_color_updates 
     *
     * @return $this
     */
    public function setOptOutAutoNavTextAndTabColorUpdates($opt_out_auto_nav_text_and_tab_color_updates)
    {
        $this->container['opt_out_auto_nav_text_and_tab_color_updates'] = $opt_out_auto_nav_text_and_tab_color_updates;

        return $this;
    }

    /**
     * Gets opt_out_auto_nav_text_and_tab_color_updates_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getOptOutAutoNavTextAndTabColorUpdatesMetadata()
    {
        return $this->container['opt_out_auto_nav_text_and_tab_color_updates_metadata'];
    }

    /**
     * Sets opt_out_auto_nav_text_and_tab_color_updates_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $opt_out_auto_nav_text_and_tab_color_updates_metadata Metadata that indicates whether the `optOutAutoNavTextAndTabColorUpdates` property is editable.
     *
     * @return $this
     */
    public function setOptOutAutoNavTextAndTabColorUpdatesMetadata($opt_out_auto_nav_text_and_tab_color_updates_metadata)
    {
        $this->container['opt_out_auto_nav_text_and_tab_color_updates_metadata'] = $opt_out_auto_nav_text_and_tab_color_updates_metadata;

        return $this;
    }

    /**
     * Gets opt_out_new_platform_seal
     *
     * @return ?string
     */
    public function getOptOutNewPlatformSeal()
    {
        return $this->container['opt_out_new_platform_seal'];
    }

    /**
     * Sets opt_out_new_platform_seal
     *
     * @param ?string $opt_out_new_platform_seal 
     *
     * @return $this
     */
    public function setOptOutNewPlatformSeal($opt_out_new_platform_seal)
    {
        $this->container['opt_out_new_platform_seal'] = $opt_out_new_platform_seal;

        return $this;
    }

    /**
     * Gets opt_out_new_platform_seal_platform_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getOptOutNewPlatformSealPlatformMetadata()
    {
        return $this->container['opt_out_new_platform_seal_platform_metadata'];
    }

    /**
     * Sets opt_out_new_platform_seal_platform_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $opt_out_new_platform_seal_platform_metadata Metadata that indicates whether the `optOutNewPlatformSealPlatform` property is editable.
     *
     * @return $this
     */
    public function setOptOutNewPlatformSealPlatformMetadata($opt_out_new_platform_seal_platform_metadata)
    {
        $this->container['opt_out_new_platform_seal_platform_metadata'] = $opt_out_new_platform_seal_platform_metadata;

        return $this;
    }

    /**
     * Gets pdf_max_chunked_upload_part_size
     *
     * @return ?string
     */
    public function getPdfMaxChunkedUploadPartSize()
    {
        return $this->container['pdf_max_chunked_upload_part_size'];
    }

    /**
     * Sets pdf_max_chunked_upload_part_size
     *
     * @param ?string $pdf_max_chunked_upload_part_size 
     *
     * @return $this
     */
    public function setPdfMaxChunkedUploadPartSize($pdf_max_chunked_upload_part_size)
    {
        $this->container['pdf_max_chunked_upload_part_size'] = $pdf_max_chunked_upload_part_size;

        return $this;
    }

    /**
     * Gets pdf_max_chunked_upload_part_size_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getPdfMaxChunkedUploadPartSizeMetadata()
    {
        return $this->container['pdf_max_chunked_upload_part_size_metadata'];
    }

    /**
     * Sets pdf_max_chunked_upload_part_size_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $pdf_max_chunked_upload_part_size_metadata 
     *
     * @return $this
     */
    public function setPdfMaxChunkedUploadPartSizeMetadata($pdf_max_chunked_upload_part_size_metadata)
    {
        $this->container['pdf_max_chunked_upload_part_size_metadata'] = $pdf_max_chunked_upload_part_size_metadata;

        return $this;
    }

    /**
     * Gets pdf_max_chunked_upload_total_size
     *
     * @return ?string
     */
    public function getPdfMaxChunkedUploadTotalSize()
    {
        return $this->container['pdf_max_chunked_upload_total_size'];
    }

    /**
     * Sets pdf_max_chunked_upload_total_size
     *
     * @param ?string $pdf_max_chunked_upload_total_size 
     *
     * @return $this
     */
    public function setPdfMaxChunkedUploadTotalSize($pdf_max_chunked_upload_total_size)
    {
        $this->container['pdf_max_chunked_upload_total_size'] = $pdf_max_chunked_upload_total_size;

        return $this;
    }

    /**
     * Gets pdf_max_chunked_upload_total_size_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getPdfMaxChunkedUploadTotalSizeMetadata()
    {
        return $this->container['pdf_max_chunked_upload_total_size_metadata'];
    }

    /**
     * Sets pdf_max_chunked_upload_total_size_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $pdf_max_chunked_upload_total_size_metadata 
     *
     * @return $this
     */
    public function setPdfMaxChunkedUploadTotalSizeMetadata($pdf_max_chunked_upload_total_size_metadata)
    {
        $this->container['pdf_max_chunked_upload_total_size_metadata'] = $pdf_max_chunked_upload_total_size_metadata;

        return $this;
    }

    /**
     * Gets pdf_max_individual_upload_size
     *
     * @return ?string
     */
    public function getPdfMaxIndividualUploadSize()
    {
        return $this->container['pdf_max_individual_upload_size'];
    }

    /**
     * Sets pdf_max_individual_upload_size
     *
     * @param ?string $pdf_max_individual_upload_size 
     *
     * @return $this
     */
    public function setPdfMaxIndividualUploadSize($pdf_max_individual_upload_size)
    {
        $this->container['pdf_max_individual_upload_size'] = $pdf_max_individual_upload_size;

        return $this;
    }

    /**
     * Gets pdf_max_individual_upload_size_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getPdfMaxIndividualUploadSizeMetadata()
    {
        return $this->container['pdf_max_individual_upload_size_metadata'];
    }

    /**
     * Sets pdf_max_individual_upload_size_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $pdf_max_individual_upload_size_metadata 
     *
     * @return $this
     */
    public function setPdfMaxIndividualUploadSizeMetadata($pdf_max_individual_upload_size_metadata)
    {
        $this->container['pdf_max_individual_upload_size_metadata'] = $pdf_max_individual_upload_size_metadata;

        return $this;
    }

    /**
     * Gets phone_auth_recipient_may_provide_phone_number
     *
     * @return ?string
     */
    public function getPhoneAuthRecipientMayProvidePhoneNumber()
    {
        return $this->container['phone_auth_recipient_may_provide_phone_number'];
    }

    /**
     * Sets phone_auth_recipient_may_provide_phone_number
     *
     * @param ?string $phone_auth_recipient_may_provide_phone_number 
     *
     * @return $this
     */
    public function setPhoneAuthRecipientMayProvidePhoneNumber($phone_auth_recipient_may_provide_phone_number)
    {
        $this->container['phone_auth_recipient_may_provide_phone_number'] = $phone_auth_recipient_may_provide_phone_number;

        return $this;
    }

    /**
     * Gets phone_auth_recipient_may_provide_phone_number_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getPhoneAuthRecipientMayProvidePhoneNumberMetadata()
    {
        return $this->container['phone_auth_recipient_may_provide_phone_number_metadata'];
    }

    /**
     * Sets phone_auth_recipient_may_provide_phone_number_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $phone_auth_recipient_may_provide_phone_number_metadata Metadata that indicates whether the `phoneAuthRecipientMayProvidePhoneNumber` property is editable.
     *
     * @return $this
     */
    public function setPhoneAuthRecipientMayProvidePhoneNumberMetadata($phone_auth_recipient_may_provide_phone_number_metadata)
    {
        $this->container['phone_auth_recipient_may_provide_phone_number_metadata'] = $phone_auth_recipient_may_provide_phone_number_metadata;

        return $this;
    }

    /**
     * Gets pki_sign_downloaded_pdf_docs
     *
     * @return ?string
     */
    public function getPkiSignDownloadedPdfDocs()
    {
        return $this->container['pki_sign_downloaded_pdf_docs'];
    }

    /**
     * Sets pki_sign_downloaded_pdf_docs
     *
     * @param ?string $pki_sign_downloaded_pdf_docs 
     *
     * @return $this
     */
    public function setPkiSignDownloadedPdfDocs($pki_sign_downloaded_pdf_docs)
    {
        $this->container['pki_sign_downloaded_pdf_docs'] = $pki_sign_downloaded_pdf_docs;

        return $this;
    }

    /**
     * Gets pki_sign_downloaded_pdf_docs_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getPkiSignDownloadedPdfDocsMetadata()
    {
        return $this->container['pki_sign_downloaded_pdf_docs_metadata'];
    }

    /**
     * Sets pki_sign_downloaded_pdf_docs_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $pki_sign_downloaded_pdf_docs_metadata Metadata that indicates whether the `pkiSignDownloadedPDFDocs` property is editable.
     *
     * @return $this
     */
    public function setPkiSignDownloadedPdfDocsMetadata($pki_sign_downloaded_pdf_docs_metadata)
    {
        $this->container['pki_sign_downloaded_pdf_docs_metadata'] = $pki_sign_downloaded_pdf_docs_metadata;

        return $this;
    }

    /**
     * Gets read_only_mode
     *
     * @return ?string
     */
    public function getReadOnlyMode()
    {
        return $this->container['read_only_mode'];
    }

    /**
     * Sets read_only_mode
     *
     * @param ?string $read_only_mode 
     *
     * @return $this
     */
    public function setReadOnlyMode($read_only_mode)
    {
        $this->container['read_only_mode'] = $read_only_mode;

        return $this;
    }

    /**
     * Gets read_only_mode_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getReadOnlyModeMetadata()
    {
        return $this->container['read_only_mode_metadata'];
    }

    /**
     * Sets read_only_mode_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $read_only_mode_metadata 
     *
     * @return $this
     */
    public function setReadOnlyModeMetadata($read_only_mode_metadata)
    {
        $this->container['read_only_mode_metadata'] = $read_only_mode_metadata;

        return $this;
    }

    /**
     * Gets recipients_can_sign_offline
     *
     * @return ?string
     */
    public function getRecipientsCanSignOffline()
    {
        return $this->container['recipients_can_sign_offline'];
    }

    /**
     * Sets recipients_can_sign_offline
     *
     * @param ?string $recipients_can_sign_offline 
     *
     * @return $this
     */
    public function setRecipientsCanSignOffline($recipients_can_sign_offline)
    {
        $this->container['recipients_can_sign_offline'] = $recipients_can_sign_offline;

        return $this;
    }

    /**
     * Gets recipients_can_sign_offline_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getRecipientsCanSignOfflineMetadata()
    {
        return $this->container['recipients_can_sign_offline_metadata'];
    }

    /**
     * Sets recipients_can_sign_offline_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $recipients_can_sign_offline_metadata Metadata that indicates whether the `recipientsCanSignOffline` property is editable.
     *
     * @return $this
     */
    public function setRecipientsCanSignOfflineMetadata($recipients_can_sign_offline_metadata)
    {
        $this->container['recipients_can_sign_offline_metadata'] = $recipients_can_sign_offline_metadata;

        return $this;
    }

    /**
     * Gets recipient_signing_auto_navigation_control
     *
     * @return ?string
     */
    public function getRecipientSigningAutoNavigationControl()
    {
        return $this->container['recipient_signing_auto_navigation_control'];
    }

    /**
     * Sets recipient_signing_auto_navigation_control
     *
     * @param ?string $recipient_signing_auto_navigation_control 
     *
     * @return $this
     */
    public function setRecipientSigningAutoNavigationControl($recipient_signing_auto_navigation_control)
    {
        $this->container['recipient_signing_auto_navigation_control'] = $recipient_signing_auto_navigation_control;

        return $this;
    }

    /**
     * Gets recipient_signing_auto_navigation_control_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getRecipientSigningAutoNavigationControlMetadata()
    {
        return $this->container['recipient_signing_auto_navigation_control_metadata'];
    }

    /**
     * Sets recipient_signing_auto_navigation_control_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $recipient_signing_auto_navigation_control_metadata Metadata that indicates whether the `recipientSigningAutoNavigationControl` property is editable.
     *
     * @return $this
     */
    public function setRecipientSigningAutoNavigationControlMetadata($recipient_signing_auto_navigation_control_metadata)
    {
        $this->container['recipient_signing_auto_navigation_control_metadata'] = $recipient_signing_auto_navigation_control_metadata;

        return $this;
    }

    /**
     * Gets require21_cf_rpt11_compliance
     *
     * @return ?string
     */
    public function getRequire21CfRpt11Compliance()
    {
        return $this->container['require21_cf_rpt11_compliance'];
    }

    /**
     * Sets require21_cf_rpt11_compliance
     *
     * @param ?string $require21_cf_rpt11_compliance 
     *
     * @return $this
     */
    public function setRequire21CfRpt11Compliance($require21_cf_rpt11_compliance)
    {
        $this->container['require21_cf_rpt11_compliance'] = $require21_cf_rpt11_compliance;

        return $this;
    }

    /**
     * Gets require21_cf_rpt11_compliance_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getRequire21CfRpt11ComplianceMetadata()
    {
        return $this->container['require21_cf_rpt11_compliance_metadata'];
    }

    /**
     * Sets require21_cf_rpt11_compliance_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $require21_cf_rpt11_compliance_metadata Metadata that indicates whether the `require21CFRpt11Compliance` property is editable.
     *
     * @return $this
     */
    public function setRequire21CfRpt11ComplianceMetadata($require21_cf_rpt11_compliance_metadata)
    {
        $this->container['require21_cf_rpt11_compliance_metadata'] = $require21_cf_rpt11_compliance_metadata;

        return $this;
    }

    /**
     * Gets require_decline_reason
     *
     * @return ?string
     */
    public function getRequireDeclineReason()
    {
        return $this->container['require_decline_reason'];
    }

    /**
     * Sets require_decline_reason
     *
     * @param ?string $require_decline_reason 
     *
     * @return $this
     */
    public function setRequireDeclineReason($require_decline_reason)
    {
        $this->container['require_decline_reason'] = $require_decline_reason;

        return $this;
    }

    /**
     * Gets require_decline_reason_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getRequireDeclineReasonMetadata()
    {
        return $this->container['require_decline_reason_metadata'];
    }

    /**
     * Sets require_decline_reason_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $require_decline_reason_metadata Metadata that indicates whether the `requireDeclineReason` property is editable.
     *
     * @return $this
     */
    public function setRequireDeclineReasonMetadata($require_decline_reason_metadata)
    {
        $this->container['require_decline_reason_metadata'] = $require_decline_reason_metadata;

        return $this;
    }

    /**
     * Gets require_external_user_management
     *
     * @return ?string
     */
    public function getRequireExternalUserManagement()
    {
        return $this->container['require_external_user_management'];
    }

    /**
     * Sets require_external_user_management
     *
     * @param ?string $require_external_user_management 
     *
     * @return $this
     */
    public function setRequireExternalUserManagement($require_external_user_management)
    {
        $this->container['require_external_user_management'] = $require_external_user_management;

        return $this;
    }

    /**
     * Gets require_external_user_management_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getRequireExternalUserManagementMetadata()
    {
        return $this->container['require_external_user_management_metadata'];
    }

    /**
     * Sets require_external_user_management_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $require_external_user_management_metadata Metadata that indicates whether the `requireExternalUserManagement` property is editable.
     *
     * @return $this
     */
    public function setRequireExternalUserManagementMetadata($require_external_user_management_metadata)
    {
        $this->container['require_external_user_management_metadata'] = $require_external_user_management_metadata;

        return $this;
    }

    /**
     * Gets require_signer_certificate_type
     *
     * @return ?string
     */
    public function getRequireSignerCertificateType()
    {
        return $this->container['require_signer_certificate_type'];
    }

    /**
     * Sets require_signer_certificate_type
     *
     * @param ?string $require_signer_certificate_type 
     *
     * @return $this
     */
    public function setRequireSignerCertificateType($require_signer_certificate_type)
    {
        $this->container['require_signer_certificate_type'] = $require_signer_certificate_type;

        return $this;
    }

    /**
     * Gets require_signer_certificate_type_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getRequireSignerCertificateTypeMetadata()
    {
        return $this->container['require_signer_certificate_type_metadata'];
    }

    /**
     * Sets require_signer_certificate_type_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $require_signer_certificate_type_metadata Metadata that indicates whether the `requireSignerCertificateType` property is editable.
     *
     * @return $this
     */
    public function setRequireSignerCertificateTypeMetadata($require_signer_certificate_type_metadata)
    {
        $this->container['require_signer_certificate_type_metadata'] = $require_signer_certificate_type_metadata;

        return $this;
    }

    /**
     * Gets rsa_verid_account_name
     *
     * @return ?string
     */
    public function getRsaVeridAccountName()
    {
        return $this->container['rsa_verid_account_name'];
    }

    /**
     * Sets rsa_verid_account_name
     *
     * @param ?string $rsa_verid_account_name 
     *
     * @return $this
     */
    public function setRsaVeridAccountName($rsa_verid_account_name)
    {
        $this->container['rsa_verid_account_name'] = $rsa_verid_account_name;

        return $this;
    }

    /**
     * Gets rsa_verid_password
     *
     * @return ?string
     */
    public function getRsaVeridPassword()
    {
        return $this->container['rsa_verid_password'];
    }

    /**
     * Sets rsa_verid_password
     *
     * @param ?string $rsa_verid_password 
     *
     * @return $this
     */
    public function setRsaVeridPassword($rsa_verid_password)
    {
        $this->container['rsa_verid_password'] = $rsa_verid_password;

        return $this;
    }

    /**
     * Gets rsa_verid_ruleset
     *
     * @return ?string
     */
    public function getRsaVeridRuleset()
    {
        return $this->container['rsa_verid_ruleset'];
    }

    /**
     * Sets rsa_verid_ruleset
     *
     * @param ?string $rsa_verid_ruleset 
     *
     * @return $this
     */
    public function setRsaVeridRuleset($rsa_verid_ruleset)
    {
        $this->container['rsa_verid_ruleset'] = $rsa_verid_ruleset;

        return $this;
    }

    /**
     * Gets rsa_verid_user_id
     *
     * @return ?string
     */
    public function getRsaVeridUserId()
    {
        return $this->container['rsa_verid_user_id'];
    }

    /**
     * Sets rsa_verid_user_id
     *
     * @param ?string $rsa_verid_user_id 
     *
     * @return $this
     */
    public function setRsaVeridUserId($rsa_verid_user_id)
    {
        $this->container['rsa_verid_user_id'] = $rsa_verid_user_id;

        return $this;
    }

    /**
     * Gets sbs_transaction_level
     *
     * @return ?string
     */
    public function getSbsTransactionLevel()
    {
        return $this->container['sbs_transaction_level'];
    }

    /**
     * Sets sbs_transaction_level
     *
     * @param ?string $sbs_transaction_level 
     *
     * @return $this
     */
    public function setSbsTransactionLevel($sbs_transaction_level)
    {
        $this->container['sbs_transaction_level'] = $sbs_transaction_level;

        return $this;
    }

    /**
     * Gets self_signed_recipient_email_document
     *
     * @return ?string
     */
    public function getSelfSignedRecipientEmailDocument()
    {
        return $this->container['self_signed_recipient_email_document'];
    }

    /**
     * Sets self_signed_recipient_email_document
     *
     * @param ?string $self_signed_recipient_email_document 
     *
     * @return $this
     */
    public function setSelfSignedRecipientEmailDocument($self_signed_recipient_email_document)
    {
        $this->container['self_signed_recipient_email_document'] = $self_signed_recipient_email_document;

        return $this;
    }

    /**
     * Gets self_signed_recipient_email_document_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSelfSignedRecipientEmailDocumentMetadata()
    {
        return $this->container['self_signed_recipient_email_document_metadata'];
    }

    /**
     * Sets self_signed_recipient_email_document_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $self_signed_recipient_email_document_metadata Metadata that indicates whether the `selfSignedRecipientEmailDocument` property is editable.
     *
     * @return $this
     */
    public function setSelfSignedRecipientEmailDocumentMetadata($self_signed_recipient_email_document_metadata)
    {
        $this->container['self_signed_recipient_email_document_metadata'] = $self_signed_recipient_email_document_metadata;

        return $this;
    }

    /**
     * Gets self_signed_recipient_email_document_user_override
     *
     * @return ?string
     */
    public function getSelfSignedRecipientEmailDocumentUserOverride()
    {
        return $this->container['self_signed_recipient_email_document_user_override'];
    }

    /**
     * Sets self_signed_recipient_email_document_user_override
     *
     * @param ?string $self_signed_recipient_email_document_user_override 
     *
     * @return $this
     */
    public function setSelfSignedRecipientEmailDocumentUserOverride($self_signed_recipient_email_document_user_override)
    {
        $this->container['self_signed_recipient_email_document_user_override'] = $self_signed_recipient_email_document_user_override;

        return $this;
    }

    /**
     * Gets self_signed_recipient_email_document_user_override_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSelfSignedRecipientEmailDocumentUserOverrideMetadata()
    {
        return $this->container['self_signed_recipient_email_document_user_override_metadata'];
    }

    /**
     * Sets self_signed_recipient_email_document_user_override_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $self_signed_recipient_email_document_user_override_metadata Metadata that indicates whether the `selfSignedRecipientEmailDocumentUserOverride` property is editable.
     *
     * @return $this
     */
    public function setSelfSignedRecipientEmailDocumentUserOverrideMetadata($self_signed_recipient_email_document_user_override_metadata)
    {
        $this->container['self_signed_recipient_email_document_user_override_metadata'] = $self_signed_recipient_email_document_user_override_metadata;

        return $this;
    }

    /**
     * Gets sender_can_sign_in_each_location
     *
     * @return ?string
     */
    public function getSenderCanSignInEachLocation()
    {
        return $this->container['sender_can_sign_in_each_location'];
    }

    /**
     * Sets sender_can_sign_in_each_location
     *
     * @param ?string $sender_can_sign_in_each_location 
     *
     * @return $this
     */
    public function setSenderCanSignInEachLocation($sender_can_sign_in_each_location)
    {
        $this->container['sender_can_sign_in_each_location'] = $sender_can_sign_in_each_location;

        return $this;
    }

    /**
     * Gets sender_can_sign_in_each_location_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSenderCanSignInEachLocationMetadata()
    {
        return $this->container['sender_can_sign_in_each_location_metadata'];
    }

    /**
     * Sets sender_can_sign_in_each_location_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $sender_can_sign_in_each_location_metadata Metadata that indicates whether the `senderCanSignInEachLocation` property is editable.
     *
     * @return $this
     */
    public function setSenderCanSignInEachLocationMetadata($sender_can_sign_in_each_location_metadata)
    {
        $this->container['sender_can_sign_in_each_location_metadata'] = $sender_can_sign_in_each_location_metadata;

        return $this;
    }

    /**
     * Gets sender_must_authenticate_signing
     *
     * @return ?string
     */
    public function getSenderMustAuthenticateSigning()
    {
        return $this->container['sender_must_authenticate_signing'];
    }

    /**
     * Sets sender_must_authenticate_signing
     *
     * @param ?string $sender_must_authenticate_signing 
     *
     * @return $this
     */
    public function setSenderMustAuthenticateSigning($sender_must_authenticate_signing)
    {
        $this->container['sender_must_authenticate_signing'] = $sender_must_authenticate_signing;

        return $this;
    }

    /**
     * Gets sender_must_authenticate_signing_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSenderMustAuthenticateSigningMetadata()
    {
        return $this->container['sender_must_authenticate_signing_metadata'];
    }

    /**
     * Sets sender_must_authenticate_signing_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $sender_must_authenticate_signing_metadata Metadata that indicates whether the `senderMustAuthenticateSigning` property is editable.
     *
     * @return $this
     */
    public function setSenderMustAuthenticateSigningMetadata($sender_must_authenticate_signing_metadata)
    {
        $this->container['sender_must_authenticate_signing_metadata'] = $sender_must_authenticate_signing_metadata;

        return $this;
    }

    /**
     * Gets sending_tags_font_color
     *
     * @return ?string
     */
    public function getSendingTagsFontColor()
    {
        return $this->container['sending_tags_font_color'];
    }

    /**
     * Sets sending_tags_font_color
     *
     * @param ?string $sending_tags_font_color 
     *
     * @return $this
     */
    public function setSendingTagsFontColor($sending_tags_font_color)
    {
        $this->container['sending_tags_font_color'] = $sending_tags_font_color;

        return $this;
    }

    /**
     * Gets sending_tags_font_color_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSendingTagsFontColorMetadata()
    {
        return $this->container['sending_tags_font_color_metadata'];
    }

    /**
     * Sets sending_tags_font_color_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $sending_tags_font_color_metadata Metadata that indicates whether the `sendingTagsFontColor` property is editable.
     *
     * @return $this
     */
    public function setSendingTagsFontColorMetadata($sending_tags_font_color_metadata)
    {
        $this->container['sending_tags_font_color_metadata'] = $sending_tags_font_color_metadata;

        return $this;
    }

    /**
     * Gets sending_tags_font_name
     *
     * @return ?string
     */
    public function getSendingTagsFontName()
    {
        return $this->container['sending_tags_font_name'];
    }

    /**
     * Sets sending_tags_font_name
     *
     * @param ?string $sending_tags_font_name 
     *
     * @return $this
     */
    public function setSendingTagsFontName($sending_tags_font_name)
    {
        $this->container['sending_tags_font_name'] = $sending_tags_font_name;

        return $this;
    }

    /**
     * Gets sending_tags_font_name_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSendingTagsFontNameMetadata()
    {
        return $this->container['sending_tags_font_name_metadata'];
    }

    /**
     * Sets sending_tags_font_name_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $sending_tags_font_name_metadata Metadata that indicates whether the `sendingTagsFontName` property is editable.
     *
     * @return $this
     */
    public function setSendingTagsFontNameMetadata($sending_tags_font_name_metadata)
    {
        $this->container['sending_tags_font_name_metadata'] = $sending_tags_font_name_metadata;

        return $this;
    }

    /**
     * Gets sending_tags_font_size
     *
     * @return ?string
     */
    public function getSendingTagsFontSize()
    {
        return $this->container['sending_tags_font_size'];
    }

    /**
     * Sets sending_tags_font_size
     *
     * @param ?string $sending_tags_font_size 
     *
     * @return $this
     */
    public function setSendingTagsFontSize($sending_tags_font_size)
    {
        $this->container['sending_tags_font_size'] = $sending_tags_font_size;

        return $this;
    }

    /**
     * Gets sending_tags_font_size_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSendingTagsFontSizeMetadata()
    {
        return $this->container['sending_tags_font_size_metadata'];
    }

    /**
     * Sets sending_tags_font_size_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $sending_tags_font_size_metadata Metadata that indicates whether the `sendingTagsFontSize` property is editable.
     *
     * @return $this
     */
    public function setSendingTagsFontSizeMetadata($sending_tags_font_size_metadata)
    {
        $this->container['sending_tags_font_size_metadata'] = $sending_tags_font_size_metadata;

        return $this;
    }

    /**
     * Gets send_lockout_recipient_notification
     *
     * @return ?string
     */
    public function getSendLockoutRecipientNotification()
    {
        return $this->container['send_lockout_recipient_notification'];
    }

    /**
     * Sets send_lockout_recipient_notification
     *
     * @param ?string $send_lockout_recipient_notification 
     *
     * @return $this
     */
    public function setSendLockoutRecipientNotification($send_lockout_recipient_notification)
    {
        $this->container['send_lockout_recipient_notification'] = $send_lockout_recipient_notification;

        return $this;
    }

    /**
     * Gets send_lockout_recipient_notification_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSendLockoutRecipientNotificationMetadata()
    {
        return $this->container['send_lockout_recipient_notification_metadata'];
    }

    /**
     * Sets send_lockout_recipient_notification_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $send_lockout_recipient_notification_metadata 
     *
     * @return $this
     */
    public function setSendLockoutRecipientNotificationMetadata($send_lockout_recipient_notification_metadata)
    {
        $this->container['send_lockout_recipient_notification_metadata'] = $send_lockout_recipient_notification_metadata;

        return $this;
    }

    /**
     * Gets send_to_certified_delivery_enabled
     *
     * @return ?string
     */
    public function getSendToCertifiedDeliveryEnabled()
    {
        return $this->container['send_to_certified_delivery_enabled'];
    }

    /**
     * Sets send_to_certified_delivery_enabled
     *
     * @param ?string $send_to_certified_delivery_enabled 
     *
     * @return $this
     */
    public function setSendToCertifiedDeliveryEnabled($send_to_certified_delivery_enabled)
    {
        $this->container['send_to_certified_delivery_enabled'] = $send_to_certified_delivery_enabled;

        return $this;
    }

    /**
     * Gets send_to_certified_delivery_enabled_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSendToCertifiedDeliveryEnabledMetadata()
    {
        return $this->container['send_to_certified_delivery_enabled_metadata'];
    }

    /**
     * Sets send_to_certified_delivery_enabled_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $send_to_certified_delivery_enabled_metadata Metadata that indicates whether the `sendToCertifiedDeliveryEnabled` property is editable.
     *
     * @return $this
     */
    public function setSendToCertifiedDeliveryEnabledMetadata($send_to_certified_delivery_enabled_metadata)
    {
        $this->container['send_to_certified_delivery_enabled_metadata'] = $send_to_certified_delivery_enabled_metadata;

        return $this;
    }

    /**
     * Gets session_timeout
     *
     * @return ?string
     */
    public function getSessionTimeout()
    {
        return $this->container['session_timeout'];
    }

    /**
     * Sets session_timeout
     *
     * @param ?string $session_timeout 
     *
     * @return $this
     */
    public function setSessionTimeout($session_timeout)
    {
        $this->container['session_timeout'] = $session_timeout;

        return $this;
    }

    /**
     * Gets session_timeout_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSessionTimeoutMetadata()
    {
        return $this->container['session_timeout_metadata'];
    }

    /**
     * Sets session_timeout_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $session_timeout_metadata Metadata that indicates whether the `sessionTimeout` property is editable.
     *
     * @return $this
     */
    public function setSessionTimeoutMetadata($session_timeout_metadata)
    {
        $this->container['session_timeout_metadata'] = $session_timeout_metadata;

        return $this;
    }

    /**
     * Gets set_recip_email_lang
     *
     * @return ?string
     */
    public function getSetRecipEmailLang()
    {
        return $this->container['set_recip_email_lang'];
    }

    /**
     * Sets set_recip_email_lang
     *
     * @param ?string $set_recip_email_lang 
     *
     * @return $this
     */
    public function setSetRecipEmailLang($set_recip_email_lang)
    {
        $this->container['set_recip_email_lang'] = $set_recip_email_lang;

        return $this;
    }

    /**
     * Gets set_recip_email_lang_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSetRecipEmailLangMetadata()
    {
        return $this->container['set_recip_email_lang_metadata'];
    }

    /**
     * Sets set_recip_email_lang_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $set_recip_email_lang_metadata Metadata that indicates whether the `setRecipEmailLang` property is editable.
     *
     * @return $this
     */
    public function setSetRecipEmailLangMetadata($set_recip_email_lang_metadata)
    {
        $this->container['set_recip_email_lang_metadata'] = $set_recip_email_lang_metadata;

        return $this;
    }

    /**
     * Gets set_recip_sign_lang
     *
     * @return ?string
     */
    public function getSetRecipSignLang()
    {
        return $this->container['set_recip_sign_lang'];
    }

    /**
     * Sets set_recip_sign_lang
     *
     * @param ?string $set_recip_sign_lang 
     *
     * @return $this
     */
    public function setSetRecipSignLang($set_recip_sign_lang)
    {
        $this->container['set_recip_sign_lang'] = $set_recip_sign_lang;

        return $this;
    }

    /**
     * Gets set_recip_sign_lang_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSetRecipSignLangMetadata()
    {
        return $this->container['set_recip_sign_lang_metadata'];
    }

    /**
     * Sets set_recip_sign_lang_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $set_recip_sign_lang_metadata Metadata that indicates whether the `setRecipSignLang` property is editable.
     *
     * @return $this
     */
    public function setSetRecipSignLangMetadata($set_recip_sign_lang_metadata)
    {
        $this->container['set_recip_sign_lang_metadata'] = $set_recip_sign_lang_metadata;

        return $this;
    }

    /**
     * Gets shared_template_folders
     *
     * @return ?string
     */
    public function getSharedTemplateFolders()
    {
        return $this->container['shared_template_folders'];
    }

    /**
     * Sets shared_template_folders
     *
     * @param ?string $shared_template_folders 
     *
     * @return $this
     */
    public function setSharedTemplateFolders($shared_template_folders)
    {
        $this->container['shared_template_folders'] = $shared_template_folders;

        return $this;
    }

    /**
     * Gets shared_template_folders_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSharedTemplateFoldersMetadata()
    {
        return $this->container['shared_template_folders_metadata'];
    }

    /**
     * Sets shared_template_folders_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $shared_template_folders_metadata Metadata that indicates whether the `sharedTemplateFolders` property is editable.
     *
     * @return $this
     */
    public function setSharedTemplateFoldersMetadata($shared_template_folders_metadata)
    {
        $this->container['shared_template_folders_metadata'] = $shared_template_folders_metadata;

        return $this;
    }

    /**
     * Gets show_complete_dialog_in_embedded_session
     *
     * @return ?string
     */
    public function getShowCompleteDialogInEmbeddedSession()
    {
        return $this->container['show_complete_dialog_in_embedded_session'];
    }

    /**
     * Sets show_complete_dialog_in_embedded_session
     *
     * @param ?string $show_complete_dialog_in_embedded_session 
     *
     * @return $this
     */
    public function setShowCompleteDialogInEmbeddedSession($show_complete_dialog_in_embedded_session)
    {
        $this->container['show_complete_dialog_in_embedded_session'] = $show_complete_dialog_in_embedded_session;

        return $this;
    }

    /**
     * Gets show_complete_dialog_in_embedded_session_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getShowCompleteDialogInEmbeddedSessionMetadata()
    {
        return $this->container['show_complete_dialog_in_embedded_session_metadata'];
    }

    /**
     * Sets show_complete_dialog_in_embedded_session_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $show_complete_dialog_in_embedded_session_metadata Metadata that indicates whether the `showCompleteDialogInEmbeddedSession` property is editable.
     *
     * @return $this
     */
    public function setShowCompleteDialogInEmbeddedSessionMetadata($show_complete_dialog_in_embedded_session_metadata)
    {
        $this->container['show_complete_dialog_in_embedded_session_metadata'] = $show_complete_dialog_in_embedded_session_metadata;

        return $this;
    }

    /**
     * Gets show_conditional_routing_on_send
     *
     * @return ?string
     */
    public function getShowConditionalRoutingOnSend()
    {
        return $this->container['show_conditional_routing_on_send'];
    }

    /**
     * Sets show_conditional_routing_on_send
     *
     * @param ?string $show_conditional_routing_on_send 
     *
     * @return $this
     */
    public function setShowConditionalRoutingOnSend($show_conditional_routing_on_send)
    {
        $this->container['show_conditional_routing_on_send'] = $show_conditional_routing_on_send;

        return $this;
    }

    /**
     * Gets show_conditional_routing_on_send_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getShowConditionalRoutingOnSendMetadata()
    {
        return $this->container['show_conditional_routing_on_send_metadata'];
    }

    /**
     * Sets show_conditional_routing_on_send_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $show_conditional_routing_on_send_metadata 
     *
     * @return $this
     */
    public function setShowConditionalRoutingOnSendMetadata($show_conditional_routing_on_send_metadata)
    {
        $this->container['show_conditional_routing_on_send_metadata'] = $show_conditional_routing_on_send_metadata;

        return $this;
    }

    /**
     * Gets show_initial_conditional_fields
     *
     * @return ?string
     */
    public function getShowInitialConditionalFields()
    {
        return $this->container['show_initial_conditional_fields'];
    }

    /**
     * Sets show_initial_conditional_fields
     *
     * @param ?string $show_initial_conditional_fields 
     *
     * @return $this
     */
    public function setShowInitialConditionalFields($show_initial_conditional_fields)
    {
        $this->container['show_initial_conditional_fields'] = $show_initial_conditional_fields;

        return $this;
    }

    /**
     * Gets show_initial_conditional_fields_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getShowInitialConditionalFieldsMetadata()
    {
        return $this->container['show_initial_conditional_fields_metadata'];
    }

    /**
     * Sets show_initial_conditional_fields_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $show_initial_conditional_fields_metadata Metadata that indicates whether the `showInitialConditionalFields` property is editable.
     *
     * @return $this
     */
    public function setShowInitialConditionalFieldsMetadata($show_initial_conditional_fields_metadata)
    {
        $this->container['show_initial_conditional_fields_metadata'] = $show_initial_conditional_fields_metadata;

        return $this;
    }

    /**
     * Gets show_localized_watermarks
     *
     * @return ?string
     */
    public function getShowLocalizedWatermarks()
    {
        return $this->container['show_localized_watermarks'];
    }

    /**
     * Sets show_localized_watermarks
     *
     * @param ?string $show_localized_watermarks 
     *
     * @return $this
     */
    public function setShowLocalizedWatermarks($show_localized_watermarks)
    {
        $this->container['show_localized_watermarks'] = $show_localized_watermarks;

        return $this;
    }

    /**
     * Gets show_localized_watermarks_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getShowLocalizedWatermarksMetadata()
    {
        return $this->container['show_localized_watermarks_metadata'];
    }

    /**
     * Sets show_localized_watermarks_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $show_localized_watermarks_metadata Metadata that indicates whether the `showLocalizedWatermarks` property is editable.
     *
     * @return $this
     */
    public function setShowLocalizedWatermarksMetadata($show_localized_watermarks_metadata)
    {
        $this->container['show_localized_watermarks_metadata'] = $show_localized_watermarks_metadata;

        return $this;
    }

    /**
     * Gets show_masked_fields_when_downloading_document_as_sender
     *
     * @return ?string
     */
    public function getShowMaskedFieldsWhenDownloadingDocumentAsSender()
    {
        return $this->container['show_masked_fields_when_downloading_document_as_sender'];
    }

    /**
     * Sets show_masked_fields_when_downloading_document_as_sender
     *
     * @param ?string $show_masked_fields_when_downloading_document_as_sender 
     *
     * @return $this
     */
    public function setShowMaskedFieldsWhenDownloadingDocumentAsSender($show_masked_fields_when_downloading_document_as_sender)
    {
        $this->container['show_masked_fields_when_downloading_document_as_sender'] = $show_masked_fields_when_downloading_document_as_sender;

        return $this;
    }

    /**
     * Gets show_masked_fields_when_downloading_document_as_sender_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getShowMaskedFieldsWhenDownloadingDocumentAsSenderMetadata()
    {
        return $this->container['show_masked_fields_when_downloading_document_as_sender_metadata'];
    }

    /**
     * Sets show_masked_fields_when_downloading_document_as_sender_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $show_masked_fields_when_downloading_document_as_sender_metadata 
     *
     * @return $this
     */
    public function setShowMaskedFieldsWhenDownloadingDocumentAsSenderMetadata($show_masked_fields_when_downloading_document_as_sender_metadata)
    {
        $this->container['show_masked_fields_when_downloading_document_as_sender_metadata'] = $show_masked_fields_when_downloading_document_as_sender_metadata;

        return $this;
    }

    /**
     * Gets show_tutorials
     *
     * @return ?string
     */
    public function getShowTutorials()
    {
        return $this->container['show_tutorials'];
    }

    /**
     * Sets show_tutorials
     *
     * @param ?string $show_tutorials 
     *
     * @return $this
     */
    public function setShowTutorials($show_tutorials)
    {
        $this->container['show_tutorials'] = $show_tutorials;

        return $this;
    }

    /**
     * Gets show_tutorials_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getShowTutorialsMetadata()
    {
        return $this->container['show_tutorials_metadata'];
    }

    /**
     * Sets show_tutorials_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $show_tutorials_metadata Metadata that indicates whether the `showTutorials` property is editable.
     *
     * @return $this
     */
    public function setShowTutorialsMetadata($show_tutorials_metadata)
    {
        $this->container['show_tutorials_metadata'] = $show_tutorials_metadata;

        return $this;
    }

    /**
     * Gets signature_providers
     *
     * @return ?string[]
     */
    public function getSignatureProviders()
    {
        return $this->container['signature_providers'];
    }

    /**
     * Sets signature_providers
     *
     * @param ?string[] $signature_providers 
     *
     * @return $this
     */
    public function setSignatureProviders($signature_providers)
    {
        $this->container['signature_providers'] = $signature_providers;

        return $this;
    }

    /**
     * Gets signature_providers_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSignatureProvidersMetadata()
    {
        return $this->container['signature_providers_metadata'];
    }

    /**
     * Sets signature_providers_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $signature_providers_metadata Metadata that indicates whether the `signatureProviders` property is editable.
     *
     * @return $this
     */
    public function setSignatureProvidersMetadata($signature_providers_metadata)
    {
        $this->container['signature_providers_metadata'] = $signature_providers_metadata;

        return $this;
    }

    /**
     * Gets sign_date_format
     *
     * @return ?string
     */
    public function getSignDateFormat()
    {
        return $this->container['sign_date_format'];
    }

    /**
     * Sets sign_date_format
     *
     * @param ?string $sign_date_format 
     *
     * @return $this
     */
    public function setSignDateFormat($sign_date_format)
    {
        $this->container['sign_date_format'] = $sign_date_format;

        return $this;
    }

    /**
     * Gets sign_date_format_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSignDateFormatMetadata()
    {
        return $this->container['sign_date_format_metadata'];
    }

    /**
     * Sets sign_date_format_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $sign_date_format_metadata Metadata that indicates whether the `signDateFormat` property is editable.
     *
     * @return $this
     */
    public function setSignDateFormatMetadata($sign_date_format_metadata)
    {
        $this->container['sign_date_format_metadata'] = $sign_date_format_metadata;

        return $this;
    }

    /**
     * Gets sign_date_time_account_language_override
     *
     * @return ?string
     */
    public function getSignDateTimeAccountLanguageOverride()
    {
        return $this->container['sign_date_time_account_language_override'];
    }

    /**
     * Sets sign_date_time_account_language_override
     *
     * @param ?string $sign_date_time_account_language_override 
     *
     * @return $this
     */
    public function setSignDateTimeAccountLanguageOverride($sign_date_time_account_language_override)
    {
        $this->container['sign_date_time_account_language_override'] = $sign_date_time_account_language_override;

        return $this;
    }

    /**
     * Gets sign_date_time_account_language_override_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSignDateTimeAccountLanguageOverrideMetadata()
    {
        return $this->container['sign_date_time_account_language_override_metadata'];
    }

    /**
     * Sets sign_date_time_account_language_override_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $sign_date_time_account_language_override_metadata 
     *
     * @return $this
     */
    public function setSignDateTimeAccountLanguageOverrideMetadata($sign_date_time_account_language_override_metadata)
    {
        $this->container['sign_date_time_account_language_override_metadata'] = $sign_date_time_account_language_override_metadata;

        return $this;
    }

    /**
     * Gets sign_date_time_account_timezone_override
     *
     * @return ?string
     */
    public function getSignDateTimeAccountTimezoneOverride()
    {
        return $this->container['sign_date_time_account_timezone_override'];
    }

    /**
     * Sets sign_date_time_account_timezone_override
     *
     * @param ?string $sign_date_time_account_timezone_override 
     *
     * @return $this
     */
    public function setSignDateTimeAccountTimezoneOverride($sign_date_time_account_timezone_override)
    {
        $this->container['sign_date_time_account_timezone_override'] = $sign_date_time_account_timezone_override;

        return $this;
    }

    /**
     * Gets sign_date_time_account_timezone_override_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSignDateTimeAccountTimezoneOverrideMetadata()
    {
        return $this->container['sign_date_time_account_timezone_override_metadata'];
    }

    /**
     * Sets sign_date_time_account_timezone_override_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $sign_date_time_account_timezone_override_metadata 
     *
     * @return $this
     */
    public function setSignDateTimeAccountTimezoneOverrideMetadata($sign_date_time_account_timezone_override_metadata)
    {
        $this->container['sign_date_time_account_timezone_override_metadata'] = $sign_date_time_account_timezone_override_metadata;

        return $this;
    }

    /**
     * Gets signer_attach_certificate_to_envelope_pdf
     *
     * @return ?string
     */
    public function getSignerAttachCertificateToEnvelopePdf()
    {
        return $this->container['signer_attach_certificate_to_envelope_pdf'];
    }

    /**
     * Sets signer_attach_certificate_to_envelope_pdf
     *
     * @param ?string $signer_attach_certificate_to_envelope_pdf 
     *
     * @return $this
     */
    public function setSignerAttachCertificateToEnvelopePdf($signer_attach_certificate_to_envelope_pdf)
    {
        $this->container['signer_attach_certificate_to_envelope_pdf'] = $signer_attach_certificate_to_envelope_pdf;

        return $this;
    }

    /**
     * Gets signer_attach_certificate_to_envelope_pdf_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSignerAttachCertificateToEnvelopePdfMetadata()
    {
        return $this->container['signer_attach_certificate_to_envelope_pdf_metadata'];
    }

    /**
     * Sets signer_attach_certificate_to_envelope_pdf_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $signer_attach_certificate_to_envelope_pdf_metadata Metadata that indicates whether the `signerAttachCertificateToEnvelopePDF` property is editable.
     *
     * @return $this
     */
    public function setSignerAttachCertificateToEnvelopePdfMetadata($signer_attach_certificate_to_envelope_pdf_metadata)
    {
        $this->container['signer_attach_certificate_to_envelope_pdf_metadata'] = $signer_attach_certificate_to_envelope_pdf_metadata;

        return $this;
    }

    /**
     * Gets signer_attach_concat
     *
     * @return ?string
     */
    public function getSignerAttachConcat()
    {
        return $this->container['signer_attach_concat'];
    }

    /**
     * Sets signer_attach_concat
     *
     * @param ?string $signer_attach_concat 
     *
     * @return $this
     */
    public function setSignerAttachConcat($signer_attach_concat)
    {
        $this->container['signer_attach_concat'] = $signer_attach_concat;

        return $this;
    }

    /**
     * Gets signer_attach_concat_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSignerAttachConcatMetadata()
    {
        return $this->container['signer_attach_concat_metadata'];
    }

    /**
     * Sets signer_attach_concat_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $signer_attach_concat_metadata Metadata that indicates whether the `signerAttachConcat` property is editable.
     *
     * @return $this
     */
    public function setSignerAttachConcatMetadata($signer_attach_concat_metadata)
    {
        $this->container['signer_attach_concat_metadata'] = $signer_attach_concat_metadata;

        return $this;
    }

    /**
     * Gets signer_can_create_account
     *
     * @return ?string
     */
    public function getSignerCanCreateAccount()
    {
        return $this->container['signer_can_create_account'];
    }

    /**
     * Sets signer_can_create_account
     *
     * @param ?string $signer_can_create_account 
     *
     * @return $this
     */
    public function setSignerCanCreateAccount($signer_can_create_account)
    {
        $this->container['signer_can_create_account'] = $signer_can_create_account;

        return $this;
    }

    /**
     * Gets signer_can_create_account_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSignerCanCreateAccountMetadata()
    {
        return $this->container['signer_can_create_account_metadata'];
    }

    /**
     * Sets signer_can_create_account_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $signer_can_create_account_metadata Metadata that indicates whether the `signerCanCreateAccount` property is editable.
     *
     * @return $this
     */
    public function setSignerCanCreateAccountMetadata($signer_can_create_account_metadata)
    {
        $this->container['signer_can_create_account_metadata'] = $signer_can_create_account_metadata;

        return $this;
    }

    /**
     * Gets signer_can_sign_on_mobile
     *
     * @return ?string
     */
    public function getSignerCanSignOnMobile()
    {
        return $this->container['signer_can_sign_on_mobile'];
    }

    /**
     * Sets signer_can_sign_on_mobile
     *
     * @param ?string $signer_can_sign_on_mobile 
     *
     * @return $this
     */
    public function setSignerCanSignOnMobile($signer_can_sign_on_mobile)
    {
        $this->container['signer_can_sign_on_mobile'] = $signer_can_sign_on_mobile;

        return $this;
    }

    /**
     * Gets signer_can_sign_on_mobile_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSignerCanSignOnMobileMetadata()
    {
        return $this->container['signer_can_sign_on_mobile_metadata'];
    }

    /**
     * Sets signer_can_sign_on_mobile_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $signer_can_sign_on_mobile_metadata Metadata that indicates whether the `signerCanSignOnMobile` property is editable.
     *
     * @return $this
     */
    public function setSignerCanSignOnMobileMetadata($signer_can_sign_on_mobile_metadata)
    {
        $this->container['signer_can_sign_on_mobile_metadata'] = $signer_can_sign_on_mobile_metadata;

        return $this;
    }

    /**
     * Gets signer_in_session_use_envelope_complete_email
     *
     * @return ?string
     */
    public function getSignerInSessionUseEnvelopeCompleteEmail()
    {
        return $this->container['signer_in_session_use_envelope_complete_email'];
    }

    /**
     * Sets signer_in_session_use_envelope_complete_email
     *
     * @param ?string $signer_in_session_use_envelope_complete_email 
     *
     * @return $this
     */
    public function setSignerInSessionUseEnvelopeCompleteEmail($signer_in_session_use_envelope_complete_email)
    {
        $this->container['signer_in_session_use_envelope_complete_email'] = $signer_in_session_use_envelope_complete_email;

        return $this;
    }

    /**
     * Gets signer_in_session_use_envelope_complete_email_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSignerInSessionUseEnvelopeCompleteEmailMetadata()
    {
        return $this->container['signer_in_session_use_envelope_complete_email_metadata'];
    }

    /**
     * Sets signer_in_session_use_envelope_complete_email_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $signer_in_session_use_envelope_complete_email_metadata Metadata that indicates whether the `signerInSessionUseEnvelopeCompleteEmail` property is editable.
     *
     * @return $this
     */
    public function setSignerInSessionUseEnvelopeCompleteEmailMetadata($signer_in_session_use_envelope_complete_email_metadata)
    {
        $this->container['signer_in_session_use_envelope_complete_email_metadata'] = $signer_in_session_use_envelope_complete_email_metadata;

        return $this;
    }

    /**
     * Gets signer_login_requirements
     *
     * @return ?string
     */
    public function getSignerLoginRequirements()
    {
        return $this->container['signer_login_requirements'];
    }

    /**
     * Sets signer_login_requirements
     *
     * @param ?string $signer_login_requirements 
     *
     * @return $this
     */
    public function setSignerLoginRequirements($signer_login_requirements)
    {
        $this->container['signer_login_requirements'] = $signer_login_requirements;

        return $this;
    }

    /**
     * Gets signer_login_requirements_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSignerLoginRequirementsMetadata()
    {
        return $this->container['signer_login_requirements_metadata'];
    }

    /**
     * Sets signer_login_requirements_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $signer_login_requirements_metadata Metadata that indicates whether the `signerLoginRequirements` property is editable.
     *
     * @return $this
     */
    public function setSignerLoginRequirementsMetadata($signer_login_requirements_metadata)
    {
        $this->container['signer_login_requirements_metadata'] = $signer_login_requirements_metadata;

        return $this;
    }

    /**
     * Gets signer_must_have_account
     *
     * @return ?string
     */
    public function getSignerMustHaveAccount()
    {
        return $this->container['signer_must_have_account'];
    }

    /**
     * Sets signer_must_have_account
     *
     * @param ?string $signer_must_have_account 
     *
     * @return $this
     */
    public function setSignerMustHaveAccount($signer_must_have_account)
    {
        $this->container['signer_must_have_account'] = $signer_must_have_account;

        return $this;
    }

    /**
     * Gets signer_must_have_account_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSignerMustHaveAccountMetadata()
    {
        return $this->container['signer_must_have_account_metadata'];
    }

    /**
     * Sets signer_must_have_account_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $signer_must_have_account_metadata Metadata that indicates whether the `signerMustHaveAccount` property is editable.
     *
     * @return $this
     */
    public function setSignerMustHaveAccountMetadata($signer_must_have_account_metadata)
    {
        $this->container['signer_must_have_account_metadata'] = $signer_must_have_account_metadata;

        return $this;
    }

    /**
     * Gets signer_must_login_to_sign
     *
     * @return ?string
     */
    public function getSignerMustLoginToSign()
    {
        return $this->container['signer_must_login_to_sign'];
    }

    /**
     * Sets signer_must_login_to_sign
     *
     * @param ?string $signer_must_login_to_sign 
     *
     * @return $this
     */
    public function setSignerMustLoginToSign($signer_must_login_to_sign)
    {
        $this->container['signer_must_login_to_sign'] = $signer_must_login_to_sign;

        return $this;
    }

    /**
     * Gets signer_must_login_to_sign_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSignerMustLoginToSignMetadata()
    {
        return $this->container['signer_must_login_to_sign_metadata'];
    }

    /**
     * Sets signer_must_login_to_sign_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $signer_must_login_to_sign_metadata Metadata that indicates whether the `signerMustLoginToSign` property is editable.
     *
     * @return $this
     */
    public function setSignerMustLoginToSignMetadata($signer_must_login_to_sign_metadata)
    {
        $this->container['signer_must_login_to_sign_metadata'] = $signer_must_login_to_sign_metadata;

        return $this;
    }

    /**
     * Gets signer_show_secure_field_initial_values
     *
     * @return ?string
     */
    public function getSignerShowSecureFieldInitialValues()
    {
        return $this->container['signer_show_secure_field_initial_values'];
    }

    /**
     * Sets signer_show_secure_field_initial_values
     *
     * @param ?string $signer_show_secure_field_initial_values 
     *
     * @return $this
     */
    public function setSignerShowSecureFieldInitialValues($signer_show_secure_field_initial_values)
    {
        $this->container['signer_show_secure_field_initial_values'] = $signer_show_secure_field_initial_values;

        return $this;
    }

    /**
     * Gets signer_show_secure_field_initial_values_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSignerShowSecureFieldInitialValuesMetadata()
    {
        return $this->container['signer_show_secure_field_initial_values_metadata'];
    }

    /**
     * Sets signer_show_secure_field_initial_values_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $signer_show_secure_field_initial_values_metadata Metadata that indicates whether the `signerShowSecureFieldInitialValues` property is editable.
     *
     * @return $this
     */
    public function setSignerShowSecureFieldInitialValuesMetadata($signer_show_secure_field_initial_values_metadata)
    {
        $this->container['signer_show_secure_field_initial_values_metadata'] = $signer_show_secure_field_initial_values_metadata;

        return $this;
    }

    /**
     * Gets signing_session_timeout
     *
     * @return ?string
     */
    public function getSigningSessionTimeout()
    {
        return $this->container['signing_session_timeout'];
    }

    /**
     * Sets signing_session_timeout
     *
     * @param ?string $signing_session_timeout 
     *
     * @return $this
     */
    public function setSigningSessionTimeout($signing_session_timeout)
    {
        $this->container['signing_session_timeout'] = $signing_session_timeout;

        return $this;
    }

    /**
     * Gets signing_session_timeout_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSigningSessionTimeoutMetadata()
    {
        return $this->container['signing_session_timeout_metadata'];
    }

    /**
     * Sets signing_session_timeout_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $signing_session_timeout_metadata Metadata that indicates whether the `signingSessionTimeout` property is editable.
     *
     * @return $this
     */
    public function setSigningSessionTimeoutMetadata($signing_session_timeout_metadata)
    {
        $this->container['signing_session_timeout_metadata'] = $signing_session_timeout_metadata;

        return $this;
    }

    /**
     * Gets signing_ui_version
     *
     * @return ?string
     */
    public function getSigningUiVersion()
    {
        return $this->container['signing_ui_version'];
    }

    /**
     * Sets signing_ui_version
     *
     * @param ?string $signing_ui_version 
     *
     * @return $this
     */
    public function setSigningUiVersion($signing_ui_version)
    {
        $this->container['signing_ui_version'] = $signing_ui_version;

        return $this;
    }

    /**
     * Gets signing_ui_version_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSigningUiVersionMetadata()
    {
        return $this->container['signing_ui_version_metadata'];
    }

    /**
     * Sets signing_ui_version_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $signing_ui_version_metadata Reserved for DocuSign.
     *
     * @return $this
     */
    public function setSigningUiVersionMetadata($signing_ui_version_metadata)
    {
        $this->container['signing_ui_version_metadata'] = $signing_ui_version_metadata;

        return $this;
    }

    /**
     * Gets sign_time_format
     *
     * @return ?string
     */
    public function getSignTimeFormat()
    {
        return $this->container['sign_time_format'];
    }

    /**
     * Sets sign_time_format
     *
     * @param ?string $sign_time_format 
     *
     * @return $this
     */
    public function setSignTimeFormat($sign_time_format)
    {
        $this->container['sign_time_format'] = $sign_time_format;

        return $this;
    }

    /**
     * Gets sign_time_format_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSignTimeFormatMetadata()
    {
        return $this->container['sign_time_format_metadata'];
    }

    /**
     * Sets sign_time_format_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $sign_time_format_metadata Metadata that indicates whether the `signTimeFormat` property is editable.
     *
     * @return $this
     */
    public function setSignTimeFormatMetadata($sign_time_format_metadata)
    {
        $this->container['sign_time_format_metadata'] = $sign_time_format_metadata;

        return $this;
    }

    /**
     * Gets sign_time_show_am_pm
     *
     * @return ?string
     */
    public function getSignTimeShowAmPm()
    {
        return $this->container['sign_time_show_am_pm'];
    }

    /**
     * Sets sign_time_show_am_pm
     *
     * @param ?string $sign_time_show_am_pm 
     *
     * @return $this
     */
    public function setSignTimeShowAmPm($sign_time_show_am_pm)
    {
        $this->container['sign_time_show_am_pm'] = $sign_time_show_am_pm;

        return $this;
    }

    /**
     * Gets sign_time_show_am_pm_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSignTimeShowAmPmMetadata()
    {
        return $this->container['sign_time_show_am_pm_metadata'];
    }

    /**
     * Sets sign_time_show_am_pm_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $sign_time_show_am_pm_metadata Metadata that indicates whether the `signTimeShowAmPm` property is editable.
     *
     * @return $this
     */
    public function setSignTimeShowAmPmMetadata($sign_time_show_am_pm_metadata)
    {
        $this->container['sign_time_show_am_pm_metadata'] = $sign_time_show_am_pm_metadata;

        return $this;
    }

    /**
     * Gets simplified_sending_enabled
     *
     * @return ?string
     */
    public function getSimplifiedSendingEnabled()
    {
        return $this->container['simplified_sending_enabled'];
    }

    /**
     * Sets simplified_sending_enabled
     *
     * @param ?string $simplified_sending_enabled 
     *
     * @return $this
     */
    public function setSimplifiedSendingEnabled($simplified_sending_enabled)
    {
        $this->container['simplified_sending_enabled'] = $simplified_sending_enabled;

        return $this;
    }

    /**
     * Gets simplified_sending_enabled_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSimplifiedSendingEnabledMetadata()
    {
        return $this->container['simplified_sending_enabled_metadata'];
    }

    /**
     * Sets simplified_sending_enabled_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $simplified_sending_enabled_metadata Metadata that indicates whether the `simplifiedSendingEnabled` property is editable.
     *
     * @return $this
     */
    public function setSimplifiedSendingEnabledMetadata($simplified_sending_enabled_metadata)
    {
        $this->container['simplified_sending_enabled_metadata'] = $simplified_sending_enabled_metadata;

        return $this;
    }

    /**
     * Gets single_sign_on_enabled
     *
     * @return ?string
     */
    public function getSingleSignOnEnabled()
    {
        return $this->container['single_sign_on_enabled'];
    }

    /**
     * Sets single_sign_on_enabled
     *
     * @param ?string $single_sign_on_enabled 
     *
     * @return $this
     */
    public function setSingleSignOnEnabled($single_sign_on_enabled)
    {
        $this->container['single_sign_on_enabled'] = $single_sign_on_enabled;

        return $this;
    }

    /**
     * Gets single_sign_on_enabled_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSingleSignOnEnabledMetadata()
    {
        return $this->container['single_sign_on_enabled_metadata'];
    }

    /**
     * Sets single_sign_on_enabled_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $single_sign_on_enabled_metadata Metadata that indicates whether the `singleSignOnEnabled` property is editable.
     *
     * @return $this
     */
    public function setSingleSignOnEnabledMetadata($single_sign_on_enabled_metadata)
    {
        $this->container['single_sign_on_enabled_metadata'] = $single_sign_on_enabled_metadata;

        return $this;
    }

    /**
     * Gets skip_auth_completed_envelopes
     *
     * @return ?string
     */
    public function getSkipAuthCompletedEnvelopes()
    {
        return $this->container['skip_auth_completed_envelopes'];
    }

    /**
     * Sets skip_auth_completed_envelopes
     *
     * @param ?string $skip_auth_completed_envelopes 
     *
     * @return $this
     */
    public function setSkipAuthCompletedEnvelopes($skip_auth_completed_envelopes)
    {
        $this->container['skip_auth_completed_envelopes'] = $skip_auth_completed_envelopes;

        return $this;
    }

    /**
     * Gets skip_auth_completed_envelopes_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSkipAuthCompletedEnvelopesMetadata()
    {
        return $this->container['skip_auth_completed_envelopes_metadata'];
    }

    /**
     * Sets skip_auth_completed_envelopes_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $skip_auth_completed_envelopes_metadata Metadata that indicates whether the `skipAuthCompletedEnvelopes` property is editable.
     *
     * @return $this
     */
    public function setSkipAuthCompletedEnvelopesMetadata($skip_auth_completed_envelopes_metadata)
    {
        $this->container['skip_auth_completed_envelopes_metadata'] = $skip_auth_completed_envelopes_metadata;

        return $this;
    }

    /**
     * Gets social_id_recip_auth
     *
     * @return ?string
     */
    public function getSocialIdRecipAuth()
    {
        return $this->container['social_id_recip_auth'];
    }

    /**
     * Sets social_id_recip_auth
     *
     * @param ?string $social_id_recip_auth 
     *
     * @return $this
     */
    public function setSocialIdRecipAuth($social_id_recip_auth)
    {
        $this->container['social_id_recip_auth'] = $social_id_recip_auth;

        return $this;
    }

    /**
     * Gets social_id_recip_auth_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSocialIdRecipAuthMetadata()
    {
        return $this->container['social_id_recip_auth_metadata'];
    }

    /**
     * Sets social_id_recip_auth_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $social_id_recip_auth_metadata Metadata that indicates whether the `socialIdRecipAuth` property is editable.
     *
     * @return $this
     */
    public function setSocialIdRecipAuthMetadata($social_id_recip_auth_metadata)
    {
        $this->container['social_id_recip_auth_metadata'] = $social_id_recip_auth_metadata;

        return $this;
    }

    /**
     * Gets specify_document_visibility
     *
     * @return ?string
     */
    public function getSpecifyDocumentVisibility()
    {
        return $this->container['specify_document_visibility'];
    }

    /**
     * Sets specify_document_visibility
     *
     * @param ?string $specify_document_visibility 
     *
     * @return $this
     */
    public function setSpecifyDocumentVisibility($specify_document_visibility)
    {
        $this->container['specify_document_visibility'] = $specify_document_visibility;

        return $this;
    }

    /**
     * Gets specify_document_visibility_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSpecifyDocumentVisibilityMetadata()
    {
        return $this->container['specify_document_visibility_metadata'];
    }

    /**
     * Sets specify_document_visibility_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $specify_document_visibility_metadata Metadata that indicates whether the `specifyDocumentVisibility` property is editable.
     *
     * @return $this
     */
    public function setSpecifyDocumentVisibilityMetadata($specify_document_visibility_metadata)
    {
        $this->container['specify_document_visibility_metadata'] = $specify_document_visibility_metadata;

        return $this;
    }

    /**
     * Gets start_in_advanced_correct
     *
     * @return ?string
     */
    public function getStartInAdvancedCorrect()
    {
        return $this->container['start_in_advanced_correct'];
    }

    /**
     * Sets start_in_advanced_correct
     *
     * @param ?string $start_in_advanced_correct 
     *
     * @return $this
     */
    public function setStartInAdvancedCorrect($start_in_advanced_correct)
    {
        $this->container['start_in_advanced_correct'] = $start_in_advanced_correct;

        return $this;
    }

    /**
     * Gets start_in_advanced_correct_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getStartInAdvancedCorrectMetadata()
    {
        return $this->container['start_in_advanced_correct_metadata'];
    }

    /**
     * Sets start_in_advanced_correct_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $start_in_advanced_correct_metadata Metadata that indicates whether the `startInAdvancedCorrect` property is editable.
     *
     * @return $this
     */
    public function setStartInAdvancedCorrectMetadata($start_in_advanced_correct_metadata)
    {
        $this->container['start_in_advanced_correct_metadata'] = $start_in_advanced_correct_metadata;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_accept
     *
     * @return ?string
     */
    public function getSupplementalDocumentsMustAccept()
    {
        return $this->container['supplemental_documents_must_accept'];
    }

    /**
     * Sets supplemental_documents_must_accept
     *
     * @param ?string $supplemental_documents_must_accept 
     *
     * @return $this
     */
    public function setSupplementalDocumentsMustAccept($supplemental_documents_must_accept)
    {
        $this->container['supplemental_documents_must_accept'] = $supplemental_documents_must_accept;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_accept_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSupplementalDocumentsMustAcceptMetadata()
    {
        return $this->container['supplemental_documents_must_accept_metadata'];
    }

    /**
     * Sets supplemental_documents_must_accept_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $supplemental_documents_must_accept_metadata Metadata that indicates whether the `supplementalDocumentsMustAccept` property is editable.
     *
     * @return $this
     */
    public function setSupplementalDocumentsMustAcceptMetadata($supplemental_documents_must_accept_metadata)
    {
        $this->container['supplemental_documents_must_accept_metadata'] = $supplemental_documents_must_accept_metadata;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_read
     *
     * @return ?string
     */
    public function getSupplementalDocumentsMustRead()
    {
        return $this->container['supplemental_documents_must_read'];
    }

    /**
     * Sets supplemental_documents_must_read
     *
     * @param ?string $supplemental_documents_must_read 
     *
     * @return $this
     */
    public function setSupplementalDocumentsMustRead($supplemental_documents_must_read)
    {
        $this->container['supplemental_documents_must_read'] = $supplemental_documents_must_read;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_read_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSupplementalDocumentsMustReadMetadata()
    {
        return $this->container['supplemental_documents_must_read_metadata'];
    }

    /**
     * Sets supplemental_documents_must_read_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $supplemental_documents_must_read_metadata Metadata that indicates whether the `supplementalDocumentsMustRead` property is editable.
     *
     * @return $this
     */
    public function setSupplementalDocumentsMustReadMetadata($supplemental_documents_must_read_metadata)
    {
        $this->container['supplemental_documents_must_read_metadata'] = $supplemental_documents_must_read_metadata;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_view
     *
     * @return ?string
     */
    public function getSupplementalDocumentsMustView()
    {
        return $this->container['supplemental_documents_must_view'];
    }

    /**
     * Sets supplemental_documents_must_view
     *
     * @param ?string $supplemental_documents_must_view 
     *
     * @return $this
     */
    public function setSupplementalDocumentsMustView($supplemental_documents_must_view)
    {
        $this->container['supplemental_documents_must_view'] = $supplemental_documents_must_view;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_view_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSupplementalDocumentsMustViewMetadata()
    {
        return $this->container['supplemental_documents_must_view_metadata'];
    }

    /**
     * Sets supplemental_documents_must_view_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $supplemental_documents_must_view_metadata Metadata that indicates whether the `supplementalDocumentsMustView` property is editable.
     *
     * @return $this
     */
    public function setSupplementalDocumentsMustViewMetadata($supplemental_documents_must_view_metadata)
    {
        $this->container['supplemental_documents_must_view_metadata'] = $supplemental_documents_must_view_metadata;

        return $this;
    }

    /**
     * Gets suppress_certificate_enforcement
     *
     * @return ?string
     */
    public function getSuppressCertificateEnforcement()
    {
        return $this->container['suppress_certificate_enforcement'];
    }

    /**
     * Sets suppress_certificate_enforcement
     *
     * @param ?string $suppress_certificate_enforcement 
     *
     * @return $this
     */
    public function setSuppressCertificateEnforcement($suppress_certificate_enforcement)
    {
        $this->container['suppress_certificate_enforcement'] = $suppress_certificate_enforcement;

        return $this;
    }

    /**
     * Gets suppress_certificate_enforcement_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSuppressCertificateEnforcementMetadata()
    {
        return $this->container['suppress_certificate_enforcement_metadata'];
    }

    /**
     * Sets suppress_certificate_enforcement_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $suppress_certificate_enforcement_metadata Metadata that indicates whether the `suppressCertificateEnforcement` property is editable.
     *
     * @return $this
     */
    public function setSuppressCertificateEnforcementMetadata($suppress_certificate_enforcement_metadata)
    {
        $this->container['suppress_certificate_enforcement_metadata'] = $suppress_certificate_enforcement_metadata;

        return $this;
    }

    /**
     * Gets tab_account_settings
     *
     * @return \DocuSign\eSign\Model\TabAccountSettings
     */
    public function getTabAccountSettings()
    {
        return $this->container['tab_account_settings'];
    }

    /**
     * Sets tab_account_settings
     *
     * @param \DocuSign\eSign\Model\TabAccountSettings $tab_account_settings Account-wide tab settings.
     *
     * @return $this
     */
    public function setTabAccountSettings($tab_account_settings)
    {
        $this->container['tab_account_settings'] = $tab_account_settings;

        return $this;
    }

    /**
     * Gets timezone_offset_api
     *
     * @return ?string
     */
    public function getTimezoneOffsetApi()
    {
        return $this->container['timezone_offset_api'];
    }

    /**
     * Sets timezone_offset_api
     *
     * @param ?string $timezone_offset_api 
     *
     * @return $this
     */
    public function setTimezoneOffsetApi($timezone_offset_api)
    {
        $this->container['timezone_offset_api'] = $timezone_offset_api;

        return $this;
    }

    /**
     * Gets timezone_offset_api_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getTimezoneOffsetApiMetadata()
    {
        return $this->container['timezone_offset_api_metadata'];
    }

    /**
     * Sets timezone_offset_api_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $timezone_offset_api_metadata Metadata that indicates whether the `timezoneOffsetAPI` property is editable.
     *
     * @return $this
     */
    public function setTimezoneOffsetApiMetadata($timezone_offset_api_metadata)
    {
        $this->container['timezone_offset_api_metadata'] = $timezone_offset_api_metadata;

        return $this;
    }

    /**
     * Gets timezone_offset_ui
     *
     * @return ?string
     */
    public function getTimezoneOffsetUi()
    {
        return $this->container['timezone_offset_ui'];
    }

    /**
     * Sets timezone_offset_ui
     *
     * @param ?string $timezone_offset_ui 
     *
     * @return $this
     */
    public function setTimezoneOffsetUi($timezone_offset_ui)
    {
        $this->container['timezone_offset_ui'] = $timezone_offset_ui;

        return $this;
    }

    /**
     * Gets timezone_offset_ui_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getTimezoneOffsetUiMetadata()
    {
        return $this->container['timezone_offset_ui_metadata'];
    }

    /**
     * Sets timezone_offset_ui_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $timezone_offset_ui_metadata Metadata that indicates whether the `timezoneOffsetUI` property is editable.
     *
     * @return $this
     */
    public function setTimezoneOffsetUiMetadata($timezone_offset_ui_metadata)
    {
        $this->container['timezone_offset_ui_metadata'] = $timezone_offset_ui_metadata;

        return $this;
    }

    /**
     * Gets universal_signature_opt_in
     *
     * @return ?string
     */
    public function getUniversalSignatureOptIn()
    {
        return $this->container['universal_signature_opt_in'];
    }

    /**
     * Sets universal_signature_opt_in
     *
     * @param ?string $universal_signature_opt_in 
     *
     * @return $this
     */
    public function setUniversalSignatureOptIn($universal_signature_opt_in)
    {
        $this->container['universal_signature_opt_in'] = $universal_signature_opt_in;

        return $this;
    }

    /**
     * Gets use_account_level_email
     *
     * @return ?string
     */
    public function getUseAccountLevelEmail()
    {
        return $this->container['use_account_level_email'];
    }

    /**
     * Sets use_account_level_email
     *
     * @param ?string $use_account_level_email 
     *
     * @return $this
     */
    public function setUseAccountLevelEmail($use_account_level_email)
    {
        $this->container['use_account_level_email'] = $use_account_level_email;

        return $this;
    }

    /**
     * Gets use_account_level_email_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getUseAccountLevelEmailMetadata()
    {
        return $this->container['use_account_level_email_metadata'];
    }

    /**
     * Sets use_account_level_email_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $use_account_level_email_metadata Metadata that indicates whether the `useAccountLevelEmail` property is editable.
     *
     * @return $this
     */
    public function setUseAccountLevelEmailMetadata($use_account_level_email_metadata)
    {
        $this->container['use_account_level_email_metadata'] = $use_account_level_email_metadata;

        return $this;
    }

    /**
     * Gets use_consumer_disclosure
     *
     * @return ?string
     */
    public function getUseConsumerDisclosure()
    {
        return $this->container['use_consumer_disclosure'];
    }

    /**
     * Sets use_consumer_disclosure
     *
     * @param ?string $use_consumer_disclosure 
     *
     * @return $this
     */
    public function setUseConsumerDisclosure($use_consumer_disclosure)
    {
        $this->container['use_consumer_disclosure'] = $use_consumer_disclosure;

        return $this;
    }

    /**
     * Gets use_consumer_disclosure_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getUseConsumerDisclosureMetadata()
    {
        return $this->container['use_consumer_disclosure_metadata'];
    }

    /**
     * Sets use_consumer_disclosure_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $use_consumer_disclosure_metadata Metadata that indicates whether the `useConsumerDisclosure` property is editable.
     *
     * @return $this
     */
    public function setUseConsumerDisclosureMetadata($use_consumer_disclosure_metadata)
    {
        $this->container['use_consumer_disclosure_metadata'] = $use_consumer_disclosure_metadata;

        return $this;
    }

    /**
     * Gets use_consumer_disclosure_within_account
     *
     * @return ?string
     */
    public function getUseConsumerDisclosureWithinAccount()
    {
        return $this->container['use_consumer_disclosure_within_account'];
    }

    /**
     * Sets use_consumer_disclosure_within_account
     *
     * @param ?string $use_consumer_disclosure_within_account 
     *
     * @return $this
     */
    public function setUseConsumerDisclosureWithinAccount($use_consumer_disclosure_within_account)
    {
        $this->container['use_consumer_disclosure_within_account'] = $use_consumer_disclosure_within_account;

        return $this;
    }

    /**
     * Gets use_consumer_disclosure_within_account_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getUseConsumerDisclosureWithinAccountMetadata()
    {
        return $this->container['use_consumer_disclosure_within_account_metadata'];
    }

    /**
     * Sets use_consumer_disclosure_within_account_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $use_consumer_disclosure_within_account_metadata Metadata that indicates whether the `useConsumerDisclosureWithinAccount` property is editable.
     *
     * @return $this
     */
    public function setUseConsumerDisclosureWithinAccountMetadata($use_consumer_disclosure_within_account_metadata)
    {
        $this->container['use_consumer_disclosure_within_account_metadata'] = $use_consumer_disclosure_within_account_metadata;

        return $this;
    }

    /**
     * Gets use_derived_keys
     *
     * @return ?string
     */
    public function getUseDerivedKeys()
    {
        return $this->container['use_derived_keys'];
    }

    /**
     * Sets use_derived_keys
     *
     * @param ?string $use_derived_keys 
     *
     * @return $this
     */
    public function setUseDerivedKeys($use_derived_keys)
    {
        $this->container['use_derived_keys'] = $use_derived_keys;

        return $this;
    }

    /**
     * Gets use_derived_keys_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getUseDerivedKeysMetadata()
    {
        return $this->container['use_derived_keys_metadata'];
    }

    /**
     * Sets use_derived_keys_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $use_derived_keys_metadata Metadata that indicates whether the `useDerivedKeys` property is editable.
     *
     * @return $this
     */
    public function setUseDerivedKeysMetadata($use_derived_keys_metadata)
    {
        $this->container['use_derived_keys_metadata'] = $use_derived_keys_metadata;

        return $this;
    }

    /**
     * Gets use_docu_sign_express_signer_certificate
     *
     * @return ?string
     */
    public function getUseDocuSignExpressSignerCertificate()
    {
        return $this->container['use_docu_sign_express_signer_certificate'];
    }

    /**
     * Sets use_docu_sign_express_signer_certificate
     *
     * @param ?string $use_docu_sign_express_signer_certificate 
     *
     * @return $this
     */
    public function setUseDocuSignExpressSignerCertificate($use_docu_sign_express_signer_certificate)
    {
        $this->container['use_docu_sign_express_signer_certificate'] = $use_docu_sign_express_signer_certificate;

        return $this;
    }

    /**
     * Gets use_docu_sign_express_signer_certificate_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getUseDocuSignExpressSignerCertificateMetadata()
    {
        return $this->container['use_docu_sign_express_signer_certificate_metadata'];
    }

    /**
     * Sets use_docu_sign_express_signer_certificate_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $use_docu_sign_express_signer_certificate_metadata Metadata that indicates whether the `useDocuSignExpressSignerCertificate` property is editable.
     *
     * @return $this
     */
    public function setUseDocuSignExpressSignerCertificateMetadata($use_docu_sign_express_signer_certificate_metadata)
    {
        $this->container['use_docu_sign_express_signer_certificate_metadata'] = $use_docu_sign_express_signer_certificate_metadata;

        return $this;
    }

    /**
     * Gets use_envelope_search_mixed_mode
     *
     * @return ?string
     */
    public function getUseEnvelopeSearchMixedMode()
    {
        return $this->container['use_envelope_search_mixed_mode'];
    }

    /**
     * Sets use_envelope_search_mixed_mode
     *
     * @param ?string $use_envelope_search_mixed_mode 
     *
     * @return $this
     */
    public function setUseEnvelopeSearchMixedMode($use_envelope_search_mixed_mode)
    {
        $this->container['use_envelope_search_mixed_mode'] = $use_envelope_search_mixed_mode;

        return $this;
    }

    /**
     * Gets use_envelope_search_mixed_mode_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getUseEnvelopeSearchMixedModeMetadata()
    {
        return $this->container['use_envelope_search_mixed_mode_metadata'];
    }

    /**
     * Sets use_envelope_search_mixed_mode_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $use_envelope_search_mixed_mode_metadata 
     *
     * @return $this
     */
    public function setUseEnvelopeSearchMixedModeMetadata($use_envelope_search_mixed_mode_metadata)
    {
        $this->container['use_envelope_search_mixed_mode_metadata'] = $use_envelope_search_mixed_mode_metadata;

        return $this;
    }

    /**
     * Gets use_multi_app_groups_data
     *
     * @return ?string
     */
    public function getUseMultiAppGroupsData()
    {
        return $this->container['use_multi_app_groups_data'];
    }

    /**
     * Sets use_multi_app_groups_data
     *
     * @param ?string $use_multi_app_groups_data 
     *
     * @return $this
     */
    public function setUseMultiAppGroupsData($use_multi_app_groups_data)
    {
        $this->container['use_multi_app_groups_data'] = $use_multi_app_groups_data;

        return $this;
    }

    /**
     * Gets use_multi_app_groups_data_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getUseMultiAppGroupsDataMetadata()
    {
        return $this->container['use_multi_app_groups_data_metadata'];
    }

    /**
     * Sets use_multi_app_groups_data_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $use_multi_app_groups_data_metadata 
     *
     * @return $this
     */
    public function setUseMultiAppGroupsDataMetadata($use_multi_app_groups_data_metadata)
    {
        $this->container['use_multi_app_groups_data_metadata'] = $use_multi_app_groups_data_metadata;

        return $this;
    }

    /**
     * Gets use_new_blob_for_pdf
     *
     * @return ?string
     */
    public function getUseNewBlobForPdf()
    {
        return $this->container['use_new_blob_for_pdf'];
    }

    /**
     * Sets use_new_blob_for_pdf
     *
     * @param ?string $use_new_blob_for_pdf 
     *
     * @return $this
     */
    public function setUseNewBlobForPdf($use_new_blob_for_pdf)
    {
        $this->container['use_new_blob_for_pdf'] = $use_new_blob_for_pdf;

        return $this;
    }

    /**
     * Gets use_new_blob_for_pdf_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getUseNewBlobForPdfMetadata()
    {
        return $this->container['use_new_blob_for_pdf_metadata'];
    }

    /**
     * Sets use_new_blob_for_pdf_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $use_new_blob_for_pdf_metadata Metadata that indicates whether the `useNewBlobForPdf` property is editable.
     *
     * @return $this
     */
    public function setUseNewBlobForPdfMetadata($use_new_blob_for_pdf_metadata)
    {
        $this->container['use_new_blob_for_pdf_metadata'] = $use_new_blob_for_pdf_metadata;

        return $this;
    }

    /**
     * Gets use_new_envelope_search
     *
     * @return ?string
     */
    public function getUseNewEnvelopeSearch()
    {
        return $this->container['use_new_envelope_search'];
    }

    /**
     * Sets use_new_envelope_search
     *
     * @param ?string $use_new_envelope_search 
     *
     * @return $this
     */
    public function setUseNewEnvelopeSearch($use_new_envelope_search)
    {
        $this->container['use_new_envelope_search'] = $use_new_envelope_search;

        return $this;
    }

    /**
     * Gets use_new_envelope_search_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getUseNewEnvelopeSearchMetadata()
    {
        return $this->container['use_new_envelope_search_metadata'];
    }

    /**
     * Sets use_new_envelope_search_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $use_new_envelope_search_metadata 
     *
     * @return $this
     */
    public function setUseNewEnvelopeSearchMetadata($use_new_envelope_search_metadata)
    {
        $this->container['use_new_envelope_search_metadata'] = $use_new_envelope_search_metadata;

        return $this;
    }

    /**
     * Gets use_new_envelope_search_only_when_searching_after_date
     *
     * @return ?string
     */
    public function getUseNewEnvelopeSearchOnlyWhenSearchingAfterDate()
    {
        return $this->container['use_new_envelope_search_only_when_searching_after_date'];
    }

    /**
     * Sets use_new_envelope_search_only_when_searching_after_date
     *
     * @param ?string $use_new_envelope_search_only_when_searching_after_date 
     *
     * @return $this
     */
    public function setUseNewEnvelopeSearchOnlyWhenSearchingAfterDate($use_new_envelope_search_only_when_searching_after_date)
    {
        $this->container['use_new_envelope_search_only_when_searching_after_date'] = $use_new_envelope_search_only_when_searching_after_date;

        return $this;
    }

    /**
     * Gets use_new_envelope_search_only_when_searching_after_date_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getUseNewEnvelopeSearchOnlyWhenSearchingAfterDateMetadata()
    {
        return $this->container['use_new_envelope_search_only_when_searching_after_date_metadata'];
    }

    /**
     * Sets use_new_envelope_search_only_when_searching_after_date_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $use_new_envelope_search_only_when_searching_after_date_metadata 
     *
     * @return $this
     */
    public function setUseNewEnvelopeSearchOnlyWhenSearchingAfterDateMetadata($use_new_envelope_search_only_when_searching_after_date_metadata)
    {
        $this->container['use_new_envelope_search_only_when_searching_after_date_metadata'] = $use_new_envelope_search_only_when_searching_after_date_metadata;

        return $this;
    }

    /**
     * Gets use_new_envelope_search_only_with_search_term
     *
     * @return ?string
     */
    public function getUseNewEnvelopeSearchOnlyWithSearchTerm()
    {
        return $this->container['use_new_envelope_search_only_with_search_term'];
    }

    /**
     * Sets use_new_envelope_search_only_with_search_term
     *
     * @param ?string $use_new_envelope_search_only_with_search_term 
     *
     * @return $this
     */
    public function setUseNewEnvelopeSearchOnlyWithSearchTerm($use_new_envelope_search_only_with_search_term)
    {
        $this->container['use_new_envelope_search_only_with_search_term'] = $use_new_envelope_search_only_with_search_term;

        return $this;
    }

    /**
     * Gets use_new_envelope_search_only_with_search_term_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getUseNewEnvelopeSearchOnlyWithSearchTermMetadata()
    {
        return $this->container['use_new_envelope_search_only_with_search_term_metadata'];
    }

    /**
     * Sets use_new_envelope_search_only_with_search_term_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $use_new_envelope_search_only_with_search_term_metadata 
     *
     * @return $this
     */
    public function setUseNewEnvelopeSearchOnlyWithSearchTermMetadata($use_new_envelope_search_only_with_search_term_metadata)
    {
        $this->container['use_new_envelope_search_only_with_search_term_metadata'] = $use_new_envelope_search_only_with_search_term_metadata;

        return $this;
    }

    /**
     * Gets use_safe_signer_certificates
     *
     * @return ?string
     */
    public function getUseSafeSignerCertificates()
    {
        return $this->container['use_safe_signer_certificates'];
    }

    /**
     * Sets use_safe_signer_certificates
     *
     * @param ?string $use_safe_signer_certificates 
     *
     * @return $this
     */
    public function setUseSafeSignerCertificates($use_safe_signer_certificates)
    {
        $this->container['use_safe_signer_certificates'] = $use_safe_signer_certificates;

        return $this;
    }

    /**
     * Gets use_safe_signer_certificates_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getUseSafeSignerCertificatesMetadata()
    {
        return $this->container['use_safe_signer_certificates_metadata'];
    }

    /**
     * Sets use_safe_signer_certificates_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $use_safe_signer_certificates_metadata Metadata that indicates whether the `useSAFESignerCertificates` property is editable.
     *
     * @return $this
     */
    public function setUseSafeSignerCertificatesMetadata($use_safe_signer_certificates_metadata)
    {
        $this->container['use_safe_signer_certificates_metadata'] = $use_safe_signer_certificates_metadata;

        return $this;
    }

    /**
     * Gets uses_api
     *
     * @return ?string
     */
    public function getUsesApi()
    {
        return $this->container['uses_api'];
    }

    /**
     * Sets uses_api
     *
     * @param ?string $uses_api 
     *
     * @return $this
     */
    public function setUsesApi($uses_api)
    {
        $this->container['uses_api'] = $uses_api;

        return $this;
    }

    /**
     * Gets uses_api_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getUsesApiMetadata()
    {
        return $this->container['uses_api_metadata'];
    }

    /**
     * Sets uses_api_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $uses_api_metadata Metadata that indicates whether the `usesAPI` property is editable.
     *
     * @return $this
     */
    public function setUsesApiMetadata($uses_api_metadata)
    {
        $this->container['uses_api_metadata'] = $uses_api_metadata;

        return $this;
    }

    /**
     * Gets use_signature_provider_platform
     *
     * @return ?string
     */
    public function getUseSignatureProviderPlatform()
    {
        return $this->container['use_signature_provider_platform'];
    }

    /**
     * Sets use_signature_provider_platform
     *
     * @param ?string $use_signature_provider_platform 
     *
     * @return $this
     */
    public function setUseSignatureProviderPlatform($use_signature_provider_platform)
    {
        $this->container['use_signature_provider_platform'] = $use_signature_provider_platform;

        return $this;
    }

    /**
     * Gets use_signature_provider_platform_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getUseSignatureProviderPlatformMetadata()
    {
        return $this->container['use_signature_provider_platform_metadata'];
    }

    /**
     * Sets use_signature_provider_platform_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $use_signature_provider_platform_metadata Metadata that indicates whether the `useSignatureProviderPlatform` property is editable.
     *
     * @return $this
     */
    public function setUseSignatureProviderPlatformMetadata($use_signature_provider_platform_metadata)
    {
        $this->container['use_signature_provider_platform_metadata'] = $use_signature_provider_platform_metadata;

        return $this;
    }

    /**
     * Gets use_smart_contracts_v1
     *
     * @return ?string
     */
    public function getUseSmartContractsV1()
    {
        return $this->container['use_smart_contracts_v1'];
    }

    /**
     * Sets use_smart_contracts_v1
     *
     * @param ?string $use_smart_contracts_v1 
     *
     * @return $this
     */
    public function setUseSmartContractsV1($use_smart_contracts_v1)
    {
        $this->container['use_smart_contracts_v1'] = $use_smart_contracts_v1;

        return $this;
    }

    /**
     * Gets validations_allowed
     *
     * @return ?string
     */
    public function getValidationsAllowed()
    {
        return $this->container['validations_allowed'];
    }

    /**
     * Sets validations_allowed
     *
     * @param ?string $validations_allowed 
     *
     * @return $this
     */
    public function setValidationsAllowed($validations_allowed)
    {
        $this->container['validations_allowed'] = $validations_allowed;

        return $this;
    }

    /**
     * Gets validations_allowed_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getValidationsAllowedMetadata()
    {
        return $this->container['validations_allowed_metadata'];
    }

    /**
     * Sets validations_allowed_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $validations_allowed_metadata Metadata that indicates whether the `validationsAllowed` property is editable.
     *
     * @return $this
     */
    public function setValidationsAllowedMetadata($validations_allowed_metadata)
    {
        $this->container['validations_allowed_metadata'] = $validations_allowed_metadata;

        return $this;
    }

    /**
     * Gets validations_brand
     *
     * @return ?string
     */
    public function getValidationsBrand()
    {
        return $this->container['validations_brand'];
    }

    /**
     * Sets validations_brand
     *
     * @param ?string $validations_brand 
     *
     * @return $this
     */
    public function setValidationsBrand($validations_brand)
    {
        $this->container['validations_brand'] = $validations_brand;

        return $this;
    }

    /**
     * Gets validations_brand_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getValidationsBrandMetadata()
    {
        return $this->container['validations_brand_metadata'];
    }

    /**
     * Sets validations_brand_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $validations_brand_metadata Metadata that indicates whether the `validationsBrand` property is editable.
     *
     * @return $this
     */
    public function setValidationsBrandMetadata($validations_brand_metadata)
    {
        $this->container['validations_brand_metadata'] = $validations_brand_metadata;

        return $this;
    }

    /**
     * Gets validations_cadence
     *
     * @return ?string
     */
    public function getValidationsCadence()
    {
        return $this->container['validations_cadence'];
    }

    /**
     * Sets validations_cadence
     *
     * @param ?string $validations_cadence 
     *
     * @return $this
     */
    public function setValidationsCadence($validations_cadence)
    {
        $this->container['validations_cadence'] = $validations_cadence;

        return $this;
    }

    /**
     * Gets validations_cadence_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getValidationsCadenceMetadata()
    {
        return $this->container['validations_cadence_metadata'];
    }

    /**
     * Sets validations_cadence_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $validations_cadence_metadata Metadata that indicates whether the `validationsCadence` property is editable.
     *
     * @return $this
     */
    public function setValidationsCadenceMetadata($validations_cadence_metadata)
    {
        $this->container['validations_cadence_metadata'] = $validations_cadence_metadata;

        return $this;
    }

    /**
     * Gets validations_enabled
     *
     * @return ?string
     */
    public function getValidationsEnabled()
    {
        return $this->container['validations_enabled'];
    }

    /**
     * Sets validations_enabled
     *
     * @param ?string $validations_enabled 
     *
     * @return $this
     */
    public function setValidationsEnabled($validations_enabled)
    {
        $this->container['validations_enabled'] = $validations_enabled;

        return $this;
    }

    /**
     * Gets validations_enabled_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getValidationsEnabledMetadata()
    {
        return $this->container['validations_enabled_metadata'];
    }

    /**
     * Sets validations_enabled_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $validations_enabled_metadata Metadata that indicates whether the `validationsEnabled` property is editable.
     *
     * @return $this
     */
    public function setValidationsEnabledMetadata($validations_enabled_metadata)
    {
        $this->container['validations_enabled_metadata'] = $validations_enabled_metadata;

        return $this;
    }

    /**
     * Gets validations_report
     *
     * @return ?string
     */
    public function getValidationsReport()
    {
        return $this->container['validations_report'];
    }

    /**
     * Sets validations_report
     *
     * @param ?string $validations_report 
     *
     * @return $this
     */
    public function setValidationsReport($validations_report)
    {
        $this->container['validations_report'] = $validations_report;

        return $this;
    }

    /**
     * Gets validations_report_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getValidationsReportMetadata()
    {
        return $this->container['validations_report_metadata'];
    }

    /**
     * Sets validations_report_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $validations_report_metadata Metadata that indicates whether the `validationsReport` property is editable.
     *
     * @return $this
     */
    public function setValidationsReportMetadata($validations_report_metadata)
    {
        $this->container['validations_report_metadata'] = $validations_report_metadata;

        return $this;
    }

    /**
     * Gets water_mark_enabled
     *
     * @return ?string
     */
    public function getWaterMarkEnabled()
    {
        return $this->container['water_mark_enabled'];
    }

    /**
     * Sets water_mark_enabled
     *
     * @param ?string $water_mark_enabled 
     *
     * @return $this
     */
    public function setWaterMarkEnabled($water_mark_enabled)
    {
        $this->container['water_mark_enabled'] = $water_mark_enabled;

        return $this;
    }

    /**
     * Gets water_mark_enabled_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getWaterMarkEnabledMetadata()
    {
        return $this->container['water_mark_enabled_metadata'];
    }

    /**
     * Sets water_mark_enabled_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $water_mark_enabled_metadata Metadata that indicates whether the `waterMarkEnabled` property is editable.
     *
     * @return $this
     */
    public function setWaterMarkEnabledMetadata($water_mark_enabled_metadata)
    {
        $this->container['water_mark_enabled_metadata'] = $water_mark_enabled_metadata;

        return $this;
    }

    /**
     * Gets write_reminder_to_envelope_history
     *
     * @return ?string
     */
    public function getWriteReminderToEnvelopeHistory()
    {
        return $this->container['write_reminder_to_envelope_history'];
    }

    /**
     * Sets write_reminder_to_envelope_history
     *
     * @param ?string $write_reminder_to_envelope_history 
     *
     * @return $this
     */
    public function setWriteReminderToEnvelopeHistory($write_reminder_to_envelope_history)
    {
        $this->container['write_reminder_to_envelope_history'] = $write_reminder_to_envelope_history;

        return $this;
    }

    /**
     * Gets write_reminder_to_envelope_history_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getWriteReminderToEnvelopeHistoryMetadata()
    {
        return $this->container['write_reminder_to_envelope_history_metadata'];
    }

    /**
     * Sets write_reminder_to_envelope_history_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $write_reminder_to_envelope_history_metadata Metadata that indicates whether the `writeReminderToEnvelopeHistory` property is editable.
     *
     * @return $this
     */
    public function setWriteReminderToEnvelopeHistoryMetadata($write_reminder_to_envelope_history_metadata)
    {
        $this->container['write_reminder_to_envelope_history_metadata'] = $write_reminder_to_envelope_history_metadata;

        return $this;
    }

    /**
     * Gets wurfl_min_allowable_screen_size
     *
     * @return ?string
     */
    public function getWurflMinAllowableScreenSize()
    {
        return $this->container['wurfl_min_allowable_screen_size'];
    }

    /**
     * Sets wurfl_min_allowable_screen_size
     *
     * @param ?string $wurfl_min_allowable_screen_size 
     *
     * @return $this
     */
    public function setWurflMinAllowableScreenSize($wurfl_min_allowable_screen_size)
    {
        $this->container['wurfl_min_allowable_screen_size'] = $wurfl_min_allowable_screen_size;

        return $this;
    }

    /**
     * Gets wurfl_min_allowable_screen_size_metadata
     *
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getWurflMinAllowableScreenSizeMetadata()
    {
        return $this->container['wurfl_min_allowable_screen_size_metadata'];
    }

    /**
     * Sets wurfl_min_allowable_screen_size_metadata
     *
     * @param \DocuSign\eSign\Model\SettingsMetadata $wurfl_min_allowable_screen_size_metadata Metadata that indicates whether the `wurflMinAllowableScreenSize` property is editable.
     *
     * @return $this
     */
    public function setWurflMinAllowableScreenSizeMetadata($wurfl_min_allowable_screen_size_metadata)
    {
        $this->container['wurfl_min_allowable_screen_size_metadata'] = $wurfl_min_allowable_screen_size_metadata;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

