<?php
/**
 * FolderItemV2
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * FolderItemV2 Class Doc Comment
 *
 * @category    Class
 * @description Information about folder item results.
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team <apihelp@docusign.com>
 * @license     The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class FolderItemV2 implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'folderItem_v2';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'completed_date_time' => '?string',
        'created_date_time' => '?string',
        'envelope_id' => '?string',
        'envelope_uri' => '?string',
        'expire_date_time' => '?string',
        'folder_id' => '?string',
        'folder_uri' => '?string',
        'is21_cfr_part11' => '?string',
        'last_modified_date_time' => '?string',
        'owner_name' => '?string',
        'recipients' => '\DocuSign\eSign\Model\Recipients',
        'recipients_uri' => '?string',
        'sender_company' => '?string',
        'sender_email' => '?string',
        'sender_name' => '?string',
        'sender_user_id' => '?string',
        'sent_date_time' => '?string',
        'status' => '?string',
        'subject' => '?string',
        'template_id' => '?string',
        'template_uri' => '?string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'completed_date_time' => null,
        'created_date_time' => null,
        'envelope_id' => null,
        'envelope_uri' => null,
        'expire_date_time' => null,
        'folder_id' => null,
        'folder_uri' => null,
        'is21_cfr_part11' => null,
        'last_modified_date_time' => null,
        'owner_name' => null,
        'recipients' => null,
        'recipients_uri' => null,
        'sender_company' => null,
        'sender_email' => null,
        'sender_name' => null,
        'sender_user_id' => null,
        'sent_date_time' => null,
        'status' => null,
        'subject' => null,
        'template_id' => null,
        'template_uri' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'completed_date_time' => 'completedDateTime',
        'created_date_time' => 'createdDateTime',
        'envelope_id' => 'envelopeId',
        'envelope_uri' => 'envelopeUri',
        'expire_date_time' => 'expireDateTime',
        'folder_id' => 'folderId',
        'folder_uri' => 'folderUri',
        'is21_cfr_part11' => 'is21CFRPart11',
        'last_modified_date_time' => 'lastModifiedDateTime',
        'owner_name' => 'ownerName',
        'recipients' => 'recipients',
        'recipients_uri' => 'recipientsUri',
        'sender_company' => 'senderCompany',
        'sender_email' => 'senderEmail',
        'sender_name' => 'senderName',
        'sender_user_id' => 'senderUserId',
        'sent_date_time' => 'sentDateTime',
        'status' => 'status',
        'subject' => 'subject',
        'template_id' => 'templateId',
        'template_uri' => 'templateUri'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'completed_date_time' => 'setCompletedDateTime',
        'created_date_time' => 'setCreatedDateTime',
        'envelope_id' => 'setEnvelopeId',
        'envelope_uri' => 'setEnvelopeUri',
        'expire_date_time' => 'setExpireDateTime',
        'folder_id' => 'setFolderId',
        'folder_uri' => 'setFolderUri',
        'is21_cfr_part11' => 'setIs21CfrPart11',
        'last_modified_date_time' => 'setLastModifiedDateTime',
        'owner_name' => 'setOwnerName',
        'recipients' => 'setRecipients',
        'recipients_uri' => 'setRecipientsUri',
        'sender_company' => 'setSenderCompany',
        'sender_email' => 'setSenderEmail',
        'sender_name' => 'setSenderName',
        'sender_user_id' => 'setSenderUserId',
        'sent_date_time' => 'setSentDateTime',
        'status' => 'setStatus',
        'subject' => 'setSubject',
        'template_id' => 'setTemplateId',
        'template_uri' => 'setTemplateUri'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'completed_date_time' => 'getCompletedDateTime',
        'created_date_time' => 'getCreatedDateTime',
        'envelope_id' => 'getEnvelopeId',
        'envelope_uri' => 'getEnvelopeUri',
        'expire_date_time' => 'getExpireDateTime',
        'folder_id' => 'getFolderId',
        'folder_uri' => 'getFolderUri',
        'is21_cfr_part11' => 'getIs21CfrPart11',
        'last_modified_date_time' => 'getLastModifiedDateTime',
        'owner_name' => 'getOwnerName',
        'recipients' => 'getRecipients',
        'recipients_uri' => 'getRecipientsUri',
        'sender_company' => 'getSenderCompany',
        'sender_email' => 'getSenderEmail',
        'sender_name' => 'getSenderName',
        'sender_user_id' => 'getSenderUserId',
        'sent_date_time' => 'getSentDateTime',
        'status' => 'getStatus',
        'subject' => 'getSubject',
        'template_id' => 'getTemplateId',
        'template_uri' => 'getTemplateUri'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['completed_date_time'] = isset($data['completed_date_time']) ? $data['completed_date_time'] : null;
        $this->container['created_date_time'] = isset($data['created_date_time']) ? $data['created_date_time'] : null;
        $this->container['envelope_id'] = isset($data['envelope_id']) ? $data['envelope_id'] : null;
        $this->container['envelope_uri'] = isset($data['envelope_uri']) ? $data['envelope_uri'] : null;
        $this->container['expire_date_time'] = isset($data['expire_date_time']) ? $data['expire_date_time'] : null;
        $this->container['folder_id'] = isset($data['folder_id']) ? $data['folder_id'] : null;
        $this->container['folder_uri'] = isset($data['folder_uri']) ? $data['folder_uri'] : null;
        $this->container['is21_cfr_part11'] = isset($data['is21_cfr_part11']) ? $data['is21_cfr_part11'] : null;
        $this->container['last_modified_date_time'] = isset($data['last_modified_date_time']) ? $data['last_modified_date_time'] : null;
        $this->container['owner_name'] = isset($data['owner_name']) ? $data['owner_name'] : null;
        $this->container['recipients'] = isset($data['recipients']) ? $data['recipients'] : null;
        $this->container['recipients_uri'] = isset($data['recipients_uri']) ? $data['recipients_uri'] : null;
        $this->container['sender_company'] = isset($data['sender_company']) ? $data['sender_company'] : null;
        $this->container['sender_email'] = isset($data['sender_email']) ? $data['sender_email'] : null;
        $this->container['sender_name'] = isset($data['sender_name']) ? $data['sender_name'] : null;
        $this->container['sender_user_id'] = isset($data['sender_user_id']) ? $data['sender_user_id'] : null;
        $this->container['sent_date_time'] = isset($data['sent_date_time']) ? $data['sent_date_time'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['subject'] = isset($data['subject']) ? $data['subject'] : null;
        $this->container['template_id'] = isset($data['template_id']) ? $data['template_id'] : null;
        $this->container['template_uri'] = isset($data['template_uri']) ? $data['template_uri'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets completed_date_time
     *
     * @return ?string
     */
    public function getCompletedDateTime()
    {
        return $this->container['completed_date_time'];
    }

    /**
     * Sets completed_date_time
     *
     * @param ?string $completed_date_time Specifies the date and time this item was completed.
     *
     * @return $this
     */
    public function setCompletedDateTime($completed_date_time)
    {
        $this->container['completed_date_time'] = $completed_date_time;

        return $this;
    }

    /**
     * Gets created_date_time
     *
     * @return ?string
     */
    public function getCreatedDateTime()
    {
        return $this->container['created_date_time'];
    }

    /**
     * Sets created_date_time
     *
     * @param ?string $created_date_time Indicates the date and time the item was created.
     *
     * @return $this
     */
    public function setCreatedDateTime($created_date_time)
    {
        $this->container['created_date_time'] = $created_date_time;

        return $this;
    }

    /**
     * Gets envelope_id
     *
     * @return ?string
     */
    public function getEnvelopeId()
    {
        return $this->container['envelope_id'];
    }

    /**
     * Sets envelope_id
     *
     * @param ?string $envelope_id The envelope ID of the envelope status that failed to post.
     *
     * @return $this
     */
    public function setEnvelopeId($envelope_id)
    {
        $this->container['envelope_id'] = $envelope_id;

        return $this;
    }

    /**
     * Gets envelope_uri
     *
     * @return ?string
     */
    public function getEnvelopeUri()
    {
        return $this->container['envelope_uri'];
    }

    /**
     * Sets envelope_uri
     *
     * @param ?string $envelope_uri Contains a URI for an endpoint that you can use to retrieve the envelope or envelopes.
     *
     * @return $this
     */
    public function setEnvelopeUri($envelope_uri)
    {
        $this->container['envelope_uri'] = $envelope_uri;

        return $this;
    }

    /**
     * Gets expire_date_time
     *
     * @return ?string
     */
    public function getExpireDateTime()
    {
        return $this->container['expire_date_time'];
    }

    /**
     * Sets expire_date_time
     *
     * @param ?string $expire_date_time The date and time the envelope is set to expire.
     *
     * @return $this
     */
    public function setExpireDateTime($expire_date_time)
    {
        $this->container['expire_date_time'] = $expire_date_time;

        return $this;
    }

    /**
     * Gets folder_id
     *
     * @return ?string
     */
    public function getFolderId()
    {
        return $this->container['folder_id'];
    }

    /**
     * Sets folder_id
     *
     * @param ?string $folder_id 
     *
     * @return $this
     */
    public function setFolderId($folder_id)
    {
        $this->container['folder_id'] = $folder_id;

        return $this;
    }

    /**
     * Gets folder_uri
     *
     * @return ?string
     */
    public function getFolderUri()
    {
        return $this->container['folder_uri'];
    }

    /**
     * Sets folder_uri
     *
     * @param ?string $folder_uri 
     *
     * @return $this
     */
    public function setFolderUri($folder_uri)
    {
        $this->container['folder_uri'] = $folder_uri;

        return $this;
    }

    /**
     * Gets is21_cfr_part11
     *
     * @return ?string
     */
    public function getIs21CfrPart11()
    {
        return $this->container['is21_cfr_part11'];
    }

    /**
     * Sets is21_cfr_part11
     *
     * @param ?string $is21_cfr_part11 When set to **true**, indicates that this module is enabled on the account.
     *
     * @return $this
     */
    public function setIs21CfrPart11($is21_cfr_part11)
    {
        $this->container['is21_cfr_part11'] = $is21_cfr_part11;

        return $this;
    }

    /**
     * Gets last_modified_date_time
     *
     * @return ?string
     */
    public function getLastModifiedDateTime()
    {
        return $this->container['last_modified_date_time'];
    }

    /**
     * Sets last_modified_date_time
     *
     * @param ?string $last_modified_date_time The date and time the item was last modified.
     *
     * @return $this
     */
    public function setLastModifiedDateTime($last_modified_date_time)
    {
        $this->container['last_modified_date_time'] = $last_modified_date_time;

        return $this;
    }

    /**
     * Gets owner_name
     *
     * @return ?string
     */
    public function getOwnerName()
    {
        return $this->container['owner_name'];
    }

    /**
     * Sets owner_name
     *
     * @param ?string $owner_name 
     *
     * @return $this
     */
    public function setOwnerName($owner_name)
    {
        $this->container['owner_name'] = $owner_name;

        return $this;
    }

    /**
     * Gets recipients
     *
     * @return \DocuSign\eSign\Model\Recipients
     */
    public function getRecipients()
    {
        return $this->container['recipients'];
    }

    /**
     * Sets recipients
     *
     * @param \DocuSign\eSign\Model\Recipients $recipients An array of powerform recipients.
     *
     * @return $this
     */
    public function setRecipients($recipients)
    {
        $this->container['recipients'] = $recipients;

        return $this;
    }

    /**
     * Gets recipients_uri
     *
     * @return ?string
     */
    public function getRecipientsUri()
    {
        return $this->container['recipients_uri'];
    }

    /**
     * Sets recipients_uri
     *
     * @param ?string $recipients_uri Contains a URI for an endpoint that you can use to retrieve the recipients.
     *
     * @return $this
     */
    public function setRecipientsUri($recipients_uri)
    {
        $this->container['recipients_uri'] = $recipients_uri;

        return $this;
    }

    /**
     * Gets sender_company
     *
     * @return ?string
     */
    public function getSenderCompany()
    {
        return $this->container['sender_company'];
    }

    /**
     * Sets sender_company
     *
     * @param ?string $sender_company 
     *
     * @return $this
     */
    public function setSenderCompany($sender_company)
    {
        $this->container['sender_company'] = $sender_company;

        return $this;
    }

    /**
     * Gets sender_email
     *
     * @return ?string
     */
    public function getSenderEmail()
    {
        return $this->container['sender_email'];
    }

    /**
     * Sets sender_email
     *
     * @param ?string $sender_email 
     *
     * @return $this
     */
    public function setSenderEmail($sender_email)
    {
        $this->container['sender_email'] = $sender_email;

        return $this;
    }

    /**
     * Gets sender_name
     *
     * @return ?string
     */
    public function getSenderName()
    {
        return $this->container['sender_name'];
    }

    /**
     * Sets sender_name
     *
     * @param ?string $sender_name 
     *
     * @return $this
     */
    public function setSenderName($sender_name)
    {
        $this->container['sender_name'] = $sender_name;

        return $this;
    }

    /**
     * Gets sender_user_id
     *
     * @return ?string
     */
    public function getSenderUserId()
    {
        return $this->container['sender_user_id'];
    }

    /**
     * Sets sender_user_id
     *
     * @param ?string $sender_user_id 
     *
     * @return $this
     */
    public function setSenderUserId($sender_user_id)
    {
        $this->container['sender_user_id'] = $sender_user_id;

        return $this;
    }

    /**
     * Gets sent_date_time
     *
     * @return ?string
     */
    public function getSentDateTime()
    {
        return $this->container['sent_date_time'];
    }

    /**
     * Sets sent_date_time
     *
     * @param ?string $sent_date_time The date and time the envelope was sent.
     *
     * @return $this
     */
    public function setSentDateTime($sent_date_time)
    {
        $this->container['sent_date_time'] = $sent_date_time;

        return $this;
    }

    /**
     * Gets status
     *
     * @return ?string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param ?string $status Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.
     *
     * @return $this
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets subject
     *
     * @return ?string
     */
    public function getSubject()
    {
        return $this->container['subject'];
    }

    /**
     * Sets subject
     *
     * @param ?string $subject 
     *
     * @return $this
     */
    public function setSubject($subject)
    {
        $this->container['subject'] = $subject;

        return $this;
    }

    /**
     * Gets template_id
     *
     * @return ?string
     */
    public function getTemplateId()
    {
        return $this->container['template_id'];
    }

    /**
     * Sets template_id
     *
     * @param ?string $template_id The unique identifier of the template. If this is not provided, DocuSign will generate a value.
     *
     * @return $this
     */
    public function setTemplateId($template_id)
    {
        $this->container['template_id'] = $template_id;

        return $this;
    }

    /**
     * Gets template_uri
     *
     * @return ?string
     */
    public function getTemplateUri()
    {
        return $this->container['template_uri'];
    }

    /**
     * Sets template_uri
     *
     * @param ?string $template_uri 
     *
     * @return $this
     */
    public function setTemplateUri($template_uri)
    {
        $this->container['template_uri'] = $template_uri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

